/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.InfoAppMsgMapperExt;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dao.report.InfoAppMsg;
import com.bxm.adsmanager.service.adkeeper.InfoAppMsgService;
import com.bxm.adsmanager.utils.AppEntityConvertHelper;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InfoAppMsgServiceImpl
implements InfoAppMsgService {
    @Autowired
    private InfoAppMsgMapperExt infoAppMsgMapperExt;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;

    @Override
    public List<InfoAppMsg> findAllAppkeys(String mediaName, String roleCode) {
        HashMap map = Maps.newHashMap();
        map.put("mediaName", mediaName);
        map.put("roleCode", roleCode);
        ProviderAppAdDTO param = new ProviderAppAdDTO();
        param.setKeywords(mediaName);
        param.setRoleCode(roleCode);
        List<InfoAppMsg> allAppkeys = AppEntityConvertHelper.appListConvertToInfoAppMsgList(this.providerFacadeIntegration.getProviderAppList(param));
        if (CollectionUtils.isNotEmpty(allAppkeys)) {
            return allAppkeys;
        }
        return new ArrayList<InfoAppMsg>();
    }

    @Override
    public List<InfoAppMsg> findInfoAppByAppkeys(StringBuffer sbAppkeys) {
        ArrayList<String> appkeys = new ArrayList<String>();
        HashMap<String, ArrayList<String>> paramsMap = new HashMap<String, ArrayList<String>>(16);
        if (sbAppkeys != null && StringUtils.isNotEmpty((CharSequence)sbAppkeys)) {
            for (String appkey : sbAppkeys.toString().split(",")) {
                appkeys.add(appkey);
            }
            paramsMap.put("appKeys", appkeys);
        }
        if (appkeys.size() == 0) {
            return null;
        }
        ProviderAppAdDTO param = new ProviderAppAdDTO();
        param.setAppKeys(appkeys);
        List<InfoAppMsg> certificateInfos = AppEntityConvertHelper.appListConvertToInfoAppMsgList(this.providerFacadeIntegration.getProviderAppList(param));
        if (CollectionUtils.isEmpty(certificateInfos)) {
            return new ArrayList<InfoAppMsg>();
        }
        return certificateInfos;
    }
}

