/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateContentMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.PanguCreativeMapperExt;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContentExample;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreative;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreativeExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PanguCreativeBatchUpdateStatusDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeBatchUpdateTagDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeSearchDTO;
import com.bxm.adsmanager.model.vo.PanguCreativeListVO;
import com.bxm.adsmanager.model.vo.PanguCreativeUploadResultVO;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.adkeeper.PanguCreativeService;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PanguCreativeServiceImpl
implements PanguCreativeService {
    private static final Logger log = LoggerFactory.getLogger(PanguCreativeServiceImpl.class);
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private PanguCreativeMapperExt panguCreativeMapperExt;
    @Autowired
    private TblAdPostionTagMapperExt tblAdTagMapperExt;
    @Autowired
    private AdAssetsTemplateContentMapper adAssetsTemplateContentMapper;

    @Override
    public PageInfo<PanguCreativeListVO> findAll(User user, PanguCreativeSearchDTO searchDTO) {
        PageHelper.startPage((int)searchDTO.getPageNum(), (int)searchDTO.getPageSize());
        List records = this.panguCreativeMapperExt.findAll(searchDTO);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            List sysDictList = this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(-1), Integer.valueOf(4), null);
            Map<String, TblAdTagVo> sysDictMap = sysDictList.stream().collect(Collectors.toMap(a -> String.valueOf(a.getCode()), a -> a));
            for (PanguCreativeListVO record : records) {
                String tags = record.getTags();
                if (!StringUtils.isNotBlank((CharSequence)tags)) continue;
                String[] tagsArray = tags.split(",");
                StringBuffer tagStringBuffer = new StringBuffer();
                for (String tag : tagsArray) {
                    TblAdTagVo sysDict = sysDictMap.getOrDefault(tag, new TblAdTagVo());
                    String fullNameStr = sysDict.getFullNameStr();
                    if (!StringUtils.isNotBlank((CharSequence)fullNameStr)) continue;
                    String newStr = fullNameStr.replaceAll("\\.", "-");
                    tagStringBuffer.append(newStr.substring(0, newStr.length() - 1));
                    tagStringBuffer.append(",");
                }
                if (tagStringBuffer.length() > 0) {
                    tagStringBuffer.deleteCharAt(tagStringBuffer.length() - 1);
                }
                record.setTags(tagStringBuffer.toString());
            }
        }
        return new PageInfo(records);
    }

    @Override
    public List<String> findSize(User user) {
        return this.panguCreativeMapperExt.findSize();
    }

    @Override
    public Boolean update(User userVo, PanguCreative creative) {
        PanguCreative oldCreative = this.panguCreativeMapperExt.selectByPrimaryKey(creative.getId());
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public boolean batchUpdateStatus(User user, PanguCreativeBatchUpdateStatusDTO dto) throws Exception {
        PanguCreativeExample example = new PanguCreativeExample();
        example.createCriteria().andIdIn(dto.getIds());
        List list = this.panguCreativeMapperExt.selectByExample(example);
        for (PanguCreative entity : list) {
            entity.setStatus(dto.getStatus());
            entity.setModifyTime(new Date());
            entity.setModifyUser(user.getUsername());
            this.panguCreativeMapperExt.updateByPrimaryKey(entity);
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public boolean batchUpdateTag(User user, PanguCreativeBatchUpdateTagDTO dto) throws Exception {
        PanguCreativeExample example = new PanguCreativeExample();
        example.createCriteria().andIdIn(dto.getIds());
        List list = this.panguCreativeMapperExt.selectByExample(example);
        for (PanguCreative entity : list) {
            String tags = (String)StringUtils.defaultIfBlank((CharSequence)entity.getTags(), (CharSequence)"");
            String[] tagsArray = tags.split(",");
            Set tagsList = Arrays.stream(tagsArray).collect(Collectors.toSet());
            tagsList.remove("");
            List updateTagList = dto.getTags();
            if (dto.getOperaType() == 1) {
                for (int i = 0; i < updateTagList.size() && tagsList.size() < 5; ++i) {
                    tagsList.add(updateTagList.get(i));
                }
                tags = StringUtils.join(tagsList, (String)",");
            } else if (dto.getOperaType() == 2) {
                tags = StringUtils.join((Iterable)updateTagList, (String)",");
            } else if (dto.getOperaType() == 3) {
                tagsList.removeAll(updateTagList);
                tags = StringUtils.join(tagsList, (String)",");
            }
            entity.setTags(tags);
            entity.setModifyTime(new Date());
            entity.setModifyUser(user.getUsername());
            this.panguCreativeMapperExt.updateByPrimaryKey(entity);
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional
    public ArrayList<PanguCreative> add(User userVo, PanguCreativeDTO panguCreativeDTO) {
        List addCreatives = panguCreativeDTO.getCreatives();
        List md5Set = addCreatives.stream().map(PanguCreativeDTO.Creative::getMd5).distinct().collect(Collectors.toList());
        PanguCreativeExample example = new PanguCreativeExample();
        example.createCriteria().andMd5In(md5Set);
        List existList = this.panguCreativeMapperExt.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            StringBuffer stringBuffer = new StringBuffer("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\uff1a");
            for (PanguCreative panguCreative : existList) {
                stringBuffer.append(panguCreative.getPicture()).append(";");
            }
            throw new BusinessException(stringBuffer.toString());
        }
        ArrayList<PanguCreative> panguCreatives = new ArrayList<PanguCreative>();
        for (PanguCreativeDTO.Creative creative : addCreatives) {
            PanguCreative panguCreative = new PanguCreative();
            BeanUtils.copyProperties((Object)creative, (Object)panguCreative);
            panguCreative.setId(null);
            panguCreative.setStatus(Short.valueOf((short)1));
            List tags = panguCreativeDTO.getTags();
            if (CollectionUtils.isNotEmpty((Collection)tags)) {
                panguCreative.setTags(StringUtils.join((Iterable)tags, (String)","));
            }
            panguCreative.setCreateTime(new Date());
            panguCreative.setCreateUser(userVo.getUsername());
            this.panguCreativeMapperExt.insertSelective(panguCreative);
            panguCreatives.add(panguCreative);
        }
        return panguCreatives;
    }

    @Override
    public void fillCreativeInfo(PanguCreativeUploadResultVO panguCreativeUploadResultVO, int width, int height) {
        PanguCreativeExample panguCreativeExample = new PanguCreativeExample();
        panguCreativeExample.createCriteria().andMd5EqualTo(panguCreativeUploadResultVO.getMd5());
        int panguCreativeCount = this.panguCreativeMapperExt.countByExample(panguCreativeExample);
        panguCreativeUploadResultVO.setFileExist(Boolean.valueOf(panguCreativeCount > 0));
        AdAssetsTemplateContentExample adAssetsTemplateContentExample = new AdAssetsTemplateContentExample();
        adAssetsTemplateContentExample.createCriteria().andPictureConstraintsLike(width + "-" + height + "%");
        int assetsTemplateContentCount = this.adAssetsTemplateContentMapper.countByExample(adAssetsTemplateContentExample);
        panguCreativeUploadResultVO.setFileSizeExist(Boolean.valueOf(assetsTemplateContentCount > 0));
    }
}

