/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.RiskWordMapper;
import com.bxm.adsmanager.model.dao.adkeeper.RiskWord;
import com.bxm.adsmanager.model.dto.RiskWordDto;
import com.bxm.adsmanager.model.dto.RiskWordQueryDto;
import com.bxm.adsmanager.model.vo.RiskWordVo;
import com.bxm.adsmanager.service.adkeeper.RiskWordService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskWordServiceImpl
implements RiskWordService {
    @Autowired
    private RiskWordMapper riskWordMapper;

    @Override
    public PageInfo<RiskWordVo> getPage(RiskWordQueryDto queryDto) {
        if (StringUtils.isNotBlank((String)queryDto.getEndTime())) {
            queryDto.setEndTime(queryDto.getEndTime() + " 23:59:59");
        }
        Page page = PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        this.riskWordMapper.getPage(queryDto);
        return page.toPageInfo();
    }

    @Override
    public void add(RiskWordDto dto) {
        if (this.riskWordMapper.countRiskWord(dto) > 0) {
            throw new ValidateException("\u8be5\u654f\u611f\u8bcd\u6c47\u5df2\u5b58\u5728");
        }
        RiskWord riskWord = new RiskWord();
        BeanUtils.copyProperties((Object)dto, (Object)riskWord);
        String userName = RequestUtils.getCurrentRealName();
        riskWord.setCreateUser(userName);
        riskWord.setModifyUser(userName);
        this.riskWordMapper.insertSelective(riskWord);
    }

    @Override
    public void update(RiskWordDto dto) {
        if (this.riskWordMapper.countRiskWord(dto) > 0) {
            throw new ValidateException("\u8be5\u654f\u611f\u8bcd\u6c47\u5df2\u5b58\u5728");
        }
        RiskWord riskWord = new RiskWord();
        BeanUtils.copyProperties((Object)dto, (Object)riskWord);
        String userName = RequestUtils.getCurrentRealName();
        riskWord.setModifyUser(userName);
        this.riskWordMapper.updateByPrimaryKeySelective(riskWord);
    }

    @Override
    public void updateStatus(String ids, Integer status) {
        List updateId = Arrays.stream(ids.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        this.riskWordMapper.updateStatus(updateId, status);
    }

    @Override
    public String importAdd(List<RiskWordVo> orderVos) {
        List allRiskWord = this.riskWordMapper.findAll();
        Set checkSet = allRiskWord.stream().map(r -> r.getTagName() + ":" + r.getKeyword()).collect(Collectors.toSet());
        ArrayList<RiskWord> riskWords = new ArrayList<RiskWord>(allRiskWord.size());
        for (RiskWordVo orderVo : orderVos) {
            String tagName = orderVo.getTagName();
            String keyword = orderVo.getKeyword();
            if (StringUtils.isBlank((String)tagName) || StringUtils.isBlank((String)keyword) || checkSet.contains(tagName + ":" + keyword)) continue;
            RiskWord riskWord = new RiskWord();
            riskWord.setTagName(tagName);
            riskWord.setKeyword(keyword);
            riskWord.setStatus(RiskWord.STATUS_OPEN);
            riskWord.setModifyUser(RequestUtils.getCurrentRealName());
            riskWord.setCreateUser(RequestUtils.getCurrentRealName());
            riskWords.add(riskWord);
            checkSet.add(tagName + ":" + keyword);
        }
        for (RiskWord riskWord : riskWords) {
            this.riskWordMapper.insertSelective(riskWord);
        }
        return String.format("\u5bfc\u5165\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761", riskWords.size(), orderVos.size() - riskWords.size());
    }

    @Override
    public List<String> getRiskWordList() {
        return this.riskWordMapper.getRiskWordList();
    }
}

