/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.service.adkeeper.TikcetCurrentClickAveragePriceService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TikcetCurrentClickAveragePriceServiceImpl
implements TikcetCurrentClickAveragePriceService {
    @Qualifier(value="jedisFetcher")
    @Autowired
    private Fetcher jedisFetcher;

    @Override
    public Map<Long, Double> currentClickAveragePrice(List<Long> ids) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        ids.forEach(id -> map.put(id, this.fetchValue(String.valueOf(id))));
        return map;
    }

    @Override
    public Double currentClickAveragePrice(Long id) {
        return this.fetchValue(String.valueOf(id));
    }

    private String timeNode(LocalDateTime now) {
        return LocalDateTimeHelper.formatToString((LocalDateTime)now, (String)"yyyyMMdd") + (now.getHour() * 60 + now.getMinute()) / 10;
    }

    private String preTimeNode() {
        return this.timeNode(LocalDateTime.now().plusMinutes(-10L));
    }

    private Double fetchValue(String id) {
        try {
            Long clicks = (Long)this.jedisFetcher.hfetch(TicketKeyGenerator.TIMENODE.currentTimeNodeClick((String)this.preTimeNode()), String.valueOf(id), Long.class);
            Long consumes = (Long)this.jedisFetcher.hfetch(TicketKeyGenerator.TIMENODE.currentTimeNodeConsume((String)this.preTimeNode()), String.valueOf(id), Long.class);
            if (clicks == null || consumes == null || clicks == 0L) {
                return 0.0;
            }
            double v = new BigDecimal(consumes).divide(new BigDecimal(clicks), 5, 4).divide(new BigDecimal(1000), 2, 4).doubleValue();
            return v;
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

