/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.mobile.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPriceConf;
import com.bxm.adsmanager.model.dto.AdFlowPackageNewDto;
import com.bxm.adsmanager.model.dto.mobile.TicketQueryConditionDTO;
import com.bxm.adsmanager.model.dto.mobile.TicketUpdateDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.enums.TicketStatusEnum;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.model.vo.mobile.AdTicketMobileVO;
import com.bxm.adsmanager.model.vo.mobile.TicketDetailVO;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.adkeeper.AdTicketPriceConfService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.mobile.MobileAdTicketService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.CollectionDataCopyUtil;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.commons.currency.Money;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MobileAdTicketServiceImpl
implements MobileAdTicketService {
    private static final Logger log = LoggerFactory.getLogger(MobileAdTicketServiceImpl.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;
    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private AdTicketPriceConfService adTicketPriceConfService;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketFlowNewService adTicketFlowNewService;
    @Autowired
    private AdTicketFlowPackageMapper adTicketFlowPackageMapper;

    @Override
    public PageInfo<AdTicketMobileVO> findAll(TicketQueryConditionDTO conditionDTO, UserVo userVo) {
        List roleCodes = userVo.getRoleCodes();
        log.error("\u8d26\u53f7\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)userVo));
        if (CollectionUtils.isEmpty((Collection)roleCodes)) {
            return new PageInfo();
        }
        if (roleCodes.contains(RoleEnum.AELEADER.getCode()) || roleCodes.contains(RoleEnum.ADMIN.getCode())) {
            conditionDTO.setAe(null);
        } else if (roleCodes.contains(RoleEnum.AE.getCode())) {
            conditionDTO.setAe(userVo.getUsername());
        } else {
            return new PageInfo();
        }
        List<Object> advertiserDTOs = StringUtils.isBlank((CharSequence)conditionDTO.getKeywords()) ? Collections.emptyList() : this.getAllAdvertiser(conditionDTO.getKeywords());
        if (CollectionUtils.isNotEmpty(advertiserDTOs)) {
            conditionDTO.setAdvertiserIds(advertiserDTOs.stream().map(AdvertiserDto::getId).collect(Collectors.toList()));
        }
        if (1 == conditionDTO.getTicketStatusFlag()) {
            conditionDTO.setStatus(new Integer[]{TicketStatusEnum.NORMAL.getStatus(), TicketStatusEnum.PAUSE.getStatus()});
        } else {
            conditionDTO.setStatus(new Integer[]{TicketStatusEnum.STOP.getStatus()});
        }
        PageInfo adTicketPageInfo = PageHelper.startPage((int)conditionDTO.getPageNum(), (int)conditionDTO.getPageSize()).doSelectPageInfo(() -> this.adTicketMapper.findTicketsInMobile(conditionDTO));
        List adTickets = adTicketPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)adTickets)) {
            return new PageInfo();
        }
        List<Long> advertiserIds = adTickets.stream().map(AdTicket::getAdvertiser).collect(Collectors.toList());
        List<AdTicketOcpcConf> ocpcConfList = this.adTicketOcpcService.selectByTicketIdList(adTickets);
        Map ticketOcpcMap = ocpcConfList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTicketId(), v.getIsSupportOcpc() == 1), HashMap::putAll);
        advertiserDTOs = this.getAllAdvertiserByIds(advertiserIds);
        Map advertiserMap = advertiserDTOs.stream().collect(HashMap::new, (k, v) -> k.put(v.getId().longValue(), v), HashMap::putAll);
        Map<Long, BigDecimal> advertiserSumBudgetDailyMap = this.getSumTicketBudgetDailyByAdvertiser(advertiserIds);
        Map<String, String> ticketStatusDictMap = this.dictionariesService.getCodeDetailMapByCode("adstatus");
        ArrayList<AdTicketMobileVO> adTicketMobileVOS = new ArrayList<AdTicketMobileVO>(adTickets.size());
        long daysNum = DateUtil.countDiffDateDays2((Date)conditionDTO.getStartTime(), (Date)conditionDTO.getEndTime()) + 1L;
        for (AdTicket adTicket : adTickets) {
            AdTicketMobileVO adTicketMobileVO = new AdTicketMobileVO();
            BeanUtils.copyProperties((Object)adTicket, (Object)adTicketMobileVO);
            adTicketMobileVO.setPrice(Double.valueOf(adTicket.getPrice().doubleValue() / 1000.0));
            if (CommonConstant.TicketSettleType.CPC.equals(adTicketMobileVO.getSettleType())) {
                adTicketMobileVO.setBudgetDaily(Double.valueOf(adTicket.getBudgetDaily().doubleValue() / 1000.0));
            } else {
                adTicketMobileVO.setBudgetDaily(Double.valueOf(adTicket.getBudgetDaily().doubleValue()));
            }
            AdvertiserDto advertiserDto = (AdvertiserDto)advertiserMap.get(adTicketMobileVO.getAdvertiser());
            if (null != advertiserDto) {
                BigDecimal advertiserBalanceSum;
                adTicketMobileVO.setAdvertiserName(advertiserDto.getCompany());
                BigDecimal sumBudgetDaily = advertiserSumBudgetDailyMap.get(adTicketMobileVO.getAdvertiser());
                if (null != sumBudgetDaily && (sumBudgetDaily = sumBudgetDaily.divide(new BigDecimal(1000), 2, 4)).compareTo(advertiserBalanceSum = this.getAdvertiserBalance(advertiserDto)) >= 0 && !TicketStatusEnum.STOP.getStatus().equals(adTicket.getStatus().intValue())) {
                    adTicketMobileVO.setNeedBeRedFlag(Integer.valueOf(1));
                }
                Money money = Money.ofLi((long)this.prodPullerIntegration.getAdvertiserBalance(adTicket.getAdvertiser()));
                adTicketMobileVO.setAdvertiserBalance(new BigDecimal(money.getYuan()));
            }
            if (TicketStatusEnum.PAUSE.getStatus().equals(adTicket.getStatus().intValue()) && null != adTicket.getPauseReason()) {
                adTicketMobileVO.setStatus(ticketStatusDictMap.get("2-" + adTicket.getPauseReason()));
            } else {
                adTicketMobileVO.setStatus(ticketStatusDictMap.get(adTicket.getStatus() + ""));
            }
            this.calculatePv(conditionDTO.getStartTime(), daysNum, adTicketMobileVO);
            Boolean isSupportOcpc = (Boolean)ticketOcpcMap.get(adTicket.getId());
            adTicketMobileVO.setIsSupportOcpc(Integer.valueOf(null != isSupportOcpc && isSupportOcpc != false ? 1 : 0));
            adTicketMobileVOS.add(adTicketMobileVO);
        }
        this.calculateValidClick(conditionDTO.getStartTime(), adTicketMobileVOS);
        PageInfo adTicketMobileVOPageInfo = CollectionDataCopyUtil.copyPageInfo(adTicketPageInfo);
        adTicketMobileVOPageInfo.setList(adTicketMobileVOS);
        return adTicketMobileVOPageInfo;
    }

    private BigDecimal getAdvertiserBalance(AdvertiserDto advertiserDto) {
        BigDecimal balance = BigDecimal.ZERO;
        if (null != advertiserDto.getBalance()) {
            balance = balance.add(advertiserDto.getBalance());
        }
        if (null != advertiserDto.getRebateMoney()) {
            balance = balance.add(advertiserDto.getRebateMoney());
        }
        if (null != advertiserDto.getCreditMoney()) {
            balance = balance.add(advertiserDto.getCreditMoney());
        }
        return balance;
    }

    private Map<Long, BigDecimal> getSumTicketBudgetDailyByAdvertiser(List<Long> advertiserIds) {
        List adTickets = this.adTicketMapper.findTicketsByAdvertiserIds(advertiserIds);
        HashMap<Long, BigDecimal> sumBudgetDailyMap = new HashMap<Long, BigDecimal>(advertiserIds.size());
        for (AdTicket adTicket : adTickets) {
            if (CommonConstant.TicketSettleType.CPA.equals(adTicket.getSettleType())) continue;
            BigDecimal budgetDaily = (BigDecimal)sumBudgetDailyMap.get(adTicket.getAdvertiser());
            if (null == budgetDaily) {
                budgetDaily = BigDecimal.ZERO;
            }
            budgetDaily = budgetDaily.add(new BigDecimal(adTicket.getBudgetDaily()));
            sumBudgetDailyMap.put(adTicket.getAdvertiser(), budgetDaily);
        }
        return sumBudgetDailyMap;
    }

    @Override
    public TicketDetailVO detail(Long ticketId) {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (null == adTicket) {
            throw new NullPointerException("\u6728\u6709\u627e\u5230\u76f8\u5173\u7684\u5e7f\u544a\u5238\uff01");
        }
        TicketDetailVO ticketDetailVO = new TicketDetailVO();
        BeanUtils.copyProperties((Object)adTicket, (Object)ticketDetailVO);
        AdTicketOcpcConf adTicketOcpcConf = this.adTicketOcpcService.selectByTicketId(adTicket.getId());
        if (null != adTicketOcpcConf && 1 == adTicketOcpcConf.getIsSupportOcpc() && CommonConstant.TicketSettleType.CPC.equals(adTicket.getSettleType())) {
            if (null != adTicketOcpcConf.getCpaExpectPrice()) {
                ticketDetailVO.setCpaExpectPrice(Double.valueOf(Money.ofLi((long)adTicketOcpcConf.getCpaExpectPrice().intValue()).getYuan()));
            }
            ticketDetailVO.setCloseThreshold(adTicketOcpcConf.getCloseThreshold());
        }
        List<AdFlowPackageNewVo> packages = this.adTicketFlowNewService.findPackageByCondition(adTicket.getId(), adTicket.getSettleType() == null ? "cpc" : adTicket.getSettleType().toString());
        ticketDetailVO.setAdFlows(packages);
        return ticketDetailVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Boolean update(TicketUpdateDTO updateDTO, UserVo userVo) {
        boolean isSuccess;
        String operationUserName = userVo.getUsername();
        AdTicket adTicket = CollectionUtils.isNotEmpty((Collection)userVo.getRoleCodes()) && (userVo.getRoleCodes().contains(RoleEnum.AELEADER.getCode()) || userVo.getRoleCodes().contains(RoleEnum.ADMIN.getCode())) ? this.adTicketMapper.selectByPrimaryKey(updateDTO.getId()) : this.adTicketMapper.findOneByIdAndAe(updateDTO.getId(), operationUserName);
        if (null == adTicket) {
            throw new NullPointerException("\u6728\u6709\u627e\u5230\u76f8\u5173\u7684\u5e7f\u544a\u5238\uff01");
        }
        this.checkPrice(adTicket.getSettleType(), updateDTO.getPrice().doubleValue());
        adTicket.setLastStatus(adTicket.getLastStatus());
        adTicket.setId(adTicket.getId());
        adTicket.setPrice(Integer.valueOf(Long.valueOf(Money.ofYuan((double)updateDTO.getPrice().doubleValue()).getLi()).intValue()));
        if (CommonConstant.TicketSettleType.CPC.equals(adTicket.getSettleType()) || CommonConstant.TicketSettleType.CPM.equals(adTicket.getSettleType())) {
            adTicket.setBudgetDaily(Long.valueOf(Money.ofYuan((double)updateDTO.getBudgetDaily().doubleValue()).getLi()));
        } else {
            adTicket.setBudgetDaily(Long.valueOf(updateDTO.getBudgetDaily().longValue()));
        }
        if (TicketStatusEnum.NORMAL.getStatus().equals(adTicket.getStatus().intValue()) || TicketStatusEnum.PAUSE.getStatus().equals(adTicket.getStatus().intValue())) {
            this.checkAndSetStatus(adTicket);
        }
        adTicket.setModifyUser(operationUserName);
        AdTicketPriceConf adTicketPriceConf = new AdTicketPriceConf();
        adTicketPriceConf.setCreateUser(operationUserName);
        adTicketPriceConf.setModifyUser(operationUserName);
        adTicketPriceConf.setTicketId(adTicket.getId());
        adTicketPriceConf.setAfterPrice(adTicket.getPrice());
        this.adTicketPriceConfService.update(adTicketPriceConf);
        AdTicketOcpcConf adTicketOcpcConf = this.adTicketOcpcService.selectByTicketId(adTicket.getId());
        if (null != adTicketOcpcConf && 1 == adTicketOcpcConf.getIsSupportOcpc() && CommonConstant.TicketSettleType.CPC.equals(adTicket.getSettleType())) {
            if (null == updateDTO.getCloseThreshold()) {
                throw new NullPointerException("\u5e7f\u544a\u5c4f\u853d\u9608\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == updateDTO.getCpaExpectPrice()) {
                throw new NullPointerException("\u9884\u671fCPA\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            AdTicketOcpcConf ocpcConfUpdateEntity = new AdTicketOcpcConf();
            ocpcConfUpdateEntity.setCloseThreshold(updateDTO.getCloseThreshold());
            ocpcConfUpdateEntity.setIsSupportOcpc(adTicketOcpcConf.getIsSupportOcpc());
            ocpcConfUpdateEntity.setTicketId(adTicket.getId());
            ocpcConfUpdateEntity.setCpaExpectPrice(Integer.valueOf(Long.valueOf(Money.ofYuan((double)updateDTO.getCpaExpectPrice().doubleValue()).getLi()).intValue()));
            if (this.adTicketOcpcService.update(ocpcConfUpdateEntity) <= 0) {
                throw new RuntimeException("\u4fee\u6539OCPC\u5931\u8d25");
            }
        }
        this.updateAdticketFlowPackage(updateDTO.getFlowPackageArray(), adTicket.getId(), adTicket.getSettleType(), operationUserName);
        boolean bl = isSuccess = this.adTicketMapper.updateByPrimaryKeySelective(adTicket) > 0;
        if (isSuccess) {
            try {
                this.prodService.pushAdTicketToProdPre(adTicket.getId());
            }
            catch (Exception e) {
                log.error(">>>>>>>>>>\u63a8\u9001\u5e7f\u544a\u5238\u6570\u636e\u5230prod\u5931\u8d25, errMsg", (Throwable)e);
                throw new RuntimeException("\u63a8\u9001\u5e7f\u544a\u5238\u6570\u636e\u5230prod\u5931\u8d25\uff01");
            }
            return true;
        }
        throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u5238\u5931\u8d25\uff01");
    }

    @Override
    public Boolean updateStatus(Long ticketId, Short status, UserVo userVo) {
        AdTicket adTicket = CollectionUtils.isNotEmpty((Collection)userVo.getRoleCodes()) && (userVo.getRoleCodes().contains(RoleEnum.AELEADER.getCode()) || userVo.getRoleCodes().contains(RoleEnum.ADMIN.getCode())) ? this.adTicketMapper.selectByPrimaryKey(ticketId) : this.adTicketMapper.findOneByIdAndAe(ticketId, userVo.getUsername());
        if (null == adTicket) {
            throw new NullPointerException("\u6728\u6709\u627e\u5230\u76f8\u5173\u7684\u5e7f\u544a\u5238\uff01");
        }
        AdTicket updateEntity = new AdTicket();
        updateEntity.setId(ticketId);
        updateEntity.setStatus(status);
        updateEntity.setModifyUser(userVo.getUsername());
        try {
            Object result = this.adTicketService.updateStatus(updateEntity);
            return (Integer)result > 0;
        }
        catch (Exception e) {
            log.error(">>>>>>>>>\u4fee\u6539\u5238\u72b6\u6001\u5931\u8d25\uff0c", (Throwable)e);
            return false;
        }
    }

    private void checkPrice(Short settleType, Double price) {
        if (CommonConstant.TicketSettleType.CPA.equals(settleType)) {
            return;
        }
        if (99999.0 < price) {
            throw new RuntimeException("\u6700\u9ad8\u652f\u6301\u51fa\u4ef710.00\u5143");
        }
    }

    private void calculateValidClick(Date startTime, List<AdTicketMobileVO> adTicketMobileVOS) {
        if (CollectionUtils.isEmpty(adTicketMobileVOS)) {
            return;
        }
        List ticketIds = adTicketMobileVOS.stream().map(AdTicketMobileVO::getId).collect(Collectors.toList());
        String dateFormatStr = DateUtil.dateToFormat((Date)startTime, (String)"yyyy-MM-dd");
        try {
            List ticketCountCommonList = this.dataparkTicketPullerIntegration.getTicketCount(dateFormatStr, null, JSON.toJSONString(ticketIds));
            if (CollectionUtils.isEmpty((Collection)ticketCountCommonList)) {
                return;
            }
            Map ticketCountMap = ticketCountCommonList.stream().collect(HashMap::new, (k, v) -> k.put(v.getCertificateid(), v.getValidClick()), HashMap::putAll);
            for (AdTicketMobileVO adTicketMobileVO : adTicketMobileVOS) {
                Integer validClick = (Integer)ticketCountMap.get(adTicketMobileVO.getId());
                if (null == validClick) continue;
                adTicketMobileVO.setValidClick(validClick);
            }
        }
        catch (Exception e) {
            log.error(">>>>>>>>>[dataparkTicketPullerIntegration.getTicketCount(a,b,c)] \u4ecedatapark\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c", (Throwable)e);
        }
    }

    private void calculatePv(Date startTime, Long daysNum, AdTicketMobileVO adTicketMobileVO) {
        String ticketId = adTicketMobileVO.getId().toString();
        int openPv = 0;
        int clickPv = 0;
        Long budgetOfDaily = 0L;
        for (long i = 0L; i < daysNum; ++i) {
            openPv += this.prodPullerIntegration.fetchOpenPvCount(ticketId, DateUtil.dateTo8String1((Date)startTime)).intValue();
            clickPv += this.prodPullerIntegration.fetchClikePvCount(ticketId, DateUtil.dateTo8String1((Date)startTime)).intValue();
            budgetOfDaily = budgetOfDaily + this.prodPullerIntegration.fetchBudgetOfDailyCount(ticketId, DateUtil.dateTo8String1((Date)startTime));
            startTime = DateUtil.increaseDate((Date)startTime, (int)1);
        }
        adTicketMobileVO.setOpenPv(Integer.valueOf(openPv));
        adTicketMobileVO.setClickPv(Integer.valueOf(clickPv));
        adTicketMobileVO.setClickRate(DoubleUtil.formatDouble(String.valueOf(clickPv), String.valueOf(openPv)));
        adTicketMobileVO.setConsume(Double.valueOf(CommonConstant.TicketSettleType.CPC.equals(adTicketMobileVO.getSettleType()) ? Double.valueOf(String.valueOf(budgetOfDaily)) / 1000.0 : 0.0));
    }

    private List<AdvertiserDto> getAllAdvertiser(String idOrName) {
        if (StringUtils.isBlank((CharSequence)idOrName)) {
            return Collections.emptyList();
        }
        AdvertiserDto search = new AdvertiserDto();
        if (NumberUtils.isNumber((String)idOrName)) {
            try {
                search.setId(Integer.valueOf(idOrName));
            }
            catch (NumberFormatException e) {
                search.setCompany(idOrName);
            }
        } else {
            search.setCompany(idOrName);
        }
        try {
            log.info(">>>>>>>>>>[adShopIntegration.getAdShopList()]--> query params:{}", (Object)idOrName);
            return this.adShopIntegration.getAdShopList(search);
        }
        catch (Exception e) {
            log.error("[adShopIntegration.getAdShopList()]\u83b7\u53d6\u5e7f\u544a\u4e3b\u96c6\u5408\u5931\u8d25, ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<AdvertiserDto> getAllAdvertiserByIds(List<Long> advertiserIds) {
        try {
            String ids = Joiner.on((String)",").join(advertiserIds);
            log.info(">>>>>>>>>>[adShopIntegration.findAdShopMsgs()]--> query params:{}", (Object)ids);
            return this.adShopIntegration.findAdShopMsgs(ids);
        }
        catch (Exception e) {
            log.error("[adShopIntegration.getAdShopList()]\u83b7\u53d6\u5e7f\u544a\u4e3b\u96c6\u5408\u5931\u8d25, ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void checkAndSetStatus(AdTicket adTicket) {
        Date date = new Date();
        adTicket.setStatus(Short.valueOf((short)1));
        adTicket.setPauseReason(null);
        if (DateUtil.compareOnlyDate((Date)date, (Date)adTicket.getValidStartDate()) < 0) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(3));
            return;
        }
        if (DateUtil.compareOnlyDate((Date)date, (Date)adTicket.getValidEndDate()) > 0) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(4));
            return;
        }
        Long consumeBudget = this.prodPullerIntegration.getBudgetOfToday(adTicket.getId());
        if (null != consumeBudget && consumeBudget.compareTo((long)adTicket.getBudgetDaily()) >= 0) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(1));
            return;
        }
        Long advertiserBalance = this.prodPullerIntegration.getAdvertiserBalance(adTicket.getAdvertiser());
        if (null != advertiserBalance && advertiserBalance.compareTo(adTicket.getPrice().longValue()) < 0 && CommonConstant.TicketSettleType.CPC.equals(adTicket.getSettleType())) {
            adTicket.setStatus(Short.valueOf((short)2));
            adTicket.setPauseReason(Integer.valueOf(2));
        }
    }

    private void updateAdticketFlowPackage(String flowPackage, Long ticketId, Short adTicketSettleType, String operationUserName) {
        this.adTicketFlowPackageMapper.deleteByTicketIdAndType(ticketId, Integer.valueOf(2));
        if (StringUtil.isNotEmpty((CharSequence)flowPackage)) {
            if (!CommonConstant.TicketSettleType.CPC.equals(adTicketSettleType)) {
                throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u5238\u5931\u8d25\uff1a\u4ec5CPC\u7ed3\u7b97\u7c7b\u578b\u7684\u5238\u652f\u6301\u6d41\u91cf\u5305\u9650\u989d\u51fa\u4ef7\u8bbe\u7f6e\uff01");
            }
            List packages = JSON.parseArray((String)flowPackage, AdFlowPackageNewDto.class);
            for (AdFlowPackageNewDto aPackage : packages) {
                if (StringUtils.isBlank((CharSequence)aPackage.getPrice())) {
                    throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u5238\u5931\u8d25\uff1a\u6d41\u91cf\u5305\u9650\u989d\u51fa\u4ef7\u8bbe\u7f6e\u4e2d\u7684\u91d1\u989d\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
                }
                BigDecimal adPackagePrice = new BigDecimal(aPackage.getPrice());
                if (adPackagePrice.compareTo(BigDecimal.ZERO) > 0 && adPackagePrice.compareTo(BigDecimal.valueOf(99999.0)) <= 0) continue;
                throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u5238\u5931\u8d25\uff1a\u6d41\u91cf\u5305\u9650\u989d\u51fa\u4ef7\u5c0f\u4e8e\u7b49\u4e8e10\u4e14\u5927\u4e8e0\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)packages)) {
                ArrayList<AdTicketFlowPackageConf> adTicketFlowPackageConfs = new ArrayList<AdTicketFlowPackageConf>();
                for (AdFlowPackageNewDto adFlowDto : packages) {
                    AdTicketFlowPackageConf adFlow = new AdTicketFlowPackageConf();
                    adFlow.setTicketId(ticketId);
                    adFlow.setFlowPackageId(adFlowDto.getFlowPackageId());
                    adFlow.setPrice(Long.valueOf(StringUtils.isNotBlank((CharSequence)adFlowDto.getPrice()) ? Money.ofYuan((double)Double.valueOf(adFlowDto.getPrice())).getLi() : 0L));
                    String quota = adFlowDto.getQuota();
                    if (StringUtil.isNotEmpty((CharSequence)quota)) {
                        if ("infinity".equalsIgnoreCase(quota)) {
                            adFlow.setQuota("infinity");
                        } else {
                            Money money = Money.ofYuan((double)Double.valueOf(quota));
                            adFlow.setQuota(String.valueOf(money.getLi()));
                        }
                    } else {
                        adFlow.setQuota("0");
                    }
                    adFlow.setCpaPrice(Long.valueOf(StringUtils.isNotBlank((CharSequence)adFlowDto.getCpaPrice()) ? Money.ofYuan((double)Double.valueOf(adFlowDto.getCpaPrice())).getLi() : 0L));
                    adFlow.setDeepCpaPrice(Long.valueOf(StringUtils.isNotBlank((CharSequence)adFlowDto.getDeepCpaPrice()) ? Money.ofYuan((double)Double.valueOf(adFlowDto.getDeepCpaPrice())).getLi() : 0L));
                    adFlow.setType(Integer.valueOf(2));
                    adFlow.setCreateUser(operationUserName);
                    adFlow.setModifyUser(operationUserName);
                    adTicketFlowPackageConfs.add(adFlow);
                }
                this.adTicketFlowPackageMapper.insert(adTicketFlowPackageConfs);
            }
        }
    }
}

