/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adposition.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.activites.facade.constant.RedisKey;
import com.bxm.activites.facade.service.ActivityBackService;
import com.bxm.activities.service.ActivityBackFacadeService;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateMapperExt;
import com.bxm.adsmanager.dal.mapper.config.AdPositionConfigMapper;
import com.bxm.adsmanager.dal.mapper.config.AdPositionExtConfigMapper;
import com.bxm.adsmanager.dal.mapper.config.ext.AdPositionConfigMapperExt;
import com.bxm.adsmanager.dal.mapper.position.PositionNewConfigMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.config.AdPositionConfig;
import com.bxm.adsmanager.model.dao.config.AdPositionConfigExample;
import com.bxm.adsmanager.model.dao.config.AdPositionExtConfig;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.PositionNewConfig;
import com.bxm.adsmanager.model.enums.AppEntrancePutinTypeEnum;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.ro.AppEntranceEditRo;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adkeeper.AdAssetsTemplateService;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.adsmedia.ProviderFinanceService;
import com.bxm.adsmanager.service.adsmedia.ProviderService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAuditVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.appentrance.UpdateAppEntranceDTO;
import com.bxm.adsmedia.facade.model.provider.FirstProviderAuditDto;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.adsprod.facade.position.PositionConfig;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdPositionAuditServiceImpl
implements AdPositionAuditService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionAuditServiceImpl.class);
    @Resource
    private AdPositionConfigMapperExt adPositionConfigMapperExt;
    @Resource
    private AdPositionConfigMapper adPositionConfigMapper;
    @Resource
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Resource
    private RedisNewClient redisNewClient;
    @Autowired
    private AdPositionExtConfigMapper adPositionExtConfigMapper;
    @Autowired
    private PositionNewConfigMapper positionNewConfigMapper;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private ProviderFinanceService providerFinanceService;
    @Autowired
    private ProviderService providerService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private ActivityBackService activityBackService;
    @Autowired
    private ActivityBackFacadeService activityBackFacadeService;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private AdAssetsTemplateService adAssetsTemplateService;
    @Autowired
    private AdAssetsTemplateMapperExt adAssetsTemplateMapperExt;
    @Autowired
    private ProdPusherIntegration prodPusher;
    public static final Integer REDIS_INDEX = 3;
    public static final Integer PRE_SERVICE = 76;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public static KeyGenerator keyGenerator() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "NOT", "CHECK", "UV"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public boolean updateAdPositionInfo(AppEntranceEditRo editRo, String username) throws Exception {
        PositionNewConfig positionNewConfig;
        if (StringUtils.isEmpty((CharSequence)editRo.getAppKey()) || StringUtils.isEmpty((CharSequence)editRo.getBusiness())) {
            throw new ValidateException("appkey\u6216\u8005business\u4e3a\u7a7a");
        }
        String adPositionId = editRo.getAppKey().concat("-").concat(editRo.getBusiness());
        if (editRo.getCheckUv() == 0) {
            this.updater.hupdate(AdPositionAuditServiceImpl.keyGenerator(), adPositionId, (Object)0);
        } else {
            this.updater.hremove(AdPositionAuditServiceImpl.keyGenerator(), new String[]{adPositionId});
        }
        if (null == editRo.getNeedFloatMaterial()) {
            editRo.setNeedFloatMaterial(Integer.valueOf(1));
        }
        if (null == (positionNewConfig = this.positionNewConfigMapper.findByPositionId(adPositionId))) {
            positionNewConfig = new PositionNewConfig();
            positionNewConfig.setPositionId(adPositionId);
            positionNewConfig.setCreateTime(new Date());
        } else {
            positionNewConfig.setUpdateTime(new Date());
        }
        positionNewConfig.setNewWanliu(editRo.getNewWanliu());
        positionNewConfig.setStayWindowdsRegion(editRo.getStayWindowdsRegion());
        positionNewConfig.setStayWindowdsTime(editRo.getStayWindowdsTime());
        if (StringUtils.isEmpty((CharSequence)editRo.getStayWindowdsRegion())) {
            positionNewConfig.setStayWindowdsRegion("");
        }
        if (StringUtils.isEmpty((CharSequence)editRo.getStayWindowdsTime())) {
            positionNewConfig.setStayWindowdsTime("");
        }
        positionNewConfig.setMore(editRo.getMore());
        positionNewConfig.setActivityStatement(editRo.getActivityStatement());
        positionNewConfig.setIntro(editRo.getIntro());
        if (StringUtils.isEmpty((CharSequence)editRo.getIntro())) {
            positionNewConfig.setIntro(null);
        }
        positionNewConfig.setRewardTicket(editRo.getRewardTicket());
        positionNewConfig.setRewardTicketCount(editRo.getRewardTicketCount());
        positionNewConfig.setActExplain(editRo.getActExplain());
        positionNewConfig.setActRule(editRo.getActRule());
        positionNewConfig.setQq(editRo.getQq());
        positionNewConfig.setQqFront(editRo.getQqFront());
        positionNewConfig.setKfFront(Byte.valueOf(editRo.getConfig() != 0 ? (byte)1 : 0));
        positionNewConfig.setKfPhone(editRo.getKfPhone());
        if (positionNewConfig.getId() != null) {
            this.positionNewConfigMapper.updateByPrimaryKeySelective(positionNewConfig);
        } else {
            this.positionNewConfigMapper.insertSelective(positionNewConfig);
        }
        String json = JSON.toJSONString((Object)positionNewConfig);
        this.redisNewClient.hset("AD_POSITION_CONFIG_NEW", adPositionId, json, REDIS_INDEX, null);
        this.saveOrUpdate(adPositionId, editRo.getNeedFloatMaterial(), username);
        UpdateAppEntranceDTO dto = new UpdateAppEntranceDTO();
        dto.setPositionId(adPositionId);
        dto.setProviderAlias(editRo.getProviderAlias());
        dto.setAppEntranceAlias(editRo.getAppEntranceAlias());
        dto.setDspFlag(editRo.getDspFlag());
        dto.setEntranceScene(editRo.getEntranceScene());
        dto.setImageSize(editRo.getPositionSize());
        dto.setCooperationType(editRo.getCooperationType());
        dto.setReportUrl(editRo.getReportUrl());
        dto.setPositionScene(editRo.getPositionScene());
        if (editRo.getAdxConf() != null) {
            UpdateAppEntranceDTO.AdxConf adxConf = new UpdateAppEntranceDTO.AdxConf();
            BeanUtils.copyProperties((Object)editRo.getAdxConf(), (Object)adxConf);
            if (editRo.getAdxConf().getAdxNative() != null) {
                UpdateAppEntranceDTO.AdxConf.AdxNative adxNative = new UpdateAppEntranceDTO.AdxConf.AdxNative();
                BeanUtils.copyProperties((Object)editRo.getAdxConf().getAdxNative(), (Object)adxNative);
                adxConf.setAdxNative(adxNative);
            }
            if (editRo.getAdxConf().getAdxPicture() != null) {
                UpdateAppEntranceDTO.AdxConf.AdxPicture adxPicture = new UpdateAppEntranceDTO.AdxConf.AdxPicture();
                BeanUtils.copyProperties((Object)editRo.getAdxConf().getAdxPicture(), (Object)adxPicture);
                adxConf.setAdxPicture(adxPicture);
            }
            if (editRo.getAdxConf().getAdxText() != null) {
                UpdateAppEntranceDTO.AdxConf.AdxText adxText = new UpdateAppEntranceDTO.AdxConf.AdxText();
                BeanUtils.copyProperties((Object)editRo.getAdxConf().getAdxText(), (Object)adxText);
                adxConf.setAdxText(adxText);
            }
            if (editRo.getAdxConf().getAdxNativeVideo() != null) {
                UpdateAppEntranceDTO.AdxConf.AdxNativeVideo adxNativeVideo = new UpdateAppEntranceDTO.AdxConf.AdxNativeVideo();
                BeanUtils.copyProperties((Object)editRo.getAdxConf().getAdxNativeVideo(), (Object)adxNativeVideo);
                adxConf.setAdxNativeVideo(adxNativeVideo);
            }
            dto.setAdxConf(adxConf);
        }
        if (StringUtils.isNumeric((CharSequence)editRo.getMediaClass())) {
            dto.setMediaClassId(Long.valueOf(editRo.getMediaClass()));
        }
        if (null != editRo.getDockingMethod()) {
            dto.setDockingMethod(editRo.getDockingMethod());
        }
        if (StringUtils.isNumeric((CharSequence)editRo.getMediaChildClass())) {
            dto.setMediaChildClassId(Long.valueOf(editRo.getMediaChildClass()));
        }
        dto.setCountry(editRo.getCountry());
        dto.setModifier(username);
        boolean result = this.newAppEntranceFacadeIntegration.updateByPositionId(dto);
        if (!result) {
            throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01");
        }
        this.pushPositionConfig(editRo, adPositionId);
        if (editRo.getAdxConf() != null && editRo.getAdxConf().getProfitMargin() != null) {
            this.adAssetsTemplateService.updateAssetsTemplateAssociationsPositionNum();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("positionId", adPositionId);
        this.prodPusher.pushToProd(ProdServiceNameEnum.GROUP_POSITION_SWITCH.getServiceName(), map, JSONArray.toJSONBytes((Object)editRo.getOpenWhiteGroup(), (SerializerFeature[])new SerializerFeature[0]));
        return true;
    }

    @Override
    public boolean batchsaveOrUpdate(AppEntranceEditRo editRo) {
        List<String> positionIds = Arrays.asList(editRo.getPositionIds().split(","));
        for (String adPositionId : positionIds) {
            PositionNewConfig positionNewConfig = this.positionNewConfigMapper.findByPositionId(adPositionId);
            if (null == positionNewConfig) {
                positionNewConfig = new PositionNewConfig();
                positionNewConfig.setPositionId(adPositionId);
                positionNewConfig.setCreateTime(new Date());
            } else {
                positionNewConfig.setUpdateTime(new Date());
            }
            positionNewConfig.setQq(editRo.getQq());
            positionNewConfig.setQqFront(editRo.getQqFront());
            positionNewConfig.setKfFront(Byte.valueOf(editRo.getConfig() != 0 ? (byte)1 : 0));
            positionNewConfig.setKfPhone(editRo.getKfPhone());
            if (positionNewConfig.getId() != null) {
                this.positionNewConfigMapper.updateByPrimaryKeySelective(positionNewConfig);
            } else {
                this.positionNewConfigMapper.insertSelective(positionNewConfig);
            }
            String json = JSON.toJSONString((Object)positionNewConfig);
            this.redisNewClient.hset("AD_POSITION_CONFIG_NEW", adPositionId, json, REDIS_INDEX, null);
        }
        return true;
    }

    @Override
    public boolean updateOldKf() {
        List list = this.positionNewConfigMapper.findAll();
        for (PositionNewConfig adPositionConfig : list) {
            adPositionConfig.setQqFront(Byte.valueOf((byte)0));
            this.positionNewConfigMapper.updateByPrimaryKeySelective(adPositionConfig);
            String json = JSON.toJSONString((Object)adPositionConfig);
            this.redisNewClient.hset("AD_POSITION_CONFIG_NEW", adPositionConfig.getPositionId(), json, REDIS_INDEX, null);
        }
        return true;
    }

    private void pushPositionConfig(AppEntranceEditRo editRo, String adPositionId) throws Exception {
        PositionConfig positionConfig = new PositionConfig();
        positionConfig.setPositionId(adPositionId);
        positionConfig.setNeedFloatMaterial(editRo.getNeedFloatMaterial());
        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_CONFIG_CACHEPUSH.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)positionConfig));
    }

    private void saveOrUpdate(String adPositionId, Integer needFloatMaterial, String username) {
        AdPositionExtConfig config = this.adPositionExtConfigMapper.getByPositionId(adPositionId);
        Date now = new Date();
        if (config == null) {
            config = new AdPositionExtConfig();
            config.setPositionId(adPositionId);
            config.setNeedFloatMaterial(needFloatMaterial);
            config.setCreateTime(now);
            config.setCreateUser(username);
            this.adPositionExtConfigMapper.insert(config);
        } else {
            config.setNeedFloatMaterial(needFloatMaterial);
            config.setModifyTime(now);
            config.setModifyUser(username);
            this.adPositionExtConfigMapper.updateByPrimaryKeySelective(config);
        }
    }

    @Override
    public void initConfigCache() {
        LOGGER.info("========\u5f00\u59cb\u6267\u884credis\u521d\u59cb\u5316=============");
        AdPositionConfigExample example = new AdPositionConfigExample();
        example.createCriteria().andEnableEqualTo(Boolean.valueOf(true));
        List adPositionConfigs = this.adPositionConfigMapper.selectByExample(example);
        for (AdPositionConfig config : adPositionConfigs) {
            String key = RedisKeys.getKey((String)"AD_POSITION_CONFIG_%s", (Object[])new Object[]{config.getAdPositionId()});
            this.redisNewClient.sadd(key, String.valueOf(config.getConfigId()), REDIS_INDEX);
        }
        LOGGER.info("========redis\u521d\u59cb\u5316\u6267\u884c\u5b8c\u6bd5=============");
    }

    @Override
    public boolean saveOrUpdateAdPositionInfoForExist() throws Exception {
        Byte rewardTicket = 1;
        Integer rewardTicketCount = 3;
        LOGGER.info("========\u5f00\u59cb\u6267\u884c\u6fc0\u52b1\u5238\u521d\u59cb\u5316=============");
        List positionNewConfigList = this.positionNewConfigMapper.findAll();
        for (PositionNewConfig positionNewConfig : positionNewConfigList) {
            if (positionNewConfig.getRewardTicket() != null && positionNewConfig.getRewardTicketCount() != null) continue;
            positionNewConfig.setUpdateTime(new Date());
            if (positionNewConfig.getRewardTicket() == null) {
                positionNewConfig.setRewardTicket(rewardTicket);
            }
            if (positionNewConfig.getRewardTicketCount() == null) {
                positionNewConfig.setRewardTicketCount(rewardTicketCount);
            }
            this.positionNewConfigMapper.updateByPrimaryKeySelective(positionNewConfig);
            String json = JSON.toJSONString((Object)positionNewConfig);
            this.redisNewClient.hset("AD_POSITION_CONFIG_NEW", positionNewConfig.getPositionId(), json, REDIS_INDEX, null);
        }
        LOGGER.info("========\u6fc0\u52b1\u5238\u521d\u59cb\u5316\u5b8c\u6bd5=============");
        return true;
    }

    @Override
    public boolean updateCouponsInfo(AppEntranceEditRo editRo, String username) throws Exception {
        if (StringUtils.isEmpty((CharSequence)editRo.getAppKey()) || StringUtils.isEmpty((CharSequence)editRo.getBusiness())) {
            throw new ValidateException("appkey\u6216\u8005business\u4e3a\u7a7a");
        }
        String adPositionId = editRo.getAppKey().concat("-").concat(editRo.getBusiness());
        UpdateAppEntranceDTO dto = new UpdateAppEntranceDTO();
        dto.setPositionId(adPositionId);
        if (null != editRo.getCouponsPutinFlag()) {
            dto.setCouponsPutinFlag(editRo.getCouponsPutinFlag());
            if (editRo.getCouponsPutinFlag().booleanValue()) {
                dto.setPutinType(AppEntrancePutinTypeEnum.COUPON.getType());
            }
        }
        if (null != editRo.getCouponsIconSize()) {
            dto.setCouponsIconSize(editRo.getCouponsIconSize());
        }
        if (null != editRo.getCouponsCreativeSize()) {
            dto.setCouponsCreativeSize(editRo.getCouponsCreativeSize());
        }
        dto.setModifier(username);
        boolean result = this.newAppEntranceFacadeIntegration.updateCouponsInfo(dto);
        if (!result) {
            throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01");
        }
        return true;
    }

    @Override
    public PageInfo<AppEntranceAuditVO> getAuditPage(String keywords, Byte status, Long providerId, String mjCode, Integer areaType, Integer pageNum, Integer pageSize) {
        PageInfo auditPage = this.newAppEntranceFacadeIntegration.getAuditPage(keywords, status, providerId, mjCode, areaType, pageNum, pageSize);
        if (auditPage != null && auditPage.getList() != null && auditPage.getList().size() > 0) {
            Map<String, String> kfzbqMap = this.dictionariesService.getIdDetailMapByCode("KFZBQ");
            auditPage.getList().stream().forEach(e -> {
                String tags = e.getTags();
                if (StringUtils.isNotBlank((CharSequence)tags)) {
                    String[] tagArray = tags.split(",");
                    StringBuilder tagNams = new StringBuilder();
                    for (String tagId : tagArray) {
                        String tagName = (String)kfzbqMap.get(tagId);
                        if (tagName == null) continue;
                        tagNams.append(tagName).append(",");
                    }
                    if (tagNams.length() > 0) {
                        tagNams.deleteCharAt(tagNams.length() - 1);
                    }
                    e.setTags(tagNams.toString());
                }
            });
        }
        return auditPage;
    }

    @Override
    public boolean updatePutinTypeInfo(AppEntranceEditRo editRo, String username) throws Exception {
        if (StringUtils.isEmpty((CharSequence)editRo.getAppKey()) || StringUtils.isEmpty((CharSequence)editRo.getBusiness())) {
            throw new ValidateException("appkey\u6216\u8005business\u4e3a\u7a7a");
        }
        if (editRo.getPutinType() == null) {
            throw new ValidateException("\u8bf7\u9009\u62e9\u6295\u653e\u65b9\u5f0f");
        }
        AppEntrancePutinTypeEnum appEntrancePutinTypeEnum = AppEntrancePutinTypeEnum.getByCode((Byte)editRo.getPutinType());
        switch (appEntrancePutinTypeEnum) {
            case NORMAL: {
                break;
            }
            case COUPON: {
                if (null == editRo.getCouponsIconSize()) {
                    throw new ValidateException("\u5238\u7801\u6295\u653e\u6d6e\u6807\u4f4d\u5c3a\u5bf8ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != editRo.getCouponsCreativeSize()) break;
                throw new ValidateException("\u5238\u7801\u6295\u653e\u5c55\u793a\u4f4d\u5c3a\u5bf8ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case INSPRE_VIDEO: {
                if (null != editRo.getVideoDirection()) break;
                throw new ValidateException("\u89c6\u9891\u65b9\u5411\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        String adPositionId = editRo.getAppKey().concat("-").concat(editRo.getBusiness());
        UpdateAppEntranceDTO dto = new UpdateAppEntranceDTO();
        BeanUtils.copyProperties((Object)editRo, (Object)dto);
        dto.setPositionId(adPositionId);
        dto.setModifier(username);
        boolean result = this.newAppEntranceFacadeIntegration.updatePutinTypeInfo(dto);
        if (!result) {
            throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01");
        }
        return true;
    }

    @Override
    public boolean updateWechatMiniAppPutInfo(String positionId, Boolean wechatMiniAppPutFlag, String username) throws Exception {
        UpdateAppEntranceDTO dto = new UpdateAppEntranceDTO();
        dto.setPositionId(positionId);
        dto.setWechatMiniAppPutFlag(wechatMiniAppPutFlag);
        dto.setModifier(username);
        boolean result = this.newAppEntranceFacadeIntegration.updateWechatMiniAppPutInfo(dto);
        if (!result) {
            throw new RuntimeException("\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01");
        }
        if (wechatMiniAppPutFlag.booleanValue()) {
            this.jedisUpdater.supdate(RedisKey.Activity.getWechatMiniAppPut(), new String[]{positionId});
        } else {
            this.jedisUpdater.srem(RedisKey.Activity.getWechatMiniAppPut(), new String[]{positionId});
        }
        return true;
    }

    @Override
    public AppEntranceAdRO findPositionById(Long id) {
        List appEntranceAdROS = this.newAppEntranceFacadeIntegration.findByIds(Arrays.asList(id));
        if (CollectionUtils.isNotEmpty((Collection)appEntranceAdROS)) {
            return (AppEntranceAdRO)appEntranceAdROS.get(0);
        }
        return null;
    }

    @Override
    public Boolean auditPassDataHandle(FirstProviderAuditDto firstProviderAuditDto, boolean isRiskController, Boolean auditPass) {
        if (firstProviderAuditDto == null) {
            return false;
        }
        if (firstProviderAuditDto != null && !isRiskController) {
            return firstProviderAuditDto.getResult() == null ? false : firstProviderAuditDto.getResult();
        }
        try {
            if (isRiskController && firstProviderAuditDto.getAppEntranceSuccessIds() != null && auditPass.booleanValue()) {
                this.positionAddTag(firstProviderAuditDto.getAppEntranceSuccessIds());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
        }
        return true;
    }

    @Override
    public void positionAddTag(List<Long> appEntranceIds) throws Exception {
        List appEntranceAdROList = this.newAppEntranceFacadeIntegration.findByIds(appEntranceIds);
        List positionIds = appEntranceAdROList.stream().map(AppEntranceAdRO::getPositionId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(positionIds)) {
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setStatus(null);
            paramDTO.setPositionIds(positionIds);
            Map appEntranceCodeMap = this.newAppEntranceFacadeIntegration.getAppEntranceCodeMap(paramDTO);
            ArrayList<String> appKeys = new ArrayList<String>();
            for (String value : positionIds) {
                appKeys.add(value.split("-")[0]);
            }
            ProviderAppAdDTO dto = new ProviderAppAdDTO();
            dto.setAppKeys(appKeys);
            List providerAppList = this.providerFacadeIntegration.getProviderAppList(dto);
            HashMap<String, Integer> areaMap = new HashMap<String, Integer>();
            for (ProviderAppAdRO providerAppAdRO : providerAppList) {
                areaMap.put(providerAppAdRO.getAppKey(), providerAppAdRO.getAreaType());
            }
            List<String> tagArray = this.tblAdTagService.findCodeByTime();
            tagArray.addAll(Arrays.asList("157", "21", "45", "31", "32", "33", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "144"));
            String tagArrayJsonStrChina = JSON.toJSONString(tagArray);
            List<String> tagArrayOther = this.tblAdTagService.findCodeOtherByTime();
            tagArrayOther.addAll(Arrays.asList("157", "21", "45", "31", "32", "33", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "144"));
            String tagArrayJsonStrOther = JSON.toJSONString(tagArrayOther);
            String newFiveTagCode = "5";
            ArrayList<TblAdPostionTag> newFiveTagCodeList = new ArrayList<TblAdPostionTag>(100);
            List<TblAdPostionTag> newFiveTagLevel2CodeList = this.tblAdTagService.getTagCode(newFiveTagCode);
            List<TblAdPostionTag> newFiveTagLevel3CodeList = this.tblAdTagService.getLevel3TagCode(newFiveTagCode);
            newFiveTagCodeList.addAll(newFiveTagLevel2CodeList);
            newFiveTagCodeList.addAll(newFiveTagLevel3CodeList);
            Set newFiveTagIdSet = newFiveTagCodeList.stream().map(t -> t.getCode()).collect(Collectors.toSet());
            newFiveTagIdSet.add(Integer.valueOf(newFiveTagCode));
            String newFiveTagIdArrayJsonStr = JSON.toJSONString(newFiveTagIdSet);
            for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROList) {
                String positionId = appEntranceAdRO.getPositionId();
                String[] positionInfo = positionId.split("-");
                String appkey = positionInfo[0];
                String bussiness = positionInfo[1];
                String businessArray = JSON.toJSONString(Collections.singletonList(bussiness));
                if (appEntranceAdRO.getAppEntranceAdxId() == null) {
                    if (areaMap.getOrDefault(appkey, 0) == 0) {
                        this.mediaService.bathInsertTag(appkey, businessArray, tagArrayJsonStrChina, null, null);
                    } else {
                        this.mediaService.bathInsertTag(appkey, businessArray, tagArrayJsonStrOther, null, null);
                    }
                } else {
                    this.mediaService.bathInsertTag(appkey, businessArray, newFiveTagIdArrayJsonStr, null, null);
                }
                this.jedisUpdater.hremove(RedisKeys.getKeyGeneratorByPositionStatusSwitch(), new String[]{positionId});
                this.jedisUpdater.hupdate(RedisKeys.getPositionCodeKey(), positionId, appEntranceCodeMap.get(positionId));
            }
            this.activityBackFacadeService.saveActivityPOsitionRelationList(positionIds);
        }
    }
}

