/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adprofit.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdDomainArpuMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitPositionMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.AdTicketIncomeMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.AdTicketIncomePositionMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.InfoActivityCertificateValidMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdTicketIncomeMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdTicketIncomePositionMapperExt;
import com.bxm.adsmanager.dal.mapper.dting.RptAppInvalidCertificateDStatMapper;
import com.bxm.adsmanager.dal.mapper.mediamanager.ext.AdTicketPositionWeightMapperExt;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.datapark.service.DataparkListToMapService;
import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dao.adprofit.AdTicketIncome;
import com.bxm.adsmanager.model.dao.adprofit.AdTicketIncomePosition;
import com.bxm.adsmanager.model.dao.adprofit.InfoActivityCertificateValid;
import com.bxm.adsmanager.model.dao.dting.RptAppInvalidCertificateDStat;
import com.bxm.adsmanager.model.dto.AdTicketProfitSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo;
import com.bxm.adsmanager.model.vo.AdTicketIncomePositionVo;
import com.bxm.adsmanager.model.vo.AdTicketIncomeVo;
import com.bxm.adsmanager.model.vo.AdTicketPositionWeightVo;
import com.bxm.adsmanager.model.vo.AdvertiserTicketConsumeInfoVO;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.service.adprofit.UpdateReportCashService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsprod.facade.advertiser.StationUserWeightPushParam;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.commons.currency.Money;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AdIncomeTicketServiceImpl
implements AdIncomeTicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdIncomeTicketServiceImpl.class);
    public static final String TICKETARPUKEY = "AD:ARPU:TICKET:";
    public static final String POSTIONARPUKEY = "AD:ARPU:POSITION:";
    public static final int POSTIONARPUDB = 14;
    public static final String ADTICKETALL = "AD:TICKET:ALL";
    public static final String ADTICKETDEDUCTADVERTISER = "AD:TICKET:DEDUCT:ADVERTISER:";
    public static final String ADTICKETDEDUCTBDSALE = "AD:TICKET:DEDUCT:BDSALE";
    public static final String DEFAULT = "DEFAULT";
    public static final String DIRECT = "DIRECT";
    public static final String AGENT = "AGENT";
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AdTicketIncomeMapperExt adTicketIncomeExt;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private DataparkListToMapService dataparkListToMapService;
    @Autowired
    private AdTicketIncomeMapper adTicketIncomeMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private DataparkTicketPullerIntegration ticketPuller;
    @Autowired
    private RptAppInvalidCertificateDStatMapper rptAppInvalidCertificateDStatMapper;
    @Autowired
    private AdTicketIncomePositionMapper adTicketIncomePositionMapper;
    @Autowired
    private AdTicketIncomePositionMapperExt adTicketIncomePositionMapperExt;
    @Autowired
    private AdProfitPositionMapper adProfitPositionMapper;
    @Autowired
    private InfoActivityCertificateValidMapper infoActivityCertificateValidMapper;
    @Autowired
    private UpdateReportCashService updateReportCashService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private AdTicketPositionWeightMapperExt adTicketPositionWeightExt;
    @Autowired
    private AdDomainArpuMapper adDomainArpuMapper;
    @Autowired
    private PositionTicketWeightService positionTicketWeightService;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @Override
    public List<AdTicketIncomeVo> getTicketIncomeList(AdTicketProfitSearchDto search) throws Exception {
        ArrayList<AdTicketIncomeVo> results = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("start", search.getStart());
        param.put("end", search.getEnd());
        param.put("status", search.getStatus());
        param.put("advertisers", this.getAdvertiserIdsUseTicket(search.getUserName(), search.getSale()).get("advertiserIds"));
        results = this.adTicketIncomeExt.getAdTicketIncomeTotalMsg(param);
        return results;
    }

    @Override
    public List<AdTicketIncomeDetailVo> getTicketIncomeDeatil(AdTicketProfitSearchDto search) throws Exception {
        List<AdTicketIncomeDetailVo> results = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("datetime", search.getDatetime());
        Map<String, Object> msgMap = this.getAdvertiserIdsUseTicket(search.getUserName(), search.getSale());
        param.put("advertisers", msgMap.get("advertiserIds"));
        param.put("keyWords", search.getKeyWords());
        param.put("settleType", search.getSettleType());
        param.put("status", search.getStatus());
        results = this.adTicketIncomeExt.getAdTicketIncomeDetailMsg(param);
        Map advertiserMap = (Map)msgMap.get("advertiserMap");
        Map ticketMap = (Map)msgMap.get("ticketMap");
        Map<String, String> aeDic = this.dictionariesService.getCodeDetailMapByCode("ae");
        Map<String, String> saleDic = this.dictionariesService.getCodeDetailMapByCode("bususer");
        Map ticketCount = this.dataparkListToMapService.getTicketCountMap(search.getDatetime());
        for (AdTicketIncomeDetailVo vo : results) {
            AdTicket adTicket;
            AdvertiserDto advertiser = (AdvertiserDto)advertiserMap.get(vo.getAdvertiserId());
            if (advertiser != null) {
                vo.setAdvertiserName(advertiser.getCompany());
                vo.setSale(saleDic.get(advertiser.getSale()));
            }
            if (null != (adTicket = (AdTicket)ticketMap.get(vo.getTicketId()))) {
                vo.setAe(aeDic.get(adTicket.getAe()));
            }
            vo.setClickPv((Integer)ticketCount.get(vo.getTicketId()));
        }
        return results;
    }

    private Map<String, Object> getAdvertiserIds(String ae, String sale) throws Exception {
        ArrayList<Integer> advertiserIds = new ArrayList<Integer>();
        HashMap<Long, AdvertiserDto> advertiserMap = new HashMap<Long, AdvertiserDto>();
        AdvertiserDto search = new AdvertiserDto();
        if (StringUtils.isNotEmpty((CharSequence)ae)) {
            search.setAe(ae);
        }
        if (StringUtils.isNotEmpty((CharSequence)sale)) {
            search.setSale(sale);
        }
        List advertiserMsgs = this.adShopIntegration.getAdShopList(search);
        for (AdvertiserDto msg : advertiserMsgs) {
            advertiserIds.add(msg.getId());
            advertiserMap.put(msg.getId().longValue(), msg);
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("advertiserIds", advertiserIds);
        results.put("advertiserMap", advertiserMap);
        return results;
    }

    private Map<String, Object> getAdvertiserIdsUseTicket(String ae, String sale) throws Exception {
        List advertiserMsgs;
        ArrayList<Integer> advertiserIds = new ArrayList<Integer>();
        HashMap<Long, AdvertiserDto> advertiserMap = new HashMap<Long, AdvertiserDto>();
        HashMap<String, Object> results = new HashMap<String, Object>();
        AdvertiserDto search = new AdvertiserDto();
        if (StringUtils.isNotEmpty((CharSequence)sale)) {
            search.setSale(sale);
        }
        if (CollectionUtils.isEmpty((Collection)(advertiserMsgs = this.adShopIntegration.getAdShopList(search)))) {
            return results;
        }
        List ticketIds = this.adTicketMapper.findTicketByAe(ae);
        if (CollectionUtils.isEmpty((Collection)ticketIds)) {
            return results;
        }
        HashMap advTicketMap = Maps.newHashMap();
        HashMap ticketMap = Maps.newHashMap();
        for (AdTicket adTicket : ticketIds) {
            advTicketMap.put(adTicket.getAdvertiser(), adTicket);
            ticketMap.put(adTicket.getId(), adTicket);
        }
        for (AdvertiserDto advertiserDto : advertiserMsgs) {
            if (null == advTicketMap.get(advertiserDto.getId().longValue())) continue;
            advertiserIds.add(advertiserDto.getId());
            advertiserMap.put(advertiserDto.getId().longValue(), advertiserDto);
        }
        results.put("advertiserIds", advertiserIds);
        results.put("advertiserMap", advertiserMap);
        results.put("ticketMap", ticketMap);
        return results;
    }

    @Override
    public int update(Integer id, int number, String username) throws Exception {
        AdTicketIncome adTicketIncome = this.adTicketIncomeMapper.selectByPrimaryKey(Long.valueOf(id.longValue()));
        if (null == adTicketIncome) {
            throw new ValidateException("\u6839\u636eid\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u793c\u5238\u6536\u76ca");
        }
        AdTicketIncome income = new AdTicketIncome();
        income.setModifyUser(username);
        income.setId(Long.valueOf(id.longValue()));
        income.setNumber(Integer.valueOf(number));
        income.setTotalIncome(Integer.valueOf(number * adTicketIncome.getUnitPrice()));
        return this.adTicketIncomeMapper.updateByPrimaryKeySelective(income);
    }

    @Override
    public void entering(String ids, String datetime, String userName) throws Exception {
        if (StringUtils.isBlank((CharSequence)ids)) {
            throw new ValidateException("\u53c2\u6570\u5f02\u5e38");
        }
        ArrayList list = Lists.newArrayList();
        Iterator iter = Splitter.on((String)",").split((CharSequence)ids).iterator();
        while (iter.hasNext()) {
            list.add(Long.valueOf((String)iter.next()));
        }
        List adTicketIncomes = this.adTicketIncomeMapper.findAll((List)list);
        if (CollectionUtils.isEmpty((Collection)adTicketIncomes)) {
            throw new NullPointerException("\u6839\u636e\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6536\u76ca\u8bb0\u5f55");
        }
        ArrayList longList = Lists.newArrayList();
        for (AdTicketIncome income : adTicketIncomes) {
            longList.add(income.getTicketId());
        }
        List adTickets = this.adTicketMapper.findAllByIds((List)longList);
        HashMap adTicketMap = Maps.newHashMap();
        StringBuffer advertiserIds = new StringBuffer("");
        for (AdTicket adTicket : adTickets) {
            adTicketMap.put(adTicket.getId(), adTicket);
            advertiserIds.append(adTicket.getAdvertiser()).append(",");
        }
        HashMap advertiserMap = Maps.newHashMap();
        List advertiserDtos = this.adShopIntegration.findAdShopMsgs(advertiserIds.toString());
        if (CollectionUtils.isNotEmpty((Collection)advertiserDtos)) {
            for (AdvertiserDto advertiser : advertiserDtos) {
                advertiserMap.put(advertiser.getId(), advertiser);
            }
        }
        InfoActivityCertificateValid valid = this.infoActivityCertificateValidMapper.selectByDatetime(datetime);
        for (AdTicketIncome income : adTicketIncomes) {
            AdTicket adTicket = (AdTicket)adTicketMap.get(income.getTicketId());
            if (null == adTicket || null == income.getTotalIncome() || 0 > income.getTotalIncome() || 1 == income.getStatus() || 1 == adTicket.getSettleType()) continue;
            boolean ismonitoring = false;
            if (null != valid) {
                String validIds = valid.getCertificateids();
                for (String id : Splitter.on((String)",").split((CharSequence)validIds)) {
                    if (!id.equals(income.getTicketId() + "")) continue;
                    ismonitoring = true;
                }
            }
            if (2 == adTicket.getSettleType()) {
                this.deductAdvertiserFinance(income, adTicket.getAdvertiser().intValue());
            }
            int standaloneCost = 0;
            if (null != adTicket.getStandaloneCost()) {
                standaloneCost = adTicket.getStandaloneCost().intValue() / 100 * income.getTotalIncome();
            }
            income.setFixCost(Integer.valueOf(standaloneCost));
            AdvertiserDto advertiserDto = (AdvertiserDto)advertiserMap.get(adTicket.getAdvertiser().intValue());
            String bdSaleDeductRate = StringUtils.defaultString((String)this.redisClient.get(0, ADTICKETDEDUCTBDSALE), (String)"0.02");
            String accountType = advertiserDto.getAccountType() == 0 ? DIRECT : AGENT;
            String domainCode = StringUtils.defaultString((String)adTicket.getDomainCode(), (String)DEFAULT);
            String advertiserDeductRate = StringUtils.defaultString((String)this.redisClient.hGet(ADTICKETDEDUCTADVERTISER + accountType, domainCode, 0), (String)this.redisClient.hGet(ADTICKETDEDUCTADVERTISER + accountType, DEFAULT, 0));
            Double adshopAttributeNum = NumberUtils.toDouble((String)bdSaleDeductRate) + NumberUtils.toDouble((String)advertiserDeductRate, (double)0.2);
            Double deductnumTemp = (double)income.getTotalIncome().intValue() * adshopAttributeNum;
            int deductnum = deductnumTemp.intValue();
            income.setDivideIncome(Integer.valueOf(deductnum));
            income.setDivideRemark("\u72ec\u7acb\u6210\u672c\u6263\u6b3e:" + standaloneCost + ",\u5e7f\u544a\u4e3b\u5c5e\u6027\u6263\u6b3e:" + deductnum);
            income.setActualIncome(Integer.valueOf(income.getTotalIncome() - standaloneCost - deductnum));
            List ticketCountCommonList = this.ticketPuller.getTicketAppBusinessCount(datetime, adTicket.getId(), null, null);
            Map<String, Integer> pennyAlgorithmMap = this.pennyAlgorithm(ismonitoring, income, datetime, ticketCountCommonList, userName);
            AdTicketIncomePosition position = new AdTicketIncomePosition();
            position.setAppId("\u6563\u5ba2");
            position.setRemark("\u5269\u4f59\u7684\u94b1");
            position.setDatetime(datetime);
            position.setPositionId("\u6563\u5ba2");
            position.setTicketId(adTicket.getId());
            position.setConsume(Integer.valueOf(income.getActualIncome() - pennyAlgorithmMap.get("totalPositionCash")));
            this.adTicketIncomePositionMapper.insert(position);
            income.setStatus(Short.valueOf((short)1));
            income.setModifyUser(userName);
            this.adTicketIncomeMapper.updateByPrimaryKeySelective(income);
            this.updatePositionTicketWeight(adTicket.getId(), null);
        }
        this.updateReportCashService.updateReportCash(datetime);
    }

    public Map<String, Integer> pennyAlgorithm(boolean ismonitoring, AdTicketIncome income, String datetime, List<TicketCountCommon> ticketCountCommonList, String userName) {
        Integer totalPositionCash = 0;
        HashMap map = Maps.newHashMap();
        map.put("totalPositionCash", totalPositionCash);
        if (CollectionUtils.isEmpty(ticketCountCommonList)) {
            return map;
        }
        if (null == income || income.getNumber() < 1) {
            return map;
        }
        int totalActualCash = income.getActualIncome();
        int totalNum = 0;
        int validTotalNum = 0;
        for (TicketCountCommon countCommon : ticketCountCommonList) {
            totalNum += null == countCommon.getClickPv() ? 0 : countCommon.getClickPv();
            validTotalNum += null == countCommon.getValidClick() ? 0 : countCommon.getValidClick();
        }
        for (TicketCountCommon countCommon : ticketCountCommonList) {
            Double temp;
            double clickPv;
            Integer actualPositionCash = 0;
            if ("\u5408\u8ba1".equals(countCommon.getNumber())) continue;
            double validClick = null == countCommon.getValidClick() ? 0.0 : (double)countCommon.getValidClick().intValue();
            double d = clickPv = null == countCommon.getClickPv() ? 0.0 : (double)countCommon.getClickPv().intValue();
            if (ismonitoring) {
                temp = (double)totalActualCash * (validClick / (double)validTotalNum);
                actualPositionCash = temp.intValue();
            } else {
                temp = (double)totalActualCash * (clickPv / (double)totalNum);
                actualPositionCash = temp.intValue();
            }
            String business = countCommon.getBusiness();
            String product = countCommon.getBusiness();
            if (null != business) {
                business = business.replace("ad-", "");
            }
            if (actualPositionCash > 0) {
                AdTicketIncomePosition position = new AdTicketIncomePosition();
                position.setAppId(countCommon.getAppkey());
                position.setTicketId(income.getTicketId());
                position.setPositionId(countCommon.getAppkey() + "-" + business);
                position.setDatetime(datetime);
                position.setConsume(actualPositionCash);
                position.setProduct(product);
                position.setRemark("\u5e7f\u544a\u4f4d\u5b9e\u9645\u6536\u5165");
                this.adTicketIncomePositionMapper.insertSelective(position);
            }
            totalPositionCash = totalPositionCash + actualPositionCash;
        }
        map.put("totalPositionCash", totalPositionCash);
        return map;
    }

    public Map<String, String> findInvalidMsg(String datetime) {
        List list = this.rptAppInvalidCertificateDStatMapper.selectByDatetime(datetime);
        HashMap certificateMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (RptAppInvalidCertificateDStat stat : list) {
                String business = stat.getBusiness();
                if (null != business) {
                    business = business.replace("ad-", "");
                }
                certificateMap.put(stat.getAppKey() + "bxm" + business + "bxm" + stat.getCertificateId(), stat.getClickPv() + "bxm" + stat.getValidClickPv());
            }
        }
        return certificateMap;
    }

    private int inValidCash(boolean ismonitoring, Double appcash, String validMsg, int total, String positionId, String datetime, String userName) {
        String[] validMsgs;
        int invalidCash = 0;
        if (validMsg != null && validMsg.contains("bxm") && StringUtils.isNotEmpty((CharSequence)(validMsgs = validMsg.split("bxm"))[1])) {
            Double num = Double.valueOf(validMsgs[1]);
            if (ismonitoring) {
                num = Double.valueOf(validMsgs[0]);
            }
            Double temp = appcash * (num / (double)total);
            invalidCash = temp.intValue();
            AdProfitPosition position = this.adProfitPositionMapper.findByPositionIdDatetime(positionId, datetime);
            if (position != null && null != position.getIsImport() && 1 != position.getIsImport()) {
                position.setProfitCheat(Integer.valueOf(invalidCash + position.getProfitCheat()));
                position.setModifyUser(userName);
                this.adProfitPositionMapper.updateByPrimaryKeySelective(position);
            }
        }
        return invalidCash;
    }

    public void deductAdvertiserFinance(AdTicketIncome income, Integer advertiserId) throws Exception {
        Money money = Money.ofLi((long)income.getTotalIncome().intValue());
        double expenditure = money.getYuan();
        AdvertiserFinanceDto advertiser = new AdvertiserFinanceDto();
        advertiser.setAdvertiserId(advertiserId);
        advertiser.setCreated(new Date());
        advertiser.setExpenditure(new BigDecimal(expenditure));
        advertiser.setIncome(new BigDecimal("0"));
        advertiser.setRemark("\u5e7f\u544a\u5238" + income.getTicketId() + "\u6536\u76ca\u6263\u51cf");
        advertiser.setTicketId(income.getTicketId());
        String result = this.adShopIntegration.addAdShopCashNew(advertiser);
        if (StringUtils.isNotEmpty((CharSequence)result) && "true".equals(result)) {
            LOGGER.info("\u6263\u9664\u5e7f\u544a\u4e3b\uff1a" + advertiserId + "\u91d1\u989d:" + expenditure + "\u6210\u529f");
        } else {
            LOGGER.error("\u6263\u9664\u5e7f\u544a\u4e3b\uff1a" + advertiserId + "\u91d1\u989d:" + expenditure + "\u5931\u8d25");
        }
    }

    @Override
    public Map<String, Integer> getTicketIncomeGroupMedia(String datetime) {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        List msgs = this.adTicketIncomePositionMapperExt.fingMsgGroupMedia(datetime);
        for (AdTicketIncomePositionVo msg : msgs) {
            results.put(msg.getAppId(), msg.getConsume());
        }
        return results;
    }

    @Override
    public void updatePositionTicketWeight(Long ticketId, Long updateId) {
        Map stationUserWeightMap;
        if (updateId == null) {
            updateId = ticketId;
        }
        if (MapUtils.isNotEmpty((Map)(stationUserWeightMap = this.fetcher.hfetchall(TicketKeyGenerator.Advertiser.getStationUserWeight(), String.class)))) {
            for (Map.Entry entry : stationUserWeightMap.entrySet()) {
                List stationUserWeightPushParams = JSON.parseArray((String)((String)entry.getValue()), StationUserWeightPushParam.class);
                if (CollectionUtils.isEmpty((Collection)stationUserWeightPushParams)) continue;
                for (StationUserWeightPushParam weightPushParam : stationUserWeightPushParams) {
                    if (!weightPushParam.checkTicketExist(updateId).booleanValue()) continue;
                    LOGGER.info("=================================\u6743\u91cd\u8ba1\u5212\u5b58\u5728\u6b64\u5238\uff0c \u8df3\u8fc7\u5e7f\u544a\u4f4d\u6743\u91cd\u7684\u4fee\u6539\uff01\uff01\uff01\uff01");
                    return;
                }
            }
        }
        try {
            LOGGER.info(ticketId + "\u793c\u5238\u4eba\u5de5\u5e72\u9884\u7cfb\u6570\u5f00\u59cb\u91cd\u7f6e");
            List results = this.adTicketPositionWeightExt.findWeightMsg(updateId);
            for (AdTicketPositionWeightVo vo : results) {
                this.positionTicketWeightService.updateWeightRedis(vo.getPositionId(), String.valueOf(updateId), "100");
            }
            this.adTicketPositionWeightExt.updateFactorByTicket(updateId);
        }
        catch (Exception e) {
            LOGGER.error("\u793c\u5238\u4eba\u5de5\u5e72\u9884\u7cfb\u6570\u91cd\u7f6e\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    @Override
    public AdvertiserTicketConsumeInfoVO getTicketConsumeInfoByAdvertiserIds(List<Long> advertiserIds, Date beginDate, Date endDate) {
        List adTickets = this.adTicketMapper.findTicketsByAdvertisers(advertiserIds);
        if (CollectionUtils.isEmpty((Collection)adTickets)) {
            LOGGER.info("\u3010\u67e5\u8be2\u5e7f\u544a\u4e3b\u5238\u6d88\u8017\u8be6\u60c5\u3011\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u5e7f\u544a\u4e3b\u76f8\u5173\u5238\uff01\uff01\uff01");
            return new AdvertiserTicketConsumeInfoVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        Map ticketMap = adTickets.stream().collect(HashMap::new, (k, v) -> k.put(v.getId(), v), HashMap::putAll);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List adTicketIncomes = this.adTicketIncomeExt.findAllByTicketIdsInTimeFrame((List)Lists.newArrayList(ticketMap.keySet()), simpleDateFormat.format(beginDate), simpleDateFormat.format(endDate));
        if (CollectionUtils.isEmpty((Collection)adTicketIncomes)) {
            LOGGER.info("\u3010\u67e5\u8be2\u5e7f\u544a\u4e3b\u5238\u6d88\u8017\u8be6\u60c5\u3011\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u5e7f\u544a\u4e3b\u76f8\u5173\u5238\u7684\u6d88\u8017\uff01\uff01\uff01");
            return new AdvertiserTicketConsumeInfoVO(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        BigDecimal cpcTicketConsume = BigDecimal.ZERO;
        BigDecimal cpaTicketConsume = BigDecimal.ZERO;
        for (AdTicketIncome income : adTicketIncomes) {
            AdTicket adTicket = (AdTicket)ticketMap.get(income.getTicketId());
            if (null == adTicket) continue;
            if (adTicket.getSettleType().equals(CommonConstant.TicketSettleType.CPC)) {
                cpcTicketConsume = cpcTicketConsume.add(new BigDecimal(income.getTotalIncome()));
                continue;
            }
            cpaTicketConsume = cpaTicketConsume.add(new BigDecimal(income.getTotalIncome()));
        }
        AdvertiserTicketConsumeInfoVO vo = new AdvertiserTicketConsumeInfoVO();
        vo.setCpaTicketConsume(cpaTicketConsume);
        vo.setCpcTicketConsume(cpcTicketConsume);
        return vo;
    }
}

