/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adsmedia.impl;

import com.bxm.adsmanager.integration.adsmedia.appentrance.AppEntranceCalcRateConfigFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.PositionIncomeFacadeIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmanager.model.dto.position.AppEntranceCaleRateConfigQueryDto;
import com.bxm.adsmanager.service.adsmedia.AppEntranceCalcRateConfigService;
import com.bxm.adsmedia.facade.income.AppEntrancePvUvQueryDTO;
import com.bxm.adsmedia.facade.income.AppEntrancePvUvVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCalcRateConfigDTO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCalcRateConfigSimpleVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppEntranceCalcRateConfigServiceImpl
implements AppEntranceCalcRateConfigService {
    private static final Logger log = LoggerFactory.getLogger(AppEntranceCalcRateConfigServiceImpl.class);
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private AppEntranceCalcRateConfigFacadeIntegration appEntranceCalcRateConfigFacadeIntegration;
    @Autowired
    private PositionIncomeFacadeIntegration positionIncomeFacadeIntegration;

    @Override
    public PageInfo<AppEntrancePvUvVO> getPage(AppEntranceCaleRateConfigQueryDto dto) {
        String developerNameKeywords = dto.getDeveloperNameKeywords();
        String positionId = dto.getPositionId();
        if (StringUtils.isNotBlank((CharSequence)developerNameKeywords) || StringUtils.isNotBlank((CharSequence)positionId)) {
            List appEntranceAdROList;
            QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
            if (StringUtils.isNotBlank((CharSequence)developerNameKeywords)) {
                queryAppEntranceParamDTO.setProviderName(developerNameKeywords);
            }
            if (StringUtils.isNotBlank((CharSequence)positionId)) {
                queryAppEntranceParamDTO.setPositionIds(Arrays.asList(positionId));
            }
            if (CollectionUtils.isEmpty((Collection)(appEntranceAdROList = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO)))) {
                log.info("\u6ca1\u6709\u627e\u5230\u7b26\u5408\u7684\u5f00\u53d1\u8005\u5e7f\u544a\u4f4d\u6536\u76ca\u6570\u636e\uff01");
                return FacadePageInfoUtil.noneDataPage();
            }
            List appKeyList = appEntranceAdROList.stream().map(AppEntranceAdRO::getAppKey).collect(Collectors.toList());
            dto.setAppKeyList(appKeyList);
        }
        String today = DateUtil.dateTo8String((Date)new Date());
        dto.setDate(today);
        List positionPvUv = this.positionIncomeFacadeIntegration.getPositionPvUv((AppEntrancePvUvQueryDTO)dto);
        if (CollectionUtils.isEmpty((Collection)positionPvUv)) {
            log.info("\u6ca1\u6709\u6628\u65e5\u7684\u5f00\u53d1\u8005\u5e7f\u544a\u4f4d\u6536\u76ca\u6570\u636e\uff01");
            return FacadePageInfoUtil.noneDataPage();
        }
        List appEntranceCalcRateConfigFacadeIntegrationList = this.appEntranceCalcRateConfigFacadeIntegration.getList();
        if (CollectionUtils.isNotEmpty((Collection)appEntranceCalcRateConfigFacadeIntegrationList)) {
            Map<String, BigDecimal> positionPvuvRateMap = appEntranceCalcRateConfigFacadeIntegrationList.stream().collect(Collectors.toMap(AppEntranceCalcRateConfigSimpleVO::getPositionId, AppEntranceCalcRateConfigSimpleVO::getPvuvRate));
            for (AppEntrancePvUvVO appEntrancePvUvVO : positionPvUv) {
                BigDecimal pvuvRate = positionPvuvRateMap.get(appEntrancePvUvVO.getPositionId());
                if (pvuvRate == null) continue;
                appEntrancePvUvVO.setPvuvRate(pvuvRate);
            }
        }
        Collections.sort(positionPvUv, new Comparator<AppEntrancePvUvVO>(){

            @Override
            public int compare(AppEntrancePvUvVO o1, AppEntrancePvUvVO o2) {
                return o1.getPvuvRate().compareTo(o2.getPvuvRate());
            }
        });
        PageInfo pageInfo = FacadePageInfoUtil.getPageInfo((int)dto.getPageNum(), (int)dto.getPageSize(), (List)positionPvUv);
        return pageInfo;
    }

    @Override
    public void updateRate(AppEntranceCalcRateConfigDTO dto) {
        this.appEntranceCalcRateConfigFacadeIntegration.updateRate(dto);
    }
}

