/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adticketgroup.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adticketgroup.TicketGroupMutexMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adticketgroup.TicketGroupMutex;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.AdTicketAppEntranceVo;
import com.bxm.adsmanager.model.vo.adticketgroup.MutexTicketJSONVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupMutexService;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TicketGroupMutexServiceImpl
implements TicketGroupMutexService {
    private static final Logger log = LoggerFactory.getLogger(TicketGroupMutexServiceImpl.class);
    @Resource
    AdTicketMapper adTicketMapper;
    @Resource
    TicketGroupMutexMapper ticketGroupMutexMapper;
    @Autowired
    @Qualifier(value="jedisUpdaterForPangu")
    private Updater updater;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    public PageInfo<TicketGroupMutex> findAll(String keyword, Integer pageNum, Integer pageSize) {
        List list = this.adTicketMapper.getAdTicketAppEntrance(keyword, Arrays.asList("12", "13"), null, null, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        ArrayList<String> ticketIds = new ArrayList<String>();
        for (AdTicketAppEntranceVo adTicketAppEntranceVo : list) {
            ticketIds.add(adTicketAppEntranceVo.getId());
        }
        if (CollectionUtils.isEmpty(ticketIds)) {
            return new PageInfo();
        }
        List allTicketGroupMutexList = this.ticketGroupMutexMapper.selectByIds(null);
        if (CollectionUtils.isEmpty((Collection)allTicketGroupMutexList)) {
            return new PageInfo();
        }
        ArrayList<String> mutexIds = new ArrayList<String>();
        for (TicketGroupMutex ticketGroupMutex : allTicketGroupMutexList) {
            List mutexTicketJSONVos = JSON.parseArray((String)ticketGroupMutex.getJson(), MutexTicketJSONVo.class);
            Iterator iterator = mutexTicketJSONVos.iterator();
            while (iterator.hasNext()) {
                MutexTicketJSONVo mutexTicketJSONVo = (MutexTicketJSONVo)iterator.next();
                if (!ticketIds.contains(mutexTicketJSONVo.getTicketId())) continue;
                mutexIds.add(ticketGroupMutex.getId().toString());
            }
        }
        List allTicket = this.adTicketMapper.getAdTicketAppEntrance(null, Arrays.asList("12", "13"), null, null, null);
        HashMap<String, String> map = new HashMap<String, String>();
        for (AdTicketAppEntranceVo adTicketAppEntranceVo : allTicket) {
            map.put(adTicketAppEntranceVo.getId(), adTicketAppEntranceVo.getName());
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List ticketGroupMutexList = this.ticketGroupMutexMapper.selectByIds(mutexIds);
        for (TicketGroupMutex ticketGroupMutex : ticketGroupMutexList) {
            List mutexTicketJSONVos = JSON.parseArray((String)ticketGroupMutex.getJson(), MutexTicketJSONVo.class);
            for (MutexTicketJSONVo mutexTicketJSONVo : mutexTicketJSONVos) {
                mutexTicketJSONVo.setTicketName((String)map.get(mutexTicketJSONVo.getTicketId()));
            }
            ticketGroupMutex.setJson(JSON.toJSONString((Object)mutexTicketJSONVos));
        }
        return new PageInfo(ticketGroupMutexList);
    }

    @Override
    public void saveOrUpdate(Integer id, String json, String userName) throws Exception {
        TicketGroupMutex ticketGroupMutex = new TicketGroupMutex();
        if (Objects.nonNull(id)) {
            ticketGroupMutex.setId(id);
            ticketGroupMutex.setJson(json);
            ticketGroupMutex.setUpdateTime(new Date());
            ticketGroupMutex.setUpdateUser(userName);
            this.ticketGroupMutexMapper.updateByPrimaryKeySelective(ticketGroupMutex);
        } else {
            ticketGroupMutex.setJson(json);
            ticketGroupMutex.setCreaterTime(new Date());
            ticketGroupMutex.setCreaterUser(userName);
            this.ticketGroupMutexMapper.insertSelective(ticketGroupMutex);
        }
        this.saveRedis();
    }

    @Override
    public void delete(Integer id) throws Exception {
        this.ticketGroupMutexMapper.deleteByPrimaryKey(id);
        this.saveRedis();
    }

    private void saveRedis() throws Exception {
        List allList = this.ticketGroupMutexMapper.selectByIds(null);
        ArrayList<Metux> metuxList = new ArrayList<Metux>();
        for (TicketGroupMutex ticketGroupMutex : allList) {
            HashMap<Integer, ArrayList<String>> map = new HashMap<Integer, ArrayList<String>>();
            ArrayList<Integer> sortList = new ArrayList<Integer>();
            List mutexTicketJSONVos = JSON.parseArray((String)ticketGroupMutex.getJson(), MutexTicketJSONVo.class);
            for (MutexTicketJSONVo mutexTicketJSONVo : mutexTicketJSONVos) {
                ArrayList<String> ticketList = (ArrayList<String>)map.get(mutexTicketJSONVo.getSort());
                if (CollectionUtils.isNotEmpty((Collection)ticketList)) {
                    ticketList.add(mutexTicketJSONVo.getTicketId());
                } else {
                    ticketList = new ArrayList<String>();
                    ticketList.add(mutexTicketJSONVo.getTicketId());
                }
                map.put(mutexTicketJSONVo.getSort(), ticketList);
                if (sortList.contains(mutexTicketJSONVo.getSort())) continue;
                sortList.add(mutexTicketJSONVo.getSort());
            }
            Collections.sort(sortList);
            for (int i = 0; i < sortList.size() - 1; ++i) {
                Metux metux = new Metux();
                Integer sort = (Integer)sortList.get(i);
                List A = (List)map.get(sort);
                ArrayList<String> B = new ArrayList<String>();
                for (Integer key : map.keySet()) {
                    if (key <= sort) continue;
                    B.addAll((Collection)map.get(key));
                }
                metux.setMutexA(A);
                metux.setMutexB(B);
                metuxList.add(metux);
            }
        }
        log.error("\u5f00\u59cb\u63a8\u9001\u5e7f\u544a\u7ec4\u4e92\u65a5\u5238" + JSON.toJSONString(metuxList));
        this.prodPusher.pushToProd(ProdServiceNameEnum.GROUP_MUTEX_TICKET.getServiceName(), null, JSONArray.toJSONBytes(metuxList, (SerializerFeature[])new SerializerFeature[0]));
    }

    public static KeyGenerator mutexList() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "PANGU", "MUTEX", "CONFIG"});
    }

    public static void main(String[] args) {
        List<Integer> sortList = Arrays.asList(9, 1, 2, 5, 8, 4, 3);
        Collections.sort(sortList);
        for (int i = 0; i < sortList.size(); ++i) {
            System.out.println(sortList.get(i));
        }
        ArrayList<MutexTicketJSONVo> mutexTicketJSONVos = new ArrayList<MutexTicketJSONVo>();
        MutexTicketJSONVo mutexTicketJSONVo = new MutexTicketJSONVo();
        mutexTicketJSONVo.setSort(Integer.valueOf(1));
        mutexTicketJSONVo.setTicketId("30512");
        mutexTicketJSONVos.add(mutexTicketJSONVo);
        System.out.println(JSON.toJSONString(mutexTicketJSONVos));
    }

    static class Metux {
        private List<String> mutexA;
        private List<String> mutexB;

        public List<String> getMutexA() {
            return this.mutexA;
        }

        public List<String> getMutexB() {
            return this.mutexB;
        }

        public void setMutexA(List<String> mutexA) {
            this.mutexA = mutexA;
        }

        public void setMutexB(List<String> mutexB) {
            this.mutexB = mutexB;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metux)) {
                return false;
            }
            Metux other = (Metux)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$mutexA = this.getMutexA();
            List<String> other$mutexA = other.getMutexA();
            if (this$mutexA == null ? other$mutexA != null : !((Object)this$mutexA).equals(other$mutexA)) {
                return false;
            }
            List<String> this$mutexB = this.getMutexB();
            List<String> other$mutexB = other.getMutexB();
            return !(this$mutexB == null ? other$mutexB != null : !((Object)this$mutexB).equals(other$mutexB));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metux;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $mutexA = this.getMutexA();
            result = result * 59 + ($mutexA == null ? 43 : ((Object)$mutexA).hashCode());
            List<String> $mutexB = this.getMutexB();
            result = result * 59 + ($mutexB == null ? 43 : ((Object)$mutexB).hashCode());
            return result;
        }

        public String toString() {
            return "TicketGroupMutexServiceImpl.Metux(mutexA=" + this.getMutexA() + ", mutexB=" + this.getMutexB() + ")";
        }
    }
}

