/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adticketpopup.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adticketpopup.AdTicketPopupMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.AdTicketPopup.AdTicketPopup;
import com.bxm.adsmanager.model.dao.AdTicketPopup.ProvideAppDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.AdTicketNameDto;
import com.bxm.adsmanager.model.dto.AdTicketPopupDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.AdTicketPopupVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adticketpopup.AdTicketPopupService;
import com.bxm.adsmanager.service.prod.impl.ProdServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketPopupServiceImpl
implements AdTicketPopupService {
    @Autowired
    private AdTicketPopupMapper adTicketPopupMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;
    @Autowired
    private AdPositionService adPositionServiceImpl;
    @Autowired
    private AdTicketService adTicketServiceImpl;
    @Autowired
    ProdServiceImpl prodServiceImpl;

    @Override
    @Transactional
    public void add(AdTicketPopupDto adTicketPopupDto, String userName) throws Exception {
        String ticketIds = adTicketPopupDto.getTicketIds();
        ArrayList pushList = new ArrayList();
        ArrayList<AdTicketPopup> list = new ArrayList<AdTicketPopup>();
        if (StringUtil.isNotBlank((String)ticketIds)) {
            String[] ticketId;
            for (String ticIdAndseq : ticketId = ticketIds.split(",")) {
                HashMap<String, String> pushMap = new HashMap<String, String>();
                String[] sequces = ticIdAndseq.split("-");
                AdTicketPopup adTicketPopup = new AdTicketPopup();
                adTicketPopup.setCreateTime(new Date());
                adTicketPopup.setTicketId(sequces[0]);
                adTicketPopup.setPositionId(adTicketPopupDto.getPositionId());
                adTicketPopup.setScene(adTicketPopupDto.getScene());
                adTicketPopup.setCreateUser(userName);
                adTicketPopup.setSequence(Integer.valueOf(Integer.parseInt(sequces[1])));
                list.add(adTicketPopup);
                pushMap.put("ticketid", sequces[0]);
                pushMap.put("sequence", sequces[1]);
                pushList.add(pushMap);
            }
            this.adTicketPopupMapper.deleteByPositionId(adTicketPopupDto.getPositionId());
            this.adTicketPopupMapper.insert(list);
        } else {
            this.adTicketPopupMapper.deleteByPositionId(adTicketPopupDto.getPositionId());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("positionid", adTicketPopupDto.getPositionId());
        map.put("scenetype", adTicketPopupDto.getScene());
        this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET_SCENE.getServiceName(), map, JSONArray.toJSONBytes((Object)JSONArray.toJSON(pushList), (SerializerFeature[])new SerializerFeature[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Pagination findAll(AdTicketPopupDto adTicketPopupDto) {
        String appName = adTicketPopupDto.getAppName();
        String ticketId = adTicketPopupDto.getTicketId();
        String positionId = adTicketPopupDto.getPositionId();
        List<Object> prolist = new ArrayList();
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, ProvideAppDto> provideMap = new HashMap<String, ProvideAppDto>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        ArrayList<AdTicketPopupVo> atpvlist = new ArrayList<AdTicketPopupVo>();
        Integer totalCount = 0;
        if (StringUtil.isNotBlank((String)appName) && !StringUtil.equals((String)"null", (String)appName)) {
            prolist = this.adPositionServiceImpl.findAllByAppName(appName);
            if (CollectionUtils.isEmpty(prolist)) {
                return null;
            }
            StringBuffer sb = new StringBuffer("");
            for (ProvideAppDto provideAppDto : prolist) {
                provideMap.put(provideAppDto.getAppKey() + "-" + provideAppDto.getBussinessId(), provideAppDto);
                list.add(provideAppDto.getAppKey() + "-" + provideAppDto.getBussinessId());
            }
            paramsMap.put("list", list);
            paramsMap.put("ticketId", ticketId);
            paramsMap.put("positionId", positionId);
            paramsMap.put("pageStart", adTicketPopupDto.getPageStart());
            paramsMap.put("pageSize", adTicketPopupDto.getPageSize());
            totalCount = this.adTicketPopupMapper.totalcount(paramsMap);
            List adTicketPopupList = this.adTicketPopupMapper.findAll(paramsMap);
            if (adTicketPopupList == null || adTicketPopupList.size() <= 0) return null;
            for (AdTicketPopupVo adTicketPopupVo : adTicketPopupList) {
                if (!provideMap.containsKey(adTicketPopupVo.getPositionId())) continue;
                AdTicketPopupVo adTicketPopupVo2 = new AdTicketPopupVo();
                adTicketPopupVo2 = adTicketPopupVo;
                adTicketPopupVo2.setProvideName(((ProvideAppDto)provideMap.get(adTicketPopupVo.getPositionId())).getAppName());
                adTicketPopupVo2.setBusinessName(((ProvideAppDto)provideMap.get(adTicketPopupVo.getPositionId())).getBusinessName());
                atpvlist.add(adTicketPopupVo2);
            }
        } else {
            paramsMap.put("ticketId", ticketId);
            paramsMap.put("positionId", positionId);
            paramsMap.put("pageStart", adTicketPopupDto.getPageStart());
            paramsMap.put("pageSize", adTicketPopupDto.getPageSize());
            totalCount = this.adTicketPopupMapper.totalcount(paramsMap);
            List adTicketPopupList = this.adTicketPopupMapper.findAll(paramsMap);
            StringBuilder sb = new StringBuilder("");
            for (AdTicketPopupVo adTicketPopupVo : adTicketPopupList) {
                sb.append(adTicketPopupVo.getPositionId()).append(",");
            }
            prolist = this.adPositionServiceImpl.findAllByPositionId(sb.toString());
            for (ProvideAppDto provideAppDto : prolist) {
                provideMap.put(provideAppDto.getAppKey() + "-" + provideAppDto.getBussinessId(), provideAppDto);
            }
            for (AdTicketPopupVo adTicketPopupVo : adTicketPopupList) {
                if (!provideMap.containsKey(adTicketPopupVo.getPositionId())) continue;
                AdTicketPopupVo adTicketPopupVo3 = new AdTicketPopupVo();
                adTicketPopupVo3 = adTicketPopupVo;
                adTicketPopupVo3.setProvideName(((ProvideAppDto)provideMap.get(adTicketPopupVo.getPositionId())).getAppName());
                adTicketPopupVo3.setBusinessName(((ProvideAppDto)provideMap.get(adTicketPopupVo.getPositionId())).getBusinessName());
                atpvlist.add(adTicketPopupVo3);
            }
        }
        Pagination pagination = new Pagination();
        pagination.setList(atpvlist);
        pagination.setPageSize(adTicketPopupDto.getPageSize());
        pagination.setPageNo(adTicketPopupDto.getPageNum());
        pagination.setTotalCount(totalCount.intValue());
        return pagination;
    }

    @Override
    public List<AdTicketNameDto> findByPositionId(String positionId) throws Exception {
        if (StringUtil.isBlank((CharSequence)positionId)) {
            throw new Exception("\u5165\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.adTicketPopupMapper.findByPositionId(positionId);
        HashMap<String, AdTicketPopup> map = new HashMap<String, AdTicketPopup>();
        StringBuilder sb = new StringBuilder("");
        for (AdTicketPopup ap : list) {
            sb.append(ap.getTicketId()).append(",");
            map.put(ap.getTicketId(), ap);
        }
        List<AdTicket> adTicketsList = this.adTicketServiceImpl.findByIds(sb.toString());
        ArrayList<AdTicketNameDto> adntList = new ArrayList<AdTicketNameDto>();
        for (AdTicket at : adTicketsList) {
            if (!map.containsKey(at.getId() + "")) continue;
            AdTicketNameDto apnd = new AdTicketNameDto();
            apnd.setTicketId(at.getId() + "");
            apnd.setTicketName(at.getName());
            apnd.setSequence(((AdTicketPopup)map.get(at.getId() + "")).getSequence());
            apnd.setPositionId(positionId);
            adntList.add(apnd);
        }
        return adntList;
    }
}

