/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.advertiser.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.advertiser.TicketDataOptimizedMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceDto;
import com.bxm.adsmanager.integration.advertiser.service.AdFinanceFinanceService;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.advertiser.service.AdvertiserFeignService;
import com.bxm.adsmanager.model.dao.advertiserdata.TicketDataOptimized;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AdTicketDataOptimizedVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import com.bxm.adsmanager.service.advertiser.AdvertiserDataOptimizedService;
import com.bxm.commons.currency.Money;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertiserDataOptimizedServiceImpl
implements AdvertiserDataOptimizedService {
    @Autowired
    TicketDataOptimizedMapper ticketDataOptimizedMapper;
    @Autowired
    AdTicketMapper adTicketMapper;
    @Autowired
    AdFinanceFinanceService adFinanceFinanceService;
    @Autowired
    AdvertiserFeignService advertiserFeignService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserDataOptimizedServiceImpl.class);

    @Override
    public void add(TicketDataOptimized ticketDataOptimized) throws Exception {
        int count = this.ticketDataOptimizedMapper.selctCount(ticketDataOptimized.getRptDate(), ticketDataOptimized.getTicketId());
        if (count > 0) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
        }
        this.ticketDataOptimizedMapper.insert(ticketDataOptimized);
    }

    @Override
    public void delete(Long id) throws Exception {
        AdTicketDataOptimizedVo advertiserDataOptimizedVo = this.getAdvertiserDataOptimizedById(id);
        Integer deductStatus = advertiserDataOptimizedVo.getDeductStatus();
        if (deductStatus == 1) {
            throw new BusinessException("\u5220\u9664\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5df2\u6263\u6b3e");
        }
        this.ticketDataOptimizedMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void update(TicketDataOptimized ticketDataOptimized) throws Exception {
        int count = this.ticketDataOptimizedMapper.selctCount(ticketDataOptimized.getRptDate(), ticketDataOptimized.getTicketId());
        if (count < 0) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
        }
        AdTicketDataOptimizedVo advertiserDataOptimizedVo = this.getAdvertiserDataOptimizedById(ticketDataOptimized.getId());
        Integer deductStatus = advertiserDataOptimizedVo.getDeductStatus();
        if (deductStatus == 1) {
            throw new BusinessException("\u5df2\u6263\u6b3e\u4e0d\u80fd\u4fee\u6539");
        }
        ticketDataOptimized.setTicketId(null);
        ticketDataOptimized.setRptDate(null);
        this.ticketDataOptimizedMapper.updateByPrimaryKeySelective(ticketDataOptimized);
    }

    @Override
    public PageInfo<AdTicketDataOptimizedVo> findAll(String startTime, String endTime, String ticketId, String dimension, Integer pageNum, Integer pageSize) throws Exception {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("ticketId", ticketId);
        map.put("dimension", dimension);
        List adTicketDataOptimizedVos = this.ticketDataOptimizedMapper.selectTicketDataOptimizedList(map);
        Map allAdvertiserMap = this.adShopIntegration.getAllAdvertiserMap();
        adTicketDataOptimizedVos.stream().forEach(optimizedVos -> {
            if (null != optimizedVos.getAdvertiser()) {
                Integer advertiserId = optimizedVos.getAdvertiser().intValue();
                optimizedVos.setAdvertiserName((String)allAdvertiserMap.get(advertiserId));
            }
            if (optimizedVos.getShowNum() != null && optimizedVos.getClickNum() != null && optimizedVos.getClickNum() != 0L && optimizedVos.getShowNum() != 0L) {
                BigDecimal clickNum = new BigDecimal(optimizedVos.getClickNum());
                BigDecimal showNum = new BigDecimal(optimizedVos.getShowNum());
                optimizedVos.setClickRate(Double.valueOf(clickNum.divide(showNum, 2, 4).doubleValue()));
            } else {
                optimizedVos.setClickRate(Double.valueOf(0.0));
            }
        });
        PageInfo pageInfo = new PageInfo(adTicketDataOptimizedVos);
        return pageInfo;
    }

    public AdTicketDataOptimizedVo getAdvertiserDataOptimizedById(Long id) throws Exception {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("id", id);
        List advertiserDataOptimizeds = this.ticketDataOptimizedMapper.selectTicketDataOptimizedList(map);
        if (advertiserDataOptimizeds.size() <= 0) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (AdTicketDataOptimizedVo)advertiserDataOptimizeds.get(0);
    }

    @Override
    public boolean addAdvertiserFinanceById(Long id, User currentUser) throws Exception {
        AdTicketDataOptimizedVo optimizedVo = this.getAdvertiserDataOptimizedById(id);
        Long income = optimizedVo.getConsumeNum();
        Money money = Money.ofLi((long)income);
        double expenditure = money.getYuan();
        Integer advertiserId = optimizedVo.getAdvertiser().intValue();
        Integer deductStatus = optimizedVo.getDeductStatus();
        if (deductStatus == 1) {
            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u6263\u6b3e");
        }
        if (optimizedVo.getConsumeNum() == 0L && optimizedVo.getShowNum() == 0L && optimizedVo.getClickNum() == 0L && optimizedVo.getEffectNum() == 0L) {
            throw new BusinessException("\u6263\u6b3e\u5f02\u5e38\uff0c\u66dd\u5149\u3001\u70b9\u51fb\u3001\u6709\u6548\u70b9\u51fb\u3001\u6d88\u8017\u90fd\u4e3a0");
        }
        if (expenditure != 0.0) {
            AdvertiserFinanceDto advertiser = new AdvertiserFinanceDto();
            advertiser.setAdvertiserId(advertiserId);
            advertiser.setCreated(new Date());
            advertiser.setExpenditure(new BigDecimal(expenditure));
            advertiser.setIncome(new BigDecimal("0"));
            advertiser.setRemark("\u5e7f\u544a\u5238" + optimizedVo.getTicketId() + "\u6536\u76ca\u6263\u51cf");
            advertiser.setTicketId(optimizedVo.getTicketId());
            Boolean isSuccess = (Boolean)this.adFinanceFinanceService.add(advertiser).getReturnValue();
            if (isSuccess.booleanValue()) {
                LOGGER.info("\u6263\u9664\u5e7f\u544a\u4e3b\uff1a" + advertiserId + " \u91d1\u989d:" + expenditure + " \u6210\u529f");
            } else {
                LOGGER.error("\u6263\u9664\u5e7f\u544a\u4e3b\uff1a" + advertiserId + " \u91d1\u989d:" + expenditure + " \u5931\u8d25");
            }
        }
        TicketDataOptimized ticketDataOptimized = new TicketDataOptimized();
        ticketDataOptimized.setId(id);
        ticketDataOptimized.setDeductStatus(Integer.valueOf(1));
        ticketDataOptimized.setModifyTime(new Date());
        ticketDataOptimized.setModifyUser(currentUser.getUsername());
        this.ticketDataOptimizedMapper.updateByPrimaryKeySelective(ticketDataOptimized);
        return true;
    }

    @Override
    public List<TicketVo> findTicket(String keyword) throws Exception {
        List ticketVo = this.adTicketMapper.getStoppedTicket(keyword);
        return ticketVo;
    }
}

