/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adxadvertiserinfo.impl;

import com.bxm.adsmanager.dal.mapper.bes.BesAdvertiserInfoMapper;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfo;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfoExample;
import com.bxm.adsmanager.model.dto.bes.AdxAdvertiserSearchDTO;
import com.bxm.adsmanager.model.dto.bes.AuthHeader;
import com.bxm.adsmanager.model.dto.bes.qualification.BesQualificationResultDTO;
import com.bxm.adsmanager.model.dto.bes.qualification.BesQueryQualificationInfoDTO;
import com.bxm.adsmanager.model.enums.BesStatusEnum;
import com.bxm.adsmanager.model.vo.bes.BesAdvertiserInfoDetailVO;
import com.bxm.adsmanager.model.vo.bes.BesAdvertiserInfoListVO;
import com.bxm.adsmanager.service.adxadvertiserinfo.AdxAdvertiserInfoService;
import com.bxm.adsmanager.utils.BesApiUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdxAdvertiserInfoServiceImpl
implements AdxAdvertiserInfoService {
    private static final Logger log = LoggerFactory.getLogger(AdxAdvertiserInfoServiceImpl.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private BesAdvertiserInfoMapper besAdvertiserInfoMapper;
    @Autowired
    private AuthHeader authHeader;

    @Override
    public PageInfo<BesAdvertiserInfoListVO> findPage(AdxAdvertiserSearchDTO advertiserSearchDTO) throws Exception {
        AdvertiserDto search = new AdvertiserDto();
        boolean needQueryAdvertiser = false;
        if (StringUtils.isNotBlank((CharSequence)advertiserSearchDTO.getKeywords())) {
            needQueryAdvertiser = true;
            search.setCompany(advertiserSearchDTO.getKeywords());
        }
        if (advertiserSearchDTO.getAccountType() != null) {
            needQueryAdvertiser = true;
            search.setAccountType(advertiserSearchDTO.getAccountType());
        }
        BesAdvertiserInfoExample example = new BesAdvertiserInfoExample();
        BesAdvertiserInfoExample.Criteria criteria = example.createCriteria();
        PageInfo advertiserInfoListVOPageInfo = new PageInfo(Collections.emptyList());
        if (needQueryAdvertiser) {
            List adShopList = this.adShopIntegration.getAdShopList(search);
            if (CollectionUtils.isEmpty((Collection)adShopList)) {
                return advertiserInfoListVOPageInfo;
            }
            List adverstiserIdSet = adShopList.stream().map(AdvertiserDto::getId).distinct().collect(Collectors.toList());
            criteria.andAdvertiserIdIn(adverstiserIdSet);
        }
        if (advertiserSearchDTO.getAuditState() != null) {
            criteria.andAuditStateEqualTo(advertiserSearchDTO.getAuditState());
        }
        if (advertiserSearchDTO.getAdxAdvertiserType() != null) {
            criteria.andAdxAdvertiserTypeEqualTo(advertiserSearchDTO.getAdxAdvertiserType());
        }
        Page page = PageHelper.startPage((int)advertiserSearchDTO.getPageNum(), (int)advertiserSearchDTO.getPageSize());
        List besAdvertiserInfoList = this.besAdvertiserInfoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)besAdvertiserInfoList)) {
            return advertiserInfoListVOPageInfo;
        }
        List adverstiserIdSet = besAdvertiserInfoList.stream().map(BesAdvertiserInfo::getAdvertiserId).distinct().collect(Collectors.toList());
        List adShopMsgs = this.adShopIntegration.findAdShopMsgs(StringUtils.join((Object[])adverstiserIdSet.toArray(), (String)","));
        Map advertiserDtoMap = adShopMsgs.stream().collect(HashMap::new, (k, v) -> k.put(v.getId(), v), HashMap::putAll);
        ArrayList<BesAdvertiserInfoListVO> besAdvertiserInfoListVOS = new ArrayList<BesAdvertiserInfoListVO>(besAdvertiserInfoList.size());
        for (BesAdvertiserInfo besAdvertiserInfo : besAdvertiserInfoList) {
            BesAdvertiserInfoListVO besAdvertiserInfoListVO = new BesAdvertiserInfoListVO();
            BeanUtils.copyProperties((Object)besAdvertiserInfo, (Object)besAdvertiserInfoListVO);
            AdvertiserDto advertiserDto = advertiserDtoMap.getOrDefault(besAdvertiserInfoListVO.getAdvertiserId(), new AdvertiserDto());
            besAdvertiserInfoListVO.setCompany(advertiserDto.getCompany());
            besAdvertiserInfoListVO.setAccountType(advertiserDto.getAccountType());
            besAdvertiserInfoListVOS.add(besAdvertiserInfoListVO);
        }
        PageInfo pageInfo = page.toPageInfo();
        pageInfo.setList(besAdvertiserInfoListVOS);
        return pageInfo;
    }

    @Override
    public BesAdvertiserInfo get(Integer id) throws Exception {
        BesAdvertiserInfo besAdvertiserInfo = this.besAdvertiserInfoMapper.selectByPrimaryKey(id);
        if (besAdvertiserInfo == null) {
            throw new ValidateException("\u6ca1\u6709\u627e\u5230\u6570\u636e\uff01");
        }
        return besAdvertiserInfo;
    }

    @Override
    public BesAdvertiserInfoDetailVO getDetail(Integer id) throws Exception {
        BesAdvertiserInfo besAdvertiserInfo = this.besAdvertiserInfoMapper.selectByPrimaryKey(id);
        if (besAdvertiserInfo == null) {
            throw new ValidateException("\u6ca1\u6709\u627e\u5230\u6570\u636e\uff01");
        }
        BesAdvertiserInfoDetailVO besAdvertiserInfoDetailVO = new BesAdvertiserInfoDetailVO();
        BeanUtils.copyProperties((Object)besAdvertiserInfo, (Object)besAdvertiserInfoDetailVO);
        AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg((long)besAdvertiserInfoDetailVO.getAdvertiserId().intValue());
        if (advertiserDto != null) {
            besAdvertiserInfoDetailVO.setCompany(advertiserDto.getCompany());
            besAdvertiserInfoDetailVO.setAccountType(advertiserDto.getAccountType());
            besAdvertiserInfoDetailVO.setBusinessLicenseNo(advertiserDto.getBusinessLicenseNo());
        }
        return besAdvertiserInfoDetailVO;
    }

    @Override
    public BesAdvertiserInfo add(BesAdvertiserInfo besAdvertiserInfo) throws Exception {
        BesAdvertiserInfoExample example = new BesAdvertiserInfoExample();
        example.createCriteria().andAdvertiserIdEqualTo(besAdvertiserInfo.getAdvertiserId()).andAdxAdvertiserTypeEqualTo(besAdvertiserInfo.getAdxAdvertiserType());
        List list = this.besAdvertiserInfoMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new ValidateException("\u8be5\u5e7f\u544a\u4e3b\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        besAdvertiserInfo.setAuditState(null);
        besAdvertiserInfo.setId(null);
        Date currentTime = new Date();
        besAdvertiserInfo.setCreateTime(currentTime);
        this.besAdvertiserInfoMapper.insert(besAdvertiserInfo);
        return besAdvertiserInfo;
    }

    @Override
    public BesAdvertiserInfo update(BesAdvertiserInfo besAdvertiserInfo) throws Exception {
        Date currentTime = new Date();
        besAdvertiserInfo.setModifyTime(currentTime);
        this.besAdvertiserInfoMapper.updateByPrimaryKey(besAdvertiserInfo);
        return besAdvertiserInfo;
    }

    @Override
    public int getBesAuditStatus(Integer id) throws Exception {
        int licenceStatus;
        BesStatusEnum besStatusEnum;
        BesQualificationResultDTO.APIAdvertiserLicenceInfo mainLicence;
        BesQualificationResultDTO.APIAdvertiserQualificationInfo qualification;
        BesAdvertiserInfo besAdvertiserInfo = this.besAdvertiserInfoMapper.selectByPrimaryKey(id);
        if (besAdvertiserInfo == null) {
            throw new ValidateException("\u6ca1\u6709\u627e\u5230\u6570\u636e\uff01");
        }
        if (1 != besAdvertiserInfo.getAdxAdvertiserType()) {
            throw new ValidateException("\u8be5\u63a5\u53e3\u53ea\u80fd\u67e5\u8be2\u767e\u5ea6\u5e7f\u544a\u4e3b\uff01");
        }
        BesQueryQualificationInfoDTO besQueryQualificationInfoDTO = new BesQueryQualificationInfoDTO();
        besQueryQualificationInfoDTO.setAuthHeader(this.authHeader);
        besQueryQualificationInfoDTO.setAdvertiserId(Long.valueOf(besAdvertiserInfo.getAdvertiserId().longValue()));
        besQueryQualificationInfoDTO.setNeedLicenceImgUrl(Boolean.FALSE);
        BesQualificationResultDTO queryQualificationInfoResult = BesApiUtil.queryQualificationInfo(besQueryQualificationInfoDTO);
        if (queryQualificationInfoResult.success() && (qualification = queryQualificationInfoResult.getQualification()) != null && (mainLicence = qualification.getMainLicence()) != null && (besStatusEnum = BesStatusEnum.getByBesAuditResultStatus((int)(licenceStatus = mainLicence.getLicenceStatus().intValue()))) != null) {
            int status = besStatusEnum.getLogicStatus();
            besAdvertiserInfo.setAuditState(Integer.valueOf(status));
            this.besAdvertiserInfoMapper.updateByPrimaryKey(besAdvertiserInfo);
            return status;
        }
        return BesStatusEnum.PENDING.getLogicStatus();
    }

    @Override
    public void updateBesQualificationStatus() {
        BesAdvertiserInfoExample example = new BesAdvertiserInfoExample();
        example.createCriteria().andAdxAdvertiserTypeEqualTo(Integer.valueOf(1)).andAuditStateEqualTo(Integer.valueOf(BesStatusEnum.PENDING.getLogicStatus()));
        List list = this.besAdvertiserInfoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (BesAdvertiserInfo besAdvertiserInfo : list) {
            try {
                this.getDetail(besAdvertiserInfo.getId());
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5e7f\u544a\u4e3b\uff1a{}, \u7684\u767e\u5ea6\u5ba1\u6838\u72b6\u6001\u5931\u8d25\u3002", (Object)besAdvertiserInfo.getAdvertiserId(), (Object)e);
            }
        }
    }

    @Override
    public String getMeiTuanAdxAdvertiserId(Integer advertiserId) throws Exception {
        BesAdvertiserInfoExample example = new BesAdvertiserInfoExample();
        example.createCriteria().andAdvertiserIdEqualTo(advertiserId).andAdxAdvertiserTypeEqualTo(Integer.valueOf(2));
        List list = this.besAdvertiserInfoMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ((BesAdvertiserInfo)list.get(0)).getAdxAdvertiserId();
        }
        return null;
    }
}

