/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.agencychannel.impl;

import com.bxm.adsmanager.dal.mapper.agencychannel.ext.AgencyChannelDataMapperExt;
import com.bxm.adsmanager.dal.mapper.agencychannel.ext.AgencyChannelMapperExt;
import com.bxm.adsmanager.dal.mapper.agencychannel.ext.ProxyChannelDataMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.enums.BusinessEnum;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.cms.PanguPositionIncomeIntegration;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannel;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannelData;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannelDataExample;
import com.bxm.adsmanager.model.dao.agencychannel.ProxyChannelData;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDataBatchUpdateDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataImportExcelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataSearchDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelDataSyncDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelSearchDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelDataService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.utils.StartAndEndTimeUtil;
import com.bxm.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgencyChannelDataServiceImpl
implements AgencyChannelDataService {
    @Autowired
    private AgencyChannelDataMapperExt agencyChannelDataMapperExt;
    @Autowired
    private AgencyChannelMapperExt agencyChannelMapperExt;
    @Autowired
    private ProxyChannelDataMapperExt proxyChannelDataMapperExt;
    @Autowired
    private PanguPositionIncomeIntegration panguPositionIncomeIntegration;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private AgencyChannelDataService agencyChannelDataService;

    public boolean costIsEquals(AgencyChannelDataDTO data) throws Exception {
        BigDecimal validClickPrice = data.getValidClickPrice() == null ? BigDecimal.ZERO : data.getValidClickPrice();
        Long validClick = data.getValidClick() == null ? 0L : data.getValidClick();
        BigDecimal qualityFactor = data.getQualityFactor() == null ? BigDecimal.ONE : data.getQualityFactor();
        BigDecimal cpsBrokerage = data.getCpsBrokerage() == null ? BigDecimal.ZERO : data.getCpsBrokerage();
        BigDecimal income = validClickPrice.multiply(new BigDecimal(validClick.toString())).multiply(qualityFactor).add(cpsBrokerage);
        return data.getIncome().compareTo(income) == 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(AgencyChannelDataDTO dto, User user) throws Exception {
        int result;
        AgencyChannelData entity = new AgencyChannelData();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setId(null);
        Integer dataVerifyError = this.costIsEquals(dto) ? 0 : 1;
        entity.setDataVerifyError(Byte.valueOf(dataVerifyError.byteValue()));
        entity.setCreateTime(new Date());
        entity.setCreateUser(user.getUsername());
        if (StringUtils.isBlank((CharSequence)entity.getOwnedBusiness())) {
            AgencyChannelSearchDTO agencyChannelSearchDTO = new AgencyChannelSearchDTO();
            agencyChannelSearchDTO.setAgencyName(entity.getAgencyName());
            agencyChannelSearchDTO.setChannelNo(entity.getChannelNo());
            AgencyChannel agencyChannel = (AgencyChannel)this.agencyChannelMapperExt.findList(agencyChannelSearchDTO).get(0);
            entity.setOwnedBusiness(agencyChannel.getOwnedBusiness());
            entity.setProxyCode(agencyChannel.getProxyCode());
            entity.setNextProxyCode(agencyChannel.getNextProxyCode());
        }
        if ((result = this.agencyChannelDataMapperExt.insert(entity)) == 0) {
            return null;
        }
        if (StringUtils.equals((CharSequence)BusinessEnum.WFDL.getId(), (CharSequence)entity.getOwnedBusiness())) {
            ProxyChannelData proxyChannelData = new ProxyChannelData();
            proxyChannelData.setId(entity.getId());
            proxyChannelData.setThedate(entity.getThedate());
            proxyChannelData.setAgencyName(entity.getAgencyName());
            proxyChannelData.setChannelNo(entity.getChannelNo());
            proxyChannelData.setDs(entity.getNextProxyCode());
            proxyChannelData.setProxyCode(entity.getProxyCode());
            this.proxyChannelDataMapperExt.insert(proxyChannelData);
        }
        return entity.getId();
    }

    @Override
    public Integer update(AgencyChannelDataDTO dto, User user) throws Exception {
        AgencyChannelData entity = this.agencyChannelDataMapperExt.selectByPrimaryKey(Long.valueOf(dto.getId()));
        if (entity == null) {
            throw new BusinessException("\u6570\u636e\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)dto, (Object)entity, (String[])new String[]{"ownedBusiness", "proxyCode", "nextProxyCode"});
        List roleCodes = user.getRoleCodes();
        boolean isChanPinLeader = roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode());
        if (!dto.getBelonger().equals(user.getUsername()) && !isChanPinLeader) {
            throw new BusinessException("\u5f52\u5c5e\u8005\u975e\u5f53\u524d\u7528\u6237");
        }
        Integer dataVerifyError = this.costIsEquals(dto) ? 0 : 1;
        entity.setDataVerifyError(Byte.valueOf(dataVerifyError.byteValue()));
        entity.setModifyTime(new Date());
        entity.setModifyUser(user.getUsername());
        int result = this.agencyChannelDataMapperExt.updateByPrimaryKey(entity);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public boolean batchUpdate(AgencyChannelDataBatchUpdateDTO dto, User user) throws Exception {
        List<AgencyChannelData> list = this.getAgencyChannelData(dto.getIds(), user);
        for (AgencyChannelData entity : list) {
            if (dto.getValidClickPrice() != null) {
                entity.setValidClickPrice(dto.getValidClickPrice());
            }
            if (dto.getQualityFactor() != null) {
                entity.setQualityFactor(dto.getQualityFactor());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getRemark())) {
                entity.setRemark(dto.getRemark());
            }
            AgencyChannelDataDTO dataDTO = new AgencyChannelDataDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dataDTO);
            Integer dataVerifyError = this.costIsEquals(dataDTO) ? 0 : 1;
            entity.setDataVerifyError(Byte.valueOf(dataVerifyError.byteValue()));
            entity.setModifyTime(new Date());
            entity.setModifyUser(user.getUsername());
            this.agencyChannelDataMapperExt.updateByPrimaryKey(entity);
        }
        return Boolean.TRUE;
    }

    @Override
    public String importData(List<AgencyChannelDataImportExcelDTO> agencyChannelDataDTOList, User user, List<AgencyChannelDataImportExcelDTO> failList) throws Exception {
        StringBuilder errorMsg = new StringBuilder();
        StringBuilder returnStr = new StringBuilder();
        StringBuilder nonMaintainMsg = new StringBuilder();
        this.checkFailList(failList, errorMsg);
        this.checkRepeated(agencyChannelDataDTOList, errorMsg);
        int successNum = 0;
        Map agencyChannelMap = null;
        List list = this.agencyChannelMapperExt.findList(new AgencyChannelSearchDTO());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            agencyChannelMap = list.stream().collect(Collectors.toMap(agencyChannel -> agencyChannel.getAgencyName() + agencyChannel.getChannelNo(), Function.identity()));
        }
        String nullMsg = "";
        for (AgencyChannelDataImportExcelDTO agencyChannelDataImportExcelDTO : agencyChannelDataDTOList) {
            if (!Objects.nonNull(agencyChannelDataImportExcelDTO.getThedate()) || StringUtils.isBlank((CharSequence)agencyChannelDataImportExcelDTO.getAgencyName()) || StringUtils.isBlank((CharSequence)agencyChannelDataImportExcelDTO.getChannelNo())) {
                nullMsg = "\u65e5\u671f+\u4ee3\u7406\u540d\u79f0+\u6e20\u9053\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n";
            }
            if (MapUtils.isNotEmpty(agencyChannelMap)) {
                AgencyChannel agencyChannel2 = (AgencyChannel)agencyChannelMap.get(agencyChannelDataImportExcelDTO.getAgencyName() + agencyChannelDataImportExcelDTO.getChannelNo());
                if (!Objects.nonNull(agencyChannel2)) {
                    if (nonMaintainMsg.length() > 0) {
                        nonMaintainMsg.append("\u3001");
                    }
                    nonMaintainMsg.append(agencyChannelDataImportExcelDTO.getAgencyName()).append("-").append(agencyChannelDataImportExcelDTO.getChannelNo());
                    continue;
                }
                agencyChannelDataImportExcelDTO.setOwnedBusiness(agencyChannel2.getOwnedBusiness());
                agencyChannelDataImportExcelDTO.setProxyCode(agencyChannel2.getProxyCode());
                agencyChannelDataImportExcelDTO.setNextProxyCode(agencyChannel2.getNextProxyCode());
            }
            AgencyChannelDataDTO agencyChannelDataDTO = new AgencyChannelDataDTO();
            BeanUtils.copyProperties((Object)agencyChannelDataImportExcelDTO, (Object)agencyChannelDataDTO);
            agencyChannelDataDTO.setBelonger(user.getUsername());
            try {
                this.agencyChannelDataService.add(agencyChannelDataDTO, user);
                ++successNum;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof SQLIntegrityConstraintViolationException)) continue;
                if (returnStr.length() > 0) {
                    returnStr.append("\u3001");
                }
                returnStr.append(DateUtil.dateTo8String3((Date)agencyChannelDataDTO.getThedate())).append("-").append(agencyChannelDataDTO.getAgencyName()).append("-").append(agencyChannelDataDTO.getChannelNo());
            }
        }
        if (returnStr.length() > 0) {
            returnStr.insert(0, "\n\u5176\u4e2d:");
            returnStr.append("\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u672a\u5bfc\u5165\u6210\u529f");
        }
        if (nonMaintainMsg.length() > 0) {
            nonMaintainMsg.insert(0, "\n\u5176\u4e2d");
            nonMaintainMsg.append("\u5728\u6e20\u9053\u5b57\u5178\u4e2d\u672a\u7ef4\u62a4\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            returnStr.append((CharSequence)nonMaintainMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString()) || StringUtils.isNotBlank((CharSequence)nullMsg)) {
            returnStr.insert(0, nullMsg);
            returnStr.insert(0, errorMsg);
            returnStr.insert(0, "\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a\n");
        }
        returnStr.insert(0, successNum + "\u6761\u6570\u636e\u5bfc\u5165\u6210\u529f");
        return returnStr.toString();
    }

    private void checkFailList(List<AgencyChannelDataImportExcelDTO> failList, StringBuilder errorMsg) {
        if (CollectionUtils.isNotEmpty(failList)) {
            errorMsg.append("\u8d28\u91cf\u5206\u6574\u6570\u4f4d\u6700\u591a3\u4f4d\uff0c\u5c0f\u6570\u4f4d\u6700\u591a2\u4f4d\uff0c\u4e14\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff01\n");
        }
    }

    private void checkRepeated(List<AgencyChannelDataImportExcelDTO> list, StringBuilder errorMsg) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List repeated = list.stream().filter(t1 -> list.stream().filter(t2 -> (t1.getThedate() == null ? new Date() : t1.getThedate()).equals(t2.getThedate()) && (t1.getAgencyName() == null ? "" : t1.getAgencyName()).equals(t2.getAgencyName()) && (t1.getChannelNo() == null ? "" : t1.getChannelNo()).equals(t2.getChannelNo())).count() > 1L).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repeated)) {
            HashSet<String> messageSet = new HashSet<String>();
            for (AgencyChannelDataImportExcelDTO dto : repeated) {
                StringBuffer message = new StringBuffer();
                message.append(DateUtil.dateTo8String((Date)dto.getThedate())).append("-").append(dto.getAgencyName()).append("-").append(dto.getChannelNo());
                messageSet.add(message.toString());
            }
            list.removeAll(repeated);
            errorMsg.append("\u6709\u3010").append(repeated.size()).append("\u3011\u6761\u6570\u636e\u91cd\u590d\uff1a").append(((Object)messageSet).toString()).append("\n");
        }
    }

    @Override
    public PageInfo<AgencyChannelData> findAll(AgencyChannelDataSearchDTO searchDto, User user) throws Exception {
        searchDto.setBelonger(null);
        PageHelper.startPage((int)searchDto.getPageNum(), (int)searchDto.getPageSize());
        List<AgencyChannelData> list = this.getList(searchDto);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, String> dsMap = this.dictionariesService.getCodeDetailMapByCode("downstream");
            HashMap allMap = new HashMap();
            Map bdMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.BD.getCode(), Boolean.valueOf(true));
            Map saleMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.SALE.getCode(), Boolean.valueOf(true));
            allMap.putAll(bdMap);
            allMap.putAll(saleMap);
            list.forEach(agencyChannelData -> {
                if (StringUtils.isNotBlank((CharSequence)agencyChannelData.getOwnedBusiness())) {
                    agencyChannelData.setOwnedBusiness(BusinessEnum.of(agencyChannelData.getOwnedBusiness()).getName());
                    agencyChannelData.setNextProxyCode((String)dsMap.get(agencyChannelData.getNextProxyCode()));
                    agencyChannelData.setProxyCode((String)allMap.get(agencyChannelData.getProxyCode()));
                }
            });
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public List<AgencyChannelData> getList(AgencyChannelDataSearchDTO searchDto) throws Exception {
        return this.agencyChannelDataMapperExt.findList(searchDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public String delete(List<Long> ids, User user) throws Exception {
        List<AgencyChannelData> list = this.getAgencyChannelData(ids, user);
        List proxyChannelDataList = this.proxyChannelDataMapperExt.selectByIds(ids);
        Map map = null;
        if (CollectionUtils.isNotEmpty((Collection)proxyChannelDataList)) {
            map = proxyChannelDataList.stream().collect(Collectors.toMap(ProxyChannelData::getId, Function.identity()));
        }
        StringBuilder returnStr = new StringBuilder();
        ArrayList needDelList = Lists.newArrayList();
        for (AgencyChannelData agencyChannelData : list) {
            ProxyChannelData proxyChannelData;
            if (MapUtils.isNotEmpty(map) && Objects.nonNull(proxyChannelData = (ProxyChannelData)map.get(agencyChannelData.getId())) && (Objects.nonNull(proxyChannelData.getDsPrice()) || Objects.nonNull(proxyChannelData.getDsCpsBrokerage()) || Objects.nonNull(proxyChannelData.getDsIncome()) || Objects.nonNull(proxyChannelData.getDsValidClick()))) {
                returnStr.append(DateUtil.dateTo8String3((Date)agencyChannelData.getThedate())).append("-").append(agencyChannelData.getAgencyName()).append("-").append(agencyChannelData.getChannelNo()).append(";\n");
                needDelList.add(agencyChannelData);
                continue;
            }
            list.removeAll(needDelList);
            this.agencyChannelDataMapperExt.deleteByPrimaryKey(agencyChannelData.getId());
            this.proxyChannelDataMapperExt.deleteByPrimaryKey(agencyChannelData.getId());
        }
        if (returnStr.length() > 0) {
            returnStr.append("\u5728\u4ee3\u7406\u6570\u636e\u5f55\u5165\u4e2d\u5df2\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return returnStr.toString();
    }

    private List<AgencyChannelData> getAgencyChannelData(List<Long> ids, User user) {
        AgencyChannelDataExample example = new AgencyChannelDataExample();
        example.createCriteria().andIdIn(ids);
        List list = this.agencyChannelDataMapperExt.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u975e\u6cd5\u6570\u636eID");
        }
        List roleCodes = user.getRoleCodes();
        boolean isChanPinLeader = roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode());
        if (isChanPinLeader) {
            return list;
        }
        Set belongerSet = list.stream().map(t -> t.getBelonger()).collect(Collectors.toSet());
        if (belongerSet.size() > 1) {
            throw new BusinessException("\u5b58\u5728\u5f52\u5c5e\u8005\u975e\u5f53\u524d\u7528\u6237\u7684\u6570\u636e");
        }
        if (!belongerSet.contains(user.getUsername())) {
            throw new BusinessException("\u5f52\u5c5e\u8005\u975e\u5f53\u524d\u7528\u6237");
        }
        return list;
    }

    @Override
    public boolean pushDataToCms(AgencyChannelDataSyncDTO positionIncomeSyncDTO, User user) throws Exception {
        Map<String, Date> dateTime = StartAndEndTimeUtil.getStartAndEndTime(positionIncomeSyncDTO.getStartTime(), positionIncomeSyncDTO.getEndTime());
        String[] dateArray = StartAndEndTimeUtil.setResultDateTime(dateTime);
        if (dateArray == null || dateArray.length == 0) {
            throw new BusinessException("\u67e5\u8be2\u7684\u65e5\u671f\u6709\u8bef\u3002");
        }
        for (String dateStr : dateArray) {
            List panguChannelIncomeFacadeDTOList = this.agencyChannelDataMapperExt.findPanguChannelIncomeByDate(dateStr);
            if (!CollectionUtils.isNotEmpty((Collection)panguChannelIncomeFacadeDTOList)) continue;
            this.panguPositionIncomeIntegration.syncPanguChannelIncome(panguChannelIncomeFacadeDTOList);
        }
        return true;
    }
}

