/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.agencychannel.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.configures.OpenLogConfiguration;
import com.bxm.adsmanager.dal.mapper.agencychannel.ext.AgencyChannelDataMapperExt;
import com.bxm.adsmanager.dal.mapper.agencychannel.ext.AgencyChannelMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.enums.BusinessEnum;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannel;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannelDataExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelImportExcelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelSearchDTO;
import com.bxm.adsmanager.model.dto.OcpxRtbConfigDto;
import com.bxm.adsmanager.model.enums.OcpxRtbMediaEnum;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.util.MD5Util;
import com.bxm.warcar.utils.JsonHelper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.HashBiMap;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AgencyChannelServiceImpl
implements AgencyChannelService {
    private static final Logger log = LoggerFactory.getLogger(AgencyChannelServiceImpl.class);
    @Autowired
    private AgencyChannelMapperExt agencyChannelMapperExt;
    @Autowired
    private AgencyChannelDataMapperExt agencyChannelDataMapper;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private OpenLogConfiguration openLogConfiguration;
    @Autowired
    private DictionariesService dictionariesService;

    @Override
    @Transactional
    public Long add(AgencyChannelDTO dto) throws Exception {
        this.verifyBusiness(dto);
        AgencyChannel agencyChannel = new AgencyChannel();
        BeanUtils.copyProperties((Object)dto, (Object)agencyChannel);
        agencyChannel.setId(null);
        String ukMd5 = MD5Util.md5((String)(dto.getAgencyName() + dto.getChannelNo()));
        agencyChannel.setUkMd5(ukMd5);
        int result = this.agencyChannelMapperExt.insert(agencyChannel);
        if (result > 0) {
            return agencyChannel.getId();
        }
        return null;
    }

    private void verifyBusiness(AgencyChannelDTO dto) {
        if (StringUtils.equals((String)BusinessEnum.WFDL.getId(), (String)dto.getOwnedBusiness())) {
            if (StringUtils.isBlank((String)dto.getProxyCode()) || StringUtils.isBlank((String)dto.getNextProxyCode())) {
                throw new BusinessException("\u6240\u5c5e\u4e1a\u52a1\u7ebf\u4e3a\u5916\u653e\u4ee3\u7406\u65f6\uff0c\u5916\u653e\u4ee3\u7406\u4eba\u548c\u4e0b\u6e38\u4ee3\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else {
            dto.setProxyCode(null);
            dto.setNextProxyCode(null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(AgencyChannelDTO dto, User user) throws Exception {
        AgencyChannel agencyChannel = this.agencyChannelMapperExt.selectByPrimaryKey(Long.valueOf(dto.getId()));
        if (agencyChannel == null) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u6ca1\u6709\u627e\u5230");
        }
        this.verifyBusiness(dto);
        BeanUtils.copyProperties((Object)dto, (Object)agencyChannel);
        List roleCodes = user.getRoleCodes();
        boolean isChanPinLeader = roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode());
        if (!dto.getBelonger().equals(user.getUsername()) && !isChanPinLeader) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u6743\u9650");
        }
        String ukMd5 = MD5Util.md5((String)(dto.getAgencyName() + dto.getChannelNo()));
        agencyChannel.setUkMd5(ukMd5);
        log.debug("ID:{},dto:{}", (Object)dto.getId(), (Object)JsonHelper.convert((Object)dto));
        int result = this.agencyChannelMapperExt.updateByPrimaryKey(agencyChannel);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public boolean importData(List<AgencyChannelImportExcelDTO> agencyChannelDataDTOList, User user) throws Exception {
        this.checkRepeated(agencyChannelDataDTOList);
        this.fillProxyCode(agencyChannelDataDTOList);
        for (AgencyChannelImportExcelDTO agencyChannelImportExcelDTO : agencyChannelDataDTOList) {
            AgencyChannelDTO agencyChannelDataDTO = new AgencyChannelDTO();
            BeanUtils.copyProperties((Object)agencyChannelImportExcelDTO, (Object)agencyChannelDataDTO);
            agencyChannelDataDTO.setBelonger(user.getUsername());
            try {
                this.add(agencyChannelDataDTO);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof SQLIntegrityConstraintViolationException)) continue;
                throw new BusinessException(agencyChannelDataDTO.getChannelNo() + "\u4ee3\u7406\u6e20\u9053\u5df2\u5f55\u5165");
            }
        }
        return Boolean.TRUE;
    }

    private void fillProxyCode(List<AgencyChannelImportExcelDTO> list) {
        HashBiMap hashBiMap = HashBiMap.create();
        Map bdMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.BD.getCode(), Boolean.valueOf(true));
        Map saleMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.SALE.getCode(), Boolean.valueOf(true));
        Map<String, String> nextProxyMap = this.dictionariesService.getCodeDetailMapByCode("downstream");
        HashBiMap nextHashBiMap = HashBiMap.create(nextProxyMap);
        for (Map.Entry entry : bdMap.entrySet()) {
            if (hashBiMap.containsKey(entry.getValue())) continue;
            hashBiMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : saleMap.entrySet()) {
            if (hashBiMap.containsKey(entry.getValue())) continue;
            hashBiMap.put(entry.getValue(), entry.getKey());
        }
        for (AgencyChannelImportExcelDTO agencyChannelImportExcelDTO : list) {
            if (!StringUtils.equals((String)agencyChannelImportExcelDTO.getOwnedBusiness(), (String)BusinessEnum.WFDL.getId())) continue;
            agencyChannelImportExcelDTO.setProxyCode((String)hashBiMap.get((Object)agencyChannelImportExcelDTO.getProxyName()));
            agencyChannelImportExcelDTO.setNextProxyCode((String)nextHashBiMap.inverse().get((Object)agencyChannelImportExcelDTO.getNextProxyName()));
        }
    }

    private void checkRepeated(List<AgencyChannelImportExcelDTO> list) {
        List repeated = list.stream().filter(t1 -> list.stream().filter(t2 -> t1.getAgencyName().equals(t2.getAgencyName()) && t1.getProductName().equals(t2.getProductName()) && t1.getChannelNo().equals(t2.getChannelNo())).count() > 1L).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repeated)) {
            HashSet<String> messageSet = new HashSet<String>();
            for (AgencyChannelImportExcelDTO dto : repeated) {
                StringBuffer message = new StringBuffer();
                message.append(dto.getAgencyName()).append(dto.getProductName()).append(dto.getChannelNo()).append("\n");
                messageSet.add(message.toString());
            }
            throw new BusinessException("\u6709\u3010" + repeated.size() + "\u3011\u6761\u6570\u636e\u91cd\u590d\uff1a\n" + ((Object)messageSet).toString());
        }
    }

    @Override
    public PageInfo<AgencyChannel> findAll(AgencyChannelSearchDTO searchDto, User user) throws Exception {
        PageHelper.startPage((int)searchDto.getPageNum(), (int)searchDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.getList(searchDto));
        return pageInfo;
    }

    @Override
    public List<AgencyChannel> getList(AgencyChannelSearchDTO searchDto) throws Exception {
        return this.agencyChannelMapperExt.findList(searchDto);
    }

    @Override
    public boolean delete(Long id, User user) throws Exception {
        boolean isMayDelete;
        AgencyChannel agencyChannel = this.agencyChannelMapperExt.selectByPrimaryKey(id);
        if (agencyChannel == null) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u6ca1\u6709\u627e\u5230");
        }
        List roleCodes = user.getRoleCodes();
        boolean bl = isMayDelete = roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode()) || agencyChannel.getBelonger().equals(user.getUsername());
        if (!isMayDelete) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u6ca1\u6709\u6743\u9650");
        }
        AgencyChannelDataExample example = new AgencyChannelDataExample();
        example.createCriteria().andAgencyNameEqualTo(agencyChannel.getAgencyName()).andChannelNoEqualTo(agencyChannel.getChannelNo());
        long count = this.agencyChannelDataMapper.countByExample(example);
        if (count > 0L) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u4ee3\u7406+\u6e20\u9053\u5df2\u6709\u6536\u5165");
        }
        this.agencyChannelMapperExt.deleteByPrimaryKey(id);
        return Boolean.TRUE;
    }

    @Override
    public List<AgencyChannel> getDPList(String dateTime) throws Exception {
        List result = this.agencyChannelMapperExt.findListByParams(dateTime);
        return result;
    }

    @Override
    public List<String> getProductNameList() {
        return this.agencyChannelMapperExt.findProductNames();
    }

    @Override
    public String updateOcpxConfig(OcpxRtbConfigDto ocpxRtbConfigDto) {
        String mediaUrlParam = OcpxRtbMediaEnum.getUrlParamByMedia((String)ocpxRtbConfigDto.getRtbMedia());
        String mtUrl = UriComponentsBuilder.fromUriString((String)this.openLogConfiguration.getRequestOutDomain()).path("/common/s.gif").replaceQueryParam("mt", new Object[]{20}).replaceQueryParam("bxmmedia", new Object[]{ocpxRtbConfigDto.getRtbMedia()}).replaceQueryParam("bxmadvertiser", new Object[]{ocpxRtbConfigDto.getRtbAdvertiser()}).toUriString();
        String tempUrl = mtUrl + "&" + mediaUrlParam;
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)tempUrl);
        List urlFields = new ArrayList();
        String customUrlFields = ocpxRtbConfigDto.getCustomUrlFields();
        if (StringUtils.isNotBlank((String)customUrlFields)) {
            urlFields = JSONObject.parseArray((String)customUrlFields, OcpxRtbConfigDto.UrlField.class);
        }
        for (OcpxRtbConfigDto.UrlField urlField : urlFields) {
            uriComponentsBuilder.replaceQueryParam(urlField.getField(), new Object[]{urlField.getValue()});
        }
        double rate = 100.0;
        Integer strategyType = ocpxRtbConfigDto.getStrategyType();
        if (Objects.equals(strategyType, 2)) {
            rate = Optional.ofNullable(ocpxRtbConfigDto.getRate()).orElse(100.0);
        }
        String targetOneRtb = ocpxRtbConfigDto.getTargetOneRtb();
        String relateOneRtb = ocpxRtbConfigDto.getRelateOneRtb();
        String convDef = org.apache.commons.lang3.StringUtils.joinWith((String)"-", (Object[])new Object[]{relateOneRtb, targetOneRtb});
        if (Objects.equals(ocpxRtbConfigDto.getTargetType(), 2)) {
            String targetTwoRtb = ocpxRtbConfigDto.getTargetTwoRtb();
            String relateTwoRtb = ocpxRtbConfigDto.getRelateTwoRtb();
            String join2 = org.apache.commons.lang3.StringUtils.joinWith((String)"-", (Object[])new Object[]{relateTwoRtb, targetTwoRtb});
            convDef = org.apache.commons.lang3.StringUtils.joinWith((String)",", (Object[])new Object[]{convDef, join2});
        }
        uriComponentsBuilder.replaceQueryParam("conv_ratio", new Object[]{rate});
        uriComponentsBuilder.replaceQueryParam("conv_def", new Object[]{convDef});
        String link = uriComponentsBuilder.toUriString();
        ocpxRtbConfigDto.setLink(link);
        String ocpxRtbConfig = JSONObject.toJSONString((Object)ocpxRtbConfigDto);
        AgencyChannel agencyChannel = new AgencyChannel();
        agencyChannel.setId(ocpxRtbConfigDto.getId());
        agencyChannel.setOcpxRtbConfig(ocpxRtbConfig);
        this.agencyChannelMapperExt.updateByPrimaryKeySelective(agencyChannel);
        return uriComponentsBuilder.toUriString();
    }
}

