/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.agencychannel.impl;

import com.bxm.adsmanager.dal.mapper.agencychannel.ext.AgencyChannelDataMapperExt;
import com.bxm.adsmanager.dal.mapper.agencychannel.ext.AgencyChannelMapperExt;
import com.bxm.adsmanager.dal.mapper.agencychannel.ext.ProxyChannelDataMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannelData;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannelExample;
import com.bxm.adsmanager.model.dao.agencychannel.ProxyChannelData;
import com.bxm.adsmanager.model.dao.agencychannel.ProxyChannelDataExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.ProxyChannelDataBatchUpdateDTO;
import com.bxm.adsmanager.model.dto.ProxyChannelDataDTO;
import com.bxm.adsmanager.model.dto.ProxyChannelDataImportExcelDTO;
import com.bxm.adsmanager.model.dto.ProxyChannelDataSearchDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.ProxyChannelDataVO;
import com.bxm.adsmanager.service.agencychannel.ProxyChannelDataService;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.util.DateUtil;
import com.bxm.util.MD5Util;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProxyChannelDataServiceImpl
implements ProxyChannelDataService {
    private static final Logger log = LoggerFactory.getLogger(ProxyChannelDataServiceImpl.class);
    @Autowired
    private ProxyChannelDataMapperExt proxyChannelDataMapperExt;
    @Autowired
    private AgencyChannelDataMapperExt agencyChannelDataMapperExt;
    @Autowired
    private AgencyChannelMapperExt agencyChannelMapperExt;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private DictionariesService dictionariesService;

    @Override
    public Long add(ProxyChannelDataDTO dto, User user) throws Exception {
        ProxyChannelData entity = new ProxyChannelData();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int result = this.proxyChannelDataMapperExt.insert(entity);
        AgencyChannelData agencyChannelData = this.agencyChannelDataMapperExt.selectByPrimaryKey(dto.getId());
        agencyChannelData.setCost(dto.getDsIncome());
        this.agencyChannelDataMapperExt.updateByPrimaryKey(agencyChannelData);
        return entity.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public void update(ProxyChannelDataDTO dto, User user) throws Exception {
        AgencyChannelData agencyChannelData = this.agencyChannelDataMapperExt.selectByPrimaryKey(dto.getId());
        ProxyChannelData entity = this.proxyChannelDataMapperExt.selectByPrimaryKey(dto.getId());
        boolean isNew = false;
        if (entity == null) {
            isNew = true;
            entity = new ProxyChannelData();
            entity.setId(agencyChannelData.getId());
            entity.setThedate(agencyChannelData.getThedate());
            entity.setAgencyName(agencyChannelData.getAgencyName());
            entity.setChannelNo(agencyChannelData.getChannelNo());
        }
        entity.setDs(StringUtils.isNotBlank((CharSequence)dto.getDs()) ? dto.getDs() : entity.getDs());
        entity.setDsCpsBrokerage(dto.getDsCpsBrokerage());
        entity.setDsIncome(dto.getDsIncome());
        entity.setDsPrice(dto.getDsPrice());
        entity.setDsValidClick(dto.getDsValidClick());
        entity.setProxyCode(StringUtils.isNotBlank((CharSequence)dto.getProxyCode()) ? dto.getProxyCode() : entity.getProxyCode());
        if (isNew) {
            this.proxyChannelDataMapperExt.insert(entity);
        } else {
            this.proxyChannelDataMapperExt.updateByPrimaryKey(entity);
        }
        agencyChannelData.setCost(entity.getDsIncome());
        this.agencyChannelDataMapperExt.updateByPrimaryKey(agencyChannelData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public boolean batchUpdate(ProxyChannelDataBatchUpdateDTO dto, User user) throws Exception {
        List ids = dto.getIds();
        ProxyChannelDataExample example = new ProxyChannelDataExample();
        example.createCriteria().andIdIn(ids);
        List list = this.proxyChannelDataMapperExt.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list) || ids.size() != list.size()) {
            Set existIds = list.stream().map(p -> p.getId()).collect(Collectors.toSet());
            ids.removeAll(existIds);
            for (Long id : ids) {
                AgencyChannelData agencyChannelData = this.agencyChannelDataMapperExt.selectByPrimaryKey(id);
                ProxyChannelData entity = new ProxyChannelData();
                entity.setId(agencyChannelData.getId());
                entity.setThedate(agencyChannelData.getThedate());
                entity.setAgencyName(agencyChannelData.getAgencyName());
                entity.setChannelNo(agencyChannelData.getChannelNo());
                if (StringUtils.isNotBlank((CharSequence)dto.getDs())) {
                    entity.setDs(dto.getDs());
                }
                if (dto.getDsPrice() != null) {
                    entity.setDsPrice(dto.getDsPrice());
                }
                this.proxyChannelDataMapperExt.insert(entity);
            }
        }
        for (ProxyChannelData entity : list) {
            if (StringUtils.isNotBlank((CharSequence)dto.getDs())) {
                entity.setDs(dto.getDs());
            }
            if (dto.getDsPrice() != null) {
                entity.setDsPrice(dto.getDsPrice());
            }
            this.proxyChannelDataMapperExt.updateByPrimaryKey(entity);
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=120)
    public boolean importData(List<ProxyChannelDataImportExcelDTO> excelDTOList, User user, List<ProxyChannelDataImportExcelDTO> failList) throws Exception {
        StringBuilder errorMsg = new StringBuilder();
        this.checkFailList(failList, errorMsg);
        if (CollectionUtils.isNotEmpty(failList)) {
            excelDTOList.addAll(failList);
        }
        if (CollectionUtils.isNotEmpty(excelDTOList)) {
            this.checkRepeated(excelDTOList, errorMsg);
            this.checkChannelDataAndFillId(excelDTOList, errorMsg);
            this.checkDownstream(excelDTOList, errorMsg);
        }
        if (errorMsg.length() > 0) {
            errorMsg.insert(0, "\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a\n");
            throw new BusinessException(errorMsg.toString());
        }
        List ids = excelDTOList.stream().map(p -> p.getId()).collect(Collectors.toList());
        ProxyChannelDataExample example = new ProxyChannelDataExample();
        example.createCriteria().andIdIn(ids);
        this.proxyChannelDataMapperExt.deleteByExample(example);
        for (ProxyChannelDataImportExcelDTO proxyChannelDataImportExcelDTO : excelDTOList) {
            ProxyChannelDataDTO proxyChannelDataDTO = new ProxyChannelDataDTO();
            proxyChannelDataDTO.setThedate(DateUtil.StringToDate((String)proxyChannelDataImportExcelDTO.getThedate()));
            BeanUtils.copyProperties((Object)proxyChannelDataImportExcelDTO, (Object)proxyChannelDataDTO);
            Long dsValidClick = null;
            if (StringUtils.isNotBlank((CharSequence)proxyChannelDataImportExcelDTO.getDsValidClick())) {
                dsValidClick = Long.valueOf(proxyChannelDataImportExcelDTO.getDsValidClick());
            }
            proxyChannelDataDTO.setDsValidClick(dsValidClick);
            try {
                this.add(proxyChannelDataDTO, user);
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Boolean.TRUE;
    }

    private void checkFailList(List<ProxyChannelDataImportExcelDTO> failList, StringBuilder errorMsg) {
        if (CollectionUtils.isNotEmpty(failList)) {
            errorMsg.append("\u4e0b\u6e38\u5355\u4ef7/\u4e0b\u6e38CPS\u4f63\u91d1/\u4e0b\u6e38\u6536\u76ca\u7684\u5c0f\u6570\u4f4d\u6700\u591a2\u4f4d\uff0c\u4e14\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff01\n");
        }
    }

    private void checkDownstream(List<ProxyChannelDataImportExcelDTO> list, StringBuilder errorMsg) {
        Map<String, String> dsMap = this.dictionariesService.getCodeDetailMapByCode("downstream");
        HashBiMap hashBiMap = HashBiMap.create();
        hashBiMap.putAll(dsMap);
        HashBiMap allMap = HashBiMap.create();
        Map bdMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.BD.getCode(), Boolean.valueOf(true));
        Map saleMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.SALE.getCode(), Boolean.valueOf(true));
        allMap.putAll(bdMap);
        allMap.putAll(saleMap);
        HashSet<String> messageSet = new HashSet<String>();
        for (ProxyChannelDataImportExcelDTO t : list) {
            String dsCode = (String)hashBiMap.inverse().get((Object)t.getDs());
            if (StringUtils.isBlank((CharSequence)dsCode)) {
                messageSet.add("\u5b58\u5728\u7cfb\u7edf\u672a\u8bc6\u522b\u4e0b\u6e38\u4ee3\u7406\u540d\u79f0");
            } else {
                t.setDs(dsCode);
            }
            String proxyCode = (String)allMap.inverse().get((Object)t.getProxyName());
            if (StringUtils.isBlank((CharSequence)proxyCode)) {
                messageSet.add("\u5b58\u5728\u7cfb\u7edf\u672a\u8bc6\u522b\u5916\u653e\u4ee3\u7406\u4eba");
            } else {
                t.setProxyCode(proxyCode);
            }
            if (!Objects.nonNull(t.getDsIncome())) {
                messageSet.add("\u5b58\u5728\u4e3a\u7a7a\u7684\u4e0b\u6e38\u6536\u76ca");
            }
            if (!StringUtils.isNotEmpty((CharSequence)t.getDsValidClick()) || !t.getDsValidClick().contains(".") && Integer.valueOf(t.getDsValidClick()) >= 0) continue;
            messageSet.add("\u5b58\u5728\u975e\u6b63\u6574\u6570\u4e0b\u6e38\u6709\u6548\u70b9\u51fb\u6570");
        }
        if (CollectionUtils.isNotEmpty(messageSet)) {
            errorMsg.append(((Object)messageSet).toString()).append("\n");
        }
    }

    private void checkChannelDataAndFillId(List<ProxyChannelDataImportExcelDTO> list, StringBuilder errorMsg) {
        List proxyChannelData;
        List allDate = list.stream().map(t -> t.getThedate()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(allDate)) {
            errorMsg.append("\u65e5\u671f\u6570\u636e\u4e3a\u7a7a\uff01\n");
        }
        if (CollectionUtils.isEmpty((Collection)(proxyChannelData = this.agencyChannelDataMapperExt.findDataListByDate(allDate)))) {
            errorMsg.append("\u6ca1\u6709\u5339\u914d\u5230\u5bfc\u5165\u65e5\u671f\u7684\u6e20\u9053\u6536\u76ca\u6570\u636e\uff01\n");
        }
        Map<String, AgencyChannelData> channelDataMap = proxyChannelData.stream().collect(Collectors.toMap(t -> DateUtil.dateTo8String((Date)t.getThedate()) + "-" + t.getAgencyName() + "-" + t.getChannelNo(), t -> t));
        HashSet<String> messageSet = new HashSet<String>();
        for (ProxyChannelDataImportExcelDTO dto : list) {
            String key = dto.getThedate() + "-" + dto.getAgencyName() + "-" + dto.getChannelNo();
            AgencyChannelData agencyChannelData = channelDataMap.get(key);
            if (Objects.isNull(agencyChannelData)) {
                messageSet.add(key);
                continue;
            }
            dto.setId(agencyChannelData.getId());
        }
        if (CollectionUtils.isNotEmpty(messageSet)) {
            errorMsg.append("\u6709\u3010" + messageSet.size() + "\u3011\u6761\u6e20\u9053\u6536\u76ca\u6570\u636e\u4e0d\u5b58\u5728\uff1a").append(((Object)messageSet).toString()).append("\n");
        }
    }

    private void checkDataRole(List<ProxyChannelDataImportExcelDTO> list, User user, StringBuilder errorMsg) throws Exception {
        List roleCodes = user.getRoleCodes();
        boolean isChanPinLeader = roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode());
        if (isChanPinLeader) {
            return;
        }
        ArrayList<String> md5List = new ArrayList<String>();
        for (ProxyChannelDataImportExcelDTO dto : list) {
            md5List.add(MD5Util.md5((String)(dto.getAgencyName() + dto.getChannelNo())));
        }
        if (CollectionUtils.isEmpty(md5List)) {
            errorMsg.append("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u3002\n");
            throw new BusinessException(errorMsg.toString());
        }
        AgencyChannelExample example = new AgencyChannelExample();
        example.createCriteria().andUkMd5In(md5List);
        List agencyChannelList = this.agencyChannelMapperExt.selectByExample(example);
        Set proxyCodeSet = agencyChannelList.stream().map(p -> p.getProxyCode()).collect(Collectors.toSet());
        if (proxyCodeSet.size() == 0) {
            errorMsg.append("\u6ca1\u6709\u627e\u5230\u4ee3\u7406\u4eba\u4e3a\u81ea\u5df1\u7684\u6570\u636e\u3002\n");
            throw new BusinessException(errorMsg.toString());
        }
        if (proxyCodeSet.size() > 1) {
            errorMsg.append("\u5546\u52a1/\u5a92\u4ecb\u65e0\u6cd5\u5bfc\u5165\u4ee3\u7406\u4eba\u4e0d\u662f\u81ea\u5df1\u7684\u6570\u636e\u3002\n");
            throw new BusinessException(errorMsg.toString());
        }
        if (!proxyCodeSet.contains(user.getUsername())) {
            errorMsg.append("\u5bfc\u5165\u7684\u6570\u636e\u6240\u5bf9\u5e94\u7684\u4ee3\u7406\u4eba\u4e0d\u662f\u81ea\u5df1\u3002\n");
            throw new BusinessException(errorMsg.toString());
        }
    }

    private void checkRepeated(List<ProxyChannelDataImportExcelDTO> list, StringBuilder errorMsg) {
        List repeated = list.stream().filter(t1 -> list.stream().filter(t2 -> t1.getThedate().equals(t2.getThedate()) && t1.getAgencyName().equals(t2.getAgencyName()) && t1.getChannelNo().equals(t2.getChannelNo())).count() > 1L).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repeated)) {
            HashSet<String> messageSet = new HashSet<String>();
            for (ProxyChannelDataImportExcelDTO dto : repeated) {
                StringBuffer message = new StringBuffer();
                if (messageSet.size() > 0) {
                    message.append("\u3001");
                }
                message.append(dto.getThedate()).append(dto.getAgencyName()).append(dto.getChannelNo());
                messageSet.add(message.toString());
            }
            list.removeAll(repeated);
            errorMsg.append("\u6709\u3010").append(repeated.size()).append("\u3011\u6761\u6570\u636e\u91cd\u590d\uff1a").append(((Object)messageSet).toString()).append("\n");
        }
    }

    @Override
    public PageInfo<ProxyChannelDataVO> findAll(ProxyChannelDataSearchDTO searchDto, User user) throws Exception {
        PageHelper.startPage((int)searchDto.getPageNum(), (int)searchDto.getPageSize());
        List<ProxyChannelDataVO> list = this.getList(searchDto, user);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public List<ProxyChannelDataVO> getList(ProxyChannelDataSearchDTO searchDto, User user) throws Exception {
        searchDto.setProxyCode(null);
        List list = this.proxyChannelDataMapperExt.findList(searchDto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map<String, String> dsMap = this.dictionariesService.getCodeDetailMapByCode("downstream");
            HashMap allMap = new HashMap();
            Map bdMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.BD.getCode(), Boolean.valueOf(true));
            Map saleMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.SALE.getCode(), Boolean.valueOf(true));
            allMap.putAll(bdMap);
            allMap.putAll(saleMap);
            list.forEach(vo -> {
                vo.setDs((String)dsMap.get(vo.getDs()));
                vo.setProxyName((String)allMap.get(vo.getProxyCode()));
            });
        }
        return list;
    }
}

