/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.alarm;

import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SocketSessionRegistry {
    public static final String USER_SESSION_KEY = "ADS:USER_SESSION:%s";
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void registerSessionId(String user, String sessionId) {
        Assert.notNull((Object)user, (String)"User must not be null");
        Assert.notNull((Object)sessionId, (String)"Session ID must not be null");
        this.stringRedisTemplate.opsForValue().set((Object)String.format(USER_SESSION_KEY, user), (Object)sessionId);
    }

    public String getSessionId(String user) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)String.format(USER_SESSION_KEY, user));
    }
}

