/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.alarm.impl;

import com.bxm.adsmanager.dal.mapper.alarm.ext.AlarmRecordMapperExt;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.alarm.AlarmRecord;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.ro.AutoAlarmEditRo;
import com.bxm.adsmanager.model.ro.AutoAlarmRo;
import com.bxm.adsmanager.model.vo.AutoAlarmVo;
import com.bxm.adsmanager.service.alarm.AutoAlarmService;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.DateUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AutoAlarmServiceImpl
implements AutoAlarmService {
    private static final Logger log = LoggerFactory.getLogger(AutoAlarmServiceImpl.class);
    @Resource
    private AlarmRecordMapperExt alarmRecordMapperExt;
    @Resource
    private Mapper mapper;
    @Resource
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Resource
    private AclUserIntegration aclUserIntegration;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public PageInfo<AutoAlarmVo> queryList(AutoAlarmRo autoAlarmRo, String username) {
        Page result = new Page();
        if (StringUtils.isNotBlank((CharSequence)autoAlarmRo.getMediaName()) && StringUtils.isBlank((CharSequence)autoAlarmRo.getAppkey())) {
            QueryAppEntranceParamDTO queryDto = new QueryAppEntranceParamDTO();
            queryDto.setProviderName(autoAlarmRo.getMediaName());
            PageInfo pageInfoByParam = this.newAppEntranceFacadeIntegration.getPage(queryDto);
            if (pageInfoByParam.getList() == null || pageInfoByParam.getList().isEmpty()) {
                return new PageInfo((List)result);
            }
            List appkeys = pageInfoByParam.getList().stream().map(AppEntranceAdRO::getAppKey).collect(Collectors.toList());
            autoAlarmRo.setAppkeys(appkeys);
        } else if (StringUtils.isNotBlank((CharSequence)autoAlarmRo.getAppkey())) {
            autoAlarmRo.setAppkeys((List)Lists.newArrayList((Object[])new String[]{autoAlarmRo.getAppkey()}));
        }
        PageHelper.startPage((int)autoAlarmRo.getPageNum(), (int)autoAlarmRo.getPageSize());
        Page autoAlarmVos = (Page)this.alarmRecordMapperExt.queryListGroupByAppkey(autoAlarmRo);
        if (autoAlarmVos.isEmpty()) {
            return new PageInfo((List)result);
        }
        ArrayList positionIds = Lists.newArrayList();
        for (AutoAlarmVo alarmRecord2 : autoAlarmVos) {
            positionIds.add(alarmRecord2.getAlarmId());
        }
        QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
        queryAppEntranceParamDTO.setPositionIds((List)positionIds);
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO);
        HashMap<String, AppEntranceAdRO> positionNames = new HashMap<String, AppEntranceAdRO>(appEntranceAdRos.size());
        for (AppEntranceAdRO appEntranceAdRo : appEntranceAdRos) {
            positionNames.put(appEntranceAdRo.getPositionId(), appEntranceAdRo);
        }
        Map mjs = this.aclUserIntegration.queryUserByRoleCode("mj", Boolean.valueOf(true));
        for (AutoAlarmVo autoAlarmVo : autoAlarmVos) {
            AppEntranceAdRO appEntranceAdRo = (AppEntranceAdRO)positionNames.get(autoAlarmVo.getAlarmId());
            if (appEntranceAdRo != null) {
                autoAlarmVo.setMediaName(appEntranceAdRo.getProviderAlias());
                autoAlarmVo.setPositionName(appEntranceAdRo.getAppEntranceName());
            }
            if (StringUtils.isNotBlank((CharSequence)autoAlarmVo.getName())) {
                autoAlarmVo.setName((String)mjs.get(autoAlarmVo.getName()));
            }
            autoAlarmVo.setLeastAlarmTime(autoAlarmVo.getLeastAlarmTime().substring(0, autoAlarmVo.getLeastAlarmTime().length() - 2));
            autoAlarmRo.setAlarmId(autoAlarmVo.getAlarmId());
            List alarmRecords = this.alarmRecordMapperExt.queryList(autoAlarmRo);
            List subStatus = alarmRecords.stream().map(alarmRecord -> this.trans2Vo((AlarmRecord)alarmRecord, username)).collect(Collectors.toList());
            autoAlarmVo.setSubStatus(subStatus);
        }
        return new PageInfo((List)autoAlarmVos);
    }

    @Override
    public boolean modify(AutoAlarmEditRo autoAlarmEditRo, User user) {
        String username = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) ? null : user.getUsername();
        AlarmRecord alarmRecord = this.alarmRecordMapperExt.selectByIdAndUsername(autoAlarmEditRo.getId(), username);
        if (alarmRecord == null) {
            return false;
        }
        this.mapper.map((Object)autoAlarmEditRo, (Object)alarmRecord);
        if (alarmRecord.getResponseTime() == null) {
            long responseSec = (System.currentTimeMillis() - alarmRecord.getCreateTime().getTime()) / 1000L;
            alarmRecord.setResponseTime(Long.valueOf(responseSec));
        }
        this.read(autoAlarmEditRo.getId(), user.getUsername());
        return this.alarmRecordMapperExt.updateByPrimaryKeySelective(alarmRecord) == 1;
    }

    @Override
    public boolean read(Long id, String username) {
        String redisKey = RedisKeys.getKey((String)"ALARM_MSG_UNREAD_%s", (Object[])new Object[]{username});
        this.stringRedisTemplate.opsForSet().remove((Object)redisKey, new Object[]{id.toString()});
        return true;
    }

    @Override
    public boolean batchModify(AutoAlarmEditRo autoAlarmEditRo, User user) {
        String username = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) ? null : user.getUsername();
        ArrayList ids = Lists.newArrayList((Object[])autoAlarmEditRo.getIds().split(","));
        return this.alarmRecordMapperExt.updateByAlarmIdAndUsername(autoAlarmEditRo, username, (List)ids) > 0;
    }

    private AutoAlarmVo.SubStatue trans2Vo(AlarmRecord alarmRecord, String username) {
        AutoAlarmVo.SubStatue statue = (AutoAlarmVo.SubStatue)this.mapper.map((Object)alarmRecord, AutoAlarmVo.SubStatue.class);
        if (alarmRecord.getResponseTime() != null) {
            BigDecimal divide = BigDecimal.valueOf(alarmRecord.getResponseTime()).divide(BigDecimal.valueOf(3600L), 2, RoundingMode.HALF_UP);
            statue.setResponse(divide + "\u5c0f\u65f6");
        }
        double hour = BigDecimal.valueOf(alarmRecord.getScope() * 15).divide(BigDecimal.valueOf(60L), 2, RoundingMode.HALF_UP).doubleValue();
        statue.setIndicateScope(alarmRecord.getIndicationName() + "\u6700\u8fd1" + hour + "\u5c0f\u65f6");
        String redisKey = RedisKeys.getKey((String)"ALARM_MSG_UNREAD_%s", (Object[])new Object[]{username});
        statue.setUnread(this.stringRedisTemplate.opsForSet().isMember((Object)redisKey, (Object)alarmRecord.getId().toString()));
        statue.setCreateTime(DateUtil.dateTo14String((Date)alarmRecord.getCreateTime()));
        statue.setLevel(alarmRecord.getAlarmLevel());
        return statue;
    }
}

