/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.audit.impl;

import com.bxm.adsmanager.dal.mapper.audit.AdAuditRecordMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.model.dto.AdAuditRecordDto;
import com.bxm.adsmanager.model.vo.AdAuditRecordVo;
import com.bxm.adsmanager.service.audit.AdAuditRecordService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdAuditRecordServiceImpl
implements AdAuditRecordService {
    private static final Logger log = LoggerFactory.getLogger(AdAuditRecordServiceImpl.class);
    @Autowired
    private AdAuditRecordMapper adAuditRecordMapper;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;

    @Override
    public PageInfo<AdAuditRecordVo> getPage(AdAuditRecordDto adAuditRecordDto) {
        Page page = PageHelper.startPage((int)adAuditRecordDto.getPageNum(), (int)adAuditRecordDto.getPageSize());
        List adAuditRecordVos = this.adAuditRecordMapper.getPage(adAuditRecordDto);
        if (CollectionUtils.isNotEmpty((Collection)adAuditRecordVos)) {
            List ticketIds = adAuditRecordVos.stream().map(a -> (long)a.getTicketId()).collect(Collectors.toList());
            List tagNames = this.tblAdPostionTagMapperExt.findTagNamesByTicketIds(ticketIds);
            Map<Long, String> tagNamesMap = tagNames.stream().collect(Collectors.toMap(t -> t.getTicketId(), t -> t.getTagNames() == null ? "" : t.getTagNames()));
            adAuditRecordVos.forEach(v -> v.setTagName((String)tagNamesMap.get(v.getTicketId())));
        }
        return page.toPageInfo();
    }
}

