/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.audit.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.dal.mapper.advertiser.TblAdQualifyMapper;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.dal.mapper.audit.QualificationConfigMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserAuditVo;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserMainInfoVo;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dao.audit.QualificationConfig;
import com.bxm.adsmanager.model.dto.AdTicketAuditSearchDTO;
import com.bxm.adsmanager.model.ro.QualifyContentRo;
import com.bxm.adsmanager.model.vo.AdTicketAuditVo;
import com.bxm.adsmanager.model.vo.AdvertiserImgExcelVo;
import com.bxm.adsmanager.model.vo.AdvertiserQualifyInfoVo;
import com.bxm.adsmanager.service.audit.AdvertiserAuditService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ZipUtil;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.DateHelper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertiserAuditServiceImpl
implements AdvertiserAuditService {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserAuditServiceImpl.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private TblAdQualifyMapperExt adQualifyMapperExt;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdTicketMapperExt adTicketMapperExt;
    @Autowired
    private TblAdQualifyMapper tblAdQualifyMapper;
    @Autowired
    private QualificationConfigMapper qualificationConfigMapper;
    @Autowired
    private AclUserIntegration aclUserIntegration;

    @Override
    public PageInfo<AdvertiserAuditVo> listAdvertiserAudit(Integer pageNum, Integer pageSize, Byte accountType, String advertiserIdOrName, Byte advertiserStatus, Integer qualifyStatus, Integer expireStatus, Integer areaType) {
        PageInfo pageInfo;
        List advertiserIds = null;
        if (qualifyStatus != null || expireStatus != null) {
            advertiserIds = this.adQualifyMapperExt.getAdvertiserIdsByQualifyStatus(qualifyStatus, expireStatus);
            if (Objects.isNull(advertiserIds)) {
                return new PageInfo();
            }
            advertiserIds.add(-1);
        }
        if (null == (pageInfo = this.adShopIntegration.getAdvertiserAuditList(pageNum, pageSize, accountType, advertiserIdOrName, advertiserStatus, advertiserIds, areaType))) {
            return new PageInfo();
        }
        List AdvertiserAuditVos = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)AdvertiserAuditVos)) {
            return pageInfo;
        }
        List ids = AdvertiserAuditVos.stream().map(a -> a.getAdvertiserId() == null ? -99L : a.getAdvertiserId().longValue()).collect(Collectors.toList());
        List tickets = this.adTicketMapper.findAllTicketsByAdvertiserIds(ids);
        List qualifys = this.adQualifyMapperExt.getQualifyByAdvertiserIds(ids);
        ArrayList resultVoList = new ArrayList();
        AdvertiserAuditVos.stream().forEach(vo -> {
            Long id = vo.getAdvertiserId().longValue();
            Map<Short, Long> countGroupByStatus = tickets.stream().filter(t -> t.getAdvertiser().equals(id) && !t.getType().equals((short)5) && !t.getType().equals((short)6)).collect(Collectors.groupingBy(AdTicket::getStatus, Collectors.counting()));
            Long waitAuditCount = countGroupByStatus.getOrDefault((short)-2, 0L);
            Long refuseAuditCount = countGroupByStatus.getOrDefault((short)-3, 0L);
            Long passAuditCount = countGroupByStatus.getOrDefault((short)1, 0L) + countGroupByStatus.getOrDefault((short)2, 0L) + countGroupByStatus.getOrDefault((short)3, 0L) + countGroupByStatus.getOrDefault((short)-1, 0L);
            StringBuffer ticketAuditDescBuffer = new StringBuffer();
            if (!waitAuditCount.equals(0L)) {
                ticketAuditDescBuffer.append("\u5f85\u5ba1\u6838\uff1a").append(waitAuditCount).append(" \uff1b");
            }
            if (!passAuditCount.equals(0L)) {
                ticketAuditDescBuffer.append("\u5ba1\u6838\u901a\u8fc7\uff1a").append(passAuditCount).append(" \uff1b");
            }
            if (!refuseAuditCount.equals(0L)) {
                ticketAuditDescBuffer.append("\u5ba1\u6838\u62d2\u7edd\uff1a").append(refuseAuditCount).append(" \uff1b");
            }
            StringBuffer qualifyAuditDescBuffer = new StringBuffer();
            Map<Integer, Long> qualifyGroupByStatus = qualifys.stream().filter(q -> q.getAdvertiserId().equals(id)).collect(Collectors.groupingBy(TblAdQualify::getAuditStatus, Collectors.counting()));
            qualifyGroupByStatus.forEach((status, count) -> {
                switch (status) {
                    case 1: {
                        qualifyAuditDescBuffer.append("\u5ba1\u6838\u901a\u8fc7\uff1a").append(count).append(" \uff1b");
                        break;
                    }
                    case 2: {
                        qualifyAuditDescBuffer.append("\u5f85\u5ba1\u6838\uff1a").append(count).append(" \uff1b");
                        break;
                    }
                    case 3: {
                        qualifyAuditDescBuffer.append("\u5ba1\u6838\u62d2\u7edd\uff1a").append(count).append(" \uff1b");
                        break;
                    }
                }
            });
            vo.setAdAuditInfo(ticketAuditDescBuffer.toString());
            vo.setQualifyAuditInfo(qualifyAuditDescBuffer.toString());
            resultVoList.add(vo);
        });
        pageInfo.setList(resultVoList);
        return pageInfo;
    }

    @Override
    public AdvertiserQualifyInfoVo getQualifyInfo(Integer qualityId) {
        TblAdQualify tblAdQualify = this.tblAdQualifyMapper.selectByPrimaryKey(qualityId);
        if (null == tblAdQualify) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u8be5\u8d44\u8d28id");
        }
        AdvertiserQualifyInfoVo advertiserQualifyInfoVo = this.qualifyInfoVoConvert(tblAdQualify);
        return advertiserQualifyInfoVo;
    }

    @Override
    public PageInfo<AdvertiserQualifyInfoVo> getQualifyList(Integer pageNum, Integer pageSize, Integer advertiserId, Integer auditStatus, String content) {
        if (null == advertiserId) {
            throw new BusinessException("advertiserId\u4e3a\u7a7a");
        }
        AdvertiserMainInfoVo advertiserMainInfo = this.adShopIntegration.getAdvertiserMainInfo(advertiserId);
        if (advertiserMainInfo == null) {
            throw new BusinessException("\u5e7f\u544a\u4e3bId\u4e0d\u5b58\u5728");
        }
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List qualifyAuditList = this.adQualifyMapperExt.getQualifyAuditList(advertiserId, auditStatus, content);
        List allList = this.qualificationConfigMapper.getAllList();
        Map<Long, String> qualifyConfigMap = allList.stream().collect(Collectors.toMap(q -> q.getId(), q -> q.getName()));
        qualifyAuditList.forEach(q -> {
            q.setAdvertiserTypeStr((String)qualifyConfigMap.get(q.getQualifyName().longValue()));
            q.setAdvertiserName(advertiserMainInfo.getCompany());
            q.setQualifyContentRoList(this.convertQualifyContentJson(q.getQualifyContent()));
        });
        PageInfo pageInfo = page.toPageInfo();
        pageInfo.setList(qualifyAuditList);
        return pageInfo;
    }

    @Override
    public void updateQualifyRemark(Integer qualifyId, String remark) {
        TblAdQualify tblAdQualify = new TblAdQualify();
        tblAdQualify.setId(qualifyId);
        if (null != remark) {
            tblAdQualify.setRemark(remark);
        } else {
            tblAdQualify.setRemark("");
        }
        int updateLine = this.tblAdQualifyMapper.updateByPrimaryKeySelective(tblAdQualify);
        if (updateLine == 0) {
            log.error("\u66f4\u65b0\u8d44\u8d28\u5907\u6ce8\u5931\u8d25");
        }
    }

    @Override
    public AdvertiserAuditVo getAdvertiserQualifyInfo(Integer advertiserId) {
        AdvertiserAuditVo advertiserAuditInfoById = this.adShopIntegration.getAdvertiserAuditInfoById(advertiserId);
        if (Objects.nonNull(advertiserAuditInfoById)) {
            UserRo saleUser;
            if (Objects.nonNull(advertiserAuditInfoById.getSale()) && Objects.nonNull(saleUser = this.aclUserIntegration.queryUserByUsername(advertiserAuditInfoById.getSale()))) {
                advertiserAuditInfoById.setSale(saleUser.getName());
            }
            PageInfo<AdvertiserQualifyInfoVo> qualifyList = this.getQualifyList(0, Integer.MAX_VALUE, advertiserId, 1, null);
            List list = qualifyList.getList();
            advertiserAuditInfoById.setAdvertiserQualifyInfoVos(list);
        }
        return advertiserAuditInfoById;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportImgsUseZip(String searchAdvertiserIds, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        response.setHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode("\u5e7f\u544a\u4e3b\u8d44\u8d28\u56fe\u7247.zip", "UTF-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        List advertiserList = this.adShopIntegration.findAdShopMsgs(searchAdvertiserIds);
        if (CollectionUtils.isEmpty((Collection)advertiserList)) {
            throw new BusinessException("\u5e7f\u544a\u4e3b\u4e0d\u5b58\u5728");
        }
        Map<Integer, String> advertiserNameMap = advertiserList.stream().collect(Collectors.toMap(AdvertiserDto::getId, a -> a.existSpecialApproval() ? a.getCompany() + "(\u7279\u6279)" : a.getCompany()));
        List qualifyAuditList = this.adQualifyMapperExt.getQualifyAuditList(null, Integer.valueOf(1), null);
        if (qualifyAuditList == null) {
            qualifyAuditList = Lists.newArrayList();
        }
        Map<Long, List<AdvertiserQualifyInfoVo>> qualifyAuditMap = qualifyAuditList.stream().collect(Collectors.groupingBy(AdvertiserQualifyInfoVo::getAdvertiserId));
        ZipOutputStream zipOut = null;
        HashMap urlMap = Maps.newHashMap();
        try {
            advertiserList.forEach(q -> {
                String businessLicenseImg = q.getBusinessLicenseImg();
                Byte status = q.getStatus();
                if (Objects.equals(status, (byte)1) && StringUtils.isNotBlank((CharSequence)businessLicenseImg)) {
                    String suffix = StringUtils.substringAfterLast((String)businessLicenseImg, (String)".");
                    if (suffix.length() > 7) {
                        suffix = "";
                    }
                    suffix = StringUtils.isBlank((CharSequence)suffix) ? ".jpg" : "." + suffix;
                    urlMap.put(q.getId() + "_" + q.getCompany() + "_\u4e3b\u4f53\u4fe1\u606f" + suffix, businessLicenseImg);
                }
                List advertiserQualifyInfoVos = (List)qualifyAuditMap.get(q.getId().longValue());
                String advertiserName = (String)advertiserNameMap.get(q.getId());
                if (CollectionUtils.isNotEmpty((Collection)advertiserQualifyInfoVos)) {
                    int count = 1;
                    for (AdvertiserQualifyInfoVo advertiserQualifyInfoVo : advertiserQualifyInfoVos) {
                        List qualifyContentList;
                        if (!Objects.equals(advertiserQualifyInfoVo.getAuditStatus(), 1)) continue;
                        String qualifyContent = advertiserQualifyInfoVo.getQualifyContent();
                        String imgStr = advertiserQualifyInfoVo.getImgStr();
                        String images = "";
                        if (StringUtils.isNotBlank((CharSequence)qualifyContent) && CollectionUtils.isNotEmpty((Collection)(qualifyContentList = JSON.parseArray((String)qualifyContent, QualifyContentRo.class)))) {
                            images = qualifyContentList.stream().map(l -> Optional.ofNullable(l.getImages()).orElse("")).collect(Collectors.joining(","));
                        }
                        if (StringUtils.isNotBlank((CharSequence)imgStr)) {
                            images = StringUtils.joinWith((String)",", (Object[])new Object[]{images, imgStr});
                        }
                        if (StringUtils.isBlank((CharSequence)images)) continue;
                        HashSet qualityImgSet = Sets.newHashSet((Object[])images.split(","));
                        for (String qualityImg : qualityImgSet) {
                            if (StringUtils.isBlank((CharSequence)qualityImg)) continue;
                            String suffix = StringUtils.substringAfterLast((String)qualityImg, (String)".");
                            suffix = StringUtils.isBlank((CharSequence)StringUtils.substringAfterLast((String)qualityImg, (String)".")) ? ".jpg" : "." + suffix;
                            urlMap.put(advertiserQualifyInfoVo.getAdvertiserId() + "_" + advertiserName + "_\u8d44\u8d28\u4fe1\u606f_" + count++ + suffix, qualityImg);
                        }
                    }
                }
            });
            ZipOutputStream finalZipOut = zipOut = new ZipOutputStream((OutputStream)outputStream);
            urlMap.forEach((name, url) -> ZipUtil.fileToZip(url, name, "", finalZipOut));
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        log.info("\u5e7f\u544a\u4e3b{}\u8d44\u8d28\u56fe\u7247\u5bfc\u51fa\u5171{}\u5f20\u56fe\u7247\uff0c\u7528\u65f6\uff1a{}ms", new Object[]{searchAdvertiserIds, urlMap.size(), System.currentTimeMillis() - startTime});
        return "";
    }

    @Override
    public void exportImgsUseExcel(String searchAdvertiserIds, HttpServletResponse response) throws Exception {
        List advertiserList = StringUtils.isNotBlank((CharSequence)searchAdvertiserIds) ? this.adShopIntegration.findAdShopMsgs(searchAdvertiserIds) : this.adShopIntegration.getAdShopList(null);
        if (CollectionUtils.isEmpty((Collection)advertiserList)) {
            throw new BusinessException("\u5e7f\u544a\u4e3b\u4e0d\u5b58\u5728");
        }
        Map<Integer, String> advertiserNameMap = advertiserList.stream().collect(Collectors.toMap(AdvertiserDto::getId, a -> a.existSpecialApproval() ? a.getCompany() + "(\u7279\u6279)" : a.getCompany()));
        List qualifyAuditList = this.adQualifyMapperExt.getQualifyAuditList(null, Integer.valueOf(1), null);
        if (qualifyAuditList == null) {
            qualifyAuditList = Lists.newArrayList();
        }
        List allQulifyConfigList = this.qualificationConfigMapper.getAllList();
        Map<Long, String> qualifyConfigNameMap = allQulifyConfigList.stream().collect(Collectors.toMap(q -> q.getId(), q -> q.getName()));
        Map<Long, List<AdvertiserQualifyInfoVo>> qualifyAuditMap = qualifyAuditList.stream().collect(Collectors.groupingBy(AdvertiserQualifyInfoVo::getAdvertiserId));
        AdTicketAuditSearchDTO adTicketAuditSearchDTO = new AdTicketAuditSearchDTO();
        adTicketAuditSearchDTO.setTicketStatus(Integer.valueOf(1));
        if (StringUtils.isNotBlank((CharSequence)searchAdvertiserIds)) {
            List advertiserIds = Arrays.stream(StringUtils.split((String)searchAdvertiserIds, (String)",")).map(id -> Integer.valueOf(id)).collect(Collectors.toList());
            adTicketAuditSearchDTO.setAdvertiserIds(advertiserIds);
        }
        List adTicketAuditVos = this.adTicketMapperExt.getTicketAuditList(adTicketAuditSearchDTO);
        Map<Integer, List<AdTicketAuditVo>> adTicketAuditVoMap = adTicketAuditVos.stream().collect(Collectors.groupingBy(a -> a.getAdvertiserId()));
        ArrayList<AdvertiserImgExcelVo> excelVos = new ArrayList<AdvertiserImgExcelVo>();
        for (AdvertiserDto advertiserDto : advertiserList) {
            ArrayList<AdvertiserImgExcelVo.QualifyUrlObject> qualifyUrlObjects = new ArrayList<AdvertiserImgExcelVo.QualifyUrlObject>();
            long advertiserId = advertiserDto.getId().longValue();
            AdvertiserImgExcelVo excelVo = new AdvertiserImgExcelVo();
            excelVo.setAdvertiserId(Long.valueOf(advertiserId));
            excelVo.setAdvertiserName(advertiserNameMap.get(advertiserDto.getId()));
            if (Objects.equals(advertiserDto.getStatus(), (byte)1)) {
                AdvertiserImgExcelVo.UrlObject infoUrlObject = new AdvertiserImgExcelVo.UrlObject();
                infoUrlObject.setName("\u8425\u4e1a\u6267\u7167");
                infoUrlObject.setUrl(advertiserDto.getBusinessLicenseImg());
                excelVo.setInfoUrlObjects((List)Lists.newArrayList((Object[])new AdvertiserImgExcelVo.UrlObject[]{infoUrlObject}));
            }
            List<AdvertiserQualifyInfoVo> qualifyVos = qualifyAuditMap.getOrDefault(advertiserId, Collections.EMPTY_LIST);
            List<AdTicketAuditVo> advertiserAdTicket = adTicketAuditVoMap.get(advertiserDto.getId());
            if (CollectionUtils.isNotEmpty(advertiserAdTicket)) {
                excelVo.setLandingPageUrl(advertiserAdTicket.get(0).getUrl());
            }
            for (AdvertiserQualifyInfoVo qualifyVo : qualifyVos) {
                String[] split;
                String qualifyContent;
                if (!Objects.equals(qualifyVo.getAuditStatus(), 1)) continue;
                String content = qualifyVo.getContent();
                String qualifyTypeName = qualifyConfigNameMap.getOrDefault(qualifyVo.getQualifyName().longValue(), "");
                if (StringUtils.isNotBlank((CharSequence)content)) {
                    content = content + String.format("(%s)", qualifyVo.getQualifyId());
                }
                if (StringUtils.isNotBlank((CharSequence)qualifyTypeName)) {
                    qualifyTypeName = qualifyTypeName + String.format("(%s)", qualifyVo.getQualifyId());
                }
                if (StringUtils.isNotBlank((CharSequence)(qualifyContent = qualifyVo.getQualifyContent()))) {
                    List qualifyContentList = JSON.parseArray((String)qualifyContent, QualifyContentRo.class);
                    if (!CollectionUtils.isNotEmpty((Collection)qualifyContentList)) continue;
                    for (QualifyContentRo qualifyContentRo : qualifyContentList) {
                        String[] split2;
                        String images;
                        int diffTime;
                        String expireTime = qualifyContentRo.getExpireTime();
                        if (StringUtils.isNotBlank((CharSequence)expireTime) && (diffTime = DateUtil.countDiffDateDays((Date)new Date(), (Date)DateHelper.parse((String)expireTime, (String)"yyyy-MM-dd"))) < 0 || !StringUtils.isNotBlank((CharSequence)(images = qualifyContentRo.getImages()))) continue;
                        for (String url : split2 = images.split(",")) {
                            AdvertiserImgExcelVo.QualifyUrlObject qualifyUrlObject = new AdvertiserImgExcelVo.QualifyUrlObject();
                            qualifyUrlObject.setQualifyTypeName(qualifyTypeName);
                            qualifyUrlObject.setContent(content);
                            qualifyUrlObject.setName(qualifyContentRo.getLabel());
                            qualifyUrlObject.setUrl(url);
                            qualifyUrlObjects.add(qualifyUrlObject);
                        }
                    }
                    continue;
                }
                String imgStr = qualifyVo.getImgStr();
                if (!StringUtils.isNotBlank((CharSequence)imgStr)) continue;
                for (String url : split = imgStr.split(",")) {
                    AdvertiserImgExcelVo.QualifyUrlObject qualifyUrlObject = new AdvertiserImgExcelVo.QualifyUrlObject();
                    qualifyUrlObject.setQualifyTypeName(qualifyTypeName);
                    qualifyUrlObject.setContent(content);
                    qualifyUrlObject.setName("\u5176\u4ed6");
                    qualifyUrlObject.setUrl(url);
                    qualifyUrlObjects.add(qualifyUrlObject);
                }
            }
            excelVo.setQualifyUrlObjects(qualifyUrlObjects);
            excelVos.add(excelVo);
        }
        ExcelUtil.exportExcel(excelVos, null, "\u5e7f\u544a\u4e3b\u8d44\u8d28\u56fe\u7247\u5bfc\u51fa", AdvertiserImgExcelVo.class, "\u5e7f\u544a\u4e3b\u8d44\u8d28\u56fe\u7247\u5bfc\u51fa.xls", response);
    }

    private List<QualifyContentRo> convertQualifyContentJson(String qualifyContentJson) {
        List list = JSON.parseArray((String)qualifyContentJson, QualifyContentRo.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (QualifyContentRo qualifyContentRo : list) {
                if (qualifyContentRo.isLongTime()) {
                    qualifyContentRo.setIsExpire(Integer.valueOf(0));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)qualifyContentRo.getExpireTime())) continue;
                Integer time = DateUtil.countDiffDateDays((Date)new Date(), (Date)DateHelper.parse((String)qualifyContentRo.getExpireTime(), (String)"yyyy-MM-dd"));
                qualifyContentRo.setIsExpire(Integer.valueOf(time < 0 ? 1 : 0));
            }
        }
        return list;
    }

    private AdvertiserQualifyInfoVo qualifyInfoVoConvert(TblAdQualify adQualify) {
        QualificationConfig qualificationConfig;
        AdvertiserMainInfoVo advertiserMainInfo;
        if (null == adQualify) {
            throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        AdvertiserQualifyInfoVo vo = new AdvertiserQualifyInfoVo();
        vo.setAuditStatus(adQualify.getAuditStatus());
        vo.setContent(adQualify.getContent());
        vo.setQualifyId(adQualify.getId());
        vo.setImgStr(adQualify.getImage());
        vo.setRefuseReason(adQualify.getRefuseReason());
        vo.setRefuseRemark(adQualify.getRefuseRemark());
        vo.setQualifyContentRoList(this.convertQualifyContentJson(adQualify.getQualifyContent()));
        if (StringUtils.isNotBlank((CharSequence)adQualify.getImage())) {
            List<String> imgList = Arrays.asList(adQualify.getImage().split(","));
            vo.setImgList(imgList);
        }
        if (null != (advertiserMainInfo = this.adShopIntegration.getAdvertiserMainInfo(Integer.valueOf(adQualify.getAdvertiserId().intValue())))) {
            vo.setAdvertiserName(advertiserMainInfo.getCompany());
        }
        if (null != (qualificationConfig = this.qualificationConfigMapper.selectByPrimaryKey(Long.valueOf(adQualify.getQualifyName().longValue())))) {
            vo.setAdvertiserTypeStr(qualificationConfig.getName());
        }
        return vo;
    }

    @Override
    public ResultModel<Boolean> updateSpecialApproval(Integer advertiserId, Byte specialApproval) {
        return this.adShopIntegration.updateSpecialApproval(advertiserId, specialApproval);
    }
}

