/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.audit.impl;

import com.bxm.adsmanager.dal.mapper.audit.QualificationConfigMapper;
import com.bxm.adsmanager.model.dao.audit.QualificationConfig;
import com.bxm.adsmanager.model.enums.StatusEnum;
import com.bxm.adsmanager.model.vo.audit.QualificationConfigVo;
import com.bxm.adsmanager.service.audit.QualificationService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class QualificationServiceImpl
implements QualificationService {
    @Resource
    QualificationConfigMapper qualificationConfigMapper;

    @Override
    public ResultModel add(String name, Short grade, Long parentId, String remark, String userName, Integer code) throws Exception {
        QualificationConfig qulify;
        if (!Objects.isNull(code) && !Objects.isNull(qulify = this.qualificationConfigMapper.selectByCode(code))) {
            ResultModel resultModel = new ResultModel();
            resultModel.setErrorDesc("code\u7f16\u7801\u91cd\u590d");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        QualificationConfig qualificationConfig = new QualificationConfig();
        qualificationConfig.setCreateUser(userName);
        qualificationConfig.setCreateTime(new Date());
        qualificationConfig.setGrade(grade);
        qualificationConfig.setStatus(Short.valueOf((short)StatusEnum.NORMAL.getValue()));
        qualificationConfig.setParentId(parentId);
        qualificationConfig.setName(name);
        qualificationConfig.setRemark(remark);
        qualificationConfig.setCode(code);
        this.qualificationConfigMapper.insert(qualificationConfig);
        return ResultModelFactory.SUCCESS();
    }

    @Override
    public ResultModel update(String name, Long id, String remark, String userName, Integer code) throws Exception {
        QualificationConfig qulify;
        if (!Objects.isNull(code) && !Objects.isNull(qulify = this.qualificationConfigMapper.selectByCode(code))) {
            ResultModel resultModel = new ResultModel();
            resultModel.setErrorDesc("code\u7f16\u7801\u91cd\u590d");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        QualificationConfig qualificationConfig = new QualificationConfig();
        qualificationConfig.setUpdateUser(userName);
        qualificationConfig.setUpdateTime(new Date());
        qualificationConfig.setName(name);
        qualificationConfig.setRemark(remark);
        qualificationConfig.setId(id);
        qualificationConfig.setCode(code);
        this.qualificationConfigMapper.updateByPrimaryKeySelective(qualificationConfig);
        return ResultModelFactory.SUCCESS();
    }

    @Override
    public void delete(Long id, String userName) throws Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        List twoIds = this.qualificationConfigMapper.selectIdsByParentId(ids);
        if (CollectionUtils.isNotEmpty((Collection)twoIds)) {
            ids.addAll(twoIds);
            List threeIds = this.qualificationConfigMapper.selectIdsByParentId(twoIds);
            if (CollectionUtils.isNotEmpty((Collection)threeIds)) {
                ids.addAll(threeIds);
            }
        }
        this.qualificationConfigMapper.updateByPrimaryKey(ids, userName);
    }

    @Override
    public PageInfo<QualificationConfigVo> getPageList(String grade, String keywords, String status, Integer pageNum, Integer pageSize, String parentId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        List qualificationConfigList = this.qualificationConfigMapper.getAllList();
        for (QualificationConfig qualificationConfig : qualificationConfigList) {
            map.put(qualificationConfig.getId().toString(), qualificationConfig.getName());
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.qualificationConfigMapper.getList(grade, keywords, status, parentId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        for (QualificationConfigVo qualificationConfigVo : list) {
            qualificationConfigVo.setParentName((String)map.get(qualificationConfigVo.getParentId().toString()));
        }
        return new PageInfo(list);
    }

    @Override
    public List<QualificationConfigVo> getList(String grade, String keywords, String status, String parentId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        List qualificationConfigList = this.qualificationConfigMapper.getAllList();
        for (QualificationConfig qualificationConfig : qualificationConfigList) {
            map.put(qualificationConfig.getId().toString(), qualificationConfig.getName());
        }
        List list = this.qualificationConfigMapper.getList(grade, keywords, status, parentId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<QualificationConfigVo>();
        }
        for (QualificationConfigVo qualificationConfigVo : list) {
            qualificationConfigVo.setParentName((String)map.get(qualificationConfigVo.getId().toString()));
        }
        return list;
    }

    @Override
    public List<QualificationConfig> getAllList() {
        List qualificationConfigList = this.qualificationConfigMapper.getAllList();
        if (CollectionUtils.isEmpty((Collection)qualificationConfigList)) {
            return Collections.EMPTY_LIST;
        }
        return qualificationConfigList;
    }
}

