/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.audit.impl;

import com.bxm.adsmanager.dal.mapper.audit.RefuseConfigMapper;
import com.bxm.adsmanager.model.dao.audit.RefuseConfig;
import com.bxm.adsmanager.model.enums.StatusEnum;
import com.bxm.adsmanager.model.vo.audit.RefuseConfigVo;
import com.bxm.adsmanager.service.audit.RefuseService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefuseServiceImpl
implements RefuseService {
    @Autowired
    RefuseConfigMapper refuseConfigMapper;

    @Override
    public void add(String reason, Short type, String userName) throws Exception {
        RefuseConfig refuseConfig = new RefuseConfig();
        refuseConfig.setCreateTime(new Date());
        refuseConfig.setCreateUser(userName);
        refuseConfig.setReason(reason);
        refuseConfig.setType(type);
        refuseConfig.setStatus(Short.valueOf((short)StatusEnum.NORMAL.getValue()));
        this.refuseConfigMapper.insert(refuseConfig);
    }

    @Override
    public void update(String reason, Long id, String userName) throws Exception {
        RefuseConfig refuseConfig = new RefuseConfig();
        refuseConfig.setUpdateTime(new Date());
        refuseConfig.setUpdateUser(userName);
        refuseConfig.setReason(reason);
        refuseConfig.setId(id);
        this.refuseConfigMapper.updateByPrimaryKeySelective(refuseConfig);
    }

    @Override
    public void updateStatus(Long id, Short status, String userName) throws Exception {
        RefuseConfig refuseConfig = new RefuseConfig();
        refuseConfig.setId(id);
        refuseConfig.setUpdateTime(new Date());
        refuseConfig.setUpdateUser(userName);
        refuseConfig.setStatus(status);
        this.refuseConfigMapper.updateByPrimaryKeySelective(refuseConfig);
    }

    @Override
    public PageInfo<RefuseConfigVo> getList(String type, String status, Integer pageNum, Integer pageSize) throws Exception {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.refuseConfigMapper.selectByParams(type, status);
        return new PageInfo(list);
    }
}

