/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.common.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.common.LandUserInfoMapper;
import com.bxm.adsmanager.ecxeption.ExcelException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.common.LandUserInfoPageDo;
import com.bxm.adsmanager.model.dto.LandUserPageParamsDTO;
import com.bxm.adsmanager.model.enums.LandUserAgeRangeEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.common.LandUserExInfoVO;
import com.bxm.adsmanager.model.vo.common.LandUserInfoExportVO;
import com.bxm.adsmanager.model.vo.common.LandUserInfoVO;
import com.bxm.adsmanager.service.common.LandUserInfoService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.IdCardUtils;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LandUserInfoServiceImpl
implements LandUserInfoService {
    @Autowired
    private LandUserInfoMapper landUserInfoMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    public Pagination findAll(LandUserPageParamsDTO paramsDTO) {
        Pagination pagination = new Pagination();
        pagination.setCondition((Object)paramsDTO);
        pagination.setPageSize(paramsDTO.getPageSize());
        pagination.setPageNo(paramsDTO.getPageNum());
        pagination.setList(Collections.emptyList());
        return this.getLandUserInfoList(paramsDTO);
    }

    @Override
    public void export(HttpServletResponse response, LandUserPageParamsDTO paramsDTO) throws ExcelException {
        List landUserInfoExportVOS;
        paramsDTO.setPageNum(Integer.valueOf(1));
        paramsDTO.setPageSize(Integer.valueOf(1000));
        Pagination pagination = this.getLandUserInfoList(paramsDTO);
        List landUserInfoVOS = pagination.getList();
        if (CollectionUtils.isEmpty((Collection)landUserInfoVOS)) {
            landUserInfoExportVOS = Collections.emptyList();
        } else {
            landUserInfoExportVOS = new ArrayList(landUserInfoVOS.size());
            for (LandUserInfoVO landUserInfoVO : landUserInfoVOS) {
                String[] array;
                LandUserInfoExportVO landUserInfoExportVO = new LandUserInfoExportVO();
                BeanUtils.copyProperties((Object)landUserInfoVO, (Object)landUserInfoExportVO);
                landUserInfoExportVO.setUserAgeRange(LandUserAgeRangeEnum.getDesc((Integer)landUserInfoVO.getUserAgeRange()));
                String appKey = null;
                String businessId = null;
                if (StringUtils.isNotBlank((CharSequence)landUserInfoExportVO.getBusinessId()) && (array = landUserInfoExportVO.getBusinessId().split("-")).length > 1) {
                    appKey = array[0];
                    businessId = array[1];
                }
                landUserInfoExportVOS.add(landUserInfoExportVO);
            }
        }
        ExcelUtil.exportExcel(landUserInfoExportVOS, null, null, LandUserInfoExportVO.class, "\u843d\u5730\u9875\u6570\u636e\u4e0b\u8f7d.xls", response);
    }

    private Pagination getLandUserInfoList(LandUserPageParamsDTO paramsDTO) {
        String keywords = paramsDTO.getKeywords();
        if (StringUtils.isNotEmpty((CharSequence)paramsDTO.getKeywords())) {
            HashSet<Long> ticketIds = new HashSet<Long>();
            if (NumberUtils.isNumber((String)keywords)) {
                ticketIds.add(Long.parseLong(keywords));
            } else {
                List ids = this.adTicketMapper.findIdsByName(keywords);
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    ticketIds.addAll(ids);
                }
            }
            paramsDTO.setTicketIds(ticketIds);
        }
        List appEntranceAdRos = null;
        String advertisingPosition = paramsDTO.getAdvertisingPosition();
        if (StringUtils.isNotBlank((CharSequence)advertisingPosition)) {
            AbstractCollection positionIds;
            QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
            if (advertisingPosition.contains("-")) {
                positionIds = Lists.newArrayList();
                positionIds.add(advertisingPosition);
                queryAppEntranceParamDTO.setPositionIds((List)((Object)positionIds));
            } else {
                queryAppEntranceParamDTO.setAppKey(advertisingPosition);
            }
            appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO);
            if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
                return new Pagination();
            }
            positionIds = Sets.newHashSetWithExpectedSize((int)appEntranceAdRos.size());
            for (AppEntranceAdRO ro : appEntranceAdRos) {
                positionIds.add(ro.getPositionId().replace("-", "ad-"));
            }
            paramsDTO.setPositionIds((Set)((Object)positionIds));
        } else {
            paramsDTO.setPositionIds(Collections.emptySet());
        }
        PageInfo landUserInfoPageDoPageInfo = PageHelper.startPage((int)paramsDTO.getPageNum(), (int)paramsDTO.getPageSize()).doSelectPageInfo(() -> this.landUserInfoMapper.findLandUserInfoPage(paramsDTO));
        List landUserInfoPageDos = landUserInfoPageDoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)landUserInfoPageDos)) {
            return new Pagination();
        }
        ArrayList ticketIds = Lists.newArrayListWithCapacity((int)landUserInfoPageDos.size());
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)landUserInfoPageDos.size());
        for (LandUserInfoPageDo pageDo : landUserInfoPageDos) {
            String appEntranceId = pageDo.getAppEntranceId();
            ticketIds.add(pageDo.getTicketId());
            if (!StringUtils.isNotBlank((CharSequence)appEntranceId)) continue;
            positionIds.add(pageDo.getAppkey() + appEntranceId.substring(appEntranceId.lastIndexOf("-"), appEntranceId.length()));
        }
        List adTickets = this.adTicketMapper.findAllByIds((List)ticketIds);
        Map<Long, String> ticketMap = adTickets.stream().collect(Collectors.toMap(AdTicket::getId, AdTicket::getName));
        if (CollectionUtils.isNotEmpty((Collection)positionIds)) {
            QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
            queryAppEntranceParamDTO.setPositionIds((List)Lists.newArrayList((Iterable)positionIds));
            appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO);
        }
        Map appEntranceAdRoMap = CollectionUtils.isEmpty((Collection)appEntranceAdRos) ? Collections.emptyMap() : (Map)appEntranceAdRos.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        ArrayList<LandUserInfoVO> landUserInfoVOS = new ArrayList<LandUserInfoVO>(landUserInfoPageDos.size());
        for (LandUserInfoPageDo landUserInfo : landUserInfoPageDos) {
            LandUserInfoVO landUserInfoVO = new LandUserInfoVO();
            BeanUtils.copyProperties((Object)landUserInfo, (Object)landUserInfoVO);
            String appEntranceId = landUserInfo.getAppEntranceId();
            AppEntranceAdRO appEntranceAdRo = (AppEntranceAdRO)appEntranceAdRoMap.get(landUserInfo.getAppkey() + appEntranceId.substring(appEntranceId.lastIndexOf("-"), appEntranceId.length()));
            if (null != appEntranceAdRo) {
                landUserInfoVO.setMediaName(appEntranceAdRo.getProviderAlias());
                landUserInfoVO.setBusinessName(appEntranceAdRo.getAppEntranceName());
                landUserInfoVO.setBusinessId(appEntranceAdRo.getPositionId());
                landUserInfoVO.setPositionIdCodeName(String.format("%06d", appEntranceAdRo.getCode()) + "-" + appEntranceAdRo.getAppEntranceId());
            } else {
                landUserInfoVO.setBusinessId(landUserInfo.getAppkey() + "-" + landUserInfo.getBusinessId());
            }
            landUserInfoVO.setTicketName(ticketMap.get(landUserInfo.getTicketId()));
            if (null == landUserInfoVO.getUserAgeRange() && StringUtils.isNotBlank((CharSequence)landUserInfo.getIdentification())) {
                landUserInfoVO.setUserAgeRange(LandUserAgeRangeEnum.getRange((Integer)IdCardUtils.getAgeByIdCard(landUserInfo.getIdentification())));
            }
            this.buildLandUserExInfo(landUserInfoVO, landUserInfo.getInfo());
            landUserInfoVOS.add(landUserInfoVO);
        }
        Pagination pagination = new Pagination();
        pagination.setCondition((Object)paramsDTO);
        pagination.setPageSize(paramsDTO.getPageSize());
        pagination.setPageNo(paramsDTO.getPageNum());
        pagination.setList(landUserInfoVOS);
        pagination.setTotalCount((int)landUserInfoPageDoPageInfo.getTotal());
        return pagination;
    }

    private void buildLandUserExInfo(LandUserInfoVO landUserInfoVO, String info) {
        if (StringUtils.isEmpty((CharSequence)info)) {
            return;
        }
        LandUserExInfoVO landUserExInfoVO = (LandUserExInfoVO)JSON.parseObject((String)info, LandUserExInfoVO.class);
        if (null == landUserExInfoVO) {
            return;
        }
        landUserInfoVO.setOccupation(landUserExInfoVO.getOccupation());
    }

    private void buildLandUserAgeRange(LandUserInfoVO landUserInfoVO, String userAgeRange, String identification) {
        if (StringUtils.isNotEmpty((CharSequence)userAgeRange)) {
            String ageRangeDesc;
            if (userAgeRange.contains(":") && StringUtils.isNotEmpty((CharSequence)(ageRangeDesc = userAgeRange.split(":")[1]))) {
                landUserInfoVO.setUserAgeRange(LandUserAgeRangeEnum.getRange((String)ageRangeDesc));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)identification)) {
            landUserInfoVO.setUserAgeRange(LandUserAgeRangeEnum.getRange((Integer)IdCardUtils.getAgeByIdCard(identification)));
        }
    }
}

