/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.common.impl;

import com.bxm.adsmanager.dal.mapper.mediamanager.ext.AdTicketPositionWeightMapperExt;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.InfoMediaMsgDto;
import com.bxm.adsmanager.model.dto.InfoPositionMsgDto;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.service.common.MediaPositionService;
import com.bxm.adsmanager.utils.AppEntityConvertHelper;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaPositionServiceImpl
implements MediaPositionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionServiceImpl.class);
    @Autowired
    private AdTicketPositionWeightMapperExt mediaPostionWeightExt;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    public List<InfoMediaMsgDto> findMediaByRole(User user, CommonSearchDto search) {
        if (this.getMJCode(user) != null) {
            ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
            providerAppAdDto.setMedium(this.getMJCode(user));
            if (search != null && StringUtils.isNotBlank((CharSequence)search.getKeyWords())) {
                providerAppAdDto.setKeywords(search.getKeyWords());
            }
            return AppEntityConvertHelper.appListConvertToMediaMsgList(this.providerFacadeIntegration.getProviderAppList(providerAppAdDto));
        }
        return this.findMediaAll(search);
    }

    @Override
    public List<InfoPositionMsgDto> findPositionByRole(User user, CommonSearchDto search) {
        if (this.getMJCode(user) != null) {
            LOGGER.info("\u666e\u901a\u5a92\u4ecb\u67e5\u8be2\u5e7f\u544a\u4f4d");
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setAppKey(search.getAppKey());
            paramDTO.setKeywords(search.getKeywords());
            paramDTO.setMjCode(this.getMJCode(user));
            List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
            if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
                return Collections.emptyList();
            }
            return AppEntityConvertHelper.convertAppEntranceToInfoPositionMsgDto(appEntranceAdRos);
        }
        return this.findPositionAll(search);
    }

    @Override
    public List<InfoMediaMsgDto> findMediaAll(CommonSearchDto search) {
        ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
        if (search != null && StringUtils.isNotBlank((CharSequence)search.getKeyWords())) {
            providerAppAdDto.setKeywords(search.getKeyWords());
        }
        return AppEntityConvertHelper.appListConvertToMediaMsgList(this.providerFacadeIntegration.getProviderAppList(providerAppAdDto));
    }

    @Override
    public List<InfoPositionMsgDto> findPositionAll(CommonSearchDto search) {
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setKeywords(search.getKeywords());
        paramDTO.setAppKey(search.getAppKey());
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToInfoPositionMsgDto(appEntranceAdRos);
    }

    @Override
    public List<InfoPositionMsgDto> findAllPositionByAppkeysAndKeywords(List<String> appKeys, String keywords) {
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setAppKeys(appKeys);
        paramDTO.setAppKeyOrFuzzyAppEntranceNameKeywords(keywords);
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToInfoPositionMsgDto(appEntranceAdRos);
    }

    private String getMJCode(User user) {
        List codes = user.getRoleCodes();
        if (!codes.contains(RoleEnum.MJLEADER.getCode()) && codes.contains(RoleEnum.MJ.getCode())) {
            return user.getUserNameContainRole(RoleEnum.MJ.getCode());
        }
        return null;
    }
}

