/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.datapark.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitMediaMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitPositionMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdTicketIncomeMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdTicketIncomePositionMapperExt;
import com.bxm.adsmanager.integration.datapark.service.DataparkIncomeIntergration;
import com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo;
import com.bxm.adsmanager.model.vo.AdTicketIncomePositionVo;
import com.bxm.adsmanager.service.datapark.DataparkIncomeService;
import com.bxm.datapark.facade.profit.AdTicketIncomeVo;
import com.bxm.util.StringUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataparkIncomeServiceImpl
implements DataparkIncomeService {
    @Autowired
    private AdProfitMediaMapperExt adProfitMediaMapper;
    @Autowired
    private AdProfitPositionMapperExt adProfitPositionMapper;
    @Autowired
    private AdTicketIncomePositionMapperExt adTicketIncomePositionMapper;
    @Autowired
    private DataparkIncomeIntergration dataparkIncomeIntergration;
    @Autowired
    private AdTicketIncomeMapperExt incomeMapperExt;

    @Override
    public void dealAppCash(String datetime) throws IOException {
        if (StringUtil.isEmpty((CharSequence)datetime)) {
            return;
        }
        List profitApps = this.adProfitMediaMapper.getProfitMsgGroupMediaOld(datetime);
        List incomeApps = this.adTicketIncomePositionMapper.findAdTicketIncomeGroupMediaOld(datetime);
        List profitBusinesses = this.adProfitPositionMapper.getProfitMsgGroupPositionOld(datetime);
        List incomeBusinesses = this.adTicketIncomePositionMapper.fingMsgGroupPositionOld(datetime);
        HashMap mapAppIncome = new HashMap();
        HashMap mapApp = new HashMap();
        HashMap mapBusinessIncome = new HashMap();
        HashMap mapBusiness = new HashMap();
        HashSet appkeyList = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)profitApps)) {
            profitApps.stream().forEach(profitApp -> this.dealIncomeCollection(profitApp.getAppId(), profitApp.getProfitActual(), appkeyList, mapApp, true));
        }
        if (CollectionUtils.isNotEmpty((Collection)incomeApps)) {
            incomeApps.stream().forEach(incomeVo -> this.dealIncomeCollection(incomeVo.getPositionId(), incomeVo.getConsume(), appkeyList, mapAppIncome, true));
        }
        if (CollectionUtils.isNotEmpty((Collection)profitBusinesses)) {
            profitBusinesses.stream().forEach(profitPosition -> this.dealIncomeCollection(profitPosition.getPositionId(), profitPosition.getProfitActual(), appkeyList, mapBusiness, false));
        }
        if (CollectionUtils.isNotEmpty((Collection)incomeBusinesses)) {
            incomeBusinesses.stream().forEach(incomeVo -> this.dealIncomeCollection(incomeVo.getPositionId(), incomeVo.getConsume(), appkeyList, mapBusinessIncome, false));
        }
        this.dataparkIncomeIntergration.dealAppCash(datetime, JSON.toJSONString(mapAppIncome), JSON.toJSONString(mapApp), JSON.toJSONString(mapBusinessIncome), JSON.toJSONString(mapBusiness), JSON.toJSONString(appkeyList));
    }

    @Override
    public void dealTicketIncome(String datetime, List<Long> certificateidList) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datetime", datetime);
        map.put("certificateids", certificateidList);
        map.put("type", "ticket");
        List ticketIncomeVos = this.incomeMapperExt.fingAdTicketIncome(map);
        HashMap mapCertificate = Maps.newHashMap();
        this.convertConsume(ticketIncomeVos, mapCertificate);
        map.put("type", "app");
        List appCashs = this.adTicketIncomePositionMapper.findTicketIncomeOld(map);
        HashMap<String, BigDecimal> mapApp = new HashMap<String, BigDecimal>();
        this.dealTicketIncome(appCashs, mapApp);
        map.put("type", "business");
        List businessCashs = this.adTicketIncomePositionMapper.findTicketIncomeOld(map);
        HashMap<String, BigDecimal> mapBusiness = new HashMap<String, BigDecimal>();
        this.dealTicketIncome(businessCashs, mapBusiness);
        this.dataparkIncomeIntergration.dealTicketCash(datetime, JSON.toJSONString((Object)mapCertificate), JSON.toJSONString(mapApp), JSON.toJSONString(mapBusiness), JSON.toJSONString(certificateidList));
    }

    public void convertConsume(List<AdTicketIncomeDetailVo> ticketIncomeVos, Map<String, AdTicketIncomeVo> map) {
        if (CollectionUtils.isEmpty(ticketIncomeVos)) {
            return;
        }
        for (AdTicketIncomeDetailVo income : ticketIncomeVos) {
            AdTicketIncomeVo vo = new AdTicketIncomeVo();
            vo.setConsume(new BigDecimal(income.getTicketIncome()).setScale(5, 4));
            vo.setIncome(new BigDecimal(income.getActualIncomeShow()).setScale(5, 4));
            vo.setTicketId(income.getTicketId());
            map.put(income.getTicketId().toString(), vo);
        }
    }

    private void dealTicketIncome(List<AdTicketIncomePositionVo> cashs, Map<String, BigDecimal> map) {
        if (CollectionUtils.isEmpty(cashs)) {
            return;
        }
        cashs.forEach(cashDto -> map.put(cashDto.getPositionId(), new BigDecimal(cashDto.getConsume() == null ? 0.0 : (double)cashDto.getConsume().intValue() / 1000.0).setScale(5, 4)));
    }

    private void dealIncomeCollection(String key, Integer value, Set<String> appkeyList, Map<String, BigDecimal> map, boolean needset) {
        if (needset) {
            appkeyList.add(key);
        }
        map.put(key, new BigDecimal((double)(value == null ? 0 : value) / 1000.0).setScale(4, 4));
    }
}

