/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.diysite.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmanager.configures.DIYSiteConfiguration;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.dal.mapper.diysite.SiteInstanceMapper;
import com.bxm.adsmanager.dal.mapper.diysite.SiteTemplateMapper;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDao;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDto;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDao;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDto;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.diysite.SiteInstanceService;
import com.bxm.adsmanager.utils.AddCdnDomainUtils;
import com.bxm.adsprod.facade.ticket.DIYSiteInfo;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteInstanceServiceImpl
implements SiteInstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteInstanceServiceImpl.class);
    @Autowired
    private SiteInstanceMapper siteInstanceMapper;
    @Autowired
    private SiteTemplateMapper siteTemplateMapper;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Resource
    private Mapper mapper;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private DIYSiteConfiguration diySiteConfiguration;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private AclUserIntegration aclUserIntegration;

    @Override
    public PageInfo<SiteInstanceDao> findAll(SiteInstanceDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)dto.getAdvertiserName())) {
            try {
                List adShopMsgsByKeywords = this.adShopIntegration.findAdShopMsgsByKeywords(dto.getAdvertiserName(), null);
                if (CollectionUtils.isEmpty((Collection)adShopMsgsByKeywords)) {
                    return new PageInfo();
                }
                ArrayList ids = Lists.newArrayList();
                adShopMsgsByKeywords.forEach(e -> ids.add(e.getId().longValue()));
                if (CollectionUtils.isNotEmpty((Collection)dto.getAdvertiserIds())) {
                    ArrayList list = Lists.newArrayList((Iterable)CollectionUtils.intersection((Collection)ids, (Collection)dto.getAdvertiserIds()));
                    dto.setAdvertiserIds((List)list);
                } else {
                    dto.setAdvertiserIds((List)ids);
                }
            }
            catch (IOException e2) {
                LOGGER.error("adShopIntegration.findAdShopMsgsByKeywords error ", (Throwable)e2);
            }
        }
        List list = this.siteInstanceMapper.findByParam(dto);
        this.fillAdvertiserName(list);
        this.fillTemplateName(list);
        this.fillAds(list);
        for (SiteInstanceDao siteInstanceDao : list) {
            String json;
            UserRo user = this.aclUserIntegration.queryUserByUsername(siteInstanceDao.getCreateUser());
            if (user != null && !"{}".equals(json = JSON.toJSONString((Object)user))) {
                siteInstanceDao.setCreateUser(user.getName());
            }
            if (!"advertiser".equals(siteInstanceDao.getCreateUser())) continue;
            siteInstanceDao.setCreateUser("\u5e7f\u544a\u4e3b");
        }
        return new PageInfo(list);
    }

    @Override
    public boolean saveOrUpdate(SiteInstanceDto dto, User user) {
        SiteInstanceDao dao = new SiteInstanceDao();
        this.mapper.map((Object)dto, (Object)dao);
        int count = 0;
        String templateUrl = dto.getUrl();
        if (null != dto.getTemplateId() && dto.getTemplateId() > 0L) {
            SiteTemplateDto queryParam = new SiteTemplateDto();
            queryParam.setId(dto.getTemplateId());
            List temps = this.siteTemplateMapper.findAll(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)temps)) {
                templateUrl = ((SiteTemplateDao)temps.get(0)).getTemplateUrl();
            }
        }
        if (dto.getUseOwnDomain() != 0) {
            throw new IllegalStateException("\u81ea\u6709\u57df\u540d\u529f\u80fd\u5df2\u505c\u7528");
        }
        dao.setUrl(templateUrl);
        if (dto.getId() == null || dto.getId() == 0L) {
            dao.setCreateTime(new Date());
            dao.setModifyTime(new Date());
            if (null == user) {
                dao.setCreateUser("advertiser");
            } else {
                dao.setCreateUser(user.getUsername());
            }
            count = this.siteInstanceMapper.save(dao);
        } else {
            dao.setModifyTime(new Date());
            count = this.siteInstanceMapper.update(dao);
        }
        StringBuilder mutable = new StringBuilder(64);
        mutable.append(dao.getUrl());
        if (StringUtils.isNotBlank((CharSequence)mutable) && !mutable.toString().endsWith("pageId=" + dao.getId())) {
            if (mutable.toString().contains("?")) {
                mutable.append("&pageId=");
            } else {
                mutable.append("?pageId=");
            }
            mutable.append(dao.getId());
            String url = mutable.toString();
            String redirectUrl = this.replaceRedirectUrl(url);
            dao.setUrl(redirectUrl);
            this.siteInstanceMapper.update(dao);
        }
        DIYSiteInfo info = new DIYSiteInfo();
        this.mapper.map((Object)dao, (Object)info);
        try {
            this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.DIY_SITE_INFO.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)info));
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001\u81ea\u5efa\u7ad9\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return count == 1;
    }

    private String randomNum(String numInfos) {
        try {
            JSONArray jsonArray = JSONArray.parseArray((String)numInfos);
            if (jsonArray.size() > 0) {
                return jsonArray.getJSONObject(0).getString("num");
            }
        }
        catch (Exception e) {
            LOGGER.error("randomNum: ", (Throwable)e);
        }
        return null;
    }

    private String replaceRedirectUrl(String url) {
        try {
            URL url1 = new URL(url);
            String path = url1.getPath();
            String query = url1.getQuery();
            String ref = url1.getRef();
            StringBuilder str = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)path)) {
                str.append(path);
            }
            if (StringUtils.isNotBlank((CharSequence)query)) {
                str.append("?").append(query);
            }
            if (StringUtils.isNotBlank((CharSequence)ref)) {
                str.append("#").append(ref);
            }
            String redirectUrl = this.diySiteConfiguration.getRedirectUrl();
            return StringUtils.replace((String)redirectUrl, (String)"${templateUri}", (String)SiteInstanceServiceImpl.urlEncode(str.toString()));
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private static String urlEncode(String path) {
        try {
            return URLEncoder.encode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return path;
        }
    }

    private void callAliAddDdnDomain(String sefeDomain) {
        AddCdnDomainUtils.addDomain(sefeDomain, this.diySiteConfiguration);
    }

    private String getDomainFromUrl(String url) {
        try {
            URL urlObj = new URL(url);
            String host = urlObj.getHost();
            return host;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public SiteInstanceDao getById(Long id) {
        SiteInstanceDto dto = new SiteInstanceDto();
        dto.setId(id);
        List list = this.siteInstanceMapper.findByParam(dto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.fillTemplateName(list);
            return (SiteInstanceDao)list.get(0);
        }
        return null;
    }

    private void fillTemplateName(List<SiteInstanceDao> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList templateIds = Lists.newArrayList();
            for (SiteInstanceDao dao : list) {
                templateIds.add(dao.getTemplateId());
            }
            SiteTemplateDto templateDto = new SiteTemplateDto();
            templateDto.setIds((List)templateIds);
            List templateDaos = this.siteTemplateMapper.findAll(templateDto);
            HashMap map = Maps.newHashMap();
            HashMap mapUrl = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)templateDaos)) {
                templateDaos.forEach(e -> {
                    map.put(e.getId(), e.getTemplateName());
                    mapUrl.put(e.getId(), e.getTemplateUrl());
                });
            }
            list.forEach(e -> {
                e.setTemplateName((String)map.get(e.getTemplateId()));
                e.setTemplateUrl((String)mapUrl.get(e.getTemplateId()));
            });
        }
    }

    private void fillAdvertiserName(List<SiteInstanceDao> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList templateIds = Lists.newArrayList();
            for (SiteInstanceDao dao : list) {
                templateIds.add(dao.getAdvertiserId());
            }
            try {
                List adShopMsgs = this.adShopIntegration.findAdShopMsgs(StringUtils.join((Iterable)templateIds, (String)","));
                HashMap map = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)adShopMsgs)) {
                    adShopMsgs.forEach(e -> map.put(e.getId().longValue(), e.getCompany()));
                }
                list.forEach(e -> e.setAdvertiserName((String)map.get(e.getAdvertiserId())));
            }
            catch (IOException e2) {
                LOGGER.error("adShopIntegration.findAdShopMsgs error ", (Throwable)e2);
            }
        }
    }

    private void fillAds(List<SiteInstanceDao> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> {
                List ticketIds = this.adTicketMapper.findAdticketsByUrl(e.getUrl());
                if (CollectionUtils.isNotEmpty((Collection)ticketIds)) {
                    e.setAds(StringUtils.join((Iterable)ticketIds, (String)","));
                } else {
                    e.setAds("\u6682\u65e0");
                }
            });
        }
    }

    @Override
    public Boolean setOwnSite(Integer advertiserId, String ownSite) {
        if (StringUtils.isEmpty((CharSequence)ownSite) || "[]".equals(ownSite)) {
            this.jedisUpdater.hremoveWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"ADVERTISER", "OWN_SITE_TEMPLATE"}), 4, new String[]{advertiserId + ""});
            return true;
        }
        List list = JSON.parseArray((String)ownSite, String.class);
        try {
            this.jedisUpdater.hupdateWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"ADVERTISER", "OWN_SITE_TEMPLATE"}), advertiserId + "", (Object)list, 4);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u81ea\u5efa\u7ad9\u914d\u7f6e\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean deleteById(Long id) {
        SiteInstanceDao siteInstanceDao = new SiteInstanceDao();
        siteInstanceDao.setId(id);
        siteInstanceDao.setDeleteTime(new Date());
        this.siteInstanceMapper.update(siteInstanceDao);
        return null;
    }

    @Override
    public List<Dictionaries> findCreateUser() {
        ArrayList result = Lists.newArrayList();
        List userCodeList = this.siteInstanceMapper.findCreateUser();
        if (CollectionUtils.isEmpty((Collection)userCodeList)) {
            return result;
        }
        for (String userCode : userCodeList) {
            if (StringUtils.isEmpty((CharSequence)userCode)) continue;
            Dictionaries dictionaries = new Dictionaries();
            dictionaries.setTypecode(userCode);
            UserRo user = this.aclUserIntegration.queryUserByUsername(userCode);
            if (user != null) {
                dictionaries.setTypename(user.getName());
                if ("advertiser".equals(userCode)) {
                    dictionaries.setTypename("\u5e7f\u544a\u4e3b");
                }
            }
            result.add(dictionaries);
        }
        return result;
    }
}

