/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.explore.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.explore.TicketExploreConfigMapper;
import com.bxm.adsmanager.dal.mapper.explore.TicketExploreMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.utils.DataParkUtils;
import com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage;
import com.bxm.adsmanager.model.dao.explore.TicketExplore;
import com.bxm.adsmanager.model.dao.explore.TicketExploreConfig;
import com.bxm.adsmanager.model.dao.explore.TicketExploreConsume;
import com.bxm.adsmanager.model.dao.explore.TicketExplorePush;
import com.bxm.adsmanager.model.dto.explore.TicketExploreConfigDto;
import com.bxm.adsmanager.model.dto.explore.TicketExploreDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.explore.TicketExploreConfigVo;
import com.bxm.adsmanager.model.vo.explore.TicketExploreVo;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.service.explore.TicketExploreService;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.adsmanager.utils.LocalDateUtils;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.util.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketExploreServiceImpl
implements TicketExploreService {
    private static final Logger log = LoggerFactory.getLogger(TicketExploreServiceImpl.class);
    @Resource
    TicketExploreMapper ticketExploreMapper;
    @Resource
    TicketExploreConfigMapper ticketExploreConfigMapper;
    @Resource
    AdFlowPackageMapper adFlowPackageMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;
    @Resource
    AdPositionService adPositionService;
    @Autowired
    private AdRulesMapper adRulesMapper;

    @Override
    public void add(TicketExploreDto ticketExploreDto, String userName) throws Exception {
        TicketExploreConfig ticketExploreConfig;
        TicketExplore ticketExplore = new TicketExplore();
        BeanUtils.copyProperties((Object)ticketExploreDto, (Object)ticketExplore);
        ticketExplore.setCreateTime(new Date());
        ticketExplore.setCreateUser(userName);
        ticketExplore.setStartDate(LocalDateUtils.coverByString6Date(ticketExploreDto.getStartDate()));
        ticketExplore.setEndDate(LocalDateUtils.coverByString6Date(ticketExploreDto.getEndDate()));
        ticketExplore.setDayStartTime(LocalDateUtils.coverTimeByString6Date(ticketExploreDto.getDayStartTime()));
        ticketExplore.setDayEndTime(LocalDateUtils.coverTimeByString6Date(ticketExploreDto.getDayEndTime()));
        ticketExplore.setStartTime(ticketExploreDto.getDayStartTime());
        ticketExplore.setEndTime(ticketExploreDto.getDayEndTime());
        ArrayList<TicketExploreConfig> addList = new ArrayList<TicketExploreConfig>();
        List positonConfigList = new ArrayList();
        List flowPackageConfigList = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ticketExploreDto.getPositonConfig())) {
            positonConfigList = JSONObject.parseArray((String)ticketExploreDto.getPositonConfig(), TicketExploreConfigDto.class);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ticketExploreDto.getFlowPackageConfig())) {
            flowPackageConfigList = JSONObject.parseArray((String)ticketExploreDto.getFlowPackageConfig(), TicketExploreConfigDto.class);
        }
        if (CollectionUtils.isNotEmpty(positonConfigList)) {
            for (TicketExploreConfigDto ticketExploreConfigDto : positonConfigList) {
                ticketExploreConfig = new TicketExploreConfig();
                BeanUtils.copyProperties((Object)ticketExploreConfigDto, (Object)ticketExploreConfig);
                addList.add(ticketExploreConfig);
            }
        }
        if (CollectionUtils.isNotEmpty(flowPackageConfigList)) {
            for (TicketExploreConfigDto ticketExploreConfigDto : flowPackageConfigList) {
                ticketExploreConfig = new TicketExploreConfig();
                BeanUtils.copyProperties((Object)ticketExploreConfigDto, (Object)ticketExploreConfig);
                addList.add(ticketExploreConfig);
            }
        }
        this.ticketExploreMapper.insert(ticketExplore);
        if (CollectionUtils.isNotEmpty(addList)) {
            this.ticketExploreConfigMapper.batchInsert(addList);
        }
        this.push(ticketExploreDto.getTicketId());
    }

    @Override
    public TicketExploreVo findById(Long ticketId) throws Exception {
        TicketExploreConfigVo ticketExploreConfigVo2;
        TicketExplore ticketExplore = this.ticketExploreMapper.selectByPrimaryParams(ticketId);
        if (Objects.isNull(ticketExplore)) {
            return new TicketExploreVo();
        }
        TicketExploreVo ticketExploreVo = new TicketExploreVo();
        BeanUtils.copyProperties((Object)ticketExplore, (Object)ticketExploreVo);
        List positionExploreList = this.ticketExploreConfigMapper.selectByParams(ticketId, 1);
        List flowPackageExploreList = this.ticketExploreConfigMapper.selectByParams(ticketId, 2);
        ArrayList<TicketExploreConfigVo> positonExploreConfigList = new ArrayList<TicketExploreConfigVo>();
        ArrayList<TicketExploreConfigVo> flowPackageExploreConfigList = new ArrayList<TicketExploreConfigVo>();
        if (CollectionUtils.isNotEmpty((Collection)positionExploreList)) {
            ArrayList<String> positionIds = new ArrayList<String>();
            for (Object ticketExploreConfig : positionExploreList) {
                positionIds.add(ticketExploreConfig.getPositionId());
                ticketExploreConfigVo2 = new TicketExploreConfigVo();
                BeanUtils.copyProperties((Object)ticketExploreConfig, (Object)ticketExploreConfigVo2);
                positonExploreConfigList.add(ticketExploreConfigVo2);
            }
            Map<String, AppEntranceAdRO> adpositionVoMap = this.adPositionService.findByPositionIds(positionIds);
            for (TicketExploreConfigVo ticketExploreConfigVo2 : positonExploreConfigList) {
                AppEntranceAdRO adpositionVo = adpositionVoMap.getOrDefault(ticketExploreConfigVo2.getPositionId(), new AppEntranceAdRO());
                ticketExploreConfigVo2.setPositionName(adpositionVo.getAppEntranceName());
                ticketExploreConfigVo2.setMediaName(adpositionVo.getProviderAlias());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)flowPackageExploreList)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object ticketExploreConfig : flowPackageExploreList) {
                ids.add(ticketExploreConfig.getFlowPackageId());
                ticketExploreConfigVo2 = new TicketExploreConfigVo();
                BeanUtils.copyProperties((Object)ticketExploreConfig, (Object)ticketExploreConfigVo2);
                flowPackageExploreConfigList.add(ticketExploreConfigVo2);
            }
            List flowPackagesList = this.adFlowPackageMapper.findByIds(ids);
            HashMap<Long, AdFlowPackage> flowPackageMap = new HashMap<Long, AdFlowPackage>();
            for (AdFlowPackage adFlowPackage : flowPackagesList) {
                flowPackageMap.put(adFlowPackage.getId(), adFlowPackage);
            }
            for (TicketExploreConfigVo ticketExploreConfigVo3 : flowPackageExploreConfigList) {
                AdFlowPackage adFlowPackage = flowPackageMap.getOrDefault(ticketExploreConfigVo3.getFlowPackageId(), new AdFlowPackage());
                ticketExploreConfigVo3.setFlowPackageName(adFlowPackage.getPackageName());
                ticketExploreConfigVo3.setFlowPackageCount(adFlowPackage.getCount());
            }
        }
        ticketExploreVo.setPositonExploreConfigList(positonExploreConfigList);
        ticketExploreVo.setFlowPackageExploreConfigList(flowPackageExploreConfigList);
        return ticketExploreVo;
    }

    @Override
    public void update(TicketExploreDto ticketExploreDto, String userName) throws Exception {
        TicketExploreConfig ticketExploreConfig;
        TicketExplore ticketExplore = this.ticketExploreMapper.selectByPrimaryKey(ticketExploreDto.getId());
        BeanUtils.copyProperties((Object)ticketExploreDto, (Object)ticketExplore);
        ticketExplore.setModifiedTime(new Date());
        ticketExplore.setModifyUser(userName);
        ticketExplore.setStartDate(LocalDateUtils.coverByString6Date(ticketExploreDto.getStartDate()));
        ticketExplore.setEndDate(LocalDateUtils.coverByString6Date(ticketExploreDto.getEndDate()));
        ticketExplore.setDayStartTime(LocalDateUtils.coverTimeByString6Date(ticketExploreDto.getDayStartTime()));
        ticketExplore.setDayEndTime(LocalDateUtils.coverTimeByString6Date(ticketExploreDto.getDayEndTime()));
        ticketExplore.setStartTime(ticketExploreDto.getDayStartTime());
        ticketExplore.setEndTime(ticketExploreDto.getDayEndTime());
        ArrayList<TicketExploreConfig> addList = new ArrayList<TicketExploreConfig>();
        List positonConfigList = new ArrayList();
        List flowPackageConfigList = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ticketExploreDto.getPositonConfig())) {
            positonConfigList = JSONObject.parseArray((String)ticketExploreDto.getPositonConfig(), TicketExploreConfigDto.class);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ticketExploreDto.getFlowPackageConfig())) {
            flowPackageConfigList = JSONObject.parseArray((String)ticketExploreDto.getFlowPackageConfig(), TicketExploreConfigDto.class);
        }
        if (CollectionUtils.isNotEmpty(positonConfigList)) {
            for (TicketExploreConfigDto ticketExploreConfigDto : positonConfigList) {
                ticketExploreConfig = new TicketExploreConfig();
                BeanUtils.copyProperties((Object)ticketExploreConfigDto, (Object)ticketExploreConfig);
                addList.add(ticketExploreConfig);
            }
        }
        if (CollectionUtils.isNotEmpty(flowPackageConfigList)) {
            for (TicketExploreConfigDto ticketExploreConfigDto : flowPackageConfigList) {
                ticketExploreConfig = new TicketExploreConfig();
                BeanUtils.copyProperties((Object)ticketExploreConfigDto, (Object)ticketExploreConfig);
                addList.add(ticketExploreConfig);
            }
        }
        this.ticketExploreMapper.updateByPrimaryKey(ticketExplore);
        this.ticketExploreConfigMapper.deleteByTicketId(ticketExploreDto.getTicketId());
        if (CollectionUtils.isNotEmpty(addList)) {
            this.ticketExploreConfigMapper.batchInsert(addList);
        }
        this.push(ticketExploreDto.getTicketId());
    }

    @Override
    public String findConsume(Long id, Integer type) throws Exception {
        TicketExplore ticketExplore = this.ticketExploreMapper.selectByPrimaryParams(id);
        if (type == 2) {
            ticketExplore.setEstimateConsume(null);
            this.ticketExploreMapper.updateConsumeById(null, id);
            return null;
        }
        Long ticketId = ticketExplore.getTicketId();
        String value = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), ticketId);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
            String[] positionArray;
            int startIndex = value.indexOf(45);
            String[] strings = new String[]{org.apache.commons.lang3.StringUtils.substring((String)value, (int)0, (int)startIndex), org.apache.commons.lang3.StringUtils.substring((String)value, (int)(startIndex + 1), (int)value.length())};
            String positions = strings[1];
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)strings[0])) {
                throw new Exception("\u9ed1\u540d\u5355\u65e0\u6cd5\u9884\u4f30");
            }
            ArrayList<String> whitePositionIds = new ArrayList<String>();
            for (String s : positionArray = StringUtils.split((String)positions, (char)',')) {
                whitePositionIds.add(s);
            }
            if (CollectionUtils.isEmpty(whitePositionIds)) {
                throw new Exception("\u767d\u540d\u5355\u5e7f\u544a\u4f4d\u4e3a\u7a7a\u65e0\u6cd5\u9884\u4f30");
            }
            TicketExploreConsume ticketExploreConsume = this.ticketExploreMapper.selectSumByParams(whitePositionIds, DateUtils.getPreDate(DateUtil.dateTo8String((Date)new Date())));
            if (Objects.isNull(ticketExploreConsume)) {
                throw new Exception("\u767d\u540d\u5355\u5e7f\u544a\u4f4d\u6628\u65e5\u6d88\u8017\u4e3a\u7a7a\u65e0\u6cd5\u9884\u4f30");
            }
            Double finalValue = ticketExploreConsume.getConsume() / (double)ticketExploreConsume.getClick() * (double)whitePositionIds.size() * (double)ticketExplore.getClickThreshold().intValue() * 1.2;
            String v = DataParkUtils.formatDouble((Double)finalValue);
            this.ticketExploreMapper.updateConsumeById(v, ticketExplore.getId());
            return v;
        }
        throw new Exception("\u901a\u6295\u65e0\u6cd5\u9884\u4f30");
    }

    @Override
    public String push1(Long id) throws Exception {
        this.push(id);
        return null;
    }

    private void push(Long ticketId) throws Exception {
        TicketExplore ticketExplore = this.ticketExploreMapper.selectByPrimaryParams(ticketId);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ticketExplore.getSequence())) {
            List<String> ticketExploresequenceList = Arrays.asList(ticketExplore.getSequence().split(","));
            ticketExplore.setSequenceList(ticketExploresequenceList);
        }
        List positionExploreList = this.ticketExploreConfigMapper.selectByParams(ticketId, 1);
        List flowPackageExploreList = this.ticketExploreConfigMapper.selectByParams(ticketId, 2);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        ArrayList<Long> list = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)flowPackageExploreList)) {
            for (Object ticketExploreConfig : flowPackageExploreList) {
                list.add(ticketExploreConfig.getFlowPackageId());
            }
            List flowPackageList = this.adFlowPackageMapper.findByIds(list);
            for (AdFlowPackage adFlowPackage : flowPackageList) {
                List<String> posL = Arrays.asList(adFlowPackage.getPositionId().split(","));
                map.put(adFlowPackage.getId(), posL);
            }
        }
        ArrayList<TicketExplorePush> pushList = new ArrayList<TicketExplorePush>();
        ArrayList<String> allPosition = new ArrayList<String>();
        ArrayList<String> notPosition = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)positionExploreList)) {
            for (Object ticketExploreConfig : positionExploreList) {
                TicketExplorePush ticketExplorePush = new TicketExplorePush();
                BeanUtils.copyProperties((Object)ticketExplore, (Object)ticketExplorePush);
                ticketExplorePush.setPositionId(ticketExploreConfig.getPositionId());
                ticketExplorePush.setBudgetDaily(ticketExploreConfig.getBudgetDaily());
                ticketExplorePush.setClickThreshold(ticketExploreConfig.getClickThreshold());
                ticketExplorePush.setSequence(ticketExploreConfig.getSequence());
                List<String> sequenceList = Arrays.asList(ticketExploreConfig.getSequence().split(","));
                ticketExplorePush.setSequenceList(sequenceList);
                allPosition.add(ticketExploreConfig.getPositionId());
                pushList.add(ticketExplorePush);
            }
        }
        HashMap<String, TicketExplorePush> ticketExplorePushMap = new HashMap<String, TicketExplorePush>();
        if (CollectionUtils.isNotEmpty((Collection)flowPackageExploreList)) {
            for (TicketExploreConfig ticketExploreConfig : flowPackageExploreList) {
                List positionIdsList = (List)map.get(ticketExploreConfig.getFlowPackageId());
                for (String positionId : positionIdsList) {
                    List<String> sequenceList;
                    if (allPosition.contains(positionId) || notPosition.contains(positionId)) continue;
                    TicketExplorePush old = (TicketExplorePush)ticketExplorePushMap.get(positionId);
                    if (Objects.isNull(old)) {
                        TicketExplorePush ticketExplorePush = new TicketExplorePush();
                        BeanUtils.copyProperties((Object)ticketExplore, (Object)ticketExplorePush);
                        ticketExplorePush.setPositionId(positionId);
                        ticketExplorePush.setBudgetDaily(ticketExploreConfig.getBudgetDaily());
                        ticketExplorePush.setClickThreshold(ticketExploreConfig.getClickThreshold());
                        ticketExplorePush.setSequence(ticketExploreConfig.getSequence());
                        sequenceList = Arrays.asList(ticketExploreConfig.getSequence().split(","));
                        ticketExplorePush.setSequenceList(sequenceList);
                        ticketExplorePushMap.put(positionId, ticketExplorePush);
                        continue;
                    }
                    TicketExplorePush newTicketExplorePush = new TicketExplorePush();
                    BeanUtils.copyProperties((Object)ticketExplore, (Object)newTicketExplorePush);
                    newTicketExplorePush.setPositionId(positionId);
                    newTicketExplorePush.setBudgetDaily(ticketExploreConfig.getBudgetDaily());
                    newTicketExplorePush.setClickThreshold(ticketExploreConfig.getClickThreshold());
                    newTicketExplorePush.setSequence(ticketExploreConfig.getSequence());
                    sequenceList = Arrays.asList(ticketExploreConfig.getSequence().split(","));
                    newTicketExplorePush.setSequenceList(sequenceList);
                    ArrayList<String> list1 = new ArrayList<String>();
                    for (String posi : old.getSequenceList()) {
                        if (!newTicketExplorePush.getSequenceList().contains(posi)) continue;
                        list1.add(posi);
                    }
                    if (CollectionUtils.isEmpty(list1)) {
                        notPosition.add(positionId);
                        continue;
                    }
                    TicketExplorePush finalTicketExplorePush = new TicketExplorePush();
                    BeanUtils.copyProperties((Object)ticketExplore, (Object)finalTicketExplorePush);
                    finalTicketExplorePush.setPositionId(positionId);
                    finalTicketExplorePush.setSequenceList(list1);
                    finalTicketExplorePush.setClickThreshold(old.getClickThreshold() < newTicketExplorePush.getClickThreshold() ? old.getClickThreshold() : newTicketExplorePush.getClickThreshold());
                    finalTicketExplorePush.setBudgetDaily(old.getBudgetDaily() < newTicketExplorePush.getBudgetDaily() ? old.getBudgetDaily() : newTicketExplorePush.getBudgetDaily());
                    ticketExplorePushMap.put(positionId, finalTicketExplorePush);
                }
            }
        }
        if (ticketExplorePushMap != null && ticketExplorePushMap.size() > 0) {
            ticketExplorePushMap.forEach((k, v) -> pushList.add((TicketExplorePush)v));
        }
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("ticketId", ticketId);
        parameters.put("ticketExplore", (Long)ticketExplore);
        this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET_EXPLORE.getServiceName(), parameters, JSONArray.toJSONBytes(pushList, (SerializerFeature[])new SerializerFeature[0]));
    }
}

