/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.media.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaPositionDirectTicketMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.media.AdPositionDirectTicket;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.media.MediaPositionDirectTicketService;
import com.bxm.adsprod.facade.ticket.DirectTicketMaterial;
import com.bxm.adsprod.facade.ticket.PositionDirectTicket;
import com.bxm.util.StringUtil;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaPositionDirectTicketServiceImpl
implements MediaPositionDirectTicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionDirectTicketServiceImpl.class);
    @Autowired
    private MediaPositionDirectTicketMapper mediaPositionDirectTicketMapper;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private AdTicketMapper adTicketMapper;

    @Override
    public void batchSaveorUpdate(String positionIdAndSizes, String ticketIds, String userName) {
        List<String> positionIds = MediaPositionDirectTicketServiceImpl.getList(positionIdAndSizes.split(","), 0);
        List<String> positionSizes = MediaPositionDirectTicketServiceImpl.getList(positionIdAndSizes.split(","), 1);
        this.mediaPositionDirectTicketMapper.deleteByPositionId(positionIds);
        ArrayList<Long> ticketIdList = new ArrayList<Long>();
        if (StringUtil.isNotBlank((CharSequence)ticketIds)) {
            this.mediaPositionDirectTicketMapper.insert(positionIds, ticketIds, userName);
            String[] arrTicketIds = ticketIds.split(",");
            for (int i = 0; i < arrTicketIds.length; ++i) {
                long ticketid = Long.parseLong(arrTicketIds[i]);
                ticketIdList.add(ticketid);
                for (int j = 0; j < positionSizes.size(); ++j) {
                    Long lastDirectTicket = this.adTicketMapper.findLastDirectTicket(Long.valueOf(ticketid), positionSizes.get(j));
                    if (lastDirectTicket != null) continue;
                    this.adTicketMapper.insertDirectTicket(Long.valueOf(ticketid), positionSizes.get(j), Long.valueOf(0L));
                    DirectTicketMaterial directTicketMaterial = new DirectTicketMaterial();
                    directTicketMaterial.setTicketId(ticketid);
                    directTicketMaterial.setSize(positionSizes.get(j));
                    directTicketMaterial.setMaterials(new ArrayList());
                    try {
                        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.DIRECT_TICKET_MATERIAL.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)directTicketMaterial));
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63a8\u9001\u76f4\u6295\u5238\u7d20\u6750\u914d\u7f6e\u51fa\u9519" + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        for (int i = 0; i < positionIds.size(); ++i) {
            PositionDirectTicket positionDirectTicket = new PositionDirectTicket();
            positionDirectTicket.setPositionId(positionIds.get(i));
            positionDirectTicket.setSize(positionSizes.get(i));
            positionDirectTicket.setTicketIds(ticketIdList);
            try {
                String ticketid = this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_DIRECT_TICKET.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)positionDirectTicket));
                continue;
            }
            catch (Exception e) {
                LOGGER.error("\u63a8\u9001\u5e7f\u544a\u4f4d\u76f4\u6295\u5238\u914d\u7f6e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void websitePushPositionSize(String positionSize, String positionId) {
        ArrayList positionIds = Lists.newArrayList();
        positionIds.add(positionId);
        List adPositionDirectTickets = this.mediaPositionDirectTicketMapper.selectTicketIdByList((List)positionIds);
        ArrayList ticketIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)adPositionDirectTickets) && StringUtil.isNotBlank((CharSequence)((AdPositionDirectTicket)adPositionDirectTickets.get(0)).getTicketIds())) {
            String[] split = ((AdPositionDirectTicket)adPositionDirectTickets.get(0)).getTicketIds().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (!StringUtil.isNotBlank((CharSequence)split[i])) continue;
                long ticketId = Long.parseLong(split[i]);
                Long lastDirectTicket = this.adTicketMapper.findLastDirectTicket(Long.valueOf(ticketId), positionSize);
                if (lastDirectTicket == null) {
                    this.adTicketMapper.insertDirectTicket(Long.valueOf(ticketId), positionSize, Long.valueOf(0L));
                    DirectTicketMaterial directTicketMaterial = new DirectTicketMaterial();
                    directTicketMaterial.setTicketId(ticketId);
                    directTicketMaterial.setSize(positionSize);
                    directTicketMaterial.setMaterials(new ArrayList());
                    try {
                        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.DIRECT_TICKET_MATERIAL.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)directTicketMaterial));
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63a8\u9001\u76f4\u6295\u5238\u7d20\u6750\u914d\u7f6e\u51fa\u9519" + e.getMessage(), (Throwable)e);
                    }
                }
                ticketIds.add(ticketId);
            }
        }
        PositionDirectTicket positionDirectTicket = new PositionDirectTicket();
        positionDirectTicket.setPositionId(positionId);
        positionDirectTicket.setSize(positionSize);
        positionDirectTicket.setTicketIds((List)ticketIds);
        try {
            String i = this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_DIRECT_TICKET.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)positionDirectTicket));
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001\u5e7f\u544a\u4f4d\u76f4\u6295\u5238\u914d\u7f6e\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getList(String[] str, int num) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < str.length; ++i) {
            if (!StringUtil.isNotBlank((CharSequence)str[i])) continue;
            String[] split = str[i].split("\\+");
            list.add(split[num]);
        }
        return list;
    }
}

