/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.media.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.dal.mapper.media.MediaPositionWhiteTicketMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.media.AdPositionWhiteTicket;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionWhiteTicketDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.media.MediaPositionWhiteTicketService;
import com.bxm.util.StringUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaPositionWhiteTicketServiceImpl
implements MediaPositionWhiteTicketService {
    @Autowired
    private MediaPositionWhiteTicketMapper mediaPositionWhiteTicketMapper;
    @Autowired
    private AdTicketMapperExt adTicketMapperExt;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void batchSaveorUpdate(MediaPositionWhiteTicketDto mediaPositionWhiteTicketDto, String userName) throws Exception {
        List<String> positionIds = MediaPositionWhiteTicketServiceImpl.getTicketIdList(mediaPositionWhiteTicketDto.getPositionId().split(","));
        ArrayList<AdPositionWhiteTicket> list = new ArrayList<AdPositionWhiteTicket>();
        this.mediaPositionWhiteTicketMapper.deleteByPositionId(positionIds);
        for (String position : positionIds) {
            AdPositionWhiteTicket apwt = new AdPositionWhiteTicket();
            apwt.setCreateTime(new Date());
            apwt.setCreateUser(userName);
            apwt.setPositionId(position);
            if (!StringUtil.isNotBlank((CharSequence)mediaPositionWhiteTicketDto.getTicketId())) continue;
            ArrayList<Long> ticketIdList = new ArrayList<Long>(new LinkedHashSet<Long>(MediaPositionWhiteTicketServiceImpl.getTicketIdNewList(mediaPositionWhiteTicketDto.getTicketId().split(","))));
            List existTicketIdList = this.adTicketMapperExt.findExistTicketId(ticketIdList);
            if (CollectionUtils.isEmpty((Collection)existTicketIdList)) {
                throw new Exception("\u4e0d\u5b58\u5728\u767d\u540d\u5355\u5238");
            }
            if (CollectionUtils.isNotEmpty((Collection)existTicketIdList) && ticketIdList.size() != existTicketIdList.size()) {
                ticketIdList.removeAll(existTicketIdList);
                throw new Exception("\u4e0d\u5b58\u5728\u767d\u540d\u5355\u5238\u5982\uff1a" + JSON.toJSONString(ticketIdList));
            }
            apwt.setTicketId(StringUtils.join(ticketIdList, (String)","));
            list.add(apwt);
        }
        if (CollectionUtils.isNotEmpty(list) && StringUtil.isNotBlank((CharSequence)mediaPositionWhiteTicketDto.getTicketId())) {
            this.mediaPositionWhiteTicketMapper.insert(list);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("positionid", JSONArray.toJSONString(positionIds));
        this.prodPusher.pushToProd(ProdServiceNameEnum.MEDIA_WHITE_TICKET.getServiceName(), map, JSONArray.toJSONBytes((Object)mediaPositionWhiteTicketDto.getTicketId(), (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    public List<Long> savePositionWhiteTicket(MediaPositionWhiteTicketDto mediaPositionWhiteTicketDto, String userName) throws Exception {
        ArrayList<Long> ticketIdList = new ArrayList<Long>(new LinkedHashSet<Long>(MediaPositionWhiteTicketServiceImpl.getTicketIdNewList(mediaPositionWhiteTicketDto.getTicketId().split(","))));
        List existTicketIdList = this.adTicketMapperExt.findExistTicketId(ticketIdList);
        if (CollectionUtils.isEmpty((Collection)existTicketIdList)) {
            return ticketIdList;
        }
        if (CollectionUtils.isNotEmpty((Collection)existTicketIdList) && ticketIdList.size() != existTicketIdList.size()) {
            ticketIdList.removeAll(existTicketIdList);
            return ticketIdList;
        }
        return null;
    }

    public static List<String> getTicketIdList(String[] str) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < str.length; ++i) {
            if (!StringUtil.isNotBlank((CharSequence)str[i])) continue;
            list.add(str[i]);
        }
        return list;
    }

    public static List<Long> getTicketIdNewList(String[] str) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            for (int i = 0; i < str.length; ++i) {
                if (!StringUtil.isNotBlank((CharSequence)str[i])) continue;
                list.add(Long.valueOf(str[i]));
            }
        }
        catch (Exception e) {
            throw new Exception("\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return list;
    }

    public static String getTicketIds(String[] oldTickets, String[] newTickets) {
        List<String> oldTicket = MediaPositionWhiteTicketServiceImpl.getTicketIdList(oldTickets);
        List<String> newAddTicket = MediaPositionWhiteTicketServiceImpl.getTicketIdList(newTickets);
        HashSet<String> set = new HashSet<String>();
        set.addAll(oldTicket);
        set.addAll(newAddTicket);
        ArrayList c = new ArrayList(set);
        return Joiner.on((String)",").join(c);
    }
}

