/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.mediamanager.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketOcpcMapper;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.dal.mapper.mediamanager.AdTicketPositionWeightNewMapper;
import com.bxm.adsmanager.dal.mapper.mediamanager.ext.AdTicketPositionWeightMapperExt;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdTicketSimulationIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdWeightTicketIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeight;
import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeightNew;
import com.bxm.adsmanager.model.dto.AdTicketPositionWeightNewDTO;
import com.bxm.adsmanager.model.dto.AvilableTicketSearchDto;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.dto.mediamanager.PositionWeightDto;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.AdTicketPositionWeightVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.adkeeper.AdTicketTagConfService;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.warcar.cache.Updater;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionTicketWeightImpl
implements PositionTicketWeightService {
    private static final Logger log = LoggerFactory.getLogger(PositionTicketWeightImpl.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketPositionWeightMapperExt adTicketPostitionWeightExt;
    @Autowired
    private ProdWeightTicketIntegration ProdWeightTicketIntegration;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private RedisNewClient redisNewClient;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private Mapper mapper;
    @Autowired
    private AdTicketPositionWeightNewMapper adTicketPositionWeightNewMapper;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private ProdTicketSimulationIntegration prodTicketSimulationIntegration;
    @Autowired
    private ProdPullerIntegration prodPuller;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Autowired
    private AdTicketOcpcMapper adTicketOcpcMapper;
    @Autowired
    private AdTicketTagConfService adTicketTagConfService;
    public static final String POSTIONWEIGHTKEY = "AD:WEIGHT:POSITION_TICKET:";
    public static final String TICKETARPUKEY = "AD:ARPU:TICKET:";
    public static final int POSTIONARPUDB = 0;
    public static final String ADTICKETALL = "AD:TICKET:ALL";
    private static final int POSITIONBLACK = 0;
    private static final String POSITIONBLACKKEY = "AD:FILTER:POSITION:DEFINED:BLACKLIST2";
    private static final String POSITIONWHITEKEY = "AD:FILTER:POSITION:DEFINED:WHITELIST2";
    private static final String WHITEKEY = "AD:FILTER:POSITION:DEFINED:WHITECONF2";
    public static final String CERTIFICATEREALKEY = "certificate:real:key";
    public static final int LABELDB = 6;
    public static final String LABELBLACKKEY = "app:black";
    private static final String SPILT_CHAR = ",";
    private static final String STR_TWO = "2-";

    @Override
    public Pagination findAll(CommonSearchDto search) {
        String field = search.getPositionId();
        Set<String> positionBlackIds = this.getPositionBlackIds(field);
        search.setTicketIds(positionBlackIds);
        List<AdTicketPositionWeightVo> lists = this.adTicketPostitionWeightExt.findAll(search);
        int total = lists.size();
        for (AdTicketPositionWeightVo vo : lists) {
            String ticketId = vo.getTicketId().toString();
            vo.setArpu(this.ProdWeightTicketIntegration.getTicketArpu(new BigInteger(ticketId), field));
            String weight = StringUtils.defaultString((String)this.redisNewClient.hGet(TicketKeyGenerator.Weight.getWeight((String)field).generateKey(), ticketId, 0), (String)"0");
            vo.setWeight(new BigDecimal(weight));
            vo.setInterventionFactor(this.getWeightRedis(field, vo.getTicketId()));
            vo.setPositionId(field);
        }
        ListOrderUtils.sortList(lists, "weight", "DESC");
        lists = ListUtil.getTotalPage(lists, lists.size(), search.getPageNum(), search.getPageSize());
        Pagination results = new Pagination(search.getPageNum().intValue(), search.getPageSize().intValue(), total, lists);
        return results;
    }

    @Override
    public PageInfo findAllNew(AdTicketPositionWeightNewDTO search) {
        PageHelper.startPage((int)search.getPageNum(), (int)search.getPageSize());
        List lists = this.adTicketPositionWeightNewMapper.findAll(search);
        return new PageInfo(lists);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=10)
    public void updateOrInsert(AdTicketPositionWeightNew model) throws Exception {
        String list = model.getList();
        if (model.getId() != null) {
            model.setCreateUser(null);
            AdTicketPositionWeightNew adTicketPositionWeightNew = this.adTicketPositionWeightNewMapper.selectByPrimaryKey(model.getId());
            if (adTicketPositionWeightNew == null) {
                throw new NullPointerException("\u8be5Id\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            }
            model.setUpdateTime(new Date());
            this.adTicketPositionWeightNewMapper.updateByPrimaryKeySelective(model);
            model.setTicketId(adTicketPositionWeightNew.getTicketId());
            this.updateRedisCache(model);
        } else if (StringUtils.isNotBlank((CharSequence)list)) {
            List ticketDTOS = JSONObject.parseArray((String)list, AdTicketPositionWeightNew.TicketDTO.class);
            for (AdTicketPositionWeightNew.TicketDTO ad : ticketDTOS) {
                AdTicketPositionWeightNew adTicketPositionWeightNew = new AdTicketPositionWeightNew();
                BeanUtils.copyProperties((Object)model, (Object)adTicketPositionWeightNew);
                adTicketPositionWeightNew.setTicketId(ad.getTicketId());
                adTicketPositionWeightNew.setTicketName(ad.getTicketName());
                if (this.exist(adTicketPositionWeightNew)) {
                    throw new Exception("\u5e7f\u544a\u4f4d:" + adTicketPositionWeightNew.getPositionCode() + ",\u5e7f\u544a\u5238:" + adTicketPositionWeightNew.getTicketId() + "\u5bf9\u5e94\u7684\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
                }
                model.setCreateTime(new Date());
                model.setUpdateTime(new Date());
                this.adTicketPositionWeightNewMapper.insertSelective(adTicketPositionWeightNew);
                this.updateRedisCache(adTicketPositionWeightNew);
            }
        }
    }

    private boolean exist(AdTicketPositionWeightNew adTicketPositionWeightNew) {
        AdTicketPositionWeightNewDTO dto = new AdTicketPositionWeightNewDTO();
        dto.setPositionCode(adTicketPositionWeightNew.getPositionCode());
        dto.setTicketId(adTicketPositionWeightNew.getTicketId());
        List all = this.adTicketPositionWeightNewMapper.findAll(dto);
        return CollectionUtils.isNotEmpty((Collection)all);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=10)
    public void delete(AdTicketPositionWeightNew model) {
        AdTicketPositionWeightNew adTicketPositionWeightNew = this.adTicketPositionWeightNewMapper.selectByPrimaryKey(model.getId());
        if (adTicketPositionWeightNew == null) {
            throw new NullPointerException("\u8be5Id\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        model.setStatus(Integer.valueOf(-1));
        model.setUpdateTime(new Date());
        this.adTicketPositionWeightNewMapper.updateByPrimaryKeySelective(model);
        this.removeRedisCache(adTicketPositionWeightNew);
    }

    private void removeRedisCache(AdTicketPositionWeightNew model) {
        this.updater.hremove(TicketKeyGenerator.positionTicketWeightNew((String)model.getPositionId()), new String[]{model.getTicketId().toString()});
    }

    private void updateRedisCache(AdTicketPositionWeightNew model) {
        String value = model.getWeight().divide(new BigDecimal("100"), 4, 4).toString();
        this.updater.hupdate(TicketKeyGenerator.positionTicketWeightNew((String)model.getPositionId()), model.getTicketId().toString(), (Object)value);
    }

    private Set<String> getPositionBlackIds(String positionId) {
        HashSet sets = Sets.newHashSet();
        sets.addAll(this.adTicketMapper.findPositionBlackIds(positionId));
        return sets;
    }

    @Override
    public void updatePositionWeight(PositionWeightDto record) {
        Double factor = record.getInterventionFactor();
        String positionId = record.getPositionId();
        List<String> ticketRequest = PositionTicketWeightImpl.getTicketIdList(record.getTicketIdChar());
        List ticketIds = this.adTicketPostitionWeightExt.getTicketIdsByPosition(positionId);
        for (String ticketId : ticketRequest) {
            Long ticket = NumberUtils.toLong((String)ticketId);
            AdTicketPositionWeight result = new AdTicketPositionWeight(positionId, ticket, factor);
            result.setWeight(record.getWeight());
            if (CollectionUtils.isNotEmpty((Collection)ticketIds) && ticketIds.contains(ticket)) {
                this.adTicketPostitionWeightExt.updateByRecord(result);
            } else {
                this.adTicketPostitionWeightExt.insertSelective(result);
            }
            this.updateWeightRedis(positionId, ticketId, factor.toString());
        }
    }

    @Override
    public void updateWeightRedis(String positionId, String ticketId, String factor) {
        Double value = NumberUtils.toDouble((String)factor, (double)100.0) / 100.0;
        this.redisNewClient.hset(POSTIONWEIGHTKEY + positionId, ticketId, value.toString(), 0, null);
    }

    @Override
    public int findAvalibaleTicketCount(String positionId) {
        return this.adTicketMapper.findAvalibaleTicketCount(positionId);
    }

    private List<Long> getLongIds(Set<String> positionBlackIds) {
        ArrayList<Long> blackIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(positionBlackIds)) {
            for (String id : positionBlackIds) {
                blackIds.add(Long.valueOf(id));
            }
        }
        return blackIds;
    }

    @Override
    @Deprecated
    public Pagination findAvalibaleTicketList(CommonSearchDto dto) throws Exception {
        Pagination pagination = new Pagination();
        int totalCount = this.adTicketMapper.findAvalibaleTicketCount(dto.getPositionId());
        pagination.setTotalCount(totalCount);
        List avalibaleTicketList = this.adTicketMapper.findAvalibaleTicketList(dto);
        ArrayList<AdTicketVo> returnList = new ArrayList<AdTicketVo>();
        if (CollectionUtils.isNotEmpty((Collection)avalibaleTicketList)) {
            StringBuilder idsSb = new StringBuilder();
            for (AdTicket ticket : avalibaleTicketList) {
                AdTicketVo vo = new AdTicketVo();
                this.mapper.map((Object)ticket, (Object)vo);
                if (ticket.getPrice() != null) {
                    vo.setPrice(Double.valueOf((double)ticket.getPrice().intValue() / 1000.0));
                } else {
                    vo.setPrice(Double.valueOf(0.0));
                }
                if (idsSb.length() == 0) {
                    idsSb.append(vo.getAdvertiser());
                } else {
                    idsSb.append(SPILT_CHAR + vo.getAdvertiser());
                }
                returnList.add(vo);
            }
            List list = this.adShopIntegration.findAdShopMsgs(idsSb.toString());
            HashMap mapAdvertiser = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.stream().forEach(advertiserDto -> mapAdvertiser.put(advertiserDto.getId(), advertiserDto.getCompany()));
                for (AdTicketVo vo : returnList) {
                    vo.setAdvertiserName((String)mapAdvertiser.get(vo.getAdvertiser().intValue()));
                }
            }
        }
        pagination.setList(returnList);
        return pagination;
    }

    @Override
    public PageInfo<AdTicketAllVo> getAvailableTicket(AvilableTicketSearchDto dto) throws Exception {
        String code;
        List availableTicketId = this.prodTicketSimulationIntegration.simulate(dto.getPositionId());
        if (CollectionUtils.isEmpty((Collection)availableTicketId)) {
            availableTicketId.add("-1");
        }
        dto.setTicketIdList(availableTicketId);
        List ticketIdListConvert = dto.getTicketIdList().stream().map(t -> Long.valueOf(t)).collect(Collectors.toList());
        List ocpcConfList = this.adTicketOcpcMapper.selectByTicketIdList(ticketIdListConvert);
        HashMap<String, String> mapAdTicketOcpcConf = new HashMap<String, String>();
        for (AdTicketOcpcConf adTicketOcpcConf : ocpcConfList) {
            mapAdTicketOcpcConf.put(adTicketOcpcConf.getTicketId() + "", adTicketOcpcConf.getIsSupportOcpc() + "");
        }
        List<AdvertiserDto> advertiserList = this.getAdvertiserList(dto);
        Map<Integer, String> advertiserNameMap = Collections.EMPTY_MAP;
        Map<Integer, String> advertiserSaleMap = Collections.EMPTY_MAP;
        List<Integer> advertiserIds = new ArrayList<Integer>(20);
        if (CollectionUtils.isNotEmpty(advertiserList)) {
            advertiserNameMap = advertiserList.stream().collect(Collectors.toMap(AdvertiserDto::getId, a -> a.getCompany() == null ? "" : a.getCompany()));
            advertiserSaleMap = advertiserList.stream().collect(Collectors.toMap(AdvertiserDto::getId, a -> a.getSale() == null ? "" : a.getSale()));
            advertiserIds = advertiserList.stream().map(a -> a.getId()).collect(Collectors.toList());
        }
        boolean queryAdvertiserFlag = false;
        if (StringUtils.isNotBlank((CharSequence)dto.getAdvertiseIdOrName()) || StringUtils.isNotBlank((CharSequence)dto.getAe()) || StringUtils.isNotBlank((CharSequence)dto.getSale())) {
            queryAdvertiserFlag = true;
        }
        if (queryAdvertiserFlag) {
            advertiserIds.add(-1);
            dto.setAdvertiserIdList(advertiserIds);
        }
        if (StringUtil.isNotBlank((CharSequence)(code = dto.getStatusCode()))) {
            if (code.contains(STR_TWO)) {
                dto.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                dto.setStatus(Short.valueOf(code));
            }
        }
        this.dealSearchdto(dto);
        Page page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List availableTicketList = this.adTicketMapper.getAvailableTicket(dto);
        Map<String, String> dictionariesMap = this.getDictionaries("adstatus");
        ArrayList pageTicketIds = Lists.newArrayList();
        for (AdTicketAllVo vo : availableTicketList) {
            if (1 == vo.getSettleType() || 4 == vo.getSettleType() || 5 == vo.getSettleType()) {
                vo.setBudgetDaily(Double.valueOf(vo.getBudgetDaily() / 1000.0));
            } else {
                vo.setBudgetDaily(vo.getBudgetDaily());
            }
            Long todayConsume = this.getTodayConsume(vo.getId());
            vo.setAdvertiserName(advertiserNameMap.get(vo.getAdvertiser().intValue()));
            vo.setConsume(Double.valueOf(1 == vo.getSettleType() || 4 == vo.getSettleType() || 5 == vo.getSettleType() ? NumberUtils.toDouble((String)String.valueOf(todayConsume)) / 1000.0 : 0.0));
            vo.setSale(advertiserSaleMap.get(vo.getAdvertiser().intValue()));
            if (vo.getStatus() == 2 && vo.getPauseReason() != null) {
                vo.setPauseReason(dictionariesMap.get(STR_TWO + vo.getPauseReason()));
            } else {
                vo.setPauseReason(dictionariesMap.get(vo.getStatus() + ""));
            }
            vo.setIsSupportOcpc(Integer.valueOf(StringUtil.isBlank((CharSequence)((CharSequence)mapAdTicketOcpcConf.get(vo.getId() + ""))) ? 0 : Integer.parseInt((String)mapAdTicketOcpcConf.get(vo.getId() + ""))));
            pageTicketIds.add(vo.getId());
        }
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(pageTicketIds);
        for (AdTicketAllVo adTicketAllVo : availableTicketList) {
            adTicketAllVo.setTagName(tagNameMap.get(adTicketAllVo.getId()));
        }
        return page.toPageInfo();
    }

    private Double getWeightRedis(String positionId, Long ticketId) {
        String result = this.redisNewClient.hGet(POSTIONWEIGHTKEY + positionId, ticketId.toString(), 0);
        return NumberUtils.toDouble((String)result, (double)1.0) * 100.0;
    }

    private static List<String> getTicketIdList(String ticketStr) {
        if (StringUtils.isBlank((CharSequence)ticketStr)) {
            return Lists.newArrayList();
        }
        return Arrays.asList(StringUtils.split((String)ticketStr, (String)SPILT_CHAR));
    }

    public Long getTodayConsume(Long ticketId) {
        Long consume = this.prodPuller.fetchBudgetOfDailyCount(ticketId.toString(), DateUtil.dateTo8String1((Date)new Date()));
        return consume == null ? 0L : consume;
    }

    private void dealSearchdto(AvilableTicketSearchDto condition) {
        List finalTickets;
        List<Long> tagCodeTicketIds;
        List tagCodeTicketIdsConvert;
        if (condition.getSettleType() == null && condition.getOcpcTicket() == null && condition.getTagCode() == null) {
            return;
        }
        List<Long> allOcpcTicket = this.adTicketOcpcService.findAllOcpcTicket();
        List allOcpcTicketConvert = allOcpcTicket.stream().map(a -> a.toString()).collect(Collectors.toList());
        if (null != condition.getOcpcTicket() && condition.getOcpcTicket().booleanValue()) {
            if (CollectionUtils.isEmpty(allOcpcTicket)) {
                allOcpcTicket.add(-1L);
            }
            if (CollectionUtils.isEmpty((Collection)condition.getTicketIdList())) {
                condition.setTicketIdList(allOcpcTicketConvert);
            } else if (CollectionUtils.isNotEmpty(allOcpcTicketConvert)) {
                List ticketIds = condition.getTicketIdList();
                ticketIds.retainAll(allOcpcTicketConvert);
                condition.setTicketIdList(ticketIds);
            }
        }
        if (null != condition.getSettleType() && condition.getSettleType().equals((short)1)) {
            condition.setExcludeTicketIdList(allOcpcTicketConvert);
        }
        if (null != condition.getTagCode() && CollectionUtils.isNotEmpty(tagCodeTicketIdsConvert = (tagCodeTicketIds = this.adTicketTagConfService.findTicketIds(condition.getTagCode())).stream().map(t -> t.toString()).collect(Collectors.toList()))) {
            List list = condition.getTicketIdList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.retainAll(tagCodeTicketIdsConvert);
            }
            condition.setTicketIdList(list);
        }
        if (CollectionUtils.isEmpty((Collection)(finalTickets = condition.getTicketIdList()))) {
            finalTickets.add("-1");
            condition.setTicketIdList(finalTickets);
        }
    }

    public Map<String, String> getDictionaries(String typegroupid) {
        List list = this.dictionariesMapper.findAll(typegroupid);
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Dictionaries dictionaries : list) {
            map.put(dictionaries.getTypecode(), dictionaries.getTypename());
        }
        return map;
    }

    private List<AdvertiserDto> getAdvertiserList(AvilableTicketSearchDto dto) throws Exception {
        AdvertiserDto search = new AdvertiserDto();
        String advertiseIdOrName = dto.getAdvertiseIdOrName();
        if (StringUtils.isNotBlank((CharSequence)dto.getAdvertiseIdOrName())) {
            if (StringUtils.isNumeric((CharSequence)advertiseIdOrName)) {
                search.setId(Integer.valueOf(advertiseIdOrName));
            } else {
                search.setCompany(advertiseIdOrName);
            }
        }
        search.setSale(dto.getSale());
        search.setAe(dto.getAe());
        return this.adShopIntegration.getAdShopList(search);
    }
}

