/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.monitor.impl;

import com.bxm.adsmanager.dal.mapper.monitor.PositionWarnConfigMapper;
import com.bxm.adsmanager.dal.mapper.monitor.TicketWarnConfigMapper;
import com.bxm.adsmanager.dal.mapper.monitor.WarnConfigMapper;
import com.bxm.adsmanager.model.dao.monitor.WarnConfig;
import com.bxm.adsmanager.model.dto.monitor.WarnConfigDto;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.service.monitor.WarnConfigService;
import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WarnConfigServiceImpl
implements WarnConfigService {
    @Autowired
    private WarnConfigMapper warnConfigMapper;
    @Autowired
    private TicketWarnConfigMapper ticketWarnConfigMapper;
    @Autowired
    private PositionWarnConfigMapper positionWarnConfigMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addWarnConfig(WarnConfigDto warnConfigDto) throws Exception {
        WarnConfig record = new WarnConfig();
        BeanUtils.copyProperties((Object)warnConfigDto, (Object)record);
        if (StringUtils.isNotBlank((String)warnConfigDto.getSaveFlag()) && warnConfigDto.getSaveFlag().equalsIgnoreCase(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey())) {
            record.setPropKey(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
            record.setPropValue(warnConfigDto.getValue());
            record.setPropDesc(this.analysisData("\u5e7f\u544a\u4f4d\u53d1\u5238\u91cf>={0},\u5907\u7528\u5238\u53d1\u5238\u5360\u6bd4>={1}%,<={2}%", warnConfigDto.getValue()));
            this.warnConfigMapper.insertSelective(record);
            if (!CollectionUtils.isEmpty((Collection)warnConfigDto.getDataConfigList())) {
                this.positionWarnConfigMapper.insertBatch(warnConfigDto.getDataConfigList(), WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
            }
        }
        if (StringUtils.isNotBlank((String)warnConfigDto.getSaveFlag()) && warnConfigDto.getSaveFlag().equalsIgnoreCase(WarnConfigEnum.TICKET_URL.getConfigKey())) {
            record.setPropKey(WarnConfigEnum.TICKET_URL.getConfigKey());
            record.setPropValue(warnConfigDto.getValue());
            record.setPropDesc(this.analysisData("\u5e7f\u544a\u70b9\u51fb\u91cf>={0},\u843d\u5730\u9875\u5230\u8fbe\u7387>={1}%,<={2}%", warnConfigDto.getValue()));
            this.warnConfigMapper.insertSelective(record);
            if (!CollectionUtils.isEmpty((Collection)warnConfigDto.getDataConfigList())) {
                this.ticketWarnConfigMapper.insertBatch(warnConfigDto.getDataConfigList(), WarnConfigEnum.TICKET_URL.getConfigKey());
            }
        }
    }

    private String analysisData(String template, String param) {
        String[] param1 = param.split(",");
        String[] param2 = null;
        if (StringUtils.isNotBlank((String)param1[1])) {
            param2 = param1[1].split("-");
        }
        String desc = MessageFormat.format(template, param1[0], param2[0], param2[1]);
        return desc;
    }

    @Override
    public WarnConfig selectByConfigKey(String configKey) throws Exception {
        return this.warnConfigMapper.selectByConfigKey(configKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateByConfigKey(WarnConfigDto warnConfigDto) throws Exception {
        WarnConfig record = new WarnConfig();
        BeanUtils.copyProperties((Object)warnConfigDto, (Object)record);
        int result = 0;
        if (StringUtils.isNotBlank((String)warnConfigDto.getSaveFlag()) && warnConfigDto.getSaveFlag().equalsIgnoreCase(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey())) {
            record.setPropKey(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
            record.setPropValue(warnConfigDto.getValue());
            record.setPropDesc(this.analysisData("\u5e7f\u544a\u4f4d\u53d1\u5238\u91cf>={0},\u5907\u7528\u5238\u53d1\u5238\u5360\u6bd4>={1}%,<={2}%", warnConfigDto.getValue()));
            result = this.warnConfigMapper.updateByConfigKey(record);
            this.positionWarnConfigMapper.deleteAll(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
            if (!CollectionUtils.isEmpty((Collection)warnConfigDto.getDataConfigList())) {
                this.positionWarnConfigMapper.insertBatch(warnConfigDto.getDataConfigList(), WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
            }
        }
        if (StringUtils.isNotBlank((String)warnConfigDto.getSaveFlag()) && warnConfigDto.getSaveFlag().equalsIgnoreCase(WarnConfigEnum.TICKET_URL.getConfigKey())) {
            record.setPropKey(WarnConfigEnum.TICKET_URL.getConfigKey());
            record.setPropValue(warnConfigDto.getValue());
            record.setPropDesc(this.analysisData("\u5e7f\u544a\u70b9\u51fb\u91cf>={0},\u843d\u5730\u9875\u5230\u8fbe\u7387>={1}%,<={2}%", warnConfigDto.getValue()));
            result = this.warnConfigMapper.updateByConfigKey(record);
            this.ticketWarnConfigMapper.deleteAll(WarnConfigEnum.TICKET_URL.getConfigKey());
            if (!CollectionUtils.isEmpty((Collection)warnConfigDto.getDataConfigList())) {
                this.ticketWarnConfigMapper.insertBatch(warnConfigDto.getDataConfigList(), WarnConfigEnum.TICKET_URL.getConfigKey());
            }
        }
        return result;
    }
}

