/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.position.impl;

import com.bxm.adsmanager.dal.mapper.position.PositionQualityFactorMapper;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.dao.position.PositionQualityFactor;
import com.bxm.adsmanager.model.dto.position.PositionQualityFactorDto;
import com.bxm.adsmanager.service.position.PositionQualityFactorService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionQualityFactorServiceImpl
implements PositionQualityFactorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionQualityFactorServiceImpl.class);
    @Autowired
    private PositionQualityFactorMapper positionQualityFactorMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPositionQualityFactorBatch(List<PositionQualityFactor> list) throws Exception {
        this.positionQualityFactorMapper.deleteByParam(DateUtil.dateTo8String((Date)com.bxm.util.DateUtil.increaseDate((Date)new Date(), (int)-1)));
        this.positionQualityFactorMapper.insertBatch(list);
    }

    @Override
    public List<PositionQualityFactor> getPositionQualityFactorList(PositionQualityFactorDto record) throws Exception {
        return this.positionQualityFactorMapper.selectList(record);
    }

    @Override
    public long getPositionQualityFactorCountByImportTime(PositionQualityFactorDto record) throws Exception {
        return this.positionQualityFactorMapper.selectCountByImportTime(record);
    }

    @Override
    public Map<String, String> queryPositionQualityFactorMap(PositionQualityFactorDto record) {
        if (record == null) {
            record = new PositionQualityFactorDto();
        }
        if (StringUtils.isBlank((CharSequence)record.getImportTime())) {
            record.setImportTime(DateUtil.dateTo8String3((Date)new Date()));
        }
        List result = null;
        HashMap<String, String> factorMap = new HashMap<String, String>();
        try {
            long tableCount = this.positionQualityFactorMapper.selectAllCount(record);
            if (tableCount > 0L) {
                long preCount = 0L;
                long cycles = 0L;
                String preImportTime = null;
                String importTime = null;
                do {
                    preCount = this.positionQualityFactorMapper.selectCountByImportTime(record);
                    importTime = record.getImportTime();
                    preImportTime = DateUtil.dateTo8String3((Date)DateUtil.increaseDate((Date)DateUtil.convertStr2Date((String)importTime), (int)-1));
                    record.setImportTime(preImportTime);
                } while (preCount <= 0L && ++cycles <= 30L);
                record.setImportTime(importTime);
                result = this.positionQualityFactorMapper.selectList(record);
                if (!CollectionUtils.isEmpty((Collection)result)) {
                    result.forEach(positionQualityFactor -> factorMap.put(positionQualityFactor.getPositionId(), positionQualityFactor.getFactor()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u5185\u5e7f\u544a\u4f4d\u8d28\u91cf\u56e0\u5b50\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return factorMap;
    }
}

