/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.precharge.impl;

import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitPositionMapperExt;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeDeveloperRelationMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewConfigMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewRecordMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dao.precharge.PrechargeDeveloperRelation;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewConfig;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewRecord;
import com.bxm.adsmanager.model.vo.PrechargePositionConsumeVo;
import com.bxm.adsmanager.model.vo.PrechargeRecordVo;
import com.bxm.adsmanager.service.precharge.PrechargeDetailService;
import com.bxm.adsmanager.service.precharge.PrechargeService;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.adsmanager.utils.MoneyUtils;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrechargeNewDetailServiceImpl
implements PrechargeDetailService {
    private static final Logger log = LoggerFactory.getLogger(PrechargeNewDetailServiceImpl.class);
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private PrechargeDeveloperRelationMapper prechargeDeveloperRelationMapper;
    @Autowired
    private AdProfitPositionMapperExt adProfitPositionMapper;
    @Autowired
    private PrechargeNewRecordMapper prechargeNewRecordMapper;
    @Autowired
    private PrechargeNewConfigMapper prechargeNewConfigMapper;
    @Autowired
    private PrechargeService prechargeService;

    @Override
    public PageInfo<PrechargePositionConsumeVo> listConsumeDetail(Integer pageNum, Integer pageSize, String startTime, String endTime, Long accountId, String position) {
        List<AdProfitPosition> adProfitPositions = this.getAdProfitPositionList(accountId, startTime, endTime, position);
        if (CollectionUtils.isEmpty(adProfitPositions)) {
            return FacadePageInfoUtil.noneDataPage();
        }
        List<PrechargePositionConsumeVo> positionRecords = this.buildConsumeVo(adProfitPositions);
        return FacadePageInfoUtil.getPageInfo((int)pageNum, (int)pageSize, positionRecords);
    }

    @Override
    public PageInfo<PrechargeRecordVo> listRechargeDetail(Integer pageNum, Integer pageSize, String startTime, String endTime, Long accountId) {
        List<AdProfitPosition> adProfitPositions = this.getAdProfitPositionList(accountId, startTime, endTime, null);
        List<PrechargeRecordVo> prechargeRecordVos = this.buildPrechargeRecordVo(adProfitPositions, accountId, startTime, endTime);
        BigDecimal rechargeAmount = new BigDecimal(0);
        BigDecimal consumeAmount = new BigDecimal(0);
        BigDecimal correctAmount = new BigDecimal(0);
        for (PrechargeRecordVo prechargeRecordVo : prechargeRecordVos) {
            rechargeAmount = rechargeAmount.add(prechargeRecordVo.getRechargeAmount());
            consumeAmount = consumeAmount.add(prechargeRecordVo.getConsumeAmount());
            correctAmount = correctAmount.add(prechargeRecordVo.getCorrectAmount());
        }
        PrechargeRecordVo first = new PrechargeRecordVo();
        first.setRechargeAmount(rechargeAmount);
        first.setConsumeAmount(consumeAmount);
        first.setCorrectAmount(correctAmount);
        prechargeRecordVos.add(0, first);
        return FacadePageInfoUtil.getPageInfo((int)pageNum, (int)pageSize, prechargeRecordVos);
    }

    String dealPositionCode(Long code) {
        if (null != code) {
            return StringUtils.leftPad((String)code.toString(), (int)6, (String)"0");
        }
        return "";
    }

    private List<AdProfitPosition> getAdProfitPositionList(Long accountId, String startTime, String endTime, String position) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("accountId", accountId);
        List prechargeDeveloperRelations = this.prechargeDeveloperRelationMapper.selectByParams(map);
        if (CollectionUtils.isEmpty((Collection)prechargeDeveloperRelations)) {
            return Collections.EMPTY_LIST;
        }
        List appKeys = prechargeDeveloperRelations.stream().map(p -> p.getProviderAppKey()).collect(Collectors.toList());
        List<AdProfitPosition> adProfitPositions = this.adProfitPositionMapper.getListByParams(appKeys, startTime, endTime, position);
        if (CollectionUtils.isEmpty((Collection)adProfitPositions)) {
            return Collections.EMPTY_LIST;
        }
        adProfitPositions = adProfitPositions.stream().filter(p -> {
            for (PrechargeDeveloperRelation developerRelation : prechargeDeveloperRelations) {
                boolean notInDateRange = p.getAppId().equals(developerRelation.getProviderAppKey()) && developerRelation.containDate(p.getDatetime()) == false;
                if (!notInDateRange) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return adProfitPositions;
    }

    private List<PrechargePositionConsumeVo> buildConsumeVo(List<AdProfitPosition> adProfitPositions) {
        List positionIdList = adProfitPositions.stream().map(p -> p.getPositionId()).collect(Collectors.toList());
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setPageNum(Integer.valueOf(1));
        paramDTO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        paramDTO.setPositionIds(positionIdList);
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        Map<String, String> positionNameMap = appEntranceAdRos.stream().collect(Collectors.toMap(AppEntranceAdRO::getPositionId, AppEntranceAdRO::getAppEntranceName));
        Map<String, String> positionCodeMap = appEntranceAdRos.stream().collect(Collectors.toMap(AppEntranceAdRO::getPositionId, p -> this.dealPositionCode(p.getCode()) + "-" + p.getAppEntranceId()));
        ArrayList<PrechargePositionConsumeVo> resultList = new ArrayList<PrechargePositionConsumeVo>(adProfitPositions.size());
        for (AdProfitPosition adProfitPosition : adProfitPositions) {
            PrechargePositionConsumeVo consumeVo = new PrechargePositionConsumeVo();
            consumeVo.setPositionId(adProfitPosition.getPositionId());
            consumeVo.setDatetime(adProfitPosition.getDatetime());
            consumeVo.setConsume(MoneyUtils.parseAmountOfYuan(adProfitPosition.getProfitActual()));
            consumeVo.setPositionName(positionNameMap.get(adProfitPosition.getPositionId()));
            consumeVo.setPositionCode(positionCodeMap.get(adProfitPosition.getPositionId()));
            resultList.add(consumeVo);
        }
        return resultList;
    }

    private List<PrechargeRecordVo> buildPrechargeRecordVo(List<AdProfitPosition> adProfitPositions, Long accountId, String startTime, String endTime) {
        PrechargeNewConfig prechargeNewConfig = this.prechargeNewConfigMapper.selectByPrimaryKey(accountId);
        if (prechargeNewConfig == null) {
            return Collections.EMPTY_LIST;
        }
        Map<String, Integer> dateConsumeMap = adProfitPositions.stream().collect(Collectors.groupingBy(AdProfitPosition::getDatetime, Collectors.reducing(0, AdProfitPosition::getProfitActual, Integer::sum)));
        List listByParam = this.prechargeNewRecordMapper.getListByParam(accountId, startTime, endTime);
        Map<String, BigDecimal> dateRechargeMap = listByParam.stream().filter(p -> PrechargeNewRecord.TYPE_RECHARGE.equals(p.getType())).collect(Collectors.groupingBy(PrechargeNewRecord::getDatetime, Collectors.reducing(BigDecimal.ZERO, PrechargeNewRecord::getAmount, BigDecimal::add)));
        Map<String, BigDecimal> dateCorrectMap = listByParam.stream().filter(p -> PrechargeNewRecord.TYPE_CORRECT.equals(p.getType())).collect(Collectors.groupingBy(PrechargeNewRecord::getDatetime, Collectors.reducing(BigDecimal.ZERO, PrechargeNewRecord::getAmount, BigDecimal::add)));
        Set<String> dailyBetweenDate = DateUtils.getDailyBetweenDate2(DateUtil.convertStr2Date((String)startTime), DateUtil.convertStr2Date((String)endTime));
        BigDecimal startBalance = this.prechargeService.getBalanceByDate(accountId, DateUtils.getPreDate(startTime));
        ArrayList<PrechargeRecordVo> prechargeRecordVos = new ArrayList<PrechargeRecordVo>();
        for (String date : dailyBetweenDate) {
            PrechargeRecordVo prechargeRecordVo = new PrechargeRecordVo();
            prechargeRecordVo.setDatetime(date);
            if (dateConsumeMap.containsKey(date)) {
                prechargeRecordVo.setConsumeAmount(MoneyUtils.parseAmountOfYuan(dateConsumeMap.getOrDefault(date, 0)));
            } else {
                prechargeRecordVo.setConsumeAmount(BigDecimal.ZERO);
            }
            prechargeRecordVo.setRechargeAmount(dateRechargeMap.getOrDefault(date, BigDecimal.ZERO));
            prechargeRecordVo.setCorrectAmount(dateCorrectMap.getOrDefault(date, BigDecimal.ZERO));
            BigDecimal dateBalance = startBalance.subtract(prechargeRecordVo.getConsumeAmount()).add(prechargeRecordVo.getRechargeAmount()).add(prechargeRecordVo.getCorrectAmount());
            prechargeRecordVo.setBalance(dateBalance);
            prechargeRecordVo.setAccountName(prechargeNewConfig.getAccountName());
            prechargeRecordVo.setAccountId(prechargeNewConfig.getId());
            prechargeRecordVos.add(prechargeRecordVo);
            startBalance = dateBalance;
        }
        return prechargeRecordVos;
    }
}

