/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.prod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdLandingPageConfigMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdLandingPagePlanMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAdxMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAppExtendMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketPersonsGradeConfMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketPriceConfMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketWeightManualConfMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsAdxMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsInspireVideoMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketGetuiTagRefMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.GetuiTagDictMapperExt;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdxExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideoExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssetsExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAdxExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtend;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtendExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsInfo;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRefExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPriceConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketWeightManualConf;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.DynamicPopupParam;
import com.bxm.adsmanager.model.vo.LandingPageConfigVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsCouponsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsInfoService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOnoffService;
import com.bxm.adsmanager.service.adkeeper.AdTicketOsConfSerive;
import com.bxm.adsmanager.service.adkeeper.AdTicketPositionTimesLimitConfigService;
import com.bxm.adsmanager.service.adkeeper.AdTicketTagConfService;
import com.bxm.adsmanager.service.adkeeper.GetuiTagDictService;
import com.bxm.adsmanager.service.adxadvertiserinfo.AdxAdvertiserInfoService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsprod.facade.rules.Rule;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.TicketAppExtend;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketAssetsCoupons;
import com.bxm.adsprod.facade.ticket.TicketCouponsInfo;
import com.bxm.adsprod.facade.ticket.TicketCrowd;
import com.bxm.adsprod.facade.ticket.TicketLand;
import com.bxm.adsprod.facade.ticket.TicketLandPlan;
import com.bxm.adsprod.facade.ticket.TicketOfRules;
import com.bxm.adsprod.facade.ticket.TicketOnoff;
import com.bxm.adsprod.facade.ticket.TicketOs;
import com.bxm.adsprod.facade.ticket.TicketPositionScene;
import com.bxm.adsprod.facade.ticket.TicketPrice;
import com.bxm.adsprod.facade.ticket.TicketRtaExtend;
import com.bxm.adsprod.facade.ticket.TicketTemplateAssets;
import com.bxm.adsprod.facade.ticket.TicketWeightMif;
import com.bxm.adsprod.facade.ticket.adx.TicketAdx;
import com.bxm.adsprod.facade.ticket.adx.TicketAdxCreative;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideoCreative;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.MessageException;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.datasync.utils.KeyHelper;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProdServiceImpl
implements ProdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProdServiceImpl.class);
    private static final String STR_ZERO = "0";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final String STR_TWO = "2-";
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdTicketTagConfService adTicketTagConfService;
    @Autowired
    private AdTicketOsConfSerive adTicketOsConfSerive;
    @Autowired
    private AdTicketOnoffService adTicketOnoffService;
    @Autowired
    private AdAssetsMapper adAssetsMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private AdTicketWeightManualConfMapper adTicketWeightManualConfMapper;
    @Autowired
    private AdTicketPriceConfMapper adTicketPriceConfMapper;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private AdTicketPersonsGradeConfMapper adTicketPersonsGradeConfMapper;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private AdTicketCouponsInfoService adTicketCouponsInfoService;
    @Autowired
    private AdTicketAssetsCouponsService adTicketAssetsCouponsService;
    @Autowired
    private AdxAdvertiserInfoService adxAdvertiserInfoService;
    @Autowired
    private AdTicketFlowPackageMapper adTicketFlowPackageMapper;
    @Autowired
    private DataSyncProducer dataSyncProducer;
    @Autowired
    private MessageSender messageSender;
    @Autowired
    private AdTicketAdxMapper adTicketAdxMapper;
    @Autowired
    private AdAssetsAdxMapperExt adAssetsAdxMapperExt;
    @Autowired
    private AdAssetsInspireVideoMapperExt adAssetsInspireVideoMapperExt;
    @Autowired
    private AdAssetsTemplateAssetsMapper adAssetsTemplateAssetsMapper;
    @Autowired
    private AdTicketAppExtendMapper adTicketAppExtendMapper;
    @Autowired
    private AdTicketGetuiTagRefMapperExt adTicketGetuiTagRefMapperExt;
    @Autowired
    private GetuiTagDictMapperExt getuiTagDictMapperExt;
    @Autowired
    private GetuiTagDictService getuiTagDictService;
    @Autowired
    private AdLandingPagePlanMapper adLandingPagePlanMapper;
    @Autowired
    private AdLandingPageConfigMapper adLandingPageConfigMapper;
    @Autowired
    private AdTicketPositionTimesLimitConfigService adTicketPositionTimesLimitConfigService;

    @Override
    public void pushAdTicketToProdPre(Long adTicketId) throws Exception {
        if (null == adTicketId) {
            throw new ValidateException("adTicketId must be not null");
        }
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adTicketId);
        if (adTicket == null) {
            throw new ValidateException("\u6839\u636e\u5e7f\u544a\u5238Id\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5238\uff0c\u6216\u8005\u8be5\u5238\u5df2\u7ecf\u5220\u9664 " + adTicketId);
        }
        String oss = this.adTicketOsConfSerive.findByTicketId(adTicket.getId());
        String adTags = this.adTicketTagConfService.findByTicketId(adTicket.getId());
        String noimei = this.adTicketOnoffService.findByTicketId(adTicket.getId(), 1);
        String imeinomatching = this.adTicketOnoffService.findByTicketId(adTicket.getId(), 2);
        Double mifs = this.adTicketWeightManualConfMapper.findByTicketId(adTicket.getId());
        AdTicketPriceConf conf = this.adTicketPriceConfMapper.findByTicketId(adTicket.getId());
        Map<String, Rule> ruleMap = this.getRuleMap(adTicket.getId());
        List list = this.adTicketPersonsGradeConfMapper.findByTicketId(adTicketId);
        if (CollectionUtils.isNotEmpty((Collection)list) && null != adTicket.getUserGradePassScore()) {
            this.pushAdTicketToProd(oss, adTags, noimei, imeinomatching, adTicket, null, mifs, conf, ruleMap);
        } else {
            this.pushAdTicketToProd(oss, adTags, null, null, adTicket, null, mifs, conf, ruleMap);
        }
    }

    @Override
    public void pushAdTicketToProd(String oss, String tags, String noiemi, String imeinomatching, AdTicket adTicket, String assetsids, Double mif, AdTicketPriceConf conf, Map<String, Rule> ruleMap) throws Exception {
        if (adTicket == null || null == adTicket.getId()) {
            return;
        }
        AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType((Short)adTicket.getType());
        if (adTicketType == null) {
            LOGGER.error("\u5e7f\u544a\u5238\uff08{},{},{}\uff09\u7c7b\u578b\u975e\u6cd5\uff01", new Object[]{adTicket.getId(), adTicket.getName(), adTicket.getType()});
            return;
        }
        Long ticketId = adTicket.getId();
        TicketOfRules ticketOfRules = new TicketOfRules();
        BeanUtils.copyProperties((Object)adTicket, (Object)ticketOfRules);
        String positionSceneConfig = adTicket.getPositionSceneConfig();
        String[] split = StringUtils.split((String)positionSceneConfig, (String)",");
        ArrayList ticketPositionScenes = Lists.newArrayList();
        if (split != null) {
            for (String s : split) {
                Byte scene = Byte.valueOf(s);
                TicketPositionScene ticketPositionScene = new TicketPositionScene();
                ticketPositionScene.setScene(scene);
                ticketPositionScene.setTicketId(BigInteger.valueOf(ticketId));
                ticketPositionScenes.add(ticketPositionScene);
            }
        }
        ticketOfRules.setPositionScenes((List)ticketPositionScenes);
        if (4 == adTicket.getSettleType()) {
            ticketOfRules.setPrice(Integer.valueOf(DoubleUtil.divide1000(adTicket.getPrice())));
        }
        ticketOfRules.setId(BigInteger.valueOf(ticketId));
        ticketOfRules.setAdvertiser(BigInteger.valueOf(adTicket.getAdvertiser()));
        ticketOfRules.setSettleType(TypeHelper.castToByte((Object)adTicket.getSettleType()));
        ticketOfRules.setBudgetDaily(BigInteger.valueOf(adTicket.getBudgetDaily()));
        ticketOfRules.setStatus(TypeHelper.castToByte((Object)adTicket.getStatus()));
        ticketOfRules.setType(TypeHelper.castToByte((Object)adTicket.getType()));
        ticketOfRules.setAssetsDistribute(adTicket.getAssetsSelectType());
        if (adTicket.getRightsId() != null) {
            ticketOfRules.setRightsId(BigInteger.valueOf(adTicket.getRightsId()));
        }
        ticketOfRules.setTargetConvType(adTicket.getTargetConvType());
        ticketOfRules.setRtbAppKey(adTicket.getRtbAppKey());
        ticketOfRules.setDeduplicateValidClick(adTicket.getDeduplicateValidClick());
        ticketOfRules.setAlgoTarget(adTicket.getAlgoTarget());
        this.setLandingPagePlan(ticketId, ticketOfRules);
        ticketOfRules.setIsSupportWechat(TypeHelper.castToByte((Object)adTicket.getIsSupportWechat()));
        ticketOfRules.setIsEffectMonitor(TypeHelper.castToByte((Object)adTicket.getIsEffectMonitor()));
        if (StringUtil.isNotBlank((CharSequence)adTicket.getApps())) {
            String[] appsArray;
            ArrayList appsList = Lists.newArrayList();
            for (String app : appsArray = StringUtils.split((String)adTicket.getApps(), (String)",")) {
                appsList.add(TypeHelper.castToInt((Object)app));
            }
            ticketOfRules.setApps((List)appsList);
        }
        if (StringUtil.isNotBlank((CharSequence)oss)) {
            String[] ossArray;
            ArrayList<TicketOs> osList = new ArrayList<TicketOs>();
            for (String o : ossArray = oss.split(",")) {
                TicketOs os = new TicketOs();
                os.setSupportOs(new Byte(o));
                os.setTicketId(ticketOfRules.getId());
                osList.add(os);
            }
            ticketOfRules.setOss(osList);
        }
        if (StringUtil.isNotBlank((CharSequence)tags)) {
            String[] tagArray;
            ArrayList<Tag> tagList = new ArrayList<Tag>();
            for (String t : tagArray = tags.split(",")) {
                Tag tag = new Tag();
                tag.setCode(t);
                tagList.add(tag);
            }
            ticketOfRules.setTags(tagList);
        }
        if (StringUtil.isNotBlank((CharSequence)noiemi) && StringUtil.isNotBlank((CharSequence)imeinomatching)) {
            List<TicketOnoff> onoffList = this.getTicketOnoffList(noiemi, ticketId, 1);
            onoffList.addAll(this.getTicketOnoffList(imeinomatching, ticketId, 2));
            ticketOfRules.setOnoffs(onoffList);
        }
        AdTicketGetuiTagRefExample adTicketGetuiTagRefExample = new AdTicketGetuiTagRefExample();
        adTicketGetuiTagRefExample.createCriteria().andTicketIdEqualTo(ticketId);
        List adTicketGetuiTagRefs = this.adTicketGetuiTagRefMapperExt.selectByExample(adTicketGetuiTagRefExample);
        if (CollectionUtils.isNotEmpty((Collection)adTicketGetuiTagRefs)) {
            List<String> tagValues = adTicketGetuiTagRefs.stream().map(AdTicketGetuiTagRef::getTagGroupValue).collect(Collectors.toList());
            List<String> lastTagValues = this.getuiTagDictService.buildRealTag(tagValues);
            TicketCrowd ticketCrowd = new TicketCrowd();
            ticketCrowd.setTicketId(BigInteger.valueOf(ticketId));
            ticketCrowd.setGetuiTags(lastTagValues);
            ticketOfRules.setTicketCrowd(ticketCrowd);
        }
        switch (adTicketType) {
            case TYPE_NORMALS: 
            case TYPE_STANDBYS: 
            case TYPE_DSP: 
            case TYPE_RTA: 
            case TYPE_ENCOURAGE: 
            case TYPE_PUSH: {
                this.fillNormalsAssets(ticketId, ticketOfRules, assetsids);
                break;
            }
            case TYPE_COUPON: {
                this.fillCouponAssets(ticketId, ticketOfRules);
                break;
            }
            case TYPE_ADX_DIRECT: 
            case TYPE_ADX_INTERACT: {
                this.fillAdxAssets(ticketId, ticketOfRules);
                break;
            }
            case TYPE_INSPIRE_VIDEO: 
            case TYPE_INSPIRE_VIDEO_STANDBYS: {
                this.fillInspireVideoAssets(ticketId, ticketOfRules);
                break;
            }
            case TYPE_ACTIVITY: 
            case TYPE_DIRECT: {
                this.fillActivityAndDirectAssets(ticketId, ticketOfRules);
                String meiTuanAdxAdvertiserId = this.adxAdvertiserInfoService.getMeiTuanAdxAdvertiserId(ticketOfRules.getAdvertiser().intValue());
                ticketOfRules.setMeituanAdxAdvertiser(meiTuanAdxAdvertiserId);
                break;
            }
            default: {
                LOGGER.error("\u672a\u5904\u7406\u7684\u5e7f\u544a\u5238\uff08{},{},{}\uff09\u7c7b\u578b\u975e\u6cd5\uff01", new Object[]{adTicket.getId(), adTicket.getName(), adTicket.getType()});
                return;
            }
        }
        if (AdTicket.AdTicketType.isNotAdx((Short)adTicket.getType())) {
            this.fillTicketAppExtend(ticketId, ticketOfRules);
        }
        if (null != mif) {
            ArrayList<TicketWeightMif> mifs = new ArrayList<TicketWeightMif>();
            TicketWeightMif weightMif = new TicketWeightMif();
            weightMif.setMif(mif);
            weightMif.setTicketId(BigInteger.valueOf(ticketId));
            mifs.add(weightMif);
            ticketOfRules.setMifs(mifs);
        }
        if (conf != null) {
            ArrayList<TicketPrice> prices = new ArrayList<TicketPrice>();
            TicketPrice price = new TicketPrice();
            BeanUtils.copyProperties((Object)conf, (Object)price);
            price.setTicketId(BigInteger.valueOf(ticketId));
            prices.add(price);
            ticketOfRules.setPrices(prices);
        }
        ticketOfRules.setRegion(ruleMap.get("region"));
        ticketOfRules.setIpLib(ruleMap.get("ipLib"));
        ticketOfRules.setPosition(ruleMap.get("position"));
        ticketOfRules.setTimeline(ruleMap.get("timeline"));
        ticketOfRules.setTimes(ruleMap.get("times"));
        ticketOfRules.setCrowdPackage(ruleMap.get("crowdPackage"));
        ticketOfRules.setTicketPackage(ruleMap.get("ticketPackage"));
        ticketOfRules.setPositionGroup(ruleMap.get("positionGroup"));
        ticketOfRules.setAppPackage(ruleMap.get("appPackage"));
        ticketOfRules.setMediaAppPackageRule(ruleMap.get("mediaAppPackage"));
        ticketOfRules.setAdxAppIdRule(ruleMap.get("adxAppId"));
        ticketOfRules.setIsp(ruleMap.get("isp"));
        ticketOfRules.setNetworkType(ruleMap.get("NetworkType"));
        ticketOfRules.setAdQuality(ruleMap.get("adQuality"));
        ticketOfRules.setActivityOrientation(ruleMap.get("activityOrientation"));
        ticketOfRules.setNewAndOldUsers(ruleMap.get("newAndOldUsers"));
        ticketOfRules.setGetuiSex(ruleMap.get("getuiSex"));
        ticketOfRules.setBesGender(ruleMap.get("besGender"));
        ticketOfRules.setBesAge(ruleMap.get("besAge"));
        ticketOfRules.setPhoneBrand(ruleMap.get("phoneBrand"));
        ticketOfRules.setAdxAPPEntrance(ruleMap.get("adxAPPEntrance"));
        ticketOfRules.setAppIdPackage(ruleMap.get("appIdPackage"));
        ticketOfRules.setAdxTagIdRule(ruleMap.get("adxTagIdRule"));
        ticketOfRules.setCountry(ruleMap.get("country"));
        ticketOfRules.setBaiduLookLikeRule(ruleMap.get("baiduLookLikeRule"));
        if (Objects.isNull(ticketOfRules.getAdTicketAppExtend())) {
            TicketAppExtend ticketAppExtend = new TicketAppExtend();
            ticketOfRules.setAdTicketAppExtend(ticketAppExtend);
        }
        ticketOfRules.getAdTicketAppExtend().setTimeBidding(ruleMap.get("timeBidding"));
        AdTicketOcpcConf ocpcConf = this.adTicketOcpcService.selectByTicketId(ticketId);
        if (null == ocpcConf) {
            ticketOfRules.setOcpc(Byte.valueOf((byte)0));
        } else {
            ticketOfRules.setCpaPrice(ocpcConf.getCpaExpectPrice());
            ticketOfRules.setDeepCpaPrice(ocpcConf.getCpaDeepExpectPrice());
            ticketOfRules.setDeepExpectActionType(ocpcConf.getDeepExpectActionType());
            ticketOfRules.setExpectActionType(ocpcConf.getExpectActionType());
            Short isSupportOcpc = ocpcConf.getIsSupportOcpc();
            if (null != isSupportOcpc && isSupportOcpc == 1) {
                ticketOfRules.setOcpc(Byte.valueOf((byte)1));
                ticketOfRules.setCloseThreshold(ocpcConf.getCloseThreshold());
            } else {
                ticketOfRules.setOcpc(Byte.valueOf((byte)0));
            }
        }
        ticketOfRules.setPositionTimesLimitConfigs(this.adTicketPositionTimesLimitConfigService.findPushByTicketId(ticketId));
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ticketid", ticketId);
        this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET.getServiceName(), map, JSONArray.toJSONBytes((Object)ticketOfRules, (SerializerFeature[])new SerializerFeature[0]));
        try {
            this.dataSyncProducer.post(KeyHelper.generate(TicketOfRules.class, (Object)String.valueOf(ticketId)), (Object)ticketOfRules);
        }
        catch (Exception e) {
            LOGGER.error("post: ", (Throwable)e);
            try {
                this.messageSender.send2(new Message("\u6570\u636e\u540c\u6b65\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage()));
            }
            catch (MessageException messageException) {
                // empty catch block
            }
        }
    }

    private void fillActivityAndDirectAssets(Long ticketId, TicketOfRules ticketOfRules) {
        AdAssetsTemplateAssetsExample example = new AdAssetsTemplateAssetsExample();
        example.createCriteria().andTicketIdEqualTo(ticketId).andStatusNotEqualTo(Short.valueOf((short)2));
        List adAssetsTemplateAssetsList = this.adAssetsTemplateAssetsMapper.selectByExample(example);
        ArrayList<TicketTemplateAssets> templateAssetsList = new ArrayList<TicketTemplateAssets>(adAssetsTemplateAssetsList.size());
        for (AdAssetsTemplateAssets adAssetsTemplateAssets : adAssetsTemplateAssetsList) {
            TicketTemplateAssets ticketTemplateAssets = new TicketTemplateAssets();
            ticketTemplateAssets.setId(BigInteger.valueOf(adAssetsTemplateAssets.getId()));
            ticketTemplateAssets.setTicketId(BigInteger.valueOf(ticketId));
            if (adAssetsTemplateAssets.getOppoAuditStatus() == null) {
                ticketTemplateAssets.setStatus(adAssetsTemplateAssets.getStatus());
            } else if (adAssetsTemplateAssets.getStatus() == 1 && adAssetsTemplateAssets.getOppoAuditStatus() == 4) {
                ticketTemplateAssets.setStatus(Short.valueOf((short)1));
            } else {
                ticketTemplateAssets.setStatus(Short.valueOf((short)0));
            }
            ticketTemplateAssets.setAssetsName(adAssetsTemplateAssets.getAssetsName());
            ticketTemplateAssets.setConfig(adAssetsTemplateAssets.getConfig());
            ticketTemplateAssets.setOppoCreativeId(adAssetsTemplateAssets.getOppoCreativeId());
            ticketTemplateAssets.setAdxAuditStatus(adAssetsTemplateAssets.getAdxAuditStatus());
            ticketTemplateAssets.setAdxCreativeId(adAssetsTemplateAssets.getAdxCreativeId());
            templateAssetsList.add(ticketTemplateAssets);
        }
        ticketOfRules.setTemplateAssets(templateAssetsList);
    }

    private void fillInspireVideoAssets(Long ticketId, TicketOfRules ticketOfRules) {
        AdAssetsInspireVideoExample adAssetsInspireVideoExample = new AdAssetsInspireVideoExample();
        adAssetsInspireVideoExample.createCriteria().andTicketIdEqualTo(ticketId);
        List adAssetsInspireVideoList = this.adAssetsInspireVideoMapperExt.selectByExample(adAssetsInspireVideoExample);
        ArrayList<TicketInspireVideoCreative> ticketInspireVideoCreatives = new ArrayList<TicketInspireVideoCreative>(adAssetsInspireVideoList.size());
        for (AdAssetsInspireVideo adAssetsInspireVideo : adAssetsInspireVideoList) {
            TicketInspireVideoCreative ticketInspireVideoCreative = new TicketInspireVideoCreative();
            BeanUtils.copyProperties((Object)adAssetsInspireVideo, (Object)ticketInspireVideoCreative);
            ticketInspireVideoCreative.setCreativeId(BigInteger.valueOf(adAssetsInspireVideo.getId()));
            ticketInspireVideoCreative.setTicketId(BigInteger.valueOf(ticketId));
            ticketInspireVideoCreative.setVideoUrl(adAssetsInspireVideo.getVideoUrl());
            ticketInspireVideoCreative.setVideoDuration(adAssetsInspireVideo.getVideoDuration());
            ticketInspireVideoCreative.setCoverUrl(adAssetsInspireVideo.getCoverUrl());
            ticketInspireVideoCreative.setTitle(adAssetsInspireVideo.getTitle());
            ticketInspireVideoCreative.setSubtitle(adAssetsInspireVideo.getSubtitle());
            ticketInspireVideoCreative.setIconUrl(adAssetsInspireVideo.getIconUrl());
            ticketInspireVideoCreative.setButtonUrl(adAssetsInspireVideo.getButtonUrl());
            ticketInspireVideoCreative.setEndPageFlag(adAssetsInspireVideo.getEndPageFlag());
            ticketInspireVideoCreative.setEndPagePictures(adAssetsInspireVideo.getEndPagePictures());
            ticketInspireVideoCreative.setEndPageButtonUrl(adAssetsInspireVideo.getEndPageButtonUrl());
            ticketInspireVideoCreative.setEndPageStyleType(adAssetsInspireVideo.getEndPageStyleType());
            ticketInspireVideoCreative.setEndPageUrl(adAssetsInspireVideo.getEndPageUrl());
            ticketInspireVideoCreative.setStatus(adAssetsInspireVideo.getStatus().shortValue());
            ticketInspireVideoCreative.setContent(adAssetsInspireVideo.getContent());
            ticketInspireVideoCreative.setVideoDirection(adAssetsInspireVideo.getVideoDirection());
            ticketInspireVideoCreative.setAssetsName(adAssetsInspireVideo.getAssetsName());
            ticketInspireVideoCreative.setButtonContent(adAssetsInspireVideo.getButtonContent());
            ticketInspireVideoCreative.setVideoHeight(adAssetsInspireVideo.getVideoHeight());
            ticketInspireVideoCreative.setVideoWidth(adAssetsInspireVideo.getVideoWidth());
            ticketInspireVideoCreatives.add(ticketInspireVideoCreative);
        }
        BeanUtils.copyProperties((Object)adAssetsInspireVideoList, ticketInspireVideoCreatives);
        ticketOfRules.setTicketInspireVideoCreatives(ticketInspireVideoCreatives);
    }

    private void fillTicketAppExtend(Long ticketId, TicketOfRules ticketOfRules) {
        AdTicketAppExtendExample adTicketAppExtendExample = new AdTicketAppExtendExample();
        adTicketAppExtendExample.createCriteria().andTicketIdEqualTo(ticketId);
        List adTicketAppExtends = this.adTicketAppExtendMapper.selectByExample(adTicketAppExtendExample);
        if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
            AdTicketAppExtend adTicketAppExtend = (AdTicketAppExtend)adTicketAppExtends.get(0);
            TicketAppExtend ticketAppExtend = new TicketAppExtend();
            ticketAppExtend.setTicketId(ticketId);
            ticketAppExtend.setPageType(adTicketAppExtend.getPageType());
            ticketAppExtend.setPackageName(adTicketAppExtend.getPackageName());
            ticketAppExtend.setJumpUrl(adTicketAppExtend.getJumpUrl());
            ticketAppExtend.setViewUrl(adTicketAppExtend.getViewUrl());
            ticketAppExtend.setClickUrl(adTicketAppExtend.getClickUrl());
            ticketAppExtend.setVideoPlayStartUrl(adTicketAppExtend.getVideoPlayStartUrl());
            ticketAppExtend.setVideoPlayEndUrl(adTicketAppExtend.getVideoPlayEndUrl());
            ticketAppExtend.setDeeplinkFailUrl(adTicketAppExtend.getDeeplinkFailUrl());
            ticketAppExtend.setDeeplinkStartUrl(adTicketAppExtend.getDeeplinkStartUrl());
            ticketAppExtend.setDeeplinkSuccessUrl(adTicketAppExtend.getDeeplinkSuccessUrl());
            ticketAppExtend.setDeviceOrientation(adTicketAppExtend.getDeviceOrientation());
            ticketAppExtend.setAppPackageRate(adTicketAppExtend.getAppPackageRate());
            ticketAppExtend.setMediaAppPackageRate(adTicketAppExtend.getMediaAppPackageRate());
            ticketAppExtend.setBdTags(adTicketAppExtend.getBdTags());
            ticketAppExtend.setBdTagsOrientation(adTicketAppExtend.getBdTagsOrientation());
            ticketAppExtend.setAdxAppIdRate(adTicketAppExtend.getAdxAppIdRate());
            ticketAppExtend.setAdxPrice(adTicketAppExtend.getAdxPrice());
            ticketAppExtend.setAdxBudgetDaily(adTicketAppExtend.getAdxBudgetDaily());
            ticketAppExtend.setAdxTargetCpa(adTicketAppExtend.getAdxTargetCpa());
            ticketAppExtend.setLandingPageEndJumpUrl(adTicketAppExtend.getLandingPageEndJumpUrl());
            ticketAppExtend.setAdxPriceType(adTicketAppExtend.getAdxPriceType());
            ticketAppExtend.setDownloadLandingPageId(adTicketAppExtend.getDownloadLandingPageId());
            ticketAppExtend.setCrowdPackageOrientation(adTicketAppExtend.getCrowdPackageOrientation());
            ticketAppExtend.setAdxId(adTicketAppExtend.getAdxId());
            ticketAppExtend.setRiskControl(adTicketAppExtend.getRiskControl());
            ticketAppExtend.setFirstCallOptimization(adTicketAppExtend.getFirstCallOptimization());
            ticketAppExtend.setParticipationRate(adTicketAppExtend.getParticipationRate());
            ticketAppExtend.setOsVersionOrientation(adTicketAppExtend.getOsVersionOrientation());
            ticketAppExtend.setTbWaresDetailRate(adTicketAppExtend.getTbWaresDetailRate());
            ticketAppExtend.setTbFirstCallAndWaresDetailRate(adTicketAppExtend.getTbFirstCallAndWaresDetailRate());
            ticketAppExtend.setOneClickRecovery(adTicketAppExtend.getOneClickRecovery());
            ticketAppExtend.setRoiCoefficient(adTicketAppExtend.getRoiCoefficient());
            ticketAppExtend.setBesTagsOrientation(adTicketAppExtend.getBesTagsOrientation());
            ticketAppExtend.setAdxAppRvCover(adTicketAppExtend.getAdxAppRvCover());
            ticketAppExtend.setAdxTagIdRate(adTicketAppExtend.getAdxTagIdRate());
            ticketAppExtend.setSupportOcpr(adTicketAppExtend.getSupportOcpr());
            ticketOfRules.setAdTicketAppExtend(ticketAppExtend);
            TicketRtaExtend rtaExtend = new TicketRtaExtend();
            rtaExtend.setType(adTicketAppExtend.getRta());
            rtaExtend.setParam(adTicketAppExtend.getRtaParam());
            ticketOfRules.setRtaExtend(rtaExtend);
        }
    }

    private void fillAdxAssets(Long ticketId, TicketOfRules ticketOfRules) {
        AdTicketAdxExample adTicketAdxExample = new AdTicketAdxExample();
        adTicketAdxExample.createCriteria().andAdTicketIdEqualTo(ticketId);
        List adTicketAdxes = this.adTicketAdxMapper.selectByExample(adTicketAdxExample);
        if (CollectionUtils.isNotEmpty((Collection)adTicketAdxes)) {
            AdTicketAdx adTicketAdx = (AdTicketAdx)adTicketAdxes.get(0);
            TicketAdx ticketAdx = new TicketAdx();
            ticketAdx.setAdTicketId(BigInteger.valueOf(ticketId));
            ticketAdx.setClickMaximum(adTicketAdx.getClickMaximum());
            ticketAdx.setShowMaximum(adTicketAdx.getShowMaximum());
            ticketAdx.setSpeed(adTicketAdx.getSpeed());
            ticketAdx.setCrowdSource(Short.valueOf((short)0));
            ticketAdx.setAdxSettleType(adTicketAdx.getAdxSettleType());
            ticketAdx.setAdxPrice(adTicketAdx.getAdxPrice());
            ticketAdx.setAdxBudgetDaily(adTicketAdx.getAdxBudgetDaily());
            ticketAdx.setAdxAe(adTicketAdx.getAdxAe());
            ticketAdx.setAdxPutinType(adTicketAdx.getAdxPutinType());
            ticketAdx.setAdxDownloadType(adTicketAdx.getAdxDownloadType());
            ticketAdx.setAdxPackageName(adTicketAdx.getAdxPackageName());
            ticketAdx.setDeeplinkUrl(adTicketAdx.getDeeplinkUrl());
            ticketOfRules.setTicketAdx(ticketAdx);
        }
        AdAssetsAdxExample adAssetsAdxExample = new AdAssetsAdxExample();
        adAssetsAdxExample.createCriteria().andAdTicketIdEqualTo(ticketId);
        List adAssetsAdxList = this.adAssetsAdxMapperExt.selectByExample(adAssetsAdxExample);
        ArrayList<TicketAdxCreative> ticketAssetsCoupons = new ArrayList<TicketAdxCreative>(adAssetsAdxList.size());
        for (AdAssetsAdx adAssetsAdx : adAssetsAdxList) {
            TicketAdxCreative ticketAdxCreative = new TicketAdxCreative();
            BeanUtils.copyProperties((Object)adAssetsAdx, (Object)ticketAdxCreative);
            ticketAdxCreative.setCreativeId(BigInteger.valueOf(adAssetsAdx.getId()));
            ticketAdxCreative.setAdTicketId(BigInteger.valueOf(ticketId));
            ticketAdxCreative.setAdTicketAdxId(BigInteger.valueOf(adAssetsAdx.getAdTicketAdxId()));
            ticketAdxCreative.setPositionId(adAssetsAdx.getPositionId());
            ticketAdxCreative.setPositionType(adAssetsAdx.getPositionType().shortValue());
            ticketAdxCreative.setPositionTypeDesc(adAssetsAdx.getPositionTypeDesc());
            ticketAdxCreative.setShowUrl(adAssetsAdx.getShowUrl());
            ticketAdxCreative.setClickUrl(adAssetsAdx.getClickUrl());
            ticketAdxCreative.setCreativeName(adAssetsAdx.getCreativeName());
            ticketAdxCreative.setCreativeIcon(adAssetsAdx.getCreativeIcon());
            ticketAdxCreative.setCreativeTitle(adAssetsAdx.getCreativeTitle());
            ticketAdxCreative.setCreativeContent(adAssetsAdx.getCreativeContent());
            ticketAdxCreative.setCreativePicture(adAssetsAdx.getCreativePicture());
            ticketAdxCreative.setCreativeCover(adAssetsAdx.getCreativeCover());
            ticketAdxCreative.setCreativeVideo(adAssetsAdx.getCreativeVideo());
            ticketAdxCreative.setVideoPlayStartUrl(adAssetsAdx.getVideoPlayStartUrl());
            ticketAdxCreative.setVideoPlayEndUrl(adAssetsAdx.getVideoPlayEndUrl());
            ticketAssetsCoupons.add(ticketAdxCreative);
        }
        BeanUtils.copyProperties((Object)adAssetsAdxList, ticketAssetsCoupons);
        ticketOfRules.setTicketAdxCreatives(ticketAssetsCoupons);
    }

    private void fillCouponAssets(Long ticketId, TicketOfRules ticketOfRules) {
        AdTicketCouponsInfo adTicketCouponsInfo = this.adTicketCouponsInfoService.findByTicketId(ticketId);
        if (adTicketCouponsInfo != null && adTicketCouponsInfo.getId() != null) {
            TicketCouponsInfo ticketCouponsInfo = new TicketCouponsInfo();
            BeanUtils.copyProperties((Object)adTicketCouponsInfo, (Object)ticketCouponsInfo);
            ticketCouponsInfo.setId(BigInteger.valueOf(adTicketCouponsInfo.getId()));
            ticketCouponsInfo.setUseType(TypeHelper.castToByte((Object)adTicketCouponsInfo.getUseType()));
            ticketOfRules.setTicketCouponsInfo(ticketCouponsInfo);
        }
        List<AdAssetsCoupons> adAssetsCouponsList = this.adTicketAssetsCouponsService.findByTicketId(ticketId);
        ArrayList<TicketAssetsCoupons> ticketAssetsCoupons = new ArrayList<TicketAssetsCoupons>(adAssetsCouponsList.size());
        for (AdAssetsCoupons assetsCoupons : adAssetsCouponsList) {
            TicketAssetsCoupons s = new TicketAssetsCoupons();
            if (assetsCoupons.getStatus() == 0) continue;
            BeanUtils.copyProperties((Object)assetsCoupons, (Object)s);
            s.setId(BigInteger.valueOf(assetsCoupons.getId()));
            s.setType(TypeHelper.castToByte((Object)assetsCoupons.getType()));
            ticketAssetsCoupons.add(s);
        }
        BeanUtils.copyProperties(adAssetsCouponsList, ticketAssetsCoupons);
        ticketOfRules.setAssetsCoupons(ticketAssetsCoupons);
    }

    private void fillNormalsAssets(Long ticketId, TicketOfRules ticketOfRules, String assetsids) {
        List<AdAssets> assetsList = assetsids == null ? this.adAssetsMapper.findAllByTicketId(ticketId) : this.adTicketAssetsService.findAll(assetsids);
        if (CollectionUtils.isEmpty(assetsList)) {
            return;
        }
        ArrayList<TicketAssets> ticketAssets = new ArrayList<TicketAssets>(assetsList.size());
        for (AdAssets assets : assetsList) {
            List dynamicPopupParams;
            TicketAssets s = new TicketAssets();
            if (assets.getStatus() == 0) continue;
            BeanUtils.copyProperties((Object)assets, (Object)s);
            s.setVars(TypeHelper.castToByte((Object)assets.getVars()));
            s.setStatus(TypeHelper.castToByte((Object)assets.getStatus()));
            s.setId(BigInteger.valueOf(assets.getId()));
            s.setClickThreshold(assets.getClickThreshold());
            s.setIsShieldPopup(assets.getIsPopup());
            s.setFlowRatio(assets.getFlowRate());
            String dynamicPopupParam = assets.getDynamicPopupParam();
            if (StringUtils.isNotBlank((CharSequence)dynamicPopupParam) && CollectionUtils.isNotEmpty((Collection)(dynamicPopupParams = JSON.parseArray((String)dynamicPopupParam, DynamicPopupParam.class)))) {
                ArrayList dynamicImgs = Lists.newArrayListWithCapacity((int)dynamicPopupParams.size());
                ArrayList dynamicTexts = Lists.newArrayListWithCapacity((int)dynamicPopupParams.size());
                s.setTableId(assets.getAssetPopupId());
                for (DynamicPopupParam popupParam : dynamicPopupParams) {
                    Integer configType = popupParam.getConfigType();
                    if (configType.equals(1)) {
                        dynamicImgs.add(popupParam.getImgUrl());
                        continue;
                    }
                    dynamicTexts.add(popupParam.getTextContent());
                }
                s.setDynamicImgs((List)dynamicImgs);
                s.setDynamicTexts((List)dynamicTexts);
            }
            ticketAssets.add(s);
        }
        BeanUtils.copyProperties(assetsList, ticketAssets);
        ticketOfRules.setAssets(ticketAssets);
    }

    @Override
    @Deprecated
    public void pushToProdWeight(AdTicketWeightManualConf conf) throws Exception {
        if (conf == null) {
            return;
        }
        ArrayList<TicketWeightMif> list = new ArrayList<TicketWeightMif>(1);
        TicketWeightMif weightMif = new TicketWeightMif();
        weightMif.setTicketId(BigInteger.valueOf(conf.getTicketId()));
        weightMif.setMif(conf.getInterventionFactor());
        weightMif.setId(weightMif.getId());
        list.add(weightMif);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ticketid", conf.getTicketId());
        this.prodPusher.pushToProd(ProdServiceNameEnum.TICKET_MIF.getServiceName(), map, JSONArray.toJSONBytes(list, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    @Deprecated
    public void pushToProdRules(String ruleValue, Long ticketId, Integer target, Integer ruleType) throws Exception {
        Rule regionRule = new Rule();
        regionRule.setRuleValue(ruleValue);
        regionRule.setRuleType(ruleType);
        regionRule.setTarget(target);
        regionRule.setTargetId(BigInteger.valueOf(ticketId));
        ProdServiceNameEnum enums = RuleTypeEnum.getEnumByValue((int)ruleType);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(enums.getParameters(), ticketId);
        this.prodPusher.pushToProd(enums.getServiceName(), map, JSONArray.toJSONBytes((Object)regionRule, (SerializerFeature[])new SerializerFeature[0]));
    }

    public Map<String, Rule> getRuleMap(Long ticketId) {
        List adFlows;
        String baiduLookLikeRule;
        String country;
        String adxTagIdRule;
        String appIdPackage;
        String adxAPPEntrance;
        String phoneBrand;
        String besAge;
        String besGender;
        String adxAppId;
        String getuiSex;
        String newAndOldUsers;
        String activityOrientation;
        String adQuality;
        String networkType;
        String isp;
        String ticketPackage;
        String crowdPackage;
        String times;
        String position;
        String timeBidding;
        String timeline;
        Rule rule;
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        String citys = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.DIYUXIANZHI.getValue()), ticketId);
        String ipLibs = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.IPLIB.getValue()), ticketId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{citys})) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.DIYUXIANZHI.getValue()));
            rule.setRuleValue(citys);
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("region", rule);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ipLibs})) {
            rule = new Rule();
            rule.setRuleType(Integer.valueOf(RuleTypeEnum.IPLIB.getValue()));
            rule.setRuleValue(ipLibs);
            rule.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("ipLib", rule);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{timeline = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.SHIJIANDUAN.getValue()), ticketId)})) {
            Rule rule2 = new Rule();
            rule2.setRuleType(Integer.valueOf(RuleTypeEnum.SHIJIANDUAN.getValue()));
            rule2.setRuleValue(timeline);
            rule2.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule2.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("timeline", rule2);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{timeBidding = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.TIME_BIDDING.getValue()), ticketId)})) {
            Rule rule3 = new Rule();
            rule3.setRuleType(Integer.valueOf(RuleTypeEnum.TIME_BIDDING.getValue()));
            rule3.setRuleValue(timeBidding);
            rule3.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule3.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("timeBidding", rule3);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{position = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), ticketId)})) {
            Rule rule4 = new Rule();
            rule4.setRuleType(Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()));
            rule4.setRuleValue(position);
            rule4.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule4.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("position", rule4);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{times = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.PINCI.getValue()), ticketId)})) {
            Rule rule5 = new Rule();
            rule5.setRuleType(Integer.valueOf(RuleTypeEnum.PINCI.getValue()));
            rule5.setRuleValue(times);
            rule5.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule5.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("times", rule5);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{crowdPackage = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.THIRD_PARTY_CROWD_PACKAGE.getValue()), ticketId)})) {
            Rule rule6 = new Rule();
            rule6.setRuleType(Integer.valueOf(RuleTypeEnum.THIRD_PARTY_CROWD_PACKAGE.getValue()));
            rule6.setRuleValue(crowdPackage);
            rule6.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule6.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("crowdPackage", rule6);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ticketPackage = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.TICKET_PACKAGE.getValue()), ticketId)})) {
            Rule rule7 = new Rule();
            rule7.setRuleType(Integer.valueOf(RuleTypeEnum.TICKET_PACKAGE.getValue()));
            rule7.setRuleValue(ticketPackage);
            rule7.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule7.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("ticketPackage", rule7);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{isp = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.ISP.getValue()), ticketId)})) {
            Rule rule8 = new Rule();
            rule8.setRuleType(Integer.valueOf(RuleTypeEnum.ISP.getValue()));
            rule8.setRuleValue(isp);
            rule8.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule8.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("isp", rule8);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{networkType = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.NETWORK_TYPE.getValue()), ticketId)})) {
            Rule rule9 = new Rule();
            rule9.setRuleType(Integer.valueOf(RuleTypeEnum.NETWORK_TYPE.getValue()));
            rule9.setRuleValue(networkType);
            rule9.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule9.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("networkType", rule9);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adQuality = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.AD_QUALITY.getValue()), ticketId)})) {
            Rule rule10 = new Rule();
            rule10.setRuleType(Integer.valueOf(RuleTypeEnum.AD_QUALITY.getValue()));
            rule10.setRuleValue(adQuality);
            rule10.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule10.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("adQuality", rule10);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{activityOrientation = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.ACTIVITY_ORIENTATION.getValue()), ticketId)})) {
            Rule rule11 = new Rule();
            rule11.setRuleType(Integer.valueOf(RuleTypeEnum.ACTIVITY_ORIENTATION.getValue()));
            rule11.setRuleValue(activityOrientation);
            rule11.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule11.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("activityOrientation", rule11);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newAndOldUsers = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.NEW_AND_OLD_USERS.getValue()), ticketId)})) {
            Rule rule12 = new Rule();
            rule12.setRuleType(Integer.valueOf(RuleTypeEnum.NEW_AND_OLD_USERS.getValue()));
            rule12.setRuleValue(newAndOldUsers);
            rule12.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule12.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("newAndOldUsers", rule12);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{getuiSex = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GETUI_SEX.getValue()), ticketId)})) {
            Rule rule13 = new Rule();
            rule13.setRuleType(Integer.valueOf(RuleTypeEnum.GETUI_SEX.getValue()));
            rule13.setRuleValue(getuiSex);
            rule13.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule13.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("getuiSex", rule13);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adxAppId = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.ADX_APP_ID.getValue()), ticketId)})) {
            Rule rule14 = new Rule();
            rule14.setRuleType(Integer.valueOf(RuleTypeEnum.ADX_APP_ID.getValue()));
            rule14.setRuleValue(adxAppId);
            rule14.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule14.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("adxAppId", rule14);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{besGender = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.BES_GENDER.getValue()), ticketId)})) {
            Rule rule15 = new Rule();
            rule15.setRuleType(Integer.valueOf(RuleTypeEnum.BES_GENDER.getValue()));
            rule15.setRuleValue(besGender);
            rule15.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule15.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("besGender", rule15);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{besAge = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.BES_AGE.getValue()), ticketId)})) {
            Rule rule16 = new Rule();
            rule16.setRuleType(Integer.valueOf(RuleTypeEnum.BES_AGE.getValue()));
            rule16.setRuleValue(besAge);
            rule16.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule16.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("besAge", rule16);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{phoneBrand = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.PHONE_BRAND.getValue()), ticketId)})) {
            Rule rule17 = new Rule();
            rule17.setRuleType(Integer.valueOf(RuleTypeEnum.PHONE_BRAND.getValue()));
            rule17.setRuleValue(phoneBrand);
            rule17.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule17.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("phoneBrand", rule17);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adxAPPEntrance = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.ADX_ENTRANCE.getValue()), ticketId)})) {
            Rule rule18 = new Rule();
            rule18.setRuleType(Integer.valueOf(RuleTypeEnum.ADX_ENTRANCE.getValue()));
            rule18.setRuleValue(adxAPPEntrance);
            rule18.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule18.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("adxAPPEntrance", rule18);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appIdPackage = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.APP_ID_PACKAGE.getValue()), ticketId)})) {
            Rule rule19 = new Rule();
            rule19.setRuleType(Integer.valueOf(RuleTypeEnum.APP_ID_PACKAGE.getValue()));
            rule19.setRuleValue(appIdPackage);
            rule19.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule19.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("appIdPackage", rule19);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{adxTagIdRule = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.ADX_TAG_ID.getValue()), ticketId)})) {
            Rule rule20 = new Rule();
            rule20.setRuleType(Integer.valueOf(RuleTypeEnum.ADX_TAG_ID.getValue()));
            rule20.setRuleValue(adxTagIdRule);
            rule20.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule20.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("adxTagIdRule", rule20);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{country = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.COUNTRY.getValue()), ticketId)})) {
            Rule rule21 = new Rule();
            rule21.setRuleType(Integer.valueOf(RuleTypeEnum.COUNTRY.getValue()));
            rule21.setRuleValue(country);
            rule21.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule21.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("country", rule21);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{baiduLookLikeRule = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.BAIDU_LOOK_LIKE.getValue()), ticketId)})) {
            Rule rule22 = new Rule();
            rule22.setRuleType(Integer.valueOf(RuleTypeEnum.BAIDU_LOOK_LIKE.getValue()));
            rule22.setRuleValue(baiduLookLikeRule);
            rule22.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule22.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("baiduLookLikeRule", rule22);
        }
        if (CollectionUtils.isNotEmpty((Collection)(adFlows = this.adTicketFlowPackageMapper.findByAdFlowByTicketId(ticketId, Integer.valueOf(2))))) {
            StringBuffer sb = new StringBuffer();
            Rule rule23 = new Rule();
            rule23.setRuleType(Integer.valueOf(RuleTypeEnum.FLOWPACKAGE.getValue()));
            for (AdTicketFlowPackageConf adFlow : adFlows) {
                String quota = adFlow.getQuota();
                quota = !"infinity".equalsIgnoreCase(quota) ? quota + "|" : "0|";
                sb.append(adFlow.getFlowPackageId() + "|" + quota + adFlow.getPrice() + "|" + adFlow.getPositionId().replaceAll(",", "^"));
                sb.append("|" + adFlow.getCpaPrice() + "|" + adFlow.getDeepCpaPrice());
                sb.append(",");
            }
            rule23.setRuleValue(sb.toString().substring(0, sb.toString().length() - 1));
            rule23.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
            rule23.setTargetId(BigInteger.valueOf(ticketId));
            ruleMap.put("positionGroup", rule23);
        }
        AdTicketAppExtendExample example = new AdTicketAppExtendExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        List adTicketAppExtends = this.adTicketAppExtendMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
            String mediaAppPackageRule;
            AdTicketAppExtend adTicketAppExtend = (AdTicketAppExtend)adTicketAppExtends.get(0);
            String appPackageRule = adTicketAppExtend.getAppPackageRule();
            if (StringUtils.isNotBlank((CharSequence)appPackageRule)) {
                Rule rule24 = new Rule();
                rule24.setRuleType(Integer.valueOf(RuleTypeEnum.APP_PACKAGE.getValue()));
                rule24.setRuleValue(appPackageRule);
                rule24.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
                rule24.setTargetId(BigInteger.valueOf(ticketId));
                ruleMap.put("appPackage", rule24);
            }
            if (StringUtils.isNotBlank((CharSequence)(mediaAppPackageRule = adTicketAppExtend.getMediaAppPackageRule()))) {
                Rule rule25 = new Rule();
                rule25.setRuleType(Integer.valueOf(RuleTypeEnum.MEDIA_APP_PACKAGE.getValue()));
                rule25.setRuleValue(mediaAppPackageRule);
                rule25.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
                rule25.setTargetId(BigInteger.valueOf(ticketId));
                ruleMap.put("mediaAppPackage", rule25);
            }
        }
        return ruleMap;
    }

    public List<TicketOnoff> getTicketOnoffList(String value, Long ticketId, Integer type) {
        ArrayList<TicketOnoff> onoffList = new ArrayList<TicketOnoff>(2);
        if (value != null) {
            TicketOnoff onoff = new TicketOnoff();
            onoff.setTicketId(BigInteger.valueOf(ticketId));
            onoff.setType(type);
            if (STR_ZERO.equals(value)) {
                onoff.setOnoff(Byte.valueOf((byte)0));
                onoff.setValue(null);
            } else {
                onoff.setOnoff(Byte.valueOf((byte)1));
                onoff.setValue(value);
            }
            onoffList.add(onoff);
        }
        return onoffList;
    }

    private void setLandingPagePlan(Long ticketId, TicketOfRules ticketOfRules) {
        List adLandingPagePlan = this.adLandingPagePlanMapper.findByTicketId(ticketId, null);
        if (CollectionUtils.isEmpty((Collection)adLandingPagePlan)) {
            return;
        }
        ArrayList ticketLandPlans = Lists.newArrayList();
        List landingPageConfigVos = this.adLandingPageConfigMapper.selectAll();
        Map<Long, List<LandingPageConfigVo>> planConfigMap = landingPageConfigVos.stream().collect(Collectors.groupingBy(LandingPageConfigVo::getPlanId));
        adLandingPagePlan.forEach(l -> {
            TicketLandPlan ticketLandPlan = new TicketLandPlan();
            ticketLandPlan.setPlanId(l.getId());
            ticketLandPlan.setStatus(l.getStatus());
            ticketLandPlan.setStart(l.getStartTime());
            ticketLandPlan.setEnd(l.getEndTime());
            ticketLandPlan.setStartDate(l.getStartDate());
            ticketLandPlan.setEndDate(l.getEndDate());
            ArrayList ticketLands = Lists.newArrayList();
            List landingPageConfigs = (List)planConfigMap.get(l.getId());
            landingPageConfigs.forEach(c -> {
                TicketLand ticketLand = new TicketLand();
                ticketLand.setUrl(c.getUrl());
                ticketLand.setFlowRatio(c.getFlowRate());
                ticketLand.setLandId(c.getId());
                ticketLand.setEnableKylin(c.getEnableKylin());
                ticketLands.add(ticketLand);
            });
            ticketLandPlan.setLands((List)ticketLands);
            ticketLandPlans.add(ticketLandPlan);
        });
        ticketOfRules.setLandPlans((List)ticketLandPlans);
    }
}

