/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.review.meituan.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateContentMapper;
import com.bxm.adsmanager.dal.mapper.bes.BesAdvertiserInfoMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplate;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContent;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContentExample;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfo;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfoExample;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsJsonConfig;
import com.bxm.adsmanager.service.review.QueryRequest;
import com.bxm.adsmanager.service.review.QueryResult;
import com.bxm.adsmanager.service.review.ReviewRequest;
import com.bxm.adsmanager.service.review.ReviewResult;
import com.bxm.adsmanager.service.review.meituan.MeiTuanCreative;
import com.bxm.adsmanager.service.review.meituan.conf.MeiTuanProperties;
import com.bxm.adsmanager.service.review.meituan.entity.AdvertiserQualification;
import com.bxm.adsmanager.service.review.meituan.entity.Material;
import com.bxm.adsmanager.service.review.meituan.entity.MeiTuanAdvRequest;
import com.bxm.adsmanager.service.review.meituan.entity.MeiTuanCreativeRequest;
import com.bxm.adsmanager.service.review.meituan.entity.Sign;
import com.bxm.warcar.utils.JsonHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MeiTuanCreativeImpl
implements MeiTuanCreative {
    private static final Logger log = LoggerFactory.getLogger(MeiTuanCreativeImpl.class);
    private static final Integer STATUS_REVIEWING = 0;
    private static final Integer STATUS_REVIEW_SUCCESS = 1;
    private static final Integer STATUS_REVIEW_FAIL = 2;
    private static final Integer STATUS_DOWN = 3;
    private static final Integer ADTYPE = 1;
    private static final Long POSITIONID = 116L;
    private static final String BACK_COLOR = "#FFFFFF";
    private final AdAssetsTemplateContentMapper adAssetsTemplateContentMapper;
    private final MeiTuanProperties meiTuanProperties;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final BesAdvertiserInfoMapper besAdvertiserInfoMapper;

    public MeiTuanCreativeImpl(AdAssetsTemplateContentMapper adAssetsTemplateContentMapper, MeiTuanProperties meiTuanProperties, RestTemplate restTemplate, ObjectMapper objectMapper, BesAdvertiserInfoMapper besAdvertiserInfoMapper) {
        this.adAssetsTemplateContentMapper = adAssetsTemplateContentMapper;
        this.meiTuanProperties = meiTuanProperties;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.besAdvertiserInfoMapper = besAdvertiserInfoMapper;
    }

    @Override
    public ReviewResult submitCreative(ReviewRequest reviewRequest) {
        ReviewResult.ReviewResultBuilder resultBuilder;
        block7: {
            List<MeiTuanCreativeRequest> requests = this.buildCreativeRequest(reviewRequest);
            if (CollectionUtils.isEmpty(requests)) {
                throw new BusinessException("\u63d0\u4ea4\u7d20\u6750\u5931\u8d25 empty");
            }
            String url = this.meiTuanProperties.getCreativeAddUrl() + this.getSign().toString();
            HashMap<String, List<MeiTuanCreativeRequest>> params = new HashMap<String, List<MeiTuanCreativeRequest>>();
            params.put("creatives", requests);
            HttpEntity httpEntity = new HttpEntity((Object)JsonHelper.convert(params), this.headers());
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            resultBuilder = ReviewResult.builder();
            try {
                Integer code;
                JsonNode bodyJson = this.objectMapper.readTree((String)responseEntity.getBody());
                Integer n = code = bodyJson.has("code") ? Integer.valueOf(bodyJson.get("code").asInt()) : null;
                if (code != null && code == 0) {
                    JsonNode data = bodyJson.get("data");
                    HashMap result = Maps.newHashMap();
                    String errMsg = "";
                    for (JsonNode d : data) {
                        if (d.has("errMsg") && StringUtils.isNotEmpty((CharSequence)d.get("errMsg").asText())) {
                            errMsg = errMsg + d.get("errMsg").asText() + "/";
                            continue;
                        }
                        result.put(d.get("dspCreativeId").asText(), d.get("creativeId").asLong());
                    }
                    resultBuilder.errMsg(errMsg);
                    resultBuilder.result(result);
                } else {
                    resultBuilder.errMsg(bodyJson.get("msg").asText());
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block7;
                log.error("meituan", (Throwable)e);
            }
        }
        return resultBuilder.build();
    }

    @Override
    public QueryResult queryCreative(QueryRequest request) {
        HashMap fail;
        HashSet success;
        block8: {
            if (log.isDebugEnabled()) {
                log.debug("meituan query request = {}", (Object)JsonHelper.convert((Object)request));
            }
            HashMap<String, List<Long>> requestParam = new HashMap<String, List<Long>>();
            requestParam.put("creativeIds", request.getList());
            HttpEntity httpEntity = new HttpEntity((Object)JsonHelper.convert(requestParam), this.headers());
            ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.meiTuanProperties.getCreativeQueryUrl() + this.getSign().toString(), (Object)httpEntity, String.class, new Object[0]);
            success = Sets.newHashSet();
            fail = Maps.newHashMap();
            try {
                Integer code;
                JsonNode bodyJson = this.objectMapper.readTree((String)responseEntityStr.getBody());
                Integer n = code = bodyJson.has("code") ? Integer.valueOf(bodyJson.get("code").asInt()) : null;
                if (code != null && code == 0) {
                    JsonNode data = bodyJson.get("data");
                    for (JsonNode d : data) {
                        Integer reviewStatus = d.get("reviewStatus").asInt();
                        String reviewMsg = d.get("reviewMsg").asText();
                        Long creativeId = d.get("creativeId").asLong();
                        if (Objects.isNull(reviewStatus)) continue;
                        if (reviewStatus == STATUS_REVIEW_SUCCESS) {
                            success.add(creativeId);
                        }
                        if (reviewStatus != STATUS_REVIEW_FAIL && reviewStatus != STATUS_DOWN) continue;
                        fail.put(creativeId, reviewMsg);
                    }
                } else if (log.isErrorEnabled()) {
                    log.error("meituan msg = {}", (Object)bodyJson.get("msg"));
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block8;
                log.error("meituan", (Throwable)e);
            }
        }
        return QueryResult.builder().success(success).fail(fail).build();
    }

    @Override
    public ReviewResult submitAdv(ReviewRequest reviewRequest) {
        ReviewResult.ReviewResultBuilder resultBuilder;
        block6: {
            List<MeiTuanAdvRequest> requests = this.buildAdvRequest(reviewRequest);
            if (CollectionUtils.isEmpty(requests)) {
                throw new BusinessException("\u63d0\u4ea4\u5e7f\u544a\u4e3b\u5931\u8d25 empty");
            }
            String url = this.meiTuanProperties.getAdvAddUrl() + this.getSign().toString();
            HashMap<String, List<MeiTuanAdvRequest>> params = new HashMap<String, List<MeiTuanAdvRequest>>();
            params.put("advertisers", requests);
            HttpEntity httpEntity = new HttpEntity((Object)JsonHelper.convert(params), this.headers());
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            resultBuilder = ReviewResult.builder();
            try {
                Integer code;
                JsonNode bodyJson = this.objectMapper.readTree((String)responseEntity.getBody());
                Integer n = code = bodyJson.has("code") ? Integer.valueOf(bodyJson.get("code").asInt()) : null;
                if (code != null && code == 0) {
                    JsonNode data = bodyJson.get("data");
                    HashMap result = Maps.newHashMap();
                    for (JsonNode d : data) {
                        result.put(d.get("dspAdvertiserId").asText(), d.get("advertiserId").asLong());
                    }
                    resultBuilder.result(result);
                } else {
                    resultBuilder.errMsg(bodyJson.get("msg").asText());
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error("meituan", (Throwable)e);
            }
        }
        return resultBuilder.build();
    }

    private List<MeiTuanAdvRequest> buildAdvRequest(ReviewRequest reviewRequest) {
        MeiTuanAdvRequest request = MeiTuanAdvRequest.builder().dspAdvertiserId(reviewRequest.getAdvertiserDto().getId().toString()).name(reviewRequest.getAdvertiserDto().getCompany()).primaryIndustryId(reviewRequest.getMeiTuanAdvertiserAuditDTO().getPrimaryIndustryId()).secondaryIndustryId(reviewRequest.getMeiTuanAdvertiserAuditDTO().getSecondaryIndustryId()).qualifications(Lists.newArrayList((Object[])new AdvertiserQualification[]{AdvertiserQualification.builder().name(new String("\u8425\u4e1a\u6267\u7167".getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8)).url(reviewRequest.getAdvertiserDto().getBusinessLicenseImg()).build()})).build();
        return Lists.newArrayList((Object[])new MeiTuanAdvRequest[]{request});
    }

    private List<MeiTuanCreativeRequest> buildCreativeRequest(ReviewRequest reviewRequest) {
        ArrayList<MeiTuanCreativeRequest> meiTuanCreativeRequests = new ArrayList<MeiTuanCreativeRequest>();
        for (AdAssetsTemplateAssets adAssetsTemplateAssets : reviewRequest.getAdAssetsTemplateAssetsList()) {
            String config = adAssetsTemplateAssets.getConfig();
            AdAssetsTemplateAssetsJsonConfig adAssetsTemplateAssetsJsonConfig = (AdAssetsTemplateAssetsJsonConfig)JsonHelper.convert((String)config, AdAssetsTemplateAssetsJsonConfig.class);
            AdAssetsTemplate template = reviewRequest.getAdAssetsTemplates().stream().filter(adAssetsTemplate -> adAssetsTemplate.getId().toString().equals(adAssetsTemplateAssetsJsonConfig.getTemplateId())).findFirst().orElse(null);
            if (Objects.isNull(template)) continue;
            AdAssetsTemplateContentExample adAssetsTemplateContentExample = new AdAssetsTemplateContentExample();
            adAssetsTemplateContentExample.createCriteria().andTemplateIdEqualTo(template.getId());
            List adAssetsTemplateContents = this.adAssetsTemplateContentMapper.selectByExample(adAssetsTemplateContentExample);
            Integer w = null;
            Integer h = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)adAssetsTemplateContents)) {
                String sizeInfo = ((AdAssetsTemplateContent)adAssetsTemplateContents.iterator().next()).getPictureConstraints();
                String[] infos = sizeInfo.split("-");
                if (infos.length >= 2) {
                    try {
                        w = Integer.valueOf(infos[0]);
                        h = Integer.valueOf(infos[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Objects.isNull(w) || Objects.isNull(h)) continue;
            }
            Long advId = reviewRequest.getAdTicketVo().getAdvertiser();
            BesAdvertiserInfoExample example = new BesAdvertiserInfoExample();
            example.createCriteria().andAdvertiserIdEqualTo(Integer.valueOf(advId.intValue())).andAdxAdvertiserTypeEqualTo(Integer.valueOf(2));
            List advertiserInfos = this.besAdvertiserInfoMapper.selectByExample(example);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)advertiserInfos)) {
                throw new BusinessException("\u5e7f\u544a\u4e3b\u672a\u63d0\u5ba1");
            }
            if (advertiserInfos.size() != 1) {
                throw new BusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e7f\u544a\u4e3b");
            }
            meiTuanCreativeRequests.add(MeiTuanCreativeRequest.builder().dspCreativeId(adAssetsTemplateAssets.getId().toString()).advertiserId(Long.valueOf(((BesAdvertiserInfo)advertiserInfos.get(0)).getAdxAdvertiserId())).adType(ADTYPE).positionId(POSITIONID).landingPageType(1).landingPage(reviewRequest.getAdTicketVo().getUrl()).startTime(System.currentTimeMillis() / 1000L).endTime(System.currentTimeMillis() / 1000L + 7776000L).materialList(Lists.newArrayList((Object[])new Material[]{Material.builder().type(ADTYPE).imageUrl(adAssetsTemplateAssetsJsonConfig.getImage()).imageHeight(w).imageHeight(h).build()})).build());
        }
        return meiTuanCreativeRequests;
    }

    private Sign getSign() {
        Sign signDTO = new Sign();
        signDTO.setNonce(RandomStringUtils.randomAlphabetic((int)6));
        signDTO.setTimestamp(System.currentTimeMillis() + "");
        signDTO.setDspId(this.meiTuanProperties.getDspId());
        signDTO.setSign(DigestUtils.sha1Hex((String)(signDTO.getDspId() + this.meiTuanProperties.getKey() + signDTO.getTimestamp() + signDTO.getNonce())));
        return signDTO;
    }

    private MultiValueMap<String, String> headers() {
        LinkedMultiValueMap header = new LinkedMultiValueMap();
        header.add((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
        return header;
    }
}

