/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.rta.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.rta.RtaConfigMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dto.rta.RtaDto;
import com.bxm.adsmanager.model.dto.rta.RtaSearchDto;
import com.bxm.adsmanager.model.vo.rta.RtaVo;
import com.bxm.adsmanager.service.rta.RtaService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsprod.facade.rta.RtaConfig;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.integration.pushable.CachePushableService;
import com.bxm.warcar.utils.UUIDHelper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RtaServiceImpl
implements RtaService {
    private static final Logger log = LoggerFactory.getLogger(RtaServiceImpl.class);
    @Autowired
    private RtaConfigMapper rtaConfigMapper;
    @Autowired
    private CachePushableService cachePushableService;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;

    @Override
    public PageInfo<RtaVo> page(RtaSearchDto rtaSearchDto) {
        Page page = PageHelper.startPage((int)rtaSearchDto.getPageNum(), (int)rtaSearchDto.getPageSize());
        this.rtaConfigMapper.page(rtaSearchDto);
        return page.toPageInfo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void create(RtaDto rtaDto) {
        if (!OpenAccountRtaMedia.isAutoCreateRtaId(rtaDto.getRtaMedia()) && StringUtils.isBlank((CharSequence)rtaDto.getRtaId())) {
            throw new BusinessException("rtaId cannot be empty");
        }
        String finalRtaId = rtaDto.getRtaId();
        if (OpenAccountRtaMedia.isAutoCreateRtaId(rtaDto.getRtaMedia())) {
            finalRtaId = UUIDHelper.generate();
        }
        String[] rtaIds = finalRtaId.split(",");
        ArrayList<Integer> pushIds = new ArrayList<Integer>();
        for (String rtaId : rtaIds) {
            RtaSearchDto rtaSearchDto = new RtaSearchDto();
            rtaSearchDto.setRtaId(rtaId);
            int count = this.rtaConfigMapper.count(rtaSearchDto);
            if (count > 0) {
                throw new ValidateException(rtaId + " \u8be5rtaId\u5df2\u7ecf\u5b58\u5728");
            }
            com.bxm.adsmanager.model.dao.rta.RtaConfig rtaConfig = new com.bxm.adsmanager.model.dao.rta.RtaConfig();
            BeanUtils.copyProperties((Object)rtaDto, (Object)rtaConfig);
            rtaConfig.setId(null);
            rtaConfig.setRtaId(rtaId);
            rtaConfig.setStatus(Byte.valueOf((byte)1));
            rtaConfig.setCreateUser(RequestUtils.getCurrentRealName());
            rtaConfig.setCreateTime(new Date());
            this.rtaConfigMapper.insertSelective(rtaConfig);
            pushIds.add(rtaConfig.getId());
        }
        this.push(pushIds);
    }

    @Override
    public void update(RtaDto rtaDto) {
        String rtaId = rtaDto.getRtaId();
        if (!OpenAccountRtaMedia.isAutoCreateRtaId(rtaDto.getRtaMedia()) && StringUtils.isBlank((CharSequence)rtaId)) {
            throw new BusinessException("rtaId cannot be empty");
        }
        if (OpenAccountRtaMedia.isAutoCreateRtaId(rtaDto.getRtaMedia())) {
            if (StringUtils.isBlank((CharSequence)rtaId)) {
                rtaId = UUIDHelper.generate();
            }
        } else {
            RtaSearchDto rtaSearchDto = new RtaSearchDto();
            rtaSearchDto.setRtaId(rtaId);
            rtaSearchDto.setNeId(rtaDto.getId());
            int count = this.rtaConfigMapper.count(rtaSearchDto);
            if (count > 0) {
                throw new ValidateException("\u8be5rtaId\u5df2\u7ecf\u5b58\u5728");
            }
        }
        com.bxm.adsmanager.model.dao.rta.RtaConfig rtaConfig = new com.bxm.adsmanager.model.dao.rta.RtaConfig();
        BeanUtils.copyProperties((Object)rtaDto, (Object)rtaConfig);
        rtaConfig.setRtaId(rtaId);
        rtaConfig.setUpdateUser(RequestUtils.getCurrentRealName());
        rtaConfig.setUpdateTime(new Date());
        this.rtaConfigMapper.updateByPrimaryKeySelective(rtaConfig);
        this.push(Collections.singletonList(rtaConfig.getId()));
    }

    @Override
    public void updateStatus(Integer id, Byte status) {
        com.bxm.adsmanager.model.dao.rta.RtaConfig rtaConfig = new com.bxm.adsmanager.model.dao.rta.RtaConfig();
        rtaConfig.setId(id);
        rtaConfig.setStatus(status);
        this.rtaConfigMapper.updateByPrimaryKeySelective(rtaConfig);
        this.push(Collections.singletonList(rtaConfig.getId()));
    }

    public void push(List<Integer> rtaIds) {
        for (Integer rtaId : rtaIds) {
            com.bxm.adsmanager.model.dao.rta.RtaConfig rtaConfig = this.rtaConfigMapper.selectByPrimaryKey(rtaId);
            RtaConfig rtaConfigCache = new RtaConfig();
            BeanUtils.copyProperties((Object)rtaConfig, (Object)rtaConfigCache);
            try {
                this.prodPusherIntegration.pushToProd("RTA-CONFIG", (Map)Maps.newHashMap(), JSONArray.toJSONBytes((Object)rtaConfigCache, (SerializerFeature[])new SerializerFeature[0]));
            }
            catch (Exception e) {
                log.error("occur ex in push :", (Throwable)e);
            }
        }
    }

    static enum OpenAccountRtaMedia {
        IQIYI("iqiyi", "\u7231\u5947\u827a");

        public String code;
        public String name;

        public static boolean isAutoCreateRtaId(String rtaMedia) {
            boolean result = true;
            for (OpenAccountRtaMedia media : OpenAccountRtaMedia.values()) {
                if (!media.getCode().equals(rtaMedia)) continue;
                result = false;
                break;
            }
            return result;
        }

        @ConstructorProperties(value={"code", "name"})
        private OpenAccountRtaMedia(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }
}

