/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.adsmanager.model.dao.AdTicketPopup.ProvideAppDto;
import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmanager.model.dao.report.InfoAppMsg;
import com.bxm.adsmanager.model.dto.InfoMediaMsgDto;
import com.bxm.adsmanager.model.dto.InfoPositionMsgDto;
import com.bxm.adsmanager.model.vo.AdpositionVo;
import com.bxm.adsmedia.facade.enumdata.AppEntranceAdxPositionTypeEnum;
import com.bxm.adsmedia.facade.enumdata.MediaTypeEnum;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AppEntityConvertHelper {
    private static final Logger log = LoggerFactory.getLogger(AppEntityConvertHelper.class);

    public static List<ProvideAppDto> convertAppEntranceToProvideAppDto(List<AppEntranceAdRO> appEntranceAdROS) {
        ArrayList provideAppDtos = Lists.newArrayListWithCapacity((int)appEntranceAdROS.size());
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            ProvideAppDto provideAppDto = new ProvideAppDto();
            provideAppDto.setAppKey(appEntranceAdRO.getAppKey());
            provideAppDto.setBussinessId(appEntranceAdRO.getAppEntranceId().toString());
            provideAppDto.setAppName(appEntranceAdRO.getProviderAlias());
            provideAppDto.setBusinessName(appEntranceAdRO.getAppEntranceName());
            provideAppDtos.add(provideAppDto);
        }
        return provideAppDtos;
    }

    public static List<AdpositionVo> convertAppEntranceToAdpositionVO(List<AppEntranceAdRO> appEntranceAdRos) {
        ArrayList adpositionVos = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        for (AppEntranceAdRO ro : appEntranceAdRos) {
            AdpositionVo adpositionVo = new AdpositionVo();
            adpositionVo.setMediaName(ro.getProviderAlias());
            adpositionVo.setName(ro.getAppEntranceName());
            adpositionVo.setAppkey(ro.getAppKey());
            adpositionVo.setBusiness(ro.getAppEntranceId().toString());
            adpositionVo.setMediaOnlineTime(ro.getProviderCreateTime());
            adpositionVo.setMediaIdCodeName(String.format("%06d", ro.getCode()));
            adpositionVo.setPositionId(ro.getPositionId());
            adpositionVo.setPositionIdCodeName(String.format("%06d", ro.getCode()) + "-" + ro.getAppEntranceId());
            adpositionVo.setMediaType(ro.getMediaSysType());
            adpositionVo.setMediaTypeName(MediaTypeEnum.getMediaTypeNameByCode((String)ro.getMediaSysType()));
            adpositionVo.setMediaClass(ro.getMediaClassName());
            adpositionVo.setPositionScene(ro.getPositionScene());
            adpositionVo.setDockingMethod(ro.getDockingMethod());
            adpositionVo.setImageSize(ro.getImageSize());
            if (null != ro.getMediaClassId()) {
                adpositionVo.setMediaClassId(ro.getMediaClassId().toString());
            }
            adpositionVo.setMediaChildClass(ro.getMediaChildClassName());
            if (null != ro.getMediaChildClassId()) {
                adpositionVo.setMediaChildClassId(ro.getMediaChildClassId().toString());
            }
            adpositionVo.setAppEntranceAdxId(ro.getAppEntranceAdxId());
            if (ro.getPositionType() != null) {
                adpositionVo.setPositionType(ro.getPositionType().toString());
                adpositionVo.setPositionTypeName(AppEntranceAdxPositionTypeEnum.getAppEntranceAdxPositionTypeNameByCode((Short)ro.getPositionType()));
            }
            adpositionVo.setPositionTypeDesc(ro.getPositionTypeDesc());
            adpositionVo.setMinimumPriceForYuan(ro.getMinimumPriceForYuan());
            adpositionVo.setCountry(ro.getCountry());
            if (ro.getAdxNative() != null) {
                AdpositionVo.AdxNative adxNative = new AdpositionVo.AdxNative();
                BeanUtils.copyProperties((Object)ro.getAdxNative(), (Object)adxNative);
                adpositionVo.setAdxNative(adxNative);
            }
            if (ro.getAdxPicture() != null) {
                AdpositionVo.AdxPicture adxPicture = new AdpositionVo.AdxPicture();
                BeanUtils.copyProperties((Object)ro.getAdxPicture(), (Object)adxPicture);
                adpositionVo.setAdxPicture(adxPicture);
            }
            if (ro.getAdxText() != null) {
                AdpositionVo.AdxText adxText = new AdpositionVo.AdxText();
                BeanUtils.copyProperties((Object)ro.getAdxText(), (Object)adxText);
                adpositionVo.setAdxText(adxText);
            }
            if (ro.getAdxNativeVideo() != null) {
                AdpositionVo.AdxNativeVideo nativeVideo = new AdpositionVo.AdxNativeVideo();
                BeanUtils.copyProperties((Object)ro.getAdxNativeVideo(), (Object)nativeVideo);
                adpositionVo.setAdxNativeVideo(nativeVideo);
            }
            adpositionVos.add(adpositionVo);
        }
        return adpositionVos;
    }

    public static List<InfoPositionMsgDto> convertAppEntranceToInfoPositionMsgDto(List<AppEntranceAdRO> appEntranceAdRos) {
        ArrayList infoPositionMsgDtos = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        for (AppEntranceAdRO ro : appEntranceAdRos) {
            InfoPositionMsgDto infoPositionMsgDto = new InfoPositionMsgDto();
            infoPositionMsgDto.setPositionId(ro.getPositionId());
            infoPositionMsgDto.setAlias(ro.getAppEntranceName());
            infoPositionMsgDtos.add(infoPositionMsgDto);
        }
        return infoPositionMsgDtos;
    }

    public static InfoAppMsg appConvertToInfoAppMsg(ProviderAppAdRO providerAppAdRo) {
        if (providerAppAdRo != null) {
            InfoAppMsg infoAppMsg = new InfoAppMsg();
            infoAppMsg.setId(providerAppAdRo.getId());
            infoAppMsg.setAppkey(providerAppAdRo.getAppKey());
            infoAppMsg.setAppname(providerAppAdRo.getAlias());
            infoAppMsg.setMjcode(providerAppAdRo.getMedium());
            infoAppMsg.setSalecode(providerAppAdRo.getBd());
            infoAppMsg.setRemark(providerAppAdRo.getRemark());
            infoAppMsg.setPrepay(Boolean.valueOf(providerAppAdRo.getAdvanceType() != 0));
            return infoAppMsg;
        }
        return null;
    }

    public static List<InfoAppMsg> appListConvertToInfoAppMsgList(List<ProviderAppAdRO> providerAppList) {
        if (CollectionUtils.isNotEmpty(providerAppList)) {
            ArrayList<InfoAppMsg> result = new ArrayList<InfoAppMsg>(providerAppList.size());
            InfoAppMsg infoAppMsg = null;
            for (ProviderAppAdRO providerAppAdRo : providerAppList) {
                infoAppMsg = new InfoAppMsg();
                infoAppMsg.setId(providerAppAdRo.getId());
                infoAppMsg.setAppkey(providerAppAdRo.getAppKey());
                infoAppMsg.setAppname(providerAppAdRo.getAlias());
                infoAppMsg.setMjcode(providerAppAdRo.getMedium());
                infoAppMsg.setSalecode(providerAppAdRo.getBd());
                infoAppMsg.setRemark(providerAppAdRo.getRemark());
                infoAppMsg.setPrepay(Boolean.valueOf(providerAppAdRo.getAdvanceType() != 0));
                result.add(infoAppMsg);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<AdMedia> appListConvertToAdMediaList(List<ProviderAppAdRO> providerAppList) {
        if (CollectionUtils.isNotEmpty(providerAppList)) {
            ArrayList<AdMedia> result = new ArrayList<AdMedia>(providerAppList.size());
            AdMedia adMedia = null;
            for (ProviderAppAdRO providerAppAdRo : providerAppList) {
                adMedia = new AdMedia();
                adMedia.setAppkey(providerAppAdRo.getAppKey());
                adMedia.setAppname(providerAppAdRo.getAlias());
                adMedia.setMjcode(providerAppAdRo.getMedium());
                adMedia.setBdcode(providerAppAdRo.getBd());
                adMedia.setRemark(providerAppAdRo.getRemark());
                adMedia.setPrepay(Boolean.valueOf(providerAppAdRo.getAdvanceType() != null && providerAppAdRo.getAdvanceType() != 0));
                adMedia.setAccountType(providerAppAdRo.getAccountType());
                adMedia.setCompanyName(providerAppAdRo.getCompanyName());
                adMedia.setCreateDate(providerAppAdRo.getGmtCreate());
                result.add(adMedia);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<InfoMediaMsgDto> appListConvertToMediaMsgList(List<ProviderAppAdRO> providerAppList) {
        if (CollectionUtils.isNotEmpty(providerAppList)) {
            ArrayList<InfoMediaMsgDto> result = new ArrayList<InfoMediaMsgDto>(providerAppList.size());
            InfoMediaMsgDto infoMediaMsgDto = null;
            for (ProviderAppAdRO providerAppAdRo : providerAppList) {
                infoMediaMsgDto = new InfoMediaMsgDto();
                infoMediaMsgDto.setAppKey(providerAppAdRo.getAppKey());
                infoMediaMsgDto.setAlias(providerAppAdRo.getAlias());
                infoMediaMsgDto.setMediaIdCodeName(String.format("%06d", providerAppAdRo.getCode()));
                result.add(infoMediaMsgDto);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

