/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class CollectionDataCopyUtil {
    public static <T> List<T> copyList(List<?> resource, Class<T> clazz) {
        if (CollectionUtils.isEmpty(resource)) {
            return Collections.emptyList();
        }
        return (List)CollectionDataCopyUtil.copyData(resource, new ArrayList(resource.size()), clazz);
    }

    private static <T> Collection<T> copyData(Collection<?> resource, Collection<T> result, Class<T> clazz) {
        try {
            for (Object source : resource) {
                T target = clazz.newInstance();
                BeanUtils.copyProperties(source, target);
                result.add(target);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException("copy list fail!");
        }
        return result;
    }

    public static <T> PageInfo<T> copyPageInfo(PageInfo<?> resource) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(resource, (Object)pageInfo);
        return pageInfo;
    }

    public static <T> PageInfo<T> copyPageInfoAndData(PageInfo<?> resource, Class<T> clazz) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(resource, (Object)pageInfo);
        pageInfo.setList(CollectionDataCopyUtil.copyList(resource.getList(), clazz));
        return pageInfo;
    }
}

