/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class DateFormatUtil {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static Long getMillisecondByDate(String date) {
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    public static Long getMillisecondByPlusDate(String date, long days) {
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        localDateTime = localDateTime.plusDays(days);
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    public static Long getMillisecondByMinusDate(String date, long days) {
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        localDateTime = localDateTime.minusDays(days);
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    public static int getDateHour(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.getHour();
    }

    public static String getPastDate(String date, int past) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(date));
        calendar.set(6, calendar.get(6) - past);
        String result = format.format(calendar.getTime());
        return result;
    }

    public static ArrayList<String> getPastDateList(String date, int intervals) throws Exception {
        ArrayList<String> pastDaysList = new ArrayList<String>();
        for (int i = 1; i <= intervals; ++i) {
            pastDaysList.add(DateFormatUtil.getPastDate(date, i));
        }
        return pastDaysList;
    }
}

