/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.handler.inter.IExcelDataHandler;
import com.bxm.adsmanager.model.annotation.ExcelReportIncrease;
import com.bxm.adsmanager.utils.ExcelDataCustomHandler;
import com.bxm.adsmanager.utils.ExcelExportStylerCustomImpl;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, boolean isCreateHeader, HttpServletResponse response) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(isCreateHeader);
        ExcelUtil.defaultExport(list, pojoClass, fileName, response, exportParams);
    }

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, HttpServletResponse response) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setStyle(ExcelExportStylerCustomImpl.class);
        exportParams.setDataHanlder((IExcelDataHandler)new ExcelDataCustomHandler());
        ExcelUtil.defaultExport(list, pojoClass, fileName, response, exportParams);
    }

    public static void exportExcel(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        ExcelUtil.defaultExport(list, fileName, response);
    }

    private static void defaultExport(List<?> list, Class<?> pojoClass, String fileName, HttpServletResponse response, ExportParams exportParams) {
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, pojoClass, list);
        if (workbook != null) {
            // empty if block
        }
        ExcelUtil.downLoadExcel(fileName, response, workbook);
    }

    private static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void defaultExport(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        Workbook workbook = ExcelExportUtil.exportExcel(list, (ExcelType)ExcelType.HSSF);
        if (workbook != null) {
            // empty if block
        }
        ExcelUtil.downLoadExcel(fileName, response, workbook);
    }

    public static <T> List<T> importExcel(String filePath, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((File)new File(filePath), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> importExcel(MultipartFile file, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static <T> void customFieldExport(List<T> target, Class<T> clazz, String customExportFieldStr, Integer showIncreaseFlag, String fileName, HttpServletResponse response) {
        Field[] fields;
        if (null == target || null == clazz || StringUtils.isBlank((CharSequence)fileName) || null == response) {
            throw new NullPointerException();
        }
        boolean isShowIncrease = null == showIncreaseFlag || 1 == showIncreaseFlag;
        LinkedHashSet<String> customFieldArray = new LinkedHashSet<String>(ExcelUtil.addDefaultFields(clazz));
        if (StringUtils.isNotEmpty((CharSequence)customExportFieldStr)) {
            customFieldArray.addAll(Arrays.asList(customExportFieldStr.split("\\.")));
        }
        if ((fields = clazz.getDeclaredFields()).length < 1) {
            throw new RuntimeException("the class has no field!");
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>(fields.length);
        HashMap<String, Integer> fieldTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> increaseFieldMap = null;
        if (isShowIncrease) {
            increaseFieldMap = new HashMap<String, String>(fields.length);
        }
        for (Field field : fields) {
            Excel excel = field.getAnnotation(Excel.class);
            ExcelReportIncrease excelReportIncreaseAnnotation = field.getAnnotation(ExcelReportIncrease.class);
            if (null == excel) continue;
            fieldTypeMap.put(field.getName(), excel.type());
            if (null != excelReportIncreaseAnnotation) {
                if (!isShowIncrease) continue;
                increaseFieldMap.put(excelReportIncreaseAnnotation.belongField(), excel.name() + ":" + field.getName());
                continue;
            }
            fieldMap.put(field.getName(), excel.name());
        }
        if (MapUtils.isEmpty(fieldMap)) {
            throw new RuntimeException("no field to export!");
        }
        customFieldArray.removeIf(fieldName -> !fieldMap.containsKey(fieldName));
        ArrayList<String> exportFieldArray = new ArrayList<String>(customFieldArray);
        ArrayList<ExcelExportEntity> excelHeader = new ArrayList<ExcelExportEntity>(fieldMap.size());
        int orderNum = 0;
        for (String string : customFieldArray) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity((String)fieldMap.get(string), (Object)string);
            excelExportEntity.setOrderNum(orderNum);
            excelExportEntity.setType(((Integer)fieldTypeMap.get(string)).intValue());
            excelHeader.add(excelExportEntity);
            if (isShowIncrease) {
                String belongFieldName = (String)increaseFieldMap.get(string);
                if (StringUtils.isBlank((CharSequence)belongFieldName)) continue;
                int index = belongFieldName.indexOf(":");
                String name = belongFieldName.substring(0, index);
                String key = belongFieldName.substring(index + 1, belongFieldName.length());
                excelExportEntity = new ExcelExportEntity(name, (Object)key);
                excelExportEntity.setOrderNum(++orderNum);
                excelHeader.add(excelExportEntity);
                exportFieldArray.add(key);
            }
            ++orderNum;
        }
        ArrayList excelBody = new ArrayList();
        try {
            for (T t : target) {
                Class<?> tClass = t.getClass();
                Field[] tClassField = tClass.getDeclaredFields();
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                for (Field field : tClassField) {
                    if (!exportFieldArray.contains(field.getName())) continue;
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), tClass);
                    Method method = propertyDescriptor.getReadMethod();
                    valueMap.put(field.getName(), method.invoke(t, new Object[0]));
                }
                excelBody.add(valueMap);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
            throw new RuntimeException("custom export fail! message: " + exception.getMessage());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), excelHeader, excelBody);
        ExcelUtil.downLoadExcel(fileName, response, workbook);
    }

    private static List<String> addDefaultFields(Class<?> clazz) {
        try {
            Object result;
            Method method = clazz.getMethod("getDefaultExportFields", new Class[0]);
            if (null != method && null != (result = method.invoke(clazz.newInstance(), new Object[0]))) {
                String[] defaultFields = (String[])result;
                return new ArrayList<String>(Arrays.asList(defaultFields));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(">>>>>>>>>>get default export field list fail!!", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public static <T> List<T> importExcelV2(MultipartFile file, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setKeyIndex(null);
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

