/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.adsmanager.ecxeption.ExcelException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;

public class ExcelUtils {
    public static <T> List<T> excelToList(InputStream in, String sheetName, Class<T> entityClass, LinkedHashMap<String, String> fieldMap) throws ExcelException {
        ArrayList<T> resultList = new ArrayList<T>();
        try {
            int i;
            Workbook wb = Workbook.getWorkbook((InputStream)in);
            Sheet sheet = wb.getSheet(sheetName);
            int realRows = 0;
            for (int i2 = 0; i2 < sheet.getRows(); ++i2) {
                int nullCols = 0;
                for (int j = 0; j < sheet.getColumns(); ++j) {
                    Cell currentCell = sheet.getCell(j, i2);
                    if (currentCell != null && !"".equals(currentCell.getContents().toString())) continue;
                    ++nullCols;
                }
                if (nullCols == sheet.getColumns()) break;
                ++realRows;
            }
            if (realRows <= 1) {
                throw new ExcelException("Excel\u6587\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u6570\u636e");
            }
            Cell[] firstRow = sheet.getRow(0);
            String[] excelFieldNames = new String[firstRow.length];
            for (int i3 = 0; i3 < firstRow.length; ++i3) {
                excelFieldNames[i3] = firstRow[i3].getContents().toString().trim();
            }
            boolean isExist = true;
            List<String> excelFieldList = Arrays.asList(excelFieldNames);
            for (String cnName : fieldMap.keySet()) {
                if (excelFieldList.contains(cnName)) continue;
                isExist = false;
                break;
            }
            if (!isExist) {
                throw new ExcelException("Excel\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u5b57\u6bb5\uff0c\u6216\u5b57\u6bb5\u540d\u79f0\u6709\u8bef");
            }
            LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>();
            for (i = 0; i < excelFieldNames.length; ++i) {
                colMap.put(excelFieldNames[i], firstRow[i].getColumn());
            }
            for (i = 1; i < realRows; ++i) {
                T entity = entityClass.newInstance();
                for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                    String cnNormalName = entry.getKey();
                    String enNormalName = entry.getValue();
                    int col = (Integer)colMap.get(cnNormalName);
                    String content = sheet.getCell(col, i).getContents().toString().trim();
                    try {
                        if (enNormalName.equals("incomerate")) {
                            content = content.replace("%", "");
                        }
                        ExcelUtils.setFieldValueByName(enNormalName, content, entity);
                    }
                    catch (Exception e) {
                        throw new ExcelException("\u5217:" + cnNormalName + "   \u503c:" + content + "\u683c\u5f0f\u6709\u8bef\uff01");
                    }
                }
                resultList.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof ExcelException) {
                throw (ExcelException)e;
            }
            e.printStackTrace();
            throw new ExcelException("\u5bfc\u5165Excel\u5931\u8d25");
        }
        return resultList;
    }

    private static Object getFieldValueByName(String fieldName, Object o) throws Exception {
        Object value = null;
        Field field = ExcelUtils.getFieldByName(fieldName, o.getClass());
        if (field == null) {
            throw new ExcelException(o.getClass().getSimpleName() + "\u7c7b\u4e0d\u5b58\u5728\u5b57\u6bb5\u540d " + fieldName);
        }
        field.setAccessible(true);
        value = field.get(o);
        return value;
    }

    private static Field getFieldByName(String fieldName, Class<?> clazz) {
        Field[] selfFields;
        for (Field field : selfFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz != Object.class) {
            return ExcelUtils.getFieldByName(fieldName, superClazz);
        }
        return null;
    }

    private static Object getFieldValueByNameSequence(String fieldNameSequence, Object o) throws Exception {
        Object value = null;
        String[] attributes = fieldNameSequence.split("\\.");
        if (attributes.length == 1) {
            value = ExcelUtils.getFieldValueByName(fieldNameSequence, o);
        } else {
            Object fieldObj = ExcelUtils.getFieldValueByName(attributes[0], o);
            String subFieldNameSequence = fieldNameSequence.substring(fieldNameSequence.indexOf(".") + 1);
            value = ExcelUtils.getFieldValueByNameSequence(subFieldNameSequence, fieldObj);
        }
        return value;
    }

    private static void setFieldValueByName(String fieldName, Object fieldValue, Object o) throws Exception {
        Field field = ExcelUtils.getFieldByName(fieldName, o.getClass());
        if (field != null) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (String.class == fieldType) {
                field.set(o, String.valueOf(fieldValue));
            } else if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                field.set(o, Integer.parseInt(fieldValue.toString()));
            } else if (Long.TYPE == fieldType || Long.class == fieldType) {
                field.set(o, Long.valueOf(fieldValue.toString()));
            } else if (Float.TYPE == fieldType || Float.class == fieldType) {
                field.set(o, Float.valueOf(fieldValue.toString()));
            } else if (Short.TYPE == fieldType || Short.class == fieldType) {
                field.set(o, Short.valueOf(fieldValue.toString()));
            } else if (Double.TYPE == fieldType || Double.class == fieldType) {
                field.set(o, Double.valueOf(fieldValue.toString()));
            } else if (Character.TYPE == fieldType) {
                if (fieldValue != null && fieldValue.toString().length() > 0) {
                    field.set(o, Character.valueOf(fieldValue.toString().charAt(0)));
                }
            } else if (Date.class == fieldType) {
                field.set(o, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(fieldValue.toString()));
            } else if (BigDecimal.class == fieldType) {
                if (fieldValue.equals("")) {
                    field.set(o, null);
                } else {
                    field.set(o, new BigDecimal(fieldValue.toString()));
                }
            } else {
                field.set(o, fieldValue);
            }
        } else {
            throw new ExcelException(o.getClass().getSimpleName() + "\u7c7b\u4e0d\u5b58\u5728\u5b57\u6bb5\u540d " + fieldName);
        }
    }

    private static void setColumnAutoSize(WritableSheet ws, int extraWith) {
        for (int i = 0; i < ws.getColumns(); ++i) {
            int colWith = 0;
            for (int j = 0; j < ws.getRows(); ++j) {
                String content = ws.getCell(i, j).getContents().toString();
                int cellWith = content.length();
                if (colWith >= cellWith) continue;
                colWith = cellWith;
            }
            ws.setColumnView(i, colWith + extraWith);
        }
    }

    private static <T> void fillSheet(WritableSheet sheet, List<T> list, LinkedHashMap<String, String> fieldMap, int firstIndex, int lastIndex) throws Exception {
        String[] enFields = new String[fieldMap.size()];
        String[] cnFields = new String[fieldMap.size()];
        int count = 0;
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            enFields[count] = entry.getKey();
            cnFields[count] = entry.getValue();
            ++count;
        }
        for (int i = 0; i < cnFields.length; ++i) {
            Label label = new Label(i, 0, cnFields[i]);
            sheet.addCell((WritableCell)label);
        }
        int rowNo = 1;
        for (int index = firstIndex; index <= lastIndex; ++index) {
            T item = list.get(index);
            for (int i = 0; i < enFields.length; ++i) {
                Object objValue = ExcelUtils.getFieldValueByNameSequence(enFields[i], item);
                String fieldValue = objValue == null ? "" : objValue.toString();
                Label label = new Label(i, rowNo, fieldValue);
                sheet.addCell((WritableCell)label);
            }
            ++rowNo;
        }
        ExcelUtils.setColumnAutoSize(sheet, 5);
    }

    public static <T> List<T> excelToList(InputStream in, String sheetName, Class<T> entityClass, LinkedHashMap<String, String> fieldMap, int effectNum) throws ExcelException {
        ArrayList<T> resultList = new ArrayList<T>();
        try {
            int i;
            Workbook wb = Workbook.getWorkbook((InputStream)in);
            Sheet sheet = wb.getSheet(sheetName);
            int realRows = 0;
            for (int i2 = 0; i2 < sheet.getRows(); ++i2) {
                int nullCols = 0;
                for (int j = 0; j < sheet.getColumns(); ++j) {
                    Cell currentCell = sheet.getCell(j, i2);
                    if (currentCell != null && !"".equals(currentCell.getContents().toString())) continue;
                    ++nullCols;
                }
                if (nullCols == sheet.getColumns()) break;
                ++realRows;
            }
            if (realRows <= 1) {
                throw new ExcelException("Excel\u6587\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u6570\u636e");
            }
            Cell[] firstRow = sheet.getRow(effectNum - 1);
            String[] excelFieldNames = new String[firstRow.length];
            for (int i3 = 0; i3 < firstRow.length; ++i3) {
                excelFieldNames[i3] = firstRow[i3].getContents().toString().trim();
            }
            boolean isExist = true;
            List<String> excelFieldList = Arrays.asList(excelFieldNames);
            for (String cnName : fieldMap.keySet()) {
                if (excelFieldList.contains(cnName)) continue;
                isExist = false;
                break;
            }
            if (!isExist) {
                throw new ExcelException("Excel\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u5b57\u6bb5\uff0c\u6216\u5b57\u6bb5\u540d\u79f0\u6709\u8bef");
            }
            LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>();
            for (i = 0; i < excelFieldNames.length; ++i) {
                colMap.put(excelFieldNames[i], firstRow[i].getColumn());
            }
            for (i = effectNum; i < realRows; ++i) {
                T entity = entityClass.newInstance();
                for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                    String cnNormalName = entry.getKey();
                    String enNormalName = entry.getValue();
                    int col = (Integer)colMap.get(cnNormalName);
                    String content = sheet.getCell(col, i).getContents().toString().trim();
                    try {
                        ExcelUtils.setFieldValueByName(enNormalName, content, entity);
                    }
                    catch (Exception e) {
                        throw new ExcelException("\u5217:" + cnNormalName + "   \u503c:" + content + "\u683c\u5f0f\u6709\u8bef\uff01");
                    }
                }
                resultList.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof ExcelException) {
                throw (ExcelException)e;
            }
            e.printStackTrace();
            throw new ExcelException("\u5bfc\u5165Excel\u5931\u8d25");
        }
        return resultList;
    }
}

