/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

public class IdCardUtils {
    public static String getBirthdayByIdCard(String cardCode) {
        Integer len = cardCode.length();
        String bir = len == 18 ? IdCardUtils.getBirthdayByIdCard18(cardCode) : IdCardUtils.getBirthdayByIdCard15(cardCode);
        return bir;
    }

    public static Integer getAgeByIdCard(String cardCode) {
        Integer len = cardCode.length();
        Integer age = len == 18 ? IdCardUtils.getAgeByIdCard18(cardCode) : IdCardUtils.getAgeByIdCard15(cardCode);
        return age;
    }

    public static String getSexByIdCard(String cardCode) {
        Integer len = cardCode.length();
        String sex = len == 18 ? IdCardUtils.getSexByIdCard18(cardCode) : IdCardUtils.getSexByIdCard15(cardCode);
        return sex;
    }

    private static String getBirthdayByIdCard18(String cardCode) {
        String idyear = cardCode.substring(6).substring(0, 4);
        String idyue = cardCode.substring(10).substring(0, 2);
        String idday = cardCode.substring(12).substring(0, 2);
        String bir = idyear + "-" + idyue + "-" + idday;
        return bir;
    }

    private static String getSexByIdCard18(String cardCode) {
        String sex = "2";
        sex = Integer.parseInt(cardCode.substring(16).substring(0, 1)) % 2 == 0 ? "0" : "1";
        return sex;
    }

    private static Integer getAgeByIdCard18(String cardCode) {
        String idyear = cardCode.substring(6).substring(0, 4);
        String idyue = cardCode.substring(10).substring(0, 2);
        String idday = cardCode.substring(12).substring(0, 2);
        String idyr = idyue + idday + "";
        String year = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).substring(0, 4);
        String yue = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).substring(5, 7);
        String day = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).substring(8, 10);
        String yr = yue + day + "";
        int age = 0;
        age = Integer.parseInt(idyr) <= Integer.parseInt(yr) ? Integer.parseInt(year) - Integer.parseInt(idyear) + 1 : Integer.parseInt(year) - Integer.parseInt(idyear);
        return age;
    }

    private static String getBirthdayByIdCard15(String cardCode) {
        String idyear = "19" + cardCode.substring(6, 8);
        String idyue = cardCode.substring(8, 10);
        String idday = cardCode.substring(10, 12);
        String bir = idyear + "-" + idyue + "-" + idday;
        return bir;
    }

    private static String getSexByIdCard15(String cardCode) {
        String sex = "2";
        sex = Integer.parseInt(cardCode.substring(14, 15)) % 2 == 0 ? "0" : "1";
        return sex;
    }

    private static Integer getAgeByIdCard15(String cardCode) {
        String idyear = "19" + cardCode.substring(6, 8);
        String idyue = cardCode.substring(8, 10);
        String idday = cardCode.substring(10, 12);
        String idyr = idyue + idday + "";
        String year = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).substring(0, 4);
        String yue = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).substring(5, 7);
        String day = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).substring(8, 10);
        String yr = yue + day + "";
        int age = 0;
        age = Integer.parseInt(idyr) <= Integer.parseInt(yr) ? Integer.parseInt(year) - Integer.parseInt(idyear) + 1 : Integer.parseInt(year) - Integer.parseInt(idyear);
        return age;
    }
}

