/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    public static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileToZip(String downloadUrl, String fileName, String base, ZipOutputStream zipOut) {
        FilterInputStream dataInputStream = null;
        BufferedInputStream bufferStream = null;
        try {
            URL url = null;
            url = new URL(downloadUrl);
            dataInputStream = new DataInputStream(url.openStream());
            byte[] bufferArea = new byte[10240];
            bufferStream = new BufferedInputStream(dataInputStream, 10240);
            zipOut.putNextEntry(new ZipEntry(base + "/" + fileName));
            int length = 0;
            while ((length = bufferStream.read(bufferArea, 0, 10240)) != -1) {
                zipOut.write(bufferArea, 0, length);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (bufferStream != null) {
                try {
                    bufferStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

