/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.acl.facade;

import com.bxm.acl.facade.AclUserManagerService;
import com.bxm.acl.facade.Utils;
import com.bxm.acl.facade.model.ResultModel;
import com.bxm.acl.facade.model.UserVo;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AclAuthInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclAuthInterceptor.class);
    private final int SYSTEM_ID;
    public static final String USER_KEY = "user";
    protected static final String SESSION_USER_NAME = "user_name";
    @Resource
    private AclUserManagerService aclUserManagerService;

    public AclAuthInterceptor(int systemId) {
        this.SYSTEM_ID = systemId;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        String token = Utils.getToken(request);
        LOGGER.debug("\u8bf7\u6c42\u6743\u9650\u7ba1\u7406\u7cfb\u7edf,token={},systemId={},uri={}", new Object[]{token, this.SYSTEM_ID, request.getRequestURI()});
        if (token == null) {
            Utils.sendErrorMsg(response, "\u7528\u6237\u672a\u767b\u5f55", "10000002");
            return false;
        }
        try {
            ResultModel<UserVo> result = this.aclUserManagerService.auth(token, this.SYSTEM_ID, request.getRequestURI());
            if (!result.isSuccessed()) {
                Utils.sendErrorMsg(response, result.getErrorDesc(), result.getErrorCode());
                LOGGER.warn("\u6743\u9650\u7cfb\u7edf\u62d2\u7edd,msg={}", (Object)result.getErrorDesc());
                return false;
            }
            if (StringUtils.equals((String)(HttpStatus.FORBIDDEN.value() + ""), (String)result.getErrorCode())) {
                Utils.sendErrorMsg(response, "\u6743\u9650\u4e0d\u8db3,\u5982\u9700\u7ee7\u7eed\u8bbf\u95ee\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "");
                LOGGER.warn("token={},systemId={},uri={}\u65e0\u6743\u9650", new Object[]{token, this.SYSTEM_ID, request.getRequestURI()});
                return false;
            }
            UserVo userVo = result.getReturnValue();
            request.setAttribute(USER_KEY, (Object)userVo);
            request.setAttribute(SESSION_USER_NAME, (Object)userVo.getUsername());
            LOGGER.info("\u7528\u6237\u6743\u9650\u9a8c\u8bc1\u6210\u529fuser:" + userVo.getUsername() + ",ip:" + Utils.getIp(request) + ",\u8bbf\u95ee\u5185\u5bb9:" + request.getRequestURI());
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u6743\u9650\u7ba1\u7406\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38,token={},systemId={},uri={}:", new Object[]{token, this.SYSTEM_ID, request.getRequestURI(), e});
            Utils.sendErrorMsg(response, "\u6743\u9650\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u7a0d\u5019\u518d\u8bd5", "");
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) throws Exception {
    }
}

