/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.Windowed;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class JedisWindowed
implements Windowed {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisWindowed.class);
    private final JedisPool jedisPool;
    private final String primary;
    private final Duration windowLength;
    private final Duration slidingInterval;
    private final ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("sliding"));
    private volatile String currentWindowed;

    public JedisWindowed(JedisPool jedisPool, String primary, Duration windowLength, Duration slidingInterval) {
        Preconditions.checkNotNull((Object)jedisPool);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)primary));
        Preconditions.checkArgument((windowLength.value > 0 && windowLength.toMinutes() >= slidingInterval.toMinutes() ? 1 : 0) != 0);
        Preconditions.checkArgument((slidingInterval.value > 0 ? 1 : 0) != 0);
        this.jedisPool = jedisPool;
        this.primary = primary;
        this.windowLength = windowLength;
        this.slidingInterval = slidingInterval;
        this.startSlidingThread();
    }

    private void startSlidingThread() {
        this.scheduled.scheduleWithFixedDelay(this::sliding, 0L, this.slidingInterval.value, this.slidingInterval.timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double execute(double incr) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            String field = this.currentWindowed;
            if (StringUtils.isBlank((String)field)) {
                this.refreshCurrentWindowed();
                field = this.currentWindowed;
            }
            double d = jedis.hincrByFloat(this.primary, field, incr);
            return d;
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("execute: ", (Throwable)e);
            }
            double d = -1.0;
            return d;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double get() {
        Jedis jedis = this.jedisPool.getResource();
        try {
            double rst = 0.0;
            LocalDateTime purgeTime = this.getPurgeTime();
            Map map = jedis.hgetAll(this.primary);
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String k = (String)entry.getKey();
                String val = (String)entry.getValue();
                LocalDateTime ktime = this.convert2Time(k);
                if (this.isExpiredWindow(purgeTime, ktime)) continue;
                rst += NumberUtils.toDouble((String)val);
            }
            double d = rst;
            return d;
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("get: ", (Throwable)e);
            }
            double d = -1.0;
            return d;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void destroy() {
        this.scheduled.shutdownNow();
    }

    private void sliding() {
        this.refreshCurrentWindowed();
        this.purgeWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWindow() {
        LocalDateTime purgeTime = this.getPurgeTime();
        Jedis jedis = this.jedisPool.getResource();
        try {
            String cursor = "0";
            boolean finished = false;
            HashSet<String> deleted = new HashSet<String>();
            block5: do {
                ScanResult hscan = jedis.hscan(this.primary, cursor, new ScanParams().count(Integer.valueOf(1)));
                cursor = hscan.getStringCursor();
                List result = hscan.getResult();
                if (CollectionUtils.isEmpty((Collection)result)) {
                    finished = true;
                    continue;
                }
                for (Map.Entry entry : result) {
                    String k = (String)entry.getKey();
                    LocalDateTime ktime = this.convert2Time(k);
                    if (this.isExpiredWindow(purgeTime, ktime)) {
                        deleted.add(k);
                        continue;
                    }
                    finished = true;
                    continue block5;
                }
            } while (!finished);
            if (CollectionUtils.isNotEmpty(deleted)) {
                jedis.hdel(this.primary, deleted.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("purgeWindow: ", (Throwable)e);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private void refreshCurrentWindowed() {
        this.currentWindowed = this.convert2Field(LocalDateTime.now());
    }

    private boolean isExpiredWindow(LocalDateTime purgeTime, LocalDateTime fieldTime) {
        return fieldTime.isBefore(purgeTime) || fieldTime.isEqual(purgeTime);
    }

    private LocalDateTime getPurgeTime() {
        return LocalDateTime.now().minusMinutes(this.windowLength.toMinutes()).withSecond(0).withNano(0);
    }

    private String convert2Field(LocalDateTime time) {
        return time.format(this.formatter());
    }

    private LocalDateTime convert2Time(String field) {
        return LocalDateTime.parse(field, this.formatter());
    }

    private DateTimeFormatter formatter() {
        return DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    }

    @Override
    public String getPrimary() {
        return this.primary;
    }

    @Override
    public Duration getWindowLength() {
        return this.windowLength;
    }

    @Override
    public Duration getSlidingInterval() {
        return this.slidingInterval;
    }

    @Override
    public String getCurrentWindowed() {
        return this.currentWindowed;
    }

    public static class Duration {
        private final int value;
        private final TimeUnit timeUnit;

        public Duration(int value, TimeUnit timeUnit) {
            this.value = value;
            this.timeUnit = timeUnit;
        }

        public long toMinutes() {
            return this.timeUnit.toMinutes(this.value);
        }

        public static Duration of(int milliseconds) {
            return new Duration(milliseconds, TimeUnit.MILLISECONDS);
        }

        public static Duration days(int days) {
            return new Duration(days, TimeUnit.DAYS);
        }

        public static Duration hours(int hours) {
            return new Duration(hours, TimeUnit.HOURS);
        }

        public static Duration minutes(int minutes) {
            return new Duration(minutes, TimeUnit.MINUTES);
        }

        public String toString() {
            return "Duration{value=" + this.value + '}';
        }
    }
}

