/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.loader.zk;

import com.bxm.warcar.configure.loader.AbstractEnvironmentLoader;
import com.bxm.warcar.configure.loader.zk.ZooKeeperEnvironmentChangedListener;
import com.bxm.warcar.configure.update.ConfigureRefresher;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.NodeChangedListener;
import com.bxm.warcar.zk.listener.node.NodeChanged;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperEnvironmentLoader
extends AbstractEnvironmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperEnvironmentLoader.class);
    private ZkClientHolder zooKeeperHolder;
    private Collection<NodeChanged> nodeChangeds = Sets.newHashSet();

    public ZooKeeperEnvironmentLoader(String address, String[] keys, ConfigureRefresher configureRefresher) {
        super(address, keys);
        this.zooKeeperHolder = new ZkClientHolder(this.addresses);
        this.zooKeeperHolder.init();
        for (String key : keys) {
            NodeChanged nodeChanged = new NodeChanged(this.zooKeeperHolder, key, (NodeChangedListener)new ZooKeeperEnvironmentChangedListener(this, configureRefresher));
            nodeChanged.init();
            this.nodeChangeds.add(nodeChanged);
        }
    }

    @Override
    protected byte[] readSource(String key) {
        CuratorFramework client = this.zooKeeperHolder.get();
        try {
            return (byte[])client.getData().forPath(key);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("loadProperties:", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public void destroy() {
        if (null != this.zooKeeperHolder) {
            this.zooKeeperHolder.destroy();
        }
        for (NodeChanged nodeChanged : this.nodeChangeds) {
            nodeChanged.destroy();
        }
    }
}

