/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.rocketmq;

import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumer
extends LifeCycle
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocketmqConsumer.class);
    private final DefaultMQPushConsumer consumer;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final String namesrvAddr;
    private SingleMessageListener messageListener;
    private final String consumerGroup;
    private String subExpression;

    public RocketmqConsumer(String namesrvAddr, SingleMessageListener messageListener) {
        this(namesrvAddr, messageListener, "consumer", new HashMap<String, String>());
    }

    public RocketmqConsumer(String namesrvAddr, SingleMessageListener messageListener, String consumerGroup, Map<String, String> brokerAddrAlias) {
        this.namesrvAddr = namesrvAddr;
        this.messageListener = messageListener;
        this.consumerGroup = consumerGroup;
        this.consumer = new DefaultMQPushConsumer(consumerGroup);
        this.consumer.setNamesrvAddr(namesrvAddr);
        this.consumer.setBrokerAddrAlias(brokerAddrAlias);
        if (StringUtils.isBlank((String)this.subExpression)) {
            this.subExpression = "*";
        }
    }

    @Override
    protected void doInit() {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.messageListener.getTopic()), (Object)"topic must has not blank!");
            this.consumer.subscribe(this.messageListener.getTopic(), this.subExpression);
            this.consumer.registerMessageListener(new MessageListenerConcurrently(){

                public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                    if (CollectionUtils.isEmpty(msgs)) {
                        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    }
                    if (msgs.size() > 1) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Unsupported batch messages!!");
                        }
                        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                    }
                    Message msg = new Message();
                    MessageExt messageExt = msgs.get(0);
                    msg.setMsgId(messageExt.getMsgId());
                    msg.setBody(messageExt.getBody());
                    msg.setTags(messageExt.getTags());
                    msg.setTopic(messageExt.getTopic());
                    msg.setFlag(messageExt.getFlag());
                    ConsumeStatus status = RocketmqConsumer.this.messageListener.consume(msg, context);
                    switch (status) {
                        case CONSUME_SUCCESS: {
                            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                        }
                    }
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            });
            this.consumer.start();
            this.started.set(true);
        }
        catch (MQClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doDestroy() {
        this.shutdown();
        this.started.set(false);
    }

    @Override
    public void suspend() {
        if (null != this.consumer) {
            this.consumer.suspend();
        }
    }

    @Override
    public void shutdown() {
        if (null != this.consumer) {
            this.consumer.shutdown();
        }
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getSubExpression() {
        return this.subExpression;
    }

    public void setSubExpression(String subExpression) {
        this.subExpression = subExpression;
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    @Override
    public SingleMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(SingleMessageListener messageListener) {
        this.messageListener = messageListener;
    }
}

