/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.zk;

import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClientHolder
extends LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkClientHolder.class);
    public static final int MAX_RETRIES = 3;
    public static final int BASE_SLEEP_TIMEMS = 3000;
    public static final int SESSION_TIMEOUT = 60000;
    private CuratorFramework zkClient;
    private final String connectString;
    private final int sessionTimeout;

    public ZkClientHolder(String connectString) {
        this(connectString, 60000);
    }

    public ZkClientHolder(String connectString, int sessionTimeout) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectString), (Object)"connectString cannot be blank");
        Preconditions.checkArgument((sessionTimeout >= 10000 ? 1 : 0) != 0, (Object)"sessionTimeout must be greater than 10000");
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
    }

    public CuratorFramework get() {
        return this.zkClient;
    }

    protected void doInit() {
        this.zkClient = CuratorFrameworkFactory.builder().sessionTimeoutMs(this.sessionTimeout).connectString(this.connectString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(3000, 3)).build();
        this.zkClient.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connected to ZooKeeper server: {}", (Object)this.connectString);
        }
    }

    protected void doDestroy() {
        if (null != this.zkClient) {
            this.zkClient.close();
        }
    }
}

