/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractConsumerBeanFactory
implements DisposableBean,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConsumerBeanFactory.class);
    private final ConcurrentHashMap<String, Consumer> consumers = new ConcurrentHashMap();

    protected abstract Consumer create(String var1, Listener var2);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beans = applicationContext.getBeansOfType(Listener.class);
        if (MapUtils.isEmpty((Map)beans)) {
            return;
        }
        for (Map.Entry entry : beans.entrySet()) {
            Listener listener = (Listener)entry.getValue();
            this.register(listener);
        }
    }

    public void destroy() {
        for (Map.Entry<String, Consumer> entry : this.consumers.entrySet()) {
            String key = entry.getKey();
            Consumer consumer = entry.getValue();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Consumer {} on shutdown", (Object)key);
            }
            consumer.shutdown();
        }
    }

    private void register(Listener listener) {
        String consumerId = listener.getConsumerId();
        if (StringUtils.isBlank((String)consumerId)) {
            LOGGER.warn("{}'s consumerId value is null!", (Object)listener);
            return;
        }
        Consumer consumer = this.create(consumerId, listener);
        if (null == consumer) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering consumer: {} of topic: {}", (Object)consumerId, (Object)listener.getTopic());
        }
        consumer.start();
        this.consumers.put(consumerId, consumer);
    }

    public Map<String, Consumer> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }
}

