/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsmedia.media;

import com.bxm.adsmanager.integration.adsmedia.media.service.PositionClassTypeFacadeService;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeDto;
import com.bxm.adsmedia.facade.model.positionclasstype.PositionClassTypeRo;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaCommonConfigFacadeIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaCommonConfigFacadeIntegration.class);
    @Autowired
    private PositionClassTypeFacadeService positionClassTypeFacadeService;

    public ResultModel<List<PositionClassTypeRo>> queryPositionClassTypeList(PositionClassTypeDto positionClassTypeDto) {
        return this.positionClassTypeFacadeService.queryPositionClassTypeList(positionClassTypeDto);
    }

    public ResultModel<PageInfo<PositionClassTypeRo>> queryPositionClassTypePageList(PositionClassTypeDto positionClassTypeDto) {
        return this.positionClassTypeFacadeService.queryPositionClassTypePageList(positionClassTypeDto);
    }

    public ResultModel<PositionClassTypeRo> getPositionClassTypeById(Long id) {
        return this.positionClassTypeFacadeService.getPositionClassTypeById(id);
    }

    public ResultModel<Boolean> updatePositionClassTypeById(PositionClassTypeRo positionClassType) {
        return this.positionClassTypeFacadeService.updatePositionClassTypeById(positionClassType);
    }

    public ResultModel<Boolean> addPositionClassType(PositionClassTypeRo positionClassType) {
        return this.positionClassTypeFacadeService.addPositionClassType(positionClassType);
    }

    public ResultModel<Boolean> delPositionClassTypeById(Long id, String typeCode) {
        return this.positionClassTypeFacadeService.delPositionClassTypeById(id, typeCode);
    }

    public Map<String, String> findMediaConfigIdToNameMap(String typeCode) {
        HashMap results = Maps.newHashMap();
        try {
            PositionClassTypeDto param = new PositionClassTypeDto();
            param.setTypeCode(typeCode);
            List lists = (List)this.positionClassTypeFacadeService.queryPositionClassTypeList(param).getReturnValue();
            if (!CollectionUtils.isEmpty((Collection)lists)) {
                lists.forEach(positionClassType -> results.put(String.valueOf(positionClassType.getId()), positionClassType.getName()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5a92\u4f53\u5206\u7c7b\u4fe1\u606f\u51fa\u9519:" + e.getMessage(), (Throwable)e);
        }
        return results;
    }
}

