/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsmedia.provider;

import com.bxm.adsmanager.facade.model.position.PositionUpdateDto;
import com.bxm.adsmanager.integration.adsmedia.provider.service.ProviderFacadeService;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.adsmedia.facade.model.provider.ProviderRO;
import com.bxm.adsmedia.facade.model.provider.QueryProviderParamsDTO;
import com.bxm.adsmedia.facade.model.provider.SimulateLoginVo;
import com.bxm.adsmedia.facade.model.provider.SimulateRegisterDTO;
import com.bxm.adsmedia.facade.model.provider.UpdateProviderAppParamDTO;
import com.bxm.util.dto.BaseException;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProviderFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(ProviderFacadeIntegration.class);
    private static final String ERROR_MSG = "\u8c03\u7528app\u670d\u52a1\u67e5\u8be2\u5a92\u4f53\u4fe1\u606f\u5931\u8d25";
    @Autowired
    private ProviderFacadeService providerFacadeService;

    public PageInfo<ProviderRO> getProviderPage(QueryProviderParamsDTO dto) {
        try {
            ResultModel<PageInfo<ProviderRO>> resultModel = this.providerFacadeService.getPage(dto);
            if (resultModel.isSuccessed()) {
                return (PageInfo)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u8005\u540e\u53f0\u7684\u5f00\u53d1\u8005\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    public List<ProviderRO> getProviderList(QueryProviderParamsDTO dto) {
        return this.getProviderPage(dto).getList();
    }

    public Boolean updateProvider(PositionUpdateDto positionUpdateDto) {
        UpdateProviderAppParamDTO dto = new UpdateProviderAppParamDTO();
        dto.setAppKey(positionUpdateDto.getAppKey());
        dto.setProviderAlias(positionUpdateDto.getAppName());
        dto.setMjCode(positionUpdateDto.getMJ());
        dto.setBdCode(positionUpdateDto.getBD());
        dto.setAdvanceFlag(positionUpdateDto.getPrepay());
        dto.setAccountType(positionUpdateDto.getAccountType());
        dto.setRemark(positionUpdateDto.getRemark());
        dto.setModifier(positionUpdateDto.getModifier());
        dto.setRtbType(positionUpdateDto.getRtbType());
        dto.setAllowOcpr(positionUpdateDto.getAllowOcpr());
        dto.setDataViewingRole(positionUpdateDto.getDataViewingRole());
        dto.setDomain(positionUpdateDto.getDomain());
        try {
            ResultModel<Boolean> resultModel = this.providerFacadeService.update(dto);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5f00\u53d1\u8005\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5f00\u53d1\u8005\u5f02\u5e38\uff01");
        }
        throw new BaseException("\u4fee\u6539\u5f00\u53d1\u8005\u5931\u8d25\uff01");
    }

    public List<ProviderAppAdRO> getProviderAppList(ProviderAppAdDTO dto) {
        ResultModel<List<ProviderAppAdRO>> appListModel = this.providerFacadeService.getAppList(dto);
        if (appListModel != null && appListModel.isSuccessed()) {
            return (List)appListModel.getReturnValue();
        }
        log.error(ERROR_MSG);
        return Collections.emptyList();
    }

    public List<String> getProviderAppKeyList(ProviderAppAdDTO dto) {
        ResultModel<List<String>> appKeyListModel = this.providerFacadeService.getAppKeyList(dto);
        if (appKeyListModel != null && appKeyListModel.isSuccessed()) {
            return (List)appKeyListModel.getReturnValue();
        }
        log.error(ERROR_MSG);
        return Collections.emptyList();
    }

    public ProviderAppAdRO getProviderAppInfoByAppKey(String appKey) {
        ResultModel<ProviderAppAdRO> appInfoByAppKey = this.providerFacadeService.getAppInfoByAppKey(appKey);
        if (appInfoByAppKey != null && appInfoByAppKey.isSuccessed()) {
            return (ProviderAppAdRO)appInfoByAppKey.getReturnValue();
        }
        log.error(ERROR_MSG);
        return null;
    }

    public Map<String, String> getProviderAppCodeName(ProviderAppAdDTO dto) {
        ResultModel<List<ProviderAppAdRO>> appListModel;
        HashMap resultMap = Maps.newHashMap();
        if (dto == null) {
            dto = new ProviderAppAdDTO();
        }
        if ((appListModel = this.providerFacadeService.getAppList(dto)) != null && appListModel.isSuccessed()) {
            List providerAppList = (List)appListModel.getReturnValue();
            if (!CollectionUtils.isEmpty((Collection)providerAppList)) {
                providerAppList.forEach(providerApp -> resultMap.put(String.format("%06d", providerApp.getCode()), providerApp.getAppKey()));
            }
        } else {
            log.error(ERROR_MSG);
            return resultMap;
        }
        return resultMap;
    }

    public Map<String, String> getProviderAppWithCodeName(ProviderAppAdDTO dto) {
        ResultModel<List<ProviderAppAdRO>> appListModel;
        HashMap resultMap = Maps.newHashMap();
        if (dto == null) {
            dto = new ProviderAppAdDTO();
        }
        if ((appListModel = this.providerFacadeService.getAppList(dto)) != null && appListModel.isSuccessed()) {
            List providerAppList = (List)appListModel.getReturnValue();
            if (!CollectionUtils.isEmpty((Collection)providerAppList)) {
                providerAppList.forEach(providerApp -> resultMap.put(providerApp.getAppKey(), String.format("%06d", providerApp.getCode())));
            }
        } else {
            log.error(ERROR_MSG);
            return resultMap;
        }
        return resultMap;
    }

    public List<ProviderAppAdRO> getList(String keywords) {
        ResultModel<List<ProviderAppAdRO>> resultModel = this.providerFacadeService.getList(keywords);
        return (List)resultModel.getReturnValue();
    }

    public Map<String, ProviderAppAdRO> getListByAdvanceType(Integer advanceType, String keywords) {
        HashMap result = Maps.newHashMap();
        ResultModel<List<ProviderAppAdRO>> resultModel = this.providerFacadeService.getListByAdvanceType(advanceType, keywords);
        List lists = (List)resultModel.getReturnValue();
        if (CollectionUtils.isNotEmpty((Collection)lists)) {
            lists.forEach(mediaMsgDto -> result.put(mediaMsgDto.getAppKey(), mediaMsgDto));
        }
        return result;
    }

    public Map<String, ProviderAppAdRO> findMediaAllToMap() {
        HashMap results = Maps.newHashMap();
        try {
            List<ProviderAppAdRO> lists = this.getList(null);
            if (CollectionUtils.isNotEmpty(lists)) {
                lists.forEach(mediaMsgDto -> results.put(mediaMsgDto.getAppKey(), mediaMsgDto));
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5173\u952e\u5b57\u67e5\u8be2\u5a92\u4f53\u5217\u8868\u51fa\u9519", (Throwable)e);
        }
        return results;
    }

    @Deprecated
    public Map<String, Integer> findMediaAccountTypeMap() {
        HashMap results = Maps.newHashMap();
        try {
            List<ProviderAppAdRO> lists = this.getList(null);
            if (CollectionUtils.isNotEmpty(lists)) {
                lists.forEach(providerAppAdRo -> results.put(providerAppAdRo.getAppKey(), providerAppAdRo.getAccountType()));
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5173\u952e\u5b57\u67e5\u8be2\u5a92\u4f53\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public Boolean setMj(Long providerId, String mjCode, String modifier) {
        try {
            ResultModel<Boolean> resultModel = this.providerFacadeService.setMj(providerId, mjCode, modifier);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u7ed9\u5f00\u53d1\u8005\u8bbe\u7f6e\u5a92\u4ecb\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u7ed9\u5f00\u53d1\u8005\u8bbe\u7f6e\u5a92\u4ecb\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Boolean updateProviceBasic(Long providerId, String mjCode, String bdCode, String tags, String modifier) {
        try {
            ResultModel<Boolean> resultModel = this.providerFacadeService.updateBasic(providerId, mjCode, bdCode, tags, modifier);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u7ed9\u5f00\u53d1\u8005\u8bbe\u7f6e\u6807\u7b7e.\u5a92\u4ecb.BD\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u7ed9\u5f00\u53d1\u8005\u8bbe\u7f6e\u6807\u7b7e.\u5a92\u4ecb.BD\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public SimulateLoginVo simulateLogin(Long providerId) {
        if (null == providerId) {
            return null;
        }
        try {
            ResultModel<SimulateLoginVo> resultModel = this.providerFacadeService.simulateLogin(providerId);
            if (resultModel.isSuccessed()) {
                return (SimulateLoginVo)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0csimulateLogin -->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38 simulateLogin", (Throwable)e);
        }
        return null;
    }

    public ResultModel simulateRegister(SimulateRegisterDTO simulateRegisterDTO) {
        if (null == simulateRegisterDTO) {
            return null;
        }
        try {
            ResultModel<Boolean> resultModel = this.providerFacadeService.simulateRegister(simulateRegisterDTO);
            if (resultModel != null) {
                return resultModel;
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38 simulateRegister", (Throwable)e);
        }
        return null;
    }
}

